/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.JoinFilterFunction;
import com.facebook.presto.operator.PagesHashStrategy;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.type.TypeUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class SimplePagesHashStrategy
implements PagesHashStrategy {
    private static final Block[] EMPTY_BLOCK_ARRAY = new Block[0];
    private final List<Type> types;
    private final List<List<Block>> channels;
    private final List<Block[]> channelArrays;
    private final List<Integer> hashChannels;
    private final List<Block> precomputedHashChannel;
    private final Optional<JoinFilterFunction> filterFunction;

    public SimplePagesHashStrategy(List<Type> types, List<List<Block>> channels, List<Integer> hashChannels, Optional<Integer> precomputedHashChannel, Optional<JoinFilterFunction> filterFunction) {
        this.filterFunction = filterFunction;
        this.types = ImmutableList.copyOf((Collection)Objects.requireNonNull(types, "types is null"));
        this.channels = ImmutableList.copyOf((Collection)Objects.requireNonNull(channels, "channels is null"));
        this.channelArrays = this.buildChannelArrays(channels);
        Preconditions.checkArgument((types.size() == channels.size() ? 1 : 0) != 0, (Object)"Expected types and channels to be the same length");
        this.hashChannels = ImmutableList.copyOf((Collection)Objects.requireNonNull(hashChannels, "hashChannels is null"));
        this.precomputedHashChannel = precomputedHashChannel.isPresent() ? channels.get(precomputedHashChannel.get()) : null;
    }

    private List<Block[]> buildChannelArrays(List<List<Block>> channels) {
        if (channels.isEmpty()) {
            return new ArrayList<Block[]>();
        }
        int pagesCount = channels.get(0).size();
        ArrayList<Block[]> channelArrays = new ArrayList<Block[]>();
        for (int i = 0; i < pagesCount; ++i) {
            Block[] blocks = new Block[channels.size()];
            for (int j = 0; j < channels.size(); ++j) {
                blocks[j] = channels.get(j).get(i);
            }
            channelArrays.add(blocks);
        }
        return channelArrays;
    }

    @Override
    public int getChannelCount() {
        return this.channels.size();
    }

    @Override
    public long getSizeInBytes() {
        return this.channels.stream().flatMap(Collection::stream).mapToLong(Block::getRetainedSizeInBytes).sum();
    }

    @Override
    public void appendTo(int blockIndex, int position, PageBuilder pageBuilder, int outputChannelOffset) {
        for (int i = 0; i < this.channels.size(); ++i) {
            Type type = this.types.get(i);
            List<Block> channel = this.channels.get(i);
            Block block = channel.get(blockIndex);
            type.appendTo(block, position, pageBuilder.getBlockBuilder(outputChannelOffset));
            ++outputChannelOffset;
        }
    }

    @Override
    public long hashPosition(int blockIndex, int position) {
        if (this.precomputedHashChannel != null) {
            return BigintType.BIGINT.getLong(this.precomputedHashChannel.get(blockIndex), position);
        }
        long result = 0L;
        for (int hashChannel : this.hashChannels) {
            Type type = this.types.get(hashChannel);
            Block block = this.channels.get(hashChannel).get(blockIndex);
            result = result * 31L + TypeUtils.hashPosition(type, block, position);
        }
        return result;
    }

    @Override
    public long hashRow(int position, Page page) {
        long result = 0L;
        for (int i = 0; i < this.hashChannels.size(); ++i) {
            int hashChannel = this.hashChannels.get(i);
            Type type = this.types.get(hashChannel);
            Block block = page.getBlock(i);
            result = result * 31L + TypeUtils.hashPosition(type, block, position);
        }
        return result;
    }

    @Override
    public boolean rowEqualsRow(int leftPosition, Page leftPage, int rightPosition, Page rightPage) {
        Preconditions.checkState((!this.filterFunction.isPresent() ? 1 : 0) != 0, (Object)"filterFunction not supported for rowEqualsRow");
        for (int i = 0; i < this.hashChannels.size(); ++i) {
            Block rightBlock;
            Block leftBlock;
            int hashChannel = this.hashChannels.get(i);
            Type type = this.types.get(hashChannel);
            if (TypeUtils.positionEqualsPosition(type, leftBlock = leftPage.getBlock(i), leftPosition, rightBlock = rightPage.getBlock(i), rightPosition)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean positionEqualsRow(int leftBlockIndex, int leftPosition, int rightPosition, Page rightPage) {
        for (int i = 0; i < this.hashChannels.size(); ++i) {
            Block rightBlock;
            Block leftBlock;
            int hashChannel = this.hashChannels.get(i);
            Type type = this.types.get(hashChannel);
            if (TypeUtils.positionEqualsPosition(type, leftBlock = this.channels.get(hashChannel).get(leftBlockIndex), leftPosition, rightBlock = rightPage.getBlock(i), rightPosition)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean positionEqualsRowIgnoreNulls(int leftBlockIndex, int leftPosition, int rightPosition, Page rightPage) {
        for (int i = 0; i < this.hashChannels.size(); ++i) {
            Block rightBlock;
            Block leftBlock;
            int hashChannel = this.hashChannels.get(i);
            Type type = this.types.get(hashChannel);
            if (type.equalTo(leftBlock = this.channels.get(hashChannel).get(leftBlockIndex), leftPosition, rightBlock = rightPage.getBlock(i), rightPosition)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean positionEqualsRow(int leftBlockIndex, int leftPosition, int rightPosition, Page page, int[] rightHashChannels) {
        for (int i = 0; i < this.hashChannels.size(); ++i) {
            Block rightBlock;
            Block leftBlock;
            int hashChannel = this.hashChannels.get(i);
            Type type = this.types.get(hashChannel);
            if (TypeUtils.positionEqualsPosition(type, leftBlock = this.channels.get(hashChannel).get(leftBlockIndex), leftPosition, rightBlock = page.getBlock(rightHashChannels[i]), rightPosition)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean positionEqualsPosition(int leftBlockIndex, int leftPosition, int rightBlockIndex, int rightPosition) {
        for (int hashChannel : this.hashChannels) {
            Block rightBlock;
            List<Block> channel;
            Block leftBlock;
            Type type = this.types.get(hashChannel);
            if (TypeUtils.positionEqualsPosition(type, leftBlock = (channel = this.channels.get(hashChannel)).get(leftBlockIndex), leftPosition, rightBlock = channel.get(rightBlockIndex), rightPosition)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean positionEqualsPositionIgnoreNulls(int leftBlockIndex, int leftPosition, int rightBlockIndex, int rightPosition) {
        for (int hashChannel : this.hashChannels) {
            Block rightBlock;
            List<Block> channel;
            Block leftBlock;
            Type type = this.types.get(hashChannel);
            if (type.equalTo(leftBlock = (channel = this.channels.get(hashChannel)).get(leftBlockIndex), leftPosition, rightBlock = channel.get(rightBlockIndex), rightPosition)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Optional<JoinFilterFunction> getFilterFunction() {
        return this.filterFunction;
    }

    @Override
    public boolean applyFilterFunction(int leftBlockIndex, int leftPosition, int rightPosition, Block[] allRightBlocks) {
        return this.filterFunction.get().filter(leftPosition, this.getLeftBlocks(leftBlockIndex), rightPosition, allRightBlocks);
    }

    private Block[] getLeftBlocks(int leftBlockIndex) {
        if (this.channelArrays.isEmpty()) {
            return EMPTY_BLOCK_ARRAY;
        }
        return this.channelArrays.get(leftBlockIndex);
    }

    @Override
    public boolean isPositionNull(int blockIndex, int blockPosition) {
        for (int hashChannel : this.hashChannels) {
            List<Block> channel = this.channels.get(hashChannel);
            Block block = channel.get(blockIndex);
            if (!block.isNull(blockPosition)) continue;
            return true;
        }
        return false;
    }
}

