/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.JoinFilterFunction;
import com.facebook.presto.operator.LookupSource;
import com.facebook.presto.operator.LookupSourceSupplier;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.PagesIndex;
import com.facebook.presto.operator.PartitionedLookupSourceSupplier;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class ParallelHashBuildOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final PartitionedLookupSourceSupplier lookupSourceSupplier;
    private final int partitionIndex;
    private final List<Integer> hashChannels;
    private final Optional<Integer> preComputedHashChannel;
    private final Optional<JoinFilterFunction> filterFunction;
    private final PagesIndex index;
    private boolean finished;

    public ParallelHashBuildOperator(OperatorContext operatorContext, PartitionedLookupSourceSupplier lookupSourceSupplier, int partitionIndex, List<Integer> hashChannels, Optional<Integer> preComputedHashChannel, Optional<JoinFilterFunction> filterFunction, int expectedPositions) {
        this.operatorContext = operatorContext;
        this.partitionIndex = partitionIndex;
        this.filterFunction = filterFunction;
        this.index = new PagesIndex(lookupSourceSupplier.getTypes(), expectedPositions);
        this.lookupSourceSupplier = lookupSourceSupplier;
        this.hashChannels = hashChannels;
        this.preComputedHashChannel = preComputedHashChannel;
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public List<Type> getTypes() {
        return this.lookupSourceSupplier.getTypes();
    }

    @Override
    public void finish() {
        if (this.finished) {
            return;
        }
        this.finished = true;
        LookupSource lookupSource = this.index.createLookupSource(this.hashChannels, this.preComputedHashChannel, this.filterFunction);
        this.lookupSourceSupplier.setLookupSource(this.partitionIndex, lookupSource, this.operatorContext);
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public boolean needsInput() {
        return !this.finished;
    }

    @Override
    public void addInput(Page page) {
        Objects.requireNonNull(page, "page is null");
        Preconditions.checkState((!this.isFinished() ? 1 : 0) != 0, (Object)"Operator is already finished");
        this.index.addPage(page);
        this.operatorContext.setMemoryReservation(page.getPositionCount());
        this.operatorContext.recordGeneratedOutput(page.getSizeInBytes(), page.getPositionCount());
    }

    @Override
    public Page getOutput() {
        return null;
    }

    public static class ParallelHashBuildOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final PartitionedLookupSourceSupplier lookupSourceSupplier;
        private final List<Integer> hashChannels;
        private final Optional<Integer> preComputedHashChannel;
        private final Optional<JoinFilterFunction> filterFunction;
        private final int expectedPositions;
        private int partitionIndex;
        private boolean closed;

        public ParallelHashBuildOperatorFactory(int operatorId, PlanNodeId planNodeId, List<Type> types, Map<Symbol, Integer> layout, List<Integer> hashChannels, Optional<Integer> preComputedHashChannel, boolean outer, Optional<JoinFilterFunction> filterFunction, int expectedPositions, int partitionCount) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            Preconditions.checkArgument((Integer.bitCount(partitionCount) == 1 ? 1 : 0) != 0, (Object)"partitionCount must be a power of 2");
            this.lookupSourceSupplier = new PartitionedLookupSourceSupplier(types, hashChannels, partitionCount, Objects.requireNonNull(layout, "layout is null"), outer);
            Preconditions.checkArgument((!hashChannels.isEmpty() ? 1 : 0) != 0, (Object)"hashChannels is empty");
            this.hashChannels = ImmutableList.copyOf((Collection)Objects.requireNonNull(hashChannels, "hashChannels is null"));
            this.preComputedHashChannel = Objects.requireNonNull(preComputedHashChannel, "preComputedHashChannel is null");
            this.filterFunction = Objects.requireNonNull(filterFunction, "filterFunction is null");
            this.expectedPositions = expectedPositions;
        }

        public LookupSourceSupplier getLookupSourceSupplier() {
            return this.lookupSourceSupplier;
        }

        @Override
        public List<Type> getTypes() {
            return this.lookupSourceSupplier.getTypes();
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.planNodeId, ParallelHashBuildOperator.class.getSimpleName());
            ParallelHashBuildOperator operator = new ParallelHashBuildOperator(operatorContext, this.lookupSourceSupplier, this.partitionIndex, this.hashChannels, this.preComputedHashChannel, this.filterFunction, this.expectedPositions);
            ++this.partitionIndex;
            return operator;
        }

        @Override
        public void close() {
            this.closed = true;
        }

        @Override
        public OperatorFactory duplicate() {
            throw new UnsupportedOperationException("Parallel hash build can not be duplicated");
        }
    }
}

