/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.block.RunLengthEncodedBlock;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.util.ImmutableCollectors;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class GroupIdOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final List<Type> types;
    private final BitSet[] groupingSetNullChannels;
    private final Block[] nullBlocks;
    private final Block[] groupIdBlocks;
    private final int[] groupInputs;
    private final int[] copyInputs;
    private Page currentPage = null;
    private int currentGroupingSet = 0;
    private boolean finishing;

    public GroupIdOperator(OperatorContext operatorContext, List<Type> types, BitSet[] groupingSetNullChannels, Block[] nullBlocks, Block[] groupIdBlocks, int[] groupInputs, int[] copyInputs) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.types = Objects.requireNonNull(types, "types is null");
        this.groupingSetNullChannels = Objects.requireNonNull(groupingSetNullChannels, "groupingSetNullChannels is null");
        this.nullBlocks = Objects.requireNonNull(nullBlocks);
        this.groupIdBlocks = Objects.requireNonNull(groupIdBlocks);
        Preconditions.checkArgument((groupIdBlocks.length == groupingSetNullChannels.length ? 1 : 0) != 0, (Object)"groupIdBlocks and groupingSetNullChannels must have the same length");
        this.groupInputs = Objects.requireNonNull(groupInputs);
        this.copyInputs = Objects.requireNonNull(copyInputs);
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public List<Type> getTypes() {
        return this.types;
    }

    @Override
    public void finish() {
        this.finishing = true;
    }

    @Override
    public boolean isFinished() {
        return this.finishing && this.currentPage == null;
    }

    @Override
    public boolean needsInput() {
        return !this.finishing && this.currentPage == null;
    }

    @Override
    public void addInput(Page page) {
        Preconditions.checkState((!this.finishing ? 1 : 0) != 0, (Object)"Operator is already finishing");
        Preconditions.checkState((this.currentPage == null ? 1 : 0) != 0, (Object)"currentPage must be null to add a new page");
        this.currentPage = Objects.requireNonNull(page, "page is null");
    }

    @Override
    public Page getOutput() {
        if (this.currentPage == null) {
            return null;
        }
        return this.generateNextPage();
    }

    private Page generateNextPage() {
        int i;
        Block[] outputBlocks = new Block[this.types.size()];
        for (i = 0; i < this.groupInputs.length; ++i) {
            outputBlocks[i] = this.groupingSetNullChannels[this.currentGroupingSet].get(this.groupInputs[i]) ? new RunLengthEncodedBlock(this.nullBlocks[i], this.currentPage.getPositionCount()) : this.currentPage.getBlock(this.groupInputs[i]);
        }
        for (i = 0; i < this.copyInputs.length; ++i) {
            outputBlocks[this.groupInputs.length + i] = this.currentPage.getBlock(this.copyInputs[i]);
        }
        outputBlocks[outputBlocks.length - 1] = new RunLengthEncodedBlock(this.groupIdBlocks[this.currentGroupingSet], this.currentPage.getPositionCount());
        this.currentGroupingSet = (this.currentGroupingSet + 1) % this.groupingSetNullChannels.length;
        Page outputPage = new Page(this.currentPage.getPositionCount(), outputBlocks);
        if (this.currentGroupingSet == 0) {
            this.currentPage = null;
        }
        return outputPage;
    }

    public static class GroupIdOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final List<Type> outputTypes;
        private final List<List<Integer>> groupingSetChannels;
        private final List<Integer> groupingChannels;
        private final List<Integer> copyChannels;
        private boolean closed;

        public GroupIdOperatorFactory(int operatorId, PlanNodeId planNodeId, List<? extends Type> outputTypes, List<List<Integer>> groupingSetChannels, List<Integer> groupingChannels, List<Integer> copyChannels) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.outputTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(outputTypes));
            this.groupingSetChannels = ImmutableList.copyOf((Collection)Objects.requireNonNull(groupingSetChannels));
            this.groupingChannels = ImmutableList.copyOf((Collection)Objects.requireNonNull(groupingChannels));
            this.copyChannels = ImmutableList.copyOf((Collection)Objects.requireNonNull(copyChannels));
        }

        @Override
        public List<Type> getTypes() {
            return this.outputTypes;
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.planNodeId, GroupIdOperator.class.getSimpleName());
            Set allGroupingColumns = (Set)this.groupingSetChannels.stream().flatMap(Collection::stream).collect(ImmutableCollectors.toImmutableSet());
            BitSet[] groupingSetNullChannels = new BitSet[this.groupingSetChannels.size()];
            for (int i = 0; i < this.groupingSetChannels.size(); ++i) {
                groupingSetNullChannels[i] = new BitSet(this.groupingChannels.size() + this.copyChannels.size());
                Iterator<Object> iterator = allGroupingColumns.iterator();
                while (iterator.hasNext()) {
                    int groupingColumn = (Integer)iterator.next();
                    groupingSetNullChannels[i].set(groupingColumn, true);
                }
                iterator = this.groupingSetChannels.get(i).iterator();
                while (iterator.hasNext()) {
                    int nonNullGroupingColumn = (Integer)iterator.next();
                    groupingSetNullChannels[i].set(nonNullGroupingColumn, false);
                }
            }
            Block[] nullBlocks = new Block[this.groupingChannels.size()];
            for (int i = 0; i < this.groupingChannels.size(); ++i) {
                nullBlocks[i] = this.outputTypes.get(i).createBlockBuilder(new BlockBuilderStatus(), 1).appendNull().build();
            }
            Block[] groupIdBlocks = new Block[groupingSetNullChannels.length];
            for (int i = 0; i < groupingSetNullChannels.length; ++i) {
                BlockBuilder builder = BigintType.BIGINT.createBlockBuilder(new BlockBuilderStatus(), 1);
                BigintType.BIGINT.writeLong(builder, (long)i);
                groupIdBlocks[i] = builder.build();
            }
            int[] groupInputs = this.groupingChannels.stream().mapToInt(Integer::intValue).toArray();
            int[] copyInputs = this.copyChannels.stream().mapToInt(Integer::intValue).toArray();
            return new GroupIdOperator(operatorContext, this.outputTypes, groupingSetNullChannels, nullBlocks, groupIdBlocks, groupInputs, copyInputs);
        }

        @Override
        public void close() {
            this.closed = true;
        }

        @Override
        public OperatorFactory duplicate() {
            return new GroupIdOperatorFactory(this.operatorId, this.planNodeId, this.outputTypes, this.groupingSetChannels, this.groupingChannels, this.copyChannels);
        }
    }
}

