/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.FilterFunction;
import com.facebook.presto.operator.PageProcessor;
import com.facebook.presto.operator.ProjectionFunction;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.block.DictionaryBlock;
import com.facebook.presto.spi.block.DictionaryId;
import com.facebook.presto.spi.block.LazyBlock;
import com.facebook.presto.spi.block.RunLengthEncodedBlock;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.IntStream;

public class GenericPageProcessor
implements PageProcessor {
    private final FilterFunction filterFunction;
    private final List<ProjectionFunction> projections;
    private final Block[] inputDictionaries;
    private final Block[] outputDictionaries;
    private Block inputFilterDictionary;
    private boolean[] filterResult;

    public GenericPageProcessor(FilterFunction filterFunction, Iterable<? extends ProjectionFunction> projections) {
        this.filterFunction = filterFunction;
        this.projections = ImmutableList.copyOf(projections);
        this.inputDictionaries = new Block[this.projections.size()];
        this.outputDictionaries = new Block[this.projections.size()];
    }

    @Override
    public int process(ConnectorSession session, Page page, int start, int end, PageBuilder pageBuilder) {
        int position;
        Block[] inputBlocks = page.getBlocks();
        for (position = start; position < end && !pageBuilder.isFull(); ++position) {
            if (!this.filterFunction.filter(position, inputBlocks)) continue;
            pageBuilder.declarePosition();
            for (int i = 0; i < this.projections.size(); ++i) {
                this.projections.get(i).project(position, inputBlocks, pageBuilder.getBlockBuilder(i));
            }
        }
        return position;
    }

    @Override
    public Page processColumnar(ConnectorSession session, Page page, List<? extends Type> types) {
        int[] selectedPositions = this.filterPage(page);
        if (selectedPositions.length == 0) {
            return null;
        }
        if (this.projections.isEmpty()) {
            return new Page(selectedPositions.length, new Block[0]);
        }
        PageBuilder pageBuilder = new PageBuilder(types);
        Block[] inputBlocks = page.getBlocks();
        for (int projectionIndex = 0; projectionIndex < this.projections.size(); ++projectionIndex) {
            ProjectionFunction projection = this.projections.get(projectionIndex);
            GenericPageProcessor.projectColumnar(selectedPositions, pageBuilder.getBlockBuilder(projectionIndex), inputBlocks, projection);
        }
        pageBuilder.declarePositions(selectedPositions.length);
        return pageBuilder.build();
    }

    @Override
    public Page processColumnarDictionary(ConnectorSession session, Page page, List<? extends Type> types) {
        Page inputPage = this.getNonLazyPage(page);
        int[] selectedPositions = this.filterPage(inputPage);
        HashMap<DictionaryId, DictionaryId> dictionarySourceIds = new HashMap<DictionaryId, DictionaryId>();
        if (selectedPositions.length == 0) {
            return null;
        }
        if (this.projections.isEmpty()) {
            return new Page(selectedPositions.length, new Block[0]);
        }
        PageBuilder pageBuilder = new PageBuilder(types);
        Block[] inputBlocks = page.getBlocks();
        Block[] outputBlocks = new Block[this.projections.size()];
        for (int projectionIndex = 0; projectionIndex < this.projections.size(); ++projectionIndex) {
            ProjectionFunction projection = this.projections.get(projectionIndex);
            outputBlocks[projectionIndex] = GenericPageProcessor.canDictionaryProcess(projection, inputPage) ? this.projectColumnarDictionary(inputPage, selectedPositions, projection, dictionarySourceIds) : GenericPageProcessor.projectColumnar(selectedPositions, pageBuilder.getBlockBuilder(projectionIndex), inputBlocks, projection).build();
        }
        for (Block block : outputBlocks) {
            Verify.verify((block.getPositionCount() == selectedPositions.length ? 1 : 0) != 0);
        }
        return new Page(selectedPositions.length, outputBlocks);
    }

    private Block projectColumnarDictionary(Page inputPage, int[] selectedPositions, ProjectionFunction projection, Map<DictionaryId, DictionaryId> dictionarySourceIds) {
        int inputChannel = (Integer)Iterables.getOnlyElement(projection.getInputChannels());
        Block[] blocks = new Block[inputPage.getChannelCount()];
        if (inputPage.getBlock(inputChannel) instanceof RunLengthEncodedBlock) {
            RunLengthEncodedBlock rleBlock = (RunLengthEncodedBlock)inputPage.getBlock(inputChannel);
            BlockBuilder builder = projection.getType().createBlockBuilder(new BlockBuilderStatus(), 1);
            blocks[inputChannel] = rleBlock.getValue();
            projection.project(0, blocks, builder);
            return new RunLengthEncodedBlock(builder.build(), selectedPositions.length);
        }
        Block outputDictionary = this.projectDictionary(projection, inputPage);
        int[] outputIds = GenericPageProcessor.filterIds(projection, inputPage, selectedPositions);
        DictionaryBlock dictionaryBlock = (DictionaryBlock)inputPage.getBlock(inputChannel);
        DictionaryId sourceId = dictionarySourceIds.get(dictionaryBlock.getDictionarySourceId());
        if (sourceId == null) {
            sourceId = DictionaryId.randomDictionaryId();
            dictionarySourceIds.put(dictionaryBlock.getDictionarySourceId(), sourceId);
        }
        return new DictionaryBlock(selectedPositions.length, outputDictionary, Slices.wrappedIntArray((int[])outputIds), false, sourceId);
    }

    private static BlockBuilder projectColumnar(int[] selectedPositions, BlockBuilder blockBuilder, Block[] inputBlocks, ProjectionFunction projection) {
        for (int position : selectedPositions) {
            projection.project(position, inputBlocks, blockBuilder);
        }
        return blockBuilder;
    }

    private static int[] filterIds(ProjectionFunction projection, Page page, int[] selectedPositions) {
        Slice ids = ((DictionaryBlock)page.getBlock(((Integer)Iterables.getOnlyElement(projection.getInputChannels())).intValue())).getIds();
        int[] outputIds = new int[selectedPositions.length];
        for (int pos = 0; pos < selectedPositions.length; ++pos) {
            outputIds[pos] = ids.getInt(selectedPositions[pos] * 4);
        }
        return outputIds;
    }

    private Block projectDictionary(ProjectionFunction projection, Page page) {
        int inputChannel = (Integer)Iterables.getOnlyElement(projection.getInputChannels());
        Block dictionary = ((DictionaryBlock)page.getBlock(inputChannel)).getDictionary();
        int projectionIndex = this.projections.indexOf(projection);
        if (this.inputDictionaries[projectionIndex] == dictionary) {
            return this.outputDictionaries[projectionIndex];
        }
        BlockBuilder dictionaryBuilder = projection.getType().createBlockBuilder(new BlockBuilderStatus(), dictionary.getPositionCount());
        Block[] blocks = new Block[page.getChannelCount()];
        blocks[inputChannel] = dictionary;
        for (int i = 0; i < dictionary.getPositionCount(); ++i) {
            projection.project(i, blocks, dictionaryBuilder);
        }
        this.inputDictionaries[projectionIndex] = dictionary;
        this.outputDictionaries[projectionIndex] = dictionaryBuilder.build();
        return this.outputDictionaries[projectionIndex];
    }

    private static boolean canDictionaryProcess(ProjectionFunction projection, Page inputPage) {
        if (!projection.isDeterministic()) {
            return false;
        }
        Set<Integer> inputChannels = projection.getInputChannels();
        if (inputChannels.size() != 1) {
            return false;
        }
        Block block = inputPage.getBlock(((Integer)Iterables.getOnlyElement(inputChannels)).intValue());
        return block instanceof DictionaryBlock || block instanceof RunLengthEncodedBlock;
    }

    private Page getNonLazyPage(Page page) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (ProjectionFunction projection : this.projections) {
            builder.addAll(projection.getInputChannels());
        }
        ImmutableSet inputChannels = builder.build();
        if (inputChannels.isEmpty()) {
            return page;
        }
        Block[] blocks = page.getBlocks();
        Iterator iterator = inputChannels.iterator();
        while (iterator.hasNext()) {
            int inputChannel = (Integer)iterator.next();
            Block block = page.getBlock(inputChannel);
            if (!(block instanceof LazyBlock)) continue;
            blocks[inputChannel] = ((LazyBlock)block).getBlock();
        }
        return new Page(blocks);
    }

    private int[] filterPage(Page page) {
        int[] selected = new int[page.getPositionCount()];
        int index = 0;
        if (this.filterFunction.getInputChannels().size() == 1) {
            int channel = (Integer)Iterables.getOnlyElement(this.filterFunction.getInputChannels());
            if (page.getBlock(channel) instanceof DictionaryBlock) {
                int i;
                boolean[] selectedDictionaryPositions;
                DictionaryBlock dictionaryBlock = (DictionaryBlock)page.getBlock(channel);
                Block dictionary = dictionaryBlock.getDictionary();
                Block[] blocks = new Block[page.getPositionCount()];
                blocks[channel] = dictionary;
                if (this.inputFilterDictionary == dictionary) {
                    selectedDictionaryPositions = this.filterResult;
                } else {
                    selectedDictionaryPositions = new boolean[dictionary.getPositionCount()];
                    for (i = 0; i < dictionary.getPositionCount(); ++i) {
                        selectedDictionaryPositions[i] = this.filterFunction.filter(i, blocks);
                    }
                    this.inputFilterDictionary = dictionary;
                    this.filterResult = selectedDictionaryPositions;
                }
                for (i = 0; i < page.getPositionCount(); ++i) {
                    if (!selectedDictionaryPositions[dictionaryBlock.getId(i)]) continue;
                    selected[index] = i;
                    ++index;
                }
                return Arrays.copyOf(selected, index);
            }
            if (page.getBlock(channel) instanceof RunLengthEncodedBlock) {
                RunLengthEncodedBlock rleBlock = (RunLengthEncodedBlock)page.getBlock(channel);
                Block[] blocks = new Block[page.getPositionCount()];
                blocks[channel] = rleBlock.getValue();
                if (this.filterFunction.filter(0, blocks)) {
                    return IntStream.range(0, page.getPositionCount()).toArray();
                }
                return new int[0];
            }
        }
        Block[] blocks = page.getBlocks();
        for (int position = 0; position < page.getPositionCount(); ++position) {
            if (!this.filterFunction.filter(position, blocks)) continue;
            selected[index] = position;
            ++index;
        }
        return Arrays.copyOf(selected, index);
    }
}

