/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.FunctionKind;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.LongVariableConstraint;
import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.SqlScalarFunction;
import com.facebook.presto.metadata.TypeVariableConstraint;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementation;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandle;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public abstract class SqlOperator
extends SqlScalarFunction {
    public static SqlOperator create(OperatorType operatorType, List<TypeVariableConstraint> typeVariableConstraints, List<LongVariableConstraint> longVariableConstraints, List<TypeSignature> argumentTypes, TypeSignature returnType, MethodHandle methodHandle, Optional<MethodHandle> instanceFactory, boolean nullable, List<Boolean> nullableArguments) {
        return new SimpleSqlOperator(operatorType, typeVariableConstraints, longVariableConstraints, argumentTypes, returnType, methodHandle, instanceFactory, nullable, nullableArguments);
    }

    protected SqlOperator(OperatorType operatorType, List<TypeVariableConstraint> typeVariableConstraints, List<LongVariableConstraint> longVariableConstraints, TypeSignature returnType, List<TypeSignature> argumentTypes) {
        super(new Signature(FunctionRegistry.mangleOperatorName(operatorType), FunctionKind.SCALAR, typeVariableConstraints, longVariableConstraints, returnType, argumentTypes, false));
    }

    @Override
    public final boolean isHidden() {
        return true;
    }

    @Override
    public final boolean isDeterministic() {
        return true;
    }

    @Override
    public final String getDescription() {
        return null;
    }

    public static class SimpleSqlOperator
    extends SqlOperator {
        private final MethodHandle methodHandle;
        private final Optional<MethodHandle> instanceFactory;
        private final boolean nullable;
        private final List<Boolean> nullableArguments;

        public SimpleSqlOperator(OperatorType operatorType, List<TypeVariableConstraint> typeVariableConstraints, List<LongVariableConstraint> longVariableConstraints, List<TypeSignature> argumentTypes, TypeSignature returnType, MethodHandle methodHandle, Optional<MethodHandle> instanceFactory, boolean nullable, List<Boolean> nullableArguments) {
            super(operatorType, typeVariableConstraints, longVariableConstraints, returnType, argumentTypes);
            this.methodHandle = Objects.requireNonNull(methodHandle, "methodHandle is null");
            this.instanceFactory = Objects.requireNonNull(instanceFactory, "instanceFactory is null");
            this.nullable = nullable;
            this.nullableArguments = ImmutableList.copyOf((Collection)Objects.requireNonNull(nullableArguments, "nullableArguments is null"));
        }

        @Override
        public ScalarFunctionImplementation specialize(BoundVariables boundVariables, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
            return new ScalarFunctionImplementation(this.nullable, this.nullableArguments, this.methodHandle, this.instanceFactory, this.isDeterministic());
        }
    }
}

