/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.LongVariableConstraint;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.TypeVariableConstraint;
import com.facebook.presto.spi.type.NamedTypeSignature;
import com.facebook.presto.spi.type.ParameterKind;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.spi.type.TypeSignatureParameter;
import com.facebook.presto.type.TypeCalculation;
import com.facebook.presto.type.UnknownType;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class SignatureBinder {
    private final TypeManager typeManager;
    private final Signature declaredSignature;
    private final boolean allowCoercion;
    private final Map<String, TypeVariableConstraint> typeVariableConstraints;

    public SignatureBinder(TypeManager typeManager, Signature declaredSignature, boolean allowCoercion) {
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.declaredSignature = Objects.requireNonNull(declaredSignature, "parametrizedSignature is null");
        this.allowCoercion = allowCoercion;
        this.typeVariableConstraints = declaredSignature.getTypeVariableConstraints().stream().collect(Collectors.toMap(TypeVariableConstraint::getName, t -> t));
    }

    public Optional<Signature> bind(List<? extends Type> actualArgumentTypes) {
        Optional<BoundVariables> boundVariables = this.bindVariables(actualArgumentTypes);
        if (!boundVariables.isPresent()) {
            return Optional.empty();
        }
        return Optional.of(SignatureBinder.bindVariables(this.declaredSignature, boundVariables.get(), actualArgumentTypes.size()));
    }

    public Optional<BoundVariables> bindVariables(List<? extends Type> actualArgumentTypes) {
        BoundVariables.Builder variableBinder;
        boolean variableArity;
        List<TypeSignature> expectedArgumentSignatures = this.declaredSignature.getArgumentTypes();
        if (!this.matchArguments(expectedArgumentSignatures, actualArgumentTypes, variableArity = this.declaredSignature.isVariableArity(), variableBinder = BoundVariables.builder())) {
            return Optional.empty();
        }
        this.calculateVariableValuesForLongConstraints(variableBinder);
        BoundVariables boundVariables = variableBinder.build();
        if (!this.allTypeVariablesBound(boundVariables)) {
            return Optional.empty();
        }
        return Optional.of(boundVariables);
    }

    public Optional<BoundVariables> bindVariables(List<? extends Type> actualArgumentTypes, Type actualReturnType) {
        boolean variableArity;
        BoundVariables.Builder variableBinder = BoundVariables.builder();
        TypeSignature expectedReturnTypeSignature = this.declaredSignature.getReturnType();
        if (!this.bind(expectedReturnTypeSignature, actualReturnType, variableBinder)) {
            return Optional.empty();
        }
        List<TypeSignature> expectedArgumentSignatures = this.declaredSignature.getArgumentTypes();
        if (!this.matchArguments(expectedArgumentSignatures, actualArgumentTypes, variableArity = this.declaredSignature.isVariableArity(), variableBinder)) {
            return Optional.empty();
        }
        this.calculateVariableValuesForLongConstraints(variableBinder);
        BoundVariables boundVariables = variableBinder.build();
        if (!this.allTypeVariablesBound(boundVariables)) {
            return Optional.empty();
        }
        return Optional.of(boundVariables);
    }

    private boolean matchArguments(List<TypeSignature> expectedTypes, List<? extends Type> actualTypes, boolean variableArity, BoundVariables.Builder variableBinder) {
        if (variableArity && actualTypes.size() < expectedTypes.size() - 1) {
            return false;
        }
        if (!variableArity && expectedTypes.size() != actualTypes.size()) {
            return false;
        }
        if (variableArity && actualTypes.size() >= expectedTypes.size()) {
            List<? extends Type> tail = actualTypes.subList(expectedTypes.size() - 1, actualTypes.size());
            Optional commonType = this.typeManager.getCommonSuperType(tail);
            if (!commonType.isPresent()) {
                return false;
            }
            TypeSignature expected = expectedTypes.get(expectedTypes.size() - 1);
            if (!this.bind(expected, (Type)commonType.get(), variableBinder)) {
                return false;
            }
        }
        for (int i = 0; i < actualTypes.size(); ++i) {
            Type actualArgumentType;
            TypeSignature expectedArgumentSignature = expectedTypes.get(Math.min(i, expectedTypes.size() - 1));
            if (this.bind(expectedArgumentSignature, actualArgumentType = actualTypes.get(i), variableBinder)) continue;
            return false;
        }
        return true;
    }

    private boolean bind(TypeSignature expectedSignature, Type actualType, BoundVariables.Builder variableBinder) {
        String expectedTypeBase;
        if (this.isTypeVariable(expectedSignature)) {
            String variable = expectedSignature.getBase();
            return this.matchAndBindTypeVariable(variable, actualType, variableBinder);
        }
        if (expectedSignature.getBase().equals("varchar") && expectedSignature.getParameters().isEmpty()) {
            return actualType.getTypeSignature().getBase().equals("varchar") || this.allowCoercion && this.typeManager.coerceTypeBase(actualType, "varchar").isPresent();
        }
        if (this.isConcreteType(expectedSignature)) {
            Type expectedType = this.typeManager.getType(expectedSignature);
            if (this.allowCoercion) {
                return this.typeManager.canCoerce(actualType, expectedType);
            }
            return actualType.equals(expectedType);
        }
        String actualTypeBase = actualType.getTypeSignature().getBase();
        if (actualTypeBase.equals(expectedTypeBase = expectedSignature.getBase())) {
            return this.matchAndBindTypeParameters(expectedSignature, actualType, variableBinder);
        }
        if (this.allowCoercion) {
            Optional coercionResult = this.typeManager.coerceTypeBase(actualType, expectedTypeBase);
            if (coercionResult.isPresent()) {
                return this.matchAndBindTypeParameters(expectedSignature, (Type)coercionResult.get(), variableBinder);
            }
            if (actualType.equals((Object)UnknownType.UNKNOWN)) {
                return true;
            }
        }
        return false;
    }

    private boolean matchAndBindTypeVariable(String variable, Type actualType, BoundVariables.Builder variableBinder) {
        TypeVariableConstraint typeVariableConstraint = this.typeVariableConstraints.get(variable);
        if (!variableBinder.containsTypeVariable(variable)) {
            if (typeVariableConstraint.canBind(actualType)) {
                variableBinder.setTypeVariable(variable, actualType);
                return true;
            }
            if (this.allowCoercion && actualType.equals((Object)UnknownType.UNKNOWN)) {
                return true;
            }
        } else {
            Optional commonSuperType;
            Type currentBoundType = variableBinder.getTypeVariable(variable);
            if (currentBoundType.equals(actualType)) {
                return true;
            }
            if (this.allowCoercion && (commonSuperType = this.typeManager.getCommonSuperType(currentBoundType, actualType)).isPresent() && typeVariableConstraint.canBind((Type)commonSuperType.get())) {
                variableBinder.setTypeVariable(variable, (Type)commonSuperType.get());
                return true;
            }
        }
        return false;
    }

    private boolean matchAndBindTypeParameters(TypeSignature expectedArgumentSignature, Type actualArgumentType, BoundVariables.Builder variableBinder) {
        TypeSignature actualArgumentSignature = actualArgumentType.getTypeSignature();
        Preconditions.checkState((boolean)expectedArgumentSignature.getBase().equals(actualArgumentSignature.getBase()), (Object)"equal base types are expected here");
        List expectedTypeParameters = expectedArgumentSignature.getParameters();
        List actualTypeParameters = actualArgumentSignature.getParameters();
        if (expectedTypeParameters.size() != actualTypeParameters.size()) {
            return false;
        }
        for (int typeParameterIndex = 0; typeParameterIndex < expectedTypeParameters.size(); ++typeParameterIndex) {
            TypeSignatureParameter actualTypeParameter;
            TypeSignatureParameter expectedTypeParameter = (TypeSignatureParameter)expectedTypeParameters.get(typeParameterIndex);
            if (this.matchAndBindTypeParameter(expectedTypeParameter, actualTypeParameter = (TypeSignatureParameter)actualTypeParameters.get(typeParameterIndex), variableBinder)) continue;
            return false;
        }
        return true;
    }

    private boolean matchAndBindTypeParameter(TypeSignatureParameter expected, TypeSignatureParameter actual, BoundVariables.Builder variableBinder) {
        switch (expected.getKind()) {
            case VARIABLE: {
                String variable = expected.getVariable();
                Preconditions.checkState((actual.getKind() == ParameterKind.LONG ? 1 : 0) != 0, (Object)"LONG parameter kind is expected here");
                Long variableValue = actual.getLongLiteral();
                return this.matchAndBindLongVariable(variable, variableValue, variableBinder);
            }
            case LONG: {
                Preconditions.checkState((actual.getKind() == ParameterKind.LONG ? 1 : 0) != 0, (Object)"LONG parameter kind is expected here");
                return actual.getLongLiteral().equals(expected.getLongLiteral());
            }
            case TYPE: {
                Preconditions.checkState((actual.getKind() == ParameterKind.TYPE ? 1 : 0) != 0, (Object)"TYPE parameter kind is expected here");
                TypeSignature expectedTypeSignature = expected.getTypeSignature();
                TypeSignature actualTypeSignature = actual.getTypeSignature();
                Type actualType = this.typeManager.getType(actualTypeSignature);
                return this.bind(expectedTypeSignature, actualType, variableBinder);
            }
            case NAMED_TYPE: {
                Preconditions.checkState((actual.getKind() == ParameterKind.NAMED_TYPE ? 1 : 0) != 0, (Object)"NAMED_TYPE parameter kind is expected here");
                NamedTypeSignature expectedNamedTypeSignature = expected.getNamedTypeSignature();
                NamedTypeSignature actualNamedTypeSignature = actual.getNamedTypeSignature();
                if (!expectedNamedTypeSignature.getName().equals(actualNamedTypeSignature.getName())) {
                    return false;
                }
                TypeSignature expectedTypeSignature = expectedNamedTypeSignature.getTypeSignature();
                TypeSignature actualTypeSignature = actualNamedTypeSignature.getTypeSignature();
                Type actualType = this.typeManager.getType(actualTypeSignature);
                return this.bind(expectedTypeSignature, actualType, variableBinder);
            }
        }
        throw new IllegalStateException("Unknown parameter kind: " + expected.getKind());
    }

    private boolean matchAndBindLongVariable(String variable, Long value, BoundVariables.Builder variableBinder) {
        if (variableBinder.containsLongVariable(variable)) {
            Long currentVariableValue = variableBinder.getLongVariable(variable);
            return value.equals(currentVariableValue);
        }
        variableBinder.setLongVariable(variable, value);
        return true;
    }

    private void calculateVariableValuesForLongConstraints(BoundVariables.Builder variableBinder) {
        for (LongVariableConstraint longVariableConstraint : this.declaredSignature.getLongVariableConstraints()) {
            String calculation = longVariableConstraint.getExpression();
            String variableName = longVariableConstraint.getName();
            Long calculatedValue = TypeCalculation.calculateLiteralValue((String)calculation, variableBinder.getLongVariables());
            if (variableBinder.containsLongVariable(variableName)) {
                Long currentValue = variableBinder.getLongVariable(variableName);
                Preconditions.checkState((boolean)Objects.equals(currentValue, calculatedValue), (String)"variable '%s' is already set to %s when trying to set %s", (Object[])new Object[]{variableName, currentValue, calculatedValue});
            }
            variableBinder.setLongVariable(variableName, calculatedValue);
        }
    }

    private boolean isTypeVariable(TypeSignature signature) {
        if (this.typeVariableConstraints.containsKey(signature.getBase())) {
            Preconditions.checkState((boolean)signature.getParameters().isEmpty(), (Object)"TypeSignature that represent type variable shouldn't be parametrized");
            return true;
        }
        return false;
    }

    private boolean isConcreteType(TypeSignature typeSignature) {
        if (this.isTypeVariable(typeSignature)) {
            return false;
        }
        block6: for (TypeSignatureParameter typeSignatureParameter : typeSignature.getParameters()) {
            switch (typeSignatureParameter.getKind()) {
                case LONG: {
                    continue block6;
                }
                case VARIABLE: {
                    return false;
                }
                case TYPE: {
                    if (this.isConcreteType(typeSignatureParameter.getTypeSignature())) continue block6;
                    return false;
                }
                case NAMED_TYPE: {
                    if (this.isConcreteType(typeSignatureParameter.getNamedTypeSignature().getTypeSignature())) continue block6;
                    return false;
                }
            }
            throw new UnsupportedOperationException("Unsupported TypeSignatureParameter kind: " + typeSignatureParameter.getKind());
        }
        return true;
    }

    private boolean allTypeVariablesBound(BoundVariables boundVariables) {
        return boundVariables.getTypeVariables().keySet().equals(this.typeVariableConstraints.keySet());
    }

    public static Signature bindVariables(Signature signature, BoundVariables boundVariables, int arity) {
        List<TypeSignature> argumentSignatures = SignatureBinder.fillInMissingVariableArguments(signature.getArgumentTypes(), arity);
        List<TypeSignature> boundArgumentSignatures = SignatureBinder.bindVariables(argumentSignatures, boundVariables);
        TypeSignature boundReturnTypeSignature = SignatureBinder.bindVariables(signature.getReturnType(), boundVariables);
        return new Signature(signature.getName(), signature.getKind(), (List<TypeVariableConstraint>)ImmutableList.of(), (List<LongVariableConstraint>)ImmutableList.of(), boundReturnTypeSignature, boundArgumentSignatures, false);
    }

    private static List<TypeSignature> fillInMissingVariableArguments(List<TypeSignature> argumentSignatures, int arity) {
        int variableArityArgumentsCount = arity - argumentSignatures.size();
        if (variableArityArgumentsCount > 0 && !argumentSignatures.isEmpty()) {
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.addAll(argumentSignatures);
            for (int i = 0; i < variableArityArgumentsCount; ++i) {
                builder.add(Iterables.getLast(argumentSignatures));
            }
            return builder.build();
        }
        return argumentSignatures;
    }

    public static List<TypeSignature> bindVariables(List<TypeSignature> typeSignatures, BoundVariables boundVariables) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (TypeSignature typeSignature : typeSignatures) {
            builder.add((Object)SignatureBinder.bindVariables(typeSignature, boundVariables));
        }
        return builder.build();
    }

    public static TypeSignature bindVariables(TypeSignature typeSignature, BoundVariables boundVariables) {
        String baseType = typeSignature.getBase();
        if (boundVariables.containsTypeVariable(baseType)) {
            Preconditions.checkState((boolean)typeSignature.getParameters().isEmpty(), (Object)"Type parameters cannot have parameters");
            return boundVariables.getTypeVariable(baseType).getTypeSignature();
        }
        List parameters = typeSignature.getParameters().stream().map(typeSignatureParameter -> SignatureBinder.bindVariables(typeSignatureParameter, boundVariables)).collect(Collectors.toList());
        return new TypeSignature(baseType, parameters);
    }

    private static TypeSignatureParameter bindVariables(TypeSignatureParameter parameter, BoundVariables boundVariables) {
        ParameterKind parameterKind = parameter.getKind();
        switch (parameterKind) {
            case TYPE: {
                TypeSignature typeSignature = parameter.getTypeSignature();
                return TypeSignatureParameter.of((TypeSignature)SignatureBinder.bindVariables(typeSignature, boundVariables));
            }
            case NAMED_TYPE: {
                NamedTypeSignature namedTypeSignature = parameter.getNamedTypeSignature();
                TypeSignature typeSignature = namedTypeSignature.getTypeSignature();
                return TypeSignatureParameter.of((NamedTypeSignature)new NamedTypeSignature(namedTypeSignature.getName(), SignatureBinder.bindVariables(typeSignature, boundVariables)));
            }
            case VARIABLE: {
                String variableName = parameter.getVariable();
                Preconditions.checkState((boolean)boundVariables.containsLongVariable(variableName), (String)"Variable is not bound: %s", (Object[])new Object[]{variableName});
                Long variableValue = boundVariables.getLongVariable(variableName);
                return TypeSignatureParameter.of((long)variableValue);
            }
            case LONG: {
                return parameter;
            }
        }
        throw new IllegalStateException("Unknown parameter kind: " + parameter.getKind());
    }
}

