/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.metadata.QualifiedObjectName;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.procedure.Procedure;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Primitives;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class ProcedureRegistry {
    private volatile Map<QualifiedObjectName, Procedure> procedures = ImmutableMap.of();

    public final synchronized void addProcedure(String catalog, Procedure procedure) {
        ProcedureRegistry.validateProcedure(procedure);
        QualifiedObjectName name = new QualifiedObjectName(catalog, procedure.getSchema(), procedure.getName());
        Preconditions.checkArgument((!this.procedures.containsKey(name) ? 1 : 0) != 0, (String)"Procedure already registered: %s", (Object[])new Object[]{name});
        this.procedures = ImmutableMap.builder().putAll(this.procedures).put((Object)name, (Object)procedure).build();
    }

    public Procedure resolve(QualifiedObjectName name) {
        Procedure procedure = this.procedures.get(name);
        if (procedure == null) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.PROCEDURE_NOT_FOUND, "Procedure not registered: " + name);
        }
        return procedure;
    }

    private static void validateProcedure(Procedure procedure) {
        List parameters = procedure.getMethodHandle().type().parameterList().stream().filter(type -> !ConnectorSession.class.isAssignableFrom((Class<?>)type)).collect(Collectors.toList());
        for (int i = 0; i < procedure.getArguments().size(); ++i) {
            Procedure.Argument argument = (Procedure.Argument)procedure.getArguments().get(i);
            Class argumentType = Primitives.unwrap((Class)((Class)parameters.get(i)));
            Class<?> expectedType = ProcedureRegistry.getObjectType(argument.getType());
            Preconditions.checkArgument((boolean)expectedType.equals(argumentType), (String)"Argument '%s' has invalid type %s (expected %s)", (Object[])new Object[]{argument.getName(), argumentType.getName(), expectedType.getName()});
        }
    }

    private static Class<?> getObjectType(Type type) {
        if (type.equals(BooleanType.BOOLEAN)) {
            return Boolean.TYPE;
        }
        if (type.equals(BigintType.BIGINT)) {
            return Long.TYPE;
        }
        if (type.equals(DoubleType.DOUBLE)) {
            return Double.TYPE;
        }
        if (type.equals(VarcharType.VARCHAR)) {
            return String.class;
        }
        if (type.getTypeSignature().getBase().equals("array")) {
            ProcedureRegistry.getObjectType((Type)type.getTypeParameters().get(0));
            return List.class;
        }
        if (type.getTypeSignature().getBase().equals("map")) {
            ProcedureRegistry.getObjectType((Type)type.getTypeParameters().get(0));
            ProcedureRegistry.getObjectType((Type)type.getTypeParameters().get(1));
            return Map.class;
        }
        throw new IllegalArgumentException("Unsupported argument type: " + type.getDisplayName());
    }
}

