/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.QualifiedObjectName;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.QualifiedName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class MetadataUtil {
    private MetadataUtil() {
    }

    public static void checkTableName(String catalogName, Optional<String> schemaName, Optional<String> tableName) {
        MetadataUtil.checkCatalogName(catalogName);
        MetadataUtil.checkSchemaName(schemaName);
        MetadataUtil.checkTableName(tableName);
        Preconditions.checkArgument((schemaName.isPresent() || !tableName.isPresent() ? 1 : 0) != 0, (Object)"tableName specified but schemaName is missing");
    }

    public static String checkCatalogName(String catalogName) {
        return MetadataUtil.checkLowerCase(catalogName, "catalogName");
    }

    public static String checkSchemaName(String schemaName) {
        return MetadataUtil.checkLowerCase(schemaName, "schemaName");
    }

    public static Optional<String> checkSchemaName(Optional<String> schemaName) {
        return MetadataUtil.checkLowerCase(schemaName, "schemaName");
    }

    public static String checkTableName(String tableName) {
        return MetadataUtil.checkLowerCase(tableName, "tableName");
    }

    public static Optional<String> checkTableName(Optional<String> tableName) {
        return MetadataUtil.checkLowerCase(tableName, "tableName");
    }

    public static String checkColumnName(String catalogName) {
        return MetadataUtil.checkLowerCase(catalogName, "catalogName");
    }

    public static void checkObjectName(String catalogName, String schemaName, String objectName) {
        MetadataUtil.checkLowerCase(catalogName, "catalogName");
        MetadataUtil.checkLowerCase(schemaName, "schemaName");
        MetadataUtil.checkLowerCase(objectName, "objectName");
    }

    public static Optional<String> checkLowerCase(Optional<String> value, String name) {
        if (value.isPresent()) {
            MetadataUtil.checkLowerCase(value.get(), name);
        }
        return value;
    }

    public static String checkLowerCase(String value, String name) {
        if (value == null) {
            throw new NullPointerException(String.format("%s is null", name));
        }
        Preconditions.checkArgument((boolean)value.equals(value.toLowerCase(Locale.ENGLISH)), (String)"%s is not lowercase", (Object[])new Object[]{name});
        return value;
    }

    public static ColumnMetadata findColumnMetadata(ConnectorTableMetadata tableMetadata, String columnName) {
        for (ColumnMetadata columnMetadata : tableMetadata.getColumns()) {
            if (!columnName.equals(columnMetadata.getName())) continue;
            return columnMetadata;
        }
        return null;
    }

    public static QualifiedObjectName createQualifiedObjectName(Session session, Node node, QualifiedName name) {
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(name, "name is null");
        Preconditions.checkArgument((name.getParts().size() <= 3 ? 1 : 0) != 0, (String)"Too many dots in table name: %s", (Object[])new Object[]{name});
        List parts = Lists.reverse((List)name.getParts());
        String objectName = (String)parts.get(0);
        String schemaName = parts.size() > 1 ? (String)parts.get(1) : session.getSchema().orElseThrow(() -> new SemanticException(SemanticErrorCode.SCHEMA_NOT_SPECIFIED, node, "Schema must be specified when session schema is not set", new Object[0]));
        String catalogName = parts.size() > 2 ? (String)parts.get(2) : session.getCatalog().orElseThrow(() -> new SemanticException(SemanticErrorCode.CATALOG_NOT_SPECIFIED, node, "Catalog must be specified when session catalog is not set", new Object[0]));
        return new QualifiedObjectName(catalogName, schemaName, objectName);
    }

    public static QualifiedName createQualifiedName(QualifiedObjectName name) {
        return QualifiedName.of((String)name.getCatalogName(), (String[])new String[]{name.getSchemaName(), name.getObjectName()});
    }

    public static boolean tableExists(Metadata metadata, Session session, String table) {
        if (!session.getCatalog().isPresent() || !session.getSchema().isPresent()) {
            return false;
        }
        QualifiedObjectName name = new QualifiedObjectName(session.getCatalog().get(), session.getSchema().get(), table);
        return metadata.getTableHandle(session, name).isPresent();
    }

    public static class TableMetadataBuilder {
        private final SchemaTableName tableName;
        private final ImmutableList.Builder<ColumnMetadata> columns = ImmutableList.builder();
        private final ImmutableMap.Builder<String, Object> properties = ImmutableMap.builder();

        public static TableMetadataBuilder tableMetadataBuilder(String schemaName, String tableName) {
            return new TableMetadataBuilder(new SchemaTableName(schemaName, tableName));
        }

        public static TableMetadataBuilder tableMetadataBuilder(SchemaTableName tableName) {
            return new TableMetadataBuilder(tableName);
        }

        private TableMetadataBuilder(SchemaTableName tableName) {
            this.tableName = tableName;
        }

        public TableMetadataBuilder column(String columnName, Type type) {
            this.columns.add((Object)new ColumnMetadata(columnName, type));
            return this;
        }

        public TableMetadataBuilder property(String name, Object value) {
            this.properties.put((Object)name, value);
            return this;
        }

        public ConnectorTableMetadata build() {
            return new ConnectorTableMetadata(this.tableName, (List)this.columns.build(), (Map)this.properties.build());
        }
    }

    public static class SchemaMetadataBuilder {
        private final ImmutableMap.Builder<SchemaTableName, ConnectorTableMetadata> tables = ImmutableMap.builder();

        public static SchemaMetadataBuilder schemaMetadataBuilder() {
            return new SchemaMetadataBuilder();
        }

        public SchemaMetadataBuilder table(ConnectorTableMetadata tableMetadata) {
            this.tables.put((Object)tableMetadata.getTable(), (Object)tableMetadata);
            return this;
        }

        public ImmutableMap<SchemaTableName, ConnectorTableMetadata> build() {
            return this.tables.build();
        }
    }
}

