/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.scheduler;

import com.facebook.presto.OutputBuffers;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.scheduler.OutputBufferManager;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class PartitionedOutputBufferManager
implements OutputBufferManager {
    private final Consumer<OutputBuffers> outputBufferTarget;
    @GuardedBy(value="this")
    private final Map<TaskId, Integer> partitions = new LinkedHashMap<TaskId, Integer>();
    @GuardedBy(value="this")
    private boolean noMoreBufferIds;

    public PartitionedOutputBufferManager(Consumer<OutputBuffers> outputBufferTarget) {
        this.outputBufferTarget = Objects.requireNonNull(outputBufferTarget, "outputBufferTarget is null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addOutputBuffers(List<OutputBufferManager.OutputBuffer> newBuffers, boolean noMoreBuffers) {
        PartitionedOutputBufferManager partitionedOutputBufferManager = this;
        synchronized (partitionedOutputBufferManager) {
            if (this.noMoreBufferIds) {
                return;
            }
            for (OutputBufferManager.OutputBuffer newBuffer : newBuffers) {
                this.partitions.put(newBuffer.getBufferId(), newBuffer.getPartition());
            }
            if (!noMoreBuffers) {
                return;
            }
            this.noMoreBufferIds = true;
        }
        OutputBuffers outputBuffers = OutputBuffers.INITIAL_EMPTY_OUTPUT_BUFFERS.withBuffers(this.partitions).withNoMoreBufferIds();
        this.outputBufferTarget.accept(outputBuffers);
    }
}

