/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.scheduler;

import com.facebook.presto.OutputBuffers;
import com.facebook.presto.execution.scheduler.OutputBufferManager;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
class BroadcastOutputBufferManager
implements OutputBufferManager {
    private final Consumer<OutputBuffers> outputBufferTarget;
    @GuardedBy(value="this")
    private OutputBuffers outputBuffers = OutputBuffers.INITIAL_EMPTY_OUTPUT_BUFFERS;

    public BroadcastOutputBufferManager(Consumer<OutputBuffers> outputBufferTarget) {
        this.outputBufferTarget = Objects.requireNonNull(outputBufferTarget, "outputBufferTarget is null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addOutputBuffers(List<OutputBufferManager.OutputBuffer> newBuffers, boolean noMoreBuffers) {
        BroadcastOutputBufferManager broadcastOutputBufferManager = this;
        synchronized (broadcastOutputBufferManager) {
            if (this.outputBuffers.isNoMoreBufferIds()) {
                return;
            }
            OutputBuffers originalOutputBuffers = this.outputBuffers;
            for (OutputBufferManager.OutputBuffer newBuffer : newBuffers) {
                this.outputBuffers = this.outputBuffers.withBuffer(newBuffer.getBufferId(), 0);
            }
            if (noMoreBuffers) {
                this.outputBuffers = this.outputBuffers.withNoMoreBufferIds();
            }
            if (this.outputBuffers == originalOutputBuffers) {
                return;
            }
        }
        this.outputBufferTarget.accept(this.outputBuffers);
    }
}

