/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.resourceGroups;

import com.facebook.presto.execution.resourceGroups.ResourceGroupId;
import com.facebook.presto.execution.resourceGroups.ResourceGroupIdTemplate;
import com.facebook.presto.execution.resourceGroups.ResourceGroupSelector;
import com.facebook.presto.execution.resourceGroups.SelectionContext;
import com.facebook.presto.sql.tree.Statement;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;

public class StaticSelector
implements ResourceGroupSelector {
    private final Optional<Pattern> userRegex;
    private final Optional<Pattern> sourceRegex;
    private final ResourceGroupIdTemplate group;

    public StaticSelector(Optional<Pattern> userRegex, Optional<Pattern> sourceRegex, ResourceGroupIdTemplate group) {
        this.userRegex = Objects.requireNonNull(userRegex, "userRegex is null");
        this.sourceRegex = Objects.requireNonNull(sourceRegex, "sourceRegex is null");
        this.group = Objects.requireNonNull(group, "group is null");
    }

    @Override
    public Optional<ResourceGroupId> match(Statement statement, SelectionContext context) {
        if (this.userRegex.isPresent() && !this.userRegex.get().matcher(context.getUser()).matches()) {
            return Optional.empty();
        }
        if (this.sourceRegex.isPresent()) {
            String source = context.getSource().orElse("");
            if (!this.sourceRegex.get().matcher(source).matches()) {
                return Optional.empty();
            }
        }
        return Optional.of(this.group.expandTemplate(context));
    }
}

