/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.resourceGroups;

import com.facebook.presto.Session;
import com.facebook.presto.execution.QueryExecution;
import com.facebook.presto.execution.QueryQueueManager;
import com.facebook.presto.execution.resourceGroups.ResourceGroup;
import com.facebook.presto.execution.resourceGroups.ResourceGroupConfigurationManager;
import com.facebook.presto.execution.resourceGroups.ResourceGroupId;
import com.facebook.presto.execution.resourceGroups.ResourceGroupInfo;
import com.facebook.presto.execution.resourceGroups.ResourceGroupSelector;
import com.facebook.presto.execution.resourceGroups.SelectionContext;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.sql.tree.Statement;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.concurrent.Threads;
import io.airlift.log.Logger;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;
import org.weakref.jmx.JmxException;
import org.weakref.jmx.MBeanExporter;
import org.weakref.jmx.ObjectNames;

@ThreadSafe
public class ResourceGroupManager
implements QueryQueueManager {
    private static final Logger log = Logger.get(ResourceGroupManager.class);
    private final ScheduledExecutorService refreshExecutor = Executors.newSingleThreadScheduledExecutor(Threads.daemonThreadsNamed((String)"ResourceGroupManager"));
    private final List<ResourceGroup.RootResourceGroup> rootGroups = new CopyOnWriteArrayList<ResourceGroup.RootResourceGroup>();
    private final ConcurrentMap<ResourceGroupId, ResourceGroup> groups = new ConcurrentHashMap<ResourceGroupId, ResourceGroup>();
    private final List<ResourceGroupSelector> selectors;
    private final ResourceGroupConfigurationManager configurationManager;
    private final MBeanExporter exporter;
    private final AtomicBoolean started = new AtomicBoolean();
    private final AtomicLong lastCpuQuotaGenerationNanos = new AtomicLong(System.nanoTime());

    @Inject
    public ResourceGroupManager(List<? extends ResourceGroupSelector> selectors, ResourceGroupConfigurationManager configurationManager, MBeanExporter exporter) {
        this.exporter = Objects.requireNonNull(exporter, "exporter is null");
        this.selectors = ImmutableList.copyOf(selectors);
        this.configurationManager = Objects.requireNonNull(configurationManager, "configurationManager is null");
    }

    public ResourceGroupInfo getResourceGroupInfo(ResourceGroupId id) {
        Preconditions.checkArgument((boolean)this.groups.containsKey(id), (String)"Group %s does not exist", (Object[])new Object[]{id});
        return ((ResourceGroup)this.groups.get(id)).getInfo();
    }

    @Override
    public void submit(Statement statement, QueryExecution queryExecution, Executor executor) {
        ResourceGroupId group;
        try {
            group = this.selectGroup(statement, queryExecution.getSession());
        }
        catch (PrestoException e) {
            queryExecution.fail(e);
            return;
        }
        this.createGroupIfNecessary(group, queryExecution.getSession(), executor);
        ((ResourceGroup)this.groups.get(group)).run(queryExecution);
    }

    @PreDestroy
    public void destroy() {
        this.refreshExecutor.shutdownNow();
    }

    @PostConstruct
    public void start() {
        if (this.started.compareAndSet(false, true)) {
            this.refreshExecutor.scheduleWithFixedDelay(this::refreshAndStartQueries, 1L, 1L, TimeUnit.MILLISECONDS);
        }
    }

    private void refreshAndStartQueries() {
        long nanoTime = System.nanoTime();
        long elapsedSeconds = TimeUnit.NANOSECONDS.toSeconds(nanoTime - this.lastCpuQuotaGenerationNanos.get());
        if (elapsedSeconds > 0L) {
            this.lastCpuQuotaGenerationNanos.addAndGet(elapsedSeconds * 1000000000L);
        } else if (elapsedSeconds < 0L) {
            this.lastCpuQuotaGenerationNanos.set(nanoTime);
        }
        for (ResourceGroup.RootResourceGroup group : this.rootGroups) {
            try {
                if (elapsedSeconds > 0L) {
                    group.generateCpuQuota(elapsedSeconds);
                }
            }
            catch (RuntimeException e) {
                log.error((Throwable)e, "Exception while generation cpu quota for %s", new Object[]{group});
            }
            try {
                group.processQueuedQueries();
            }
            catch (RuntimeException e) {
                log.error((Throwable)e, "Exception while processing queued queries for %s", new Object[]{group});
            }
        }
    }

    private synchronized void createGroupIfNecessary(ResourceGroupId id, Session session, Executor executor) {
        SelectionContext context = new SelectionContext(session.getIdentity().getPrincipal().isPresent(), session.getUser(), session.getSource());
        if (!this.groups.containsKey(id)) {
            ResourceGroup group;
            if (id.getParent().isPresent()) {
                this.createGroupIfNecessary(id.getParent().get(), session, executor);
                ResourceGroup parent = (ResourceGroup)this.groups.get(id.getParent().get());
                Objects.requireNonNull(parent, "parent is null");
                group = parent.getOrCreateSubGroup(id.getLastSegment());
            } else {
                ResourceGroup.RootResourceGroup root;
                group = root = new ResourceGroup.RootResourceGroup(id.getSegments().get(0), this::exportGroup, executor);
                this.rootGroups.add(root);
            }
            this.configurationManager.configure(group, context);
            Preconditions.checkState((this.groups.put(id, group) == null ? 1 : 0) != 0, (Object)"Unexpected existing resource group");
        }
    }

    private void exportGroup(ResourceGroup group, Boolean export) {
        String objectName = ObjectNames.builder(ResourceGroup.class, (String)group.getId().toString()).build();
        try {
            if (export.booleanValue()) {
                this.exporter.export(objectName, (Object)group);
            } else {
                this.exporter.unexport(objectName);
            }
        }
        catch (JmxException e) {
            log.error((Throwable)e, "Error %s resource group %s", new Object[]{export != false ? "exporting" : "unexporting", group.getId()});
        }
    }

    private ResourceGroupId selectGroup(Statement statement, Session session) {
        SelectionContext context = new SelectionContext(session.getIdentity().getPrincipal().isPresent(), session.getUser(), session.getSource());
        for (ResourceGroupSelector selector : this.selectors) {
            Optional<ResourceGroupId> group = selector.match(statement, context);
            if (!group.isPresent()) continue;
            return group.get();
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.QUERY_REJECTED, "Query did not match any selection rule");
    }
}

