/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.resourceGroups;

import com.facebook.presto.execution.resourceGroups.ResourceGroupId;
import com.google.common.collect.ImmutableList;
import io.airlift.units.DataSize;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class ResourceGroupInfo {
    private final ResourceGroupId id;
    private final DataSize softMemoryLimit;
    private final int maxRunningQueries;
    private final int maxQueuedQueries;
    private final int runningQueries;
    private final int queuedQueries;
    private final DataSize memoryUsage;
    private final List<ResourceGroupInfo> subGroups;

    public ResourceGroupInfo(ResourceGroupId id, DataSize softMemoryLimit, int maxRunningQueries, int maxQueuedQueries, int runningQueries, int queuedQueries, DataSize memoryUsage, List<ResourceGroupInfo> subGroups) {
        this.id = id;
        this.softMemoryLimit = Objects.requireNonNull(softMemoryLimit, "softMemoryLimit is null");
        this.maxRunningQueries = maxRunningQueries;
        this.maxQueuedQueries = maxQueuedQueries;
        this.runningQueries = runningQueries;
        this.queuedQueries = queuedQueries;
        this.memoryUsage = Objects.requireNonNull(memoryUsage, "memoryUsage is null");
        this.subGroups = ImmutableList.copyOf((Collection)Objects.requireNonNull(subGroups, "subGroups is null"));
    }

    public ResourceGroupId getId() {
        return this.id;
    }

    public DataSize getSoftMemoryLimit() {
        return this.softMemoryLimit;
    }

    public int getMaxRunningQueries() {
        return this.maxRunningQueries;
    }

    public int getMaxQueuedQueries() {
        return this.maxQueuedQueries;
    }

    public List<ResourceGroupInfo> getSubGroups() {
        return this.subGroups;
    }

    public int getRunningQueries() {
        return this.runningQueries;
    }

    public int getQueuedQueries() {
        return this.queuedQueries;
    }

    public DataSize getMemoryUsage() {
        return this.memoryUsage;
    }
}

