/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.resourceGroups;

import com.facebook.presto.execution.resourceGroups.ResourceGroupId;
import com.facebook.presto.execution.resourceGroups.ResourceGroupNameTemplate;
import com.facebook.presto.execution.resourceGroups.SelectionContext;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class ResourceGroupIdTemplate {
    private final List<ResourceGroupNameTemplate> segments;

    @JsonCreator
    public ResourceGroupIdTemplate(String fullId) {
        List segments = Splitter.on((String)".").splitToList((CharSequence)Objects.requireNonNull(fullId, "fullId is null"));
        Preconditions.checkArgument((!segments.isEmpty() ? 1 : 0) != 0, (Object)"Resource group id is empty");
        this.segments = segments.stream().map(ResourceGroupNameTemplate::new).collect(Collectors.toList());
    }

    public ResourceGroupId expandTemplate(SelectionContext context) {
        ResourceGroupId id = null;
        for (ResourceGroupNameTemplate segment : this.segments) {
            String expanded = segment.expandTemplate(context);
            if (id == null) {
                id = new ResourceGroupId(expanded);
                continue;
            }
            id = new ResourceGroupId(id, expanded);
        }
        return id;
    }

    public String toString() {
        return Joiner.on((String)".").join(this.segments);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceGroupIdTemplate that = (ResourceGroupIdTemplate)o;
        return Objects.equals(this.segments, that.segments);
    }

    public int hashCode() {
        return Objects.hash(this.segments);
    }
}

