/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.resourceGroups;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class ResourceGroupId {
    private final List<String> segments;

    public ResourceGroupId(String name) {
        this((List<String>)ImmutableList.of((Object)Objects.requireNonNull(name, "name is null")));
    }

    public ResourceGroupId(ResourceGroupId parent, String name) {
        this((List<String>)ImmutableList.builder().addAll(Objects.requireNonNull(parent, (String)"parent is null").segments).add((Object)Objects.requireNonNull(name, "name is null")).build());
    }

    private ResourceGroupId(List<String> segments) {
        Preconditions.checkArgument((!segments.isEmpty() ? 1 : 0) != 0, (Object)"Resource group id is empty");
        for (String segment : segments) {
            Preconditions.checkArgument((!segment.isEmpty() ? 1 : 0) != 0, (Object)"Empty segment in resource group id");
            Preconditions.checkArgument((segment.indexOf(46) < 0 ? 1 : 0) != 0, (String)"Invalid resource group id. '%s' contains a '.'", (Object[])new Object[]{Joiner.on((String)".").join(segments)});
        }
        this.segments = segments;
    }

    public String getLastSegment() {
        return this.segments.get(this.segments.size() - 1);
    }

    public List<String> getSegments() {
        return this.segments;
    }

    public Optional<ResourceGroupId> getParent() {
        if (this.segments.size() == 1) {
            return Optional.empty();
        }
        return Optional.of(new ResourceGroupId(this.segments.subList(0, this.segments.size() - 1)));
    }

    public static ResourceGroupId fromString(String value) {
        Objects.requireNonNull(value, "value is null");
        return new ResourceGroupId(Splitter.on((String)".").splitToList((CharSequence)value));
    }

    public String toString() {
        return Joiner.on((String)".").join(this.segments);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceGroupId that = (ResourceGroupId)o;
        return Objects.equals(this.segments, that.segments);
    }

    public int hashCode() {
        return Objects.hash(this.segments);
    }
}

