/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.resourceGroups;

import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.execution.QueryExecution;
import com.facebook.presto.execution.QueryState;
import com.facebook.presto.execution.resourceGroups.ConfigurableResourceGroup;
import com.facebook.presto.execution.resourceGroups.FifoQueue;
import com.facebook.presto.execution.resourceGroups.IndexedPriorityQueue;
import com.facebook.presto.execution.resourceGroups.ResourceGroupId;
import com.facebook.presto.execution.resourceGroups.ResourceGroupInfo;
import com.facebook.presto.execution.resourceGroups.StochasticPriorityQueue;
import com.facebook.presto.execution.resourceGroups.UpdateablePriorityQueue;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.ErrorType;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.weakref.jmx.Managed;

@ThreadSafe
public class ResourceGroup
implements ConfigurableResourceGroup {
    public static final int DEFAULT_WEIGHT = 1;
    private final ResourceGroup root;
    private final Optional<ResourceGroup> parent;
    private final ResourceGroupId id;
    private final BiConsumer<ResourceGroup, Boolean> jmxExportListener;
    private final Executor executor;
    @GuardedBy(value="root")
    private final Map<String, ResourceGroup> subGroups = new HashMap<String, ResourceGroup>();
    @GuardedBy(value="root")
    private UpdateablePriorityQueue<ResourceGroup> eligibleSubGroups = new FifoQueue<ResourceGroup>();
    @GuardedBy(value="root")
    private final Set<ResourceGroup> dirtySubGroups = new HashSet<ResourceGroup>();
    @GuardedBy(value="root")
    private long softMemoryLimitBytes;
    @GuardedBy(value="root")
    private int maxRunningQueries;
    @GuardedBy(value="root")
    private int maxQueuedQueries;
    @GuardedBy(value="root")
    private long softCpuLimitMillis = Long.MAX_VALUE;
    @GuardedBy(value="root")
    private long hardCpuLimitMillis = Long.MAX_VALUE;
    @GuardedBy(value="root")
    private long cpuUsageMillis;
    @GuardedBy(value="root")
    private long cpuQuotaGenerationMillisPerSecond = Long.MAX_VALUE;
    @GuardedBy(value="root")
    private int descendantRunningQueries;
    @GuardedBy(value="root")
    private int descendantQueuedQueries;
    @GuardedBy(value="root")
    private long cachedMemoryUsageBytes;
    @GuardedBy(value="root")
    private int schedulingWeight = 1;
    @GuardedBy(value="root")
    private UpdateablePriorityQueue<QueryExecution> queuedQueries = new FifoQueue<QueryExecution>();
    @GuardedBy(value="root")
    private final Set<QueryExecution> runningQueries = new HashSet<QueryExecution>();
    @GuardedBy(value="root")
    private SubGroupSchedulingPolicy schedulingPolicy = SubGroupSchedulingPolicy.FAIR;
    @GuardedBy(value="root")
    private boolean jmxExport;

    protected ResourceGroup(Optional<ResourceGroup> parent, String name, BiConsumer<ResourceGroup, Boolean> jmxExportListener, Executor executor) {
        this.parent = Objects.requireNonNull(parent, "parent is null");
        this.jmxExportListener = Objects.requireNonNull(jmxExportListener, "jmxExportListener is null");
        this.executor = Objects.requireNonNull(executor, "executor is null");
        Objects.requireNonNull(name, "name is null");
        if (parent.isPresent()) {
            this.id = new ResourceGroupId(parent.get().id, name);
            this.root = parent.get().root;
        } else {
            this.id = new ResourceGroupId(name);
            this.root = this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceGroupInfo getInfo() {
        ResourceGroup resourceGroup = this.root;
        synchronized (resourceGroup) {
            List<ResourceGroupInfo> infos = this.subGroups.values().stream().map(ResourceGroup::getInfo).collect(Collectors.toList());
            return new ResourceGroupInfo(this.id, new DataSize((double)this.softMemoryLimitBytes, DataSize.Unit.BYTE), this.maxRunningQueries, this.maxQueuedQueries, this.runningQueries.size() + this.descendantRunningQueries, this.queuedQueries.size() + this.descendantQueuedQueries, new DataSize((double)this.cachedMemoryUsageBytes, DataSize.Unit.BYTE), infos);
        }
    }

    @Override
    public ResourceGroupId getId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Managed
    public int getRunningQueries() {
        ResourceGroup resourceGroup = this.root;
        synchronized (resourceGroup) {
            return this.runningQueries.size() + this.descendantRunningQueries;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Managed
    public int getQueuedQueries() {
        ResourceGroup resourceGroup = this.root;
        synchronized (resourceGroup) {
            return this.queuedQueries.size() + this.descendantQueuedQueries;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataSize getSoftMemoryLimit() {
        ResourceGroup resourceGroup = this.root;
        synchronized (resourceGroup) {
            return new DataSize((double)this.softMemoryLimitBytes, DataSize.Unit.BYTE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSoftMemoryLimit(DataSize limit) {
        ResourceGroup resourceGroup = this.root;
        synchronized (resourceGroup) {
            boolean oldCanRun = this.canRunMore();
            this.softMemoryLimitBytes = limit.toBytes();
            if (this.canRunMore() != oldCanRun) {
                this.updateEligiblility();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Duration getSoftCpuLimit() {
        ResourceGroup resourceGroup = this.root;
        synchronized (resourceGroup) {
            return new Duration((double)this.softCpuLimitMillis, TimeUnit.MILLISECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSoftCpuLimit(Duration limit) {
        ResourceGroup resourceGroup = this.root;
        synchronized (resourceGroup) {
            if (limit.toMillis() > this.hardCpuLimitMillis) {
                this.setHardCpuLimit(limit);
            }
            boolean oldCanRun = this.canRunMore();
            this.softCpuLimitMillis = limit.toMillis();
            if (this.canRunMore() != oldCanRun) {
                this.updateEligiblility();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Duration getHardCpuLimit() {
        ResourceGroup resourceGroup = this.root;
        synchronized (resourceGroup) {
            return new Duration((double)this.hardCpuLimitMillis, TimeUnit.MILLISECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setHardCpuLimit(Duration limit) {
        ResourceGroup resourceGroup = this.root;
        synchronized (resourceGroup) {
            if (limit.toMillis() < this.softCpuLimitMillis) {
                this.setSoftCpuLimit(limit);
            }
            boolean oldCanRun = this.canRunMore();
            this.hardCpuLimitMillis = limit.toMillis();
            if (this.canRunMore() != oldCanRun) {
                this.updateEligiblility();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getCpuQuotaGenerationMillisPerSecond() {
        ResourceGroup resourceGroup = this.root;
        synchronized (resourceGroup) {
            return this.cpuQuotaGenerationMillisPerSecond;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCpuQuotaGenerationMillisPerSecond(long rate) {
        Preconditions.checkArgument((rate > 0L ? 1 : 0) != 0, (Object)"Cpu quota generation must be positive");
        ResourceGroup resourceGroup = this.root;
        synchronized (resourceGroup) {
            this.cpuQuotaGenerationMillisPerSecond = rate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Managed
    public int getMaxRunningQueries() {
        ResourceGroup resourceGroup = this.root;
        synchronized (resourceGroup) {
            return this.maxRunningQueries;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Managed
    public void setMaxRunningQueries(int maxRunningQueries) {
        Preconditions.checkArgument((maxRunningQueries >= 0 ? 1 : 0) != 0, (Object)"maxRunningQueries is negative");
        ResourceGroup resourceGroup = this.root;
        synchronized (resourceGroup) {
            boolean oldCanRun = this.canRunMore();
            this.maxRunningQueries = maxRunningQueries;
            if (this.canRunMore() != oldCanRun) {
                this.updateEligiblility();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Managed
    public int getMaxQueuedQueries() {
        ResourceGroup resourceGroup = this.root;
        synchronized (resourceGroup) {
            return this.maxQueuedQueries;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Managed
    public void setMaxQueuedQueries(int maxQueuedQueries) {
        Preconditions.checkArgument((maxQueuedQueries >= 0 ? 1 : 0) != 0, (Object)"maxQueuedQueries is negative");
        ResourceGroup resourceGroup = this.root;
        synchronized (resourceGroup) {
            this.maxQueuedQueries = maxQueuedQueries;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSchedulingWeight() {
        ResourceGroup resourceGroup = this.root;
        synchronized (resourceGroup) {
            return this.schedulingWeight;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSchedulingWeight(int weight) {
        Preconditions.checkArgument((weight > 0 ? 1 : 0) != 0, (Object)"weight must be positive");
        ResourceGroup resourceGroup = this.root;
        synchronized (resourceGroup) {
            this.schedulingWeight = weight;
            if (this.parent.isPresent() && this.parent.get().schedulingPolicy == SubGroupSchedulingPolicy.WEIGHTED && this.parent.get().eligibleSubGroups.contains(this)) {
                this.parent.get().eligibleSubGroups.addOrUpdate(this, weight);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SubGroupSchedulingPolicy getSchedulingPolicy() {
        ResourceGroup resourceGroup = this.root;
        synchronized (resourceGroup) {
            return this.schedulingPolicy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSchedulingPolicy(SubGroupSchedulingPolicy policy) {
        ResourceGroup resourceGroup = this.root;
        synchronized (resourceGroup) {
            UpdateablePriorityQueue<QueryExecution> queryQueue;
            UpdateablePriorityQueue<ResourceGroup> queue;
            if (policy == this.schedulingPolicy) {
                return;
            }
            if (this.parent.isPresent() && this.parent.get().schedulingPolicy == SubGroupSchedulingPolicy.QUERY_PRIORITY) {
                Preconditions.checkArgument((policy == SubGroupSchedulingPolicy.QUERY_PRIORITY ? 1 : 0) != 0, (String)"Parent of %s uses query priority scheduling, so %s must also", (Object[])new Object[]{this.id, this.id});
            }
            switch (policy) {
                case FAIR: {
                    queue = new FifoQueue();
                    queryQueue = new FifoQueue();
                    break;
                }
                case WEIGHTED: {
                    queue = new StochasticPriorityQueue();
                    queryQueue = new StochasticPriorityQueue();
                    break;
                }
                case QUERY_PRIORITY: {
                    for (ResourceGroup group : this.subGroups.values()) {
                        group.setSchedulingPolicy(SubGroupSchedulingPolicy.QUERY_PRIORITY);
                    }
                    queue = new IndexedPriorityQueue();
                    queryQueue = new IndexedPriorityQueue();
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported scheduling policy: " + (Object)((Object)policy));
                }
            }
            while (!this.eligibleSubGroups.isEmpty()) {
                ResourceGroup group = this.eligibleSubGroups.poll();
                queue.addOrUpdate(group, ResourceGroup.getSubGroupSchedulingPriority(policy, group));
            }
            this.eligibleSubGroups = queue;
            while (!this.queuedQueries.isEmpty()) {
                QueryExecution query = this.queuedQueries.poll();
                queryQueue.addOrUpdate(query, SystemSessionProperties.getQueryPriority(query.getSession()));
            }
            this.queuedQueries = queryQueue;
            this.schedulingPolicy = policy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getJmxExport() {
        ResourceGroup resourceGroup = this.root;
        synchronized (resourceGroup) {
            return this.jmxExport;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setJmxExport(boolean export) {
        ResourceGroup resourceGroup = this.root;
        synchronized (resourceGroup) {
            this.jmxExport = export;
        }
        this.jmxExportListener.accept(this, export);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceGroup getOrCreateSubGroup(String name) {
        Objects.requireNonNull(name, "name is null");
        ResourceGroup resourceGroup = this.root;
        synchronized (resourceGroup) {
            Preconditions.checkArgument((this.runningQueries.isEmpty() && this.queuedQueries.isEmpty() ? 1 : 0) != 0, (String)"Cannot add sub group to %s while queries are running", (Object[])new Object[]{this.id});
            if (this.subGroups.containsKey(name)) {
                return this.subGroups.get(name);
            }
            ResourceGroup subGroup = new ResourceGroup(Optional.of(this), name, this.jmxExportListener, this.executor);
            if (this.schedulingPolicy == SubGroupSchedulingPolicy.QUERY_PRIORITY) {
                subGroup.setSchedulingPolicy(SubGroupSchedulingPolicy.QUERY_PRIORITY);
            }
            this.subGroups.put(name, subGroup);
            return subGroup;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(QueryExecution query) {
        ResourceGroup resourceGroup = this.root;
        synchronized (resourceGroup) {
            Preconditions.checkState((boolean)this.subGroups.isEmpty(), (String)"Cannot add queries to %s. It is not a leaf group.", (Object[])new Object[]{this.id});
            ResourceGroup group = this;
            boolean canQueue = true;
            boolean canRun = true;
            while (true) {
                canQueue &= group.canQueueMore();
                canRun &= group.canRunMore();
                if (!group.parent.isPresent()) break;
                group = group.parent.get();
            }
            if (!canQueue && !canRun) {
                query.fail((Throwable)new PrestoException((ErrorCodeSupplier)StandardErrorCode.QUERY_QUEUE_FULL, String.format("Too many queued queries for \"%s\"!", this.id)));
                return;
            }
            if (canRun) {
                this.startInBackground(query);
            } else {
                this.enqueueQuery(query);
            }
            query.addStateChangeListener(state -> {
                if (state.isDone()) {
                    this.queryFinished(query);
                }
            });
            if (query.getState().isDone()) {
                this.queryFinished(query);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueueQuery(QueryExecution query) {
        Preconditions.checkState((boolean)Thread.holdsLock(this.root), (Object)"Must hold lock to enqueue a query");
        ResourceGroup resourceGroup = this.root;
        synchronized (resourceGroup) {
            this.queuedQueries.addOrUpdate(query, SystemSessionProperties.getQueryPriority(query.getSession()));
            ResourceGroup group = this;
            while (group.parent.isPresent()) {
                ++group.parent.get().descendantQueuedQueries;
                group = group.parent.get();
            }
            this.updateEligiblility();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateEligiblility() {
        Preconditions.checkState((boolean)Thread.holdsLock(this.root), (Object)"Must hold lock to update eligibility");
        ResourceGroup resourceGroup = this.root;
        synchronized (resourceGroup) {
            if (!this.parent.isPresent()) {
                return;
            }
            if (this.isEligibleToStartNext()) {
                this.parent.get().eligibleSubGroups.addOrUpdate(this, ResourceGroup.getSubGroupSchedulingPriority(this.parent.get().schedulingPolicy, this));
            } else {
                this.parent.get().eligibleSubGroups.remove(this);
            }
            this.parent.get().updateEligiblility();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startInBackground(QueryExecution query) {
        Preconditions.checkState((boolean)Thread.holdsLock(this.root), (Object)"Must hold lock to start a query");
        ResourceGroup resourceGroup = this.root;
        synchronized (resourceGroup) {
            this.runningQueries.add(query);
            ResourceGroup group = this;
            while (group.parent.isPresent()) {
                ++group.parent.get().descendantRunningQueries;
                group.parent.get().dirtySubGroups.add(group);
                group = group.parent.get();
            }
            this.updateEligiblility();
            this.executor.execute(query::start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queryFinished(QueryExecution query) {
        ResourceGroup resourceGroup = this.root;
        synchronized (resourceGroup) {
            ResourceGroup group;
            if (!this.runningQueries.contains(query) && !this.queuedQueries.contains(query)) {
                return;
            }
            if (query.getState() == QueryState.FINISHED || query.getQueryInfo().getErrorType() == ErrorType.USER_ERROR) {
                group = this;
                while (group != null) {
                    try {
                        group.cpuUsageMillis = Math.addExact(group.cpuUsageMillis, query.getTotalCpuTime().toMillis());
                    }
                    catch (ArithmeticException e) {
                        group.cpuUsageMillis = Long.MAX_VALUE;
                    }
                    group = group.parent.orElse(null);
                }
            }
            if (this.runningQueries.contains(query)) {
                this.runningQueries.remove(query);
                group = this;
                while (group.parent.isPresent()) {
                    --group.parent.get().descendantRunningQueries;
                    group = group.parent.get();
                }
            } else {
                this.queuedQueries.remove(query);
                group = this;
                while (group.parent.isPresent()) {
                    --group.parent.get().descendantQueuedQueries;
                    group = group.parent.get();
                }
            }
            this.updateEligiblility();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalRefreshStats() {
        Preconditions.checkState((boolean)Thread.holdsLock(this.root), (Object)"Must hold lock to refresh stats");
        ResourceGroup resourceGroup = this.root;
        synchronized (resourceGroup) {
            if (this.subGroups.isEmpty()) {
                this.cachedMemoryUsageBytes = 0L;
                for (QueryExecution query : this.runningQueries) {
                    this.cachedMemoryUsageBytes += query.getTotalMemoryReservation();
                }
            } else {
                Iterator<ResourceGroup> iterator = this.dirtySubGroups.iterator();
                while (iterator.hasNext()) {
                    ResourceGroup subGroup = iterator.next();
                    this.cachedMemoryUsageBytes -= subGroup.cachedMemoryUsageBytes;
                    subGroup.internalRefreshStats();
                    this.cachedMemoryUsageBytes += subGroup.cachedMemoryUsageBytes;
                    if (subGroup.isDirty()) continue;
                    iterator.remove();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalGenerateCpuQuota(long elapsedSeconds) {
        Preconditions.checkState((boolean)Thread.holdsLock(this.root), (Object)"Must hold lock to generate cpu quota");
        ResourceGroup resourceGroup = this.root;
        synchronized (resourceGroup) {
            long newQuota;
            try {
                newQuota = Math.multiplyExact(elapsedSeconds, this.cpuQuotaGenerationMillisPerSecond);
            }
            catch (ArithmeticException e) {
                newQuota = Long.MAX_VALUE;
            }
            try {
                this.cpuUsageMillis = Math.subtractExact(this.cpuUsageMillis, newQuota);
            }
            catch (ArithmeticException e) {
                this.cpuUsageMillis = 0L;
            }
            this.cpuUsageMillis = Math.max(0L, this.cpuUsageMillis);
            for (ResourceGroup group : this.subGroups.values()) {
                group.internalGenerateCpuQuota(elapsedSeconds);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean internalStartNext() {
        Preconditions.checkState((boolean)Thread.holdsLock(this.root), (Object)"Must hold lock to find next query");
        ResourceGroup resourceGroup = this.root;
        synchronized (resourceGroup) {
            if (!this.canRunMore()) {
                return false;
            }
            QueryExecution query = this.queuedQueries.poll();
            if (query != null) {
                this.startInBackground(query);
                return true;
            }
            ResourceGroup subGroup = this.eligibleSubGroups.poll();
            if (subGroup == null) {
                return false;
            }
            boolean started = subGroup.internalStartNext();
            Preconditions.checkState((boolean)started, (Object)"Eligible sub group had no queries to run");
            --this.descendantQueuedQueries;
            if (subGroup.isEligibleToStartNext()) {
                this.eligibleSubGroups.addOrUpdate(subGroup, ResourceGroup.getSubGroupSchedulingPriority(this.schedulingPolicy, subGroup));
            }
            return true;
        }
    }

    private static int getSubGroupSchedulingPriority(SubGroupSchedulingPolicy policy, ResourceGroup group) {
        if (policy == SubGroupSchedulingPolicy.QUERY_PRIORITY) {
            return group.getHighestQueryPriority();
        }
        return group.getSchedulingWeight();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isDirty() {
        Preconditions.checkState((boolean)Thread.holdsLock(this.root), (Object)"Must hold lock");
        ResourceGroup resourceGroup = this.root;
        synchronized (resourceGroup) {
            return this.runningQueries.size() + this.descendantRunningQueries > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isEligibleToStartNext() {
        Preconditions.checkState((boolean)Thread.holdsLock(this.root), (Object)"Must hold lock");
        ResourceGroup resourceGroup = this.root;
        synchronized (resourceGroup) {
            if (!this.canRunMore()) {
                return false;
            }
            return !this.queuedQueries.isEmpty() || !this.eligibleSubGroups.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getHighestQueryPriority() {
        Preconditions.checkState((boolean)Thread.holdsLock(this.root), (Object)"Must hold lock");
        ResourceGroup resourceGroup = this.root;
        synchronized (resourceGroup) {
            Preconditions.checkState((boolean)(this.queuedQueries instanceof IndexedPriorityQueue), (Object)"Queued queries not ordered");
            if (this.queuedQueries.isEmpty()) {
                return 0;
            }
            return SystemSessionProperties.getQueryPriority(this.queuedQueries.peek().getSession());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean canQueueMore() {
        Preconditions.checkState((boolean)Thread.holdsLock(this.root), (Object)"Must hold lock");
        ResourceGroup resourceGroup = this.root;
        synchronized (resourceGroup) {
            return this.descendantQueuedQueries + this.queuedQueries.size() < this.maxQueuedQueries;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean canRunMore() {
        Preconditions.checkState((boolean)Thread.holdsLock(this.root), (Object)"Must hold lock");
        ResourceGroup resourceGroup = this.root;
        synchronized (resourceGroup) {
            if (this.cpuUsageMillis >= this.hardCpuLimitMillis) {
                return false;
            }
            int maxRunning = this.maxRunningQueries;
            if (this.cpuUsageMillis >= this.softCpuLimitMillis) {
                double penalty = (double)(this.cpuUsageMillis - this.softCpuLimitMillis) / (double)(this.hardCpuLimitMillis - this.softCpuLimitMillis);
                maxRunning = (int)Math.floor((double)maxRunning * (1.0 - penalty));
                maxRunning = Math.min(this.maxRunningQueries - 1, maxRunning);
                maxRunning = Math.max(1, maxRunning);
            }
            return this.runningQueries.size() + this.descendantRunningQueries < maxRunning && this.cachedMemoryUsageBytes < this.softMemoryLimitBytes;
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ResourceGroup)) {
            return false;
        }
        ResourceGroup that = (ResourceGroup)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public static enum SubGroupSchedulingPolicy {
        FAIR,
        WEIGHTED,
        QUERY_PRIORITY;

    }

    @ThreadSafe
    public static final class RootResourceGroup
    extends ResourceGroup {
        public RootResourceGroup(String name, BiConsumer<ResourceGroup, Boolean> jmxExportListener, Executor executor) {
            super(Optional.empty(), name, jmxExportListener, executor);
        }

        public synchronized void processQueuedQueries() {
            this.internalRefreshStats();
            while (this.internalStartNext()) {
            }
        }

        public synchronized void generateCpuQuota(long elapsedSeconds) {
            if (elapsedSeconds > 0L) {
                this.internalGenerateCpuQuota(elapsedSeconds);
            }
        }
    }
}

