/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.resourceGroups;

import com.facebook.presto.execution.resourceGroups.ConfigurableResourceGroup;
import com.facebook.presto.execution.resourceGroups.FileResourceGroupConfig;
import com.facebook.presto.execution.resourceGroups.ResourceGroup;
import com.facebook.presto.execution.resourceGroups.ResourceGroupConfigurationManager;
import com.facebook.presto.execution.resourceGroups.ResourceGroupIdTemplate;
import com.facebook.presto.execution.resourceGroups.ResourceGroupNameTemplate;
import com.facebook.presto.execution.resourceGroups.ResourceGroupSelector;
import com.facebook.presto.execution.resourceGroups.SelectionContext;
import com.facebook.presto.execution.resourceGroups.StaticSelector;
import com.facebook.presto.memory.ClusterMemoryPoolManager;
import com.facebook.presto.memory.LocalMemoryManager;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import io.airlift.json.JsonCodec;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.concurrent.GuardedBy;
import javax.inject.Inject;
import javax.inject.Provider;

public class FileResourceGroupConfigurationManager
implements ResourceGroupConfigurationManager,
Provider<List<? extends ResourceGroupSelector>> {
    private final List<ResourceGroupSpec> rootGroups;
    private final List<? extends ResourceGroupSelector> selectors;
    private final Optional<Duration> cpuQuotaPeriodMillis;
    @GuardedBy(value="generalPoolMemoryFraction")
    private final Map<ConfigurableResourceGroup, Double> generalPoolMemoryFraction = new HashMap<ConfigurableResourceGroup, Double>();
    @GuardedBy(value="generalPoolMemoryFraction")
    private long generalPoolBytes;

    @Inject
    public FileResourceGroupConfigurationManager(ClusterMemoryPoolManager memoryPoolManager, FileResourceGroupConfig config, JsonCodec<ManagerSpec> codec) {
        ManagerSpec managerSpec;
        Objects.requireNonNull(config, "config is null");
        Objects.requireNonNull(codec, "codec is null");
        try {
            managerSpec = (ManagerSpec)codec.fromJson(Files.readAllBytes(Paths.get(config.getConfigFile(), new String[0])));
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        this.rootGroups = managerSpec.getRootGroups();
        this.cpuQuotaPeriodMillis = managerSpec.getCpuQuotaPeriod();
        LinkedList<ResourceGroupSpec> groups = new LinkedList<ResourceGroupSpec>(this.rootGroups);
        while (!groups.isEmpty()) {
            ResourceGroupSpec group = (ResourceGroupSpec)groups.poll();
            groups.addAll(group.getSubGroups());
            if (group.getSoftCpuLimit().isPresent() || group.getHardCpuLimit().isPresent()) {
                Preconditions.checkArgument((boolean)managerSpec.getCpuQuotaPeriod().isPresent(), (String)"cpuQuotaPeriod must be specified to use cpu limits on group: %s", (Object[])new Object[]{group.getName()});
            }
            if (!group.getSoftCpuLimit().isPresent()) continue;
            Preconditions.checkArgument((boolean)group.getHardCpuLimit().isPresent(), (Object)"Must specify hard CPU limit in addition to soft limit");
            Preconditions.checkArgument((group.getSoftCpuLimit().get().compareTo(group.getHardCpuLimit().get()) <= 0 ? 1 : 0) != 0, (Object)"Soft CPU limit cannot be greater than hard CPU limit");
        }
        ImmutableList.Builder selectors = ImmutableList.builder();
        for (SelectorSpec spec : managerSpec.getSelectors()) {
            selectors.add((Object)new StaticSelector(spec.getUserRegex(), spec.getSourceRegex(), spec.getGroup()));
        }
        this.selectors = selectors.build();
        memoryPoolManager.addChangeListener(LocalMemoryManager.GENERAL_POOL, poolInfo -> {
            Map<ConfigurableResourceGroup, Double> map = this.generalPoolMemoryFraction;
            synchronized (map) {
                for (Map.Entry<ConfigurableResourceGroup, Double> entry : this.generalPoolMemoryFraction.entrySet()) {
                    double bytes = (double)poolInfo.getMaxBytes() * entry.getValue();
                    entry.getKey().setSoftMemoryLimit(new DataSize(bytes, DataSize.Unit.BYTE));
                }
                this.generalPoolBytes = poolInfo.getMaxBytes();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void configure(ConfigurableResourceGroup group, SelectionContext context) {
        List<ResourceGroupSpec> candidates = this.rootGroups;
        List<String> segments = group.getId().getSegments();
        ResourceGroupSpec match = null;
        for (int i = 0; i < segments.size(); ++i) {
            List<ResourceGroupSpec> nextCandidates = null;
            ResourceGroupSpec nextCandidatesParent = null;
            for (ResourceGroupSpec candidate : candidates) {
                if (!candidate.getName().expandTemplate(context).equals(segments.get(i))) continue;
                if (i == segments.size() - 1) {
                    if (match != null) {
                        throw new IllegalStateException(String.format("Ambiguous configuration for %s. Matches %s and %s", group.getId(), match.getName(), candidate.getName()));
                    }
                    match = candidate;
                    continue;
                }
                if (nextCandidatesParent != null) {
                    throw new IllegalStateException(String.format("Ambiguous configuration for %s. Matches %s and %s", group.getId(), nextCandidatesParent.getName(), candidate.getName()));
                }
                nextCandidates = candidate.getSubGroups();
                nextCandidatesParent = candidate;
            }
            if (nextCandidates == null) break;
            candidates = nextCandidates;
        }
        Preconditions.checkState((match != null ? 1 : 0) != 0, (String)"No matching configuration found for: %s", (Object[])new Object[]{group.getId()});
        if (match.getSoftMemoryLimit().isPresent()) {
            group.setSoftMemoryLimit(match.getSoftMemoryLimit().get());
        } else {
            Map<ConfigurableResourceGroup, Double> i = this.generalPoolMemoryFraction;
            synchronized (i) {
                double fraction = match.getSoftMemoryLimitFraction().get();
                this.generalPoolMemoryFraction.put(group, fraction);
                group.setSoftMemoryLimit(new DataSize((double)this.generalPoolBytes * fraction, DataSize.Unit.BYTE));
            }
        }
        group.setMaxQueuedQueries(match.getMaxQueued());
        group.setMaxRunningQueries(match.getMaxRunning());
        if (match.getSchedulingPolicy().isPresent()) {
            group.setSchedulingPolicy(match.getSchedulingPolicy().get());
        }
        if (match.getSchedulingWeight().isPresent()) {
            group.setSchedulingWeight(match.getSchedulingWeight().get());
        }
        if (match.getJmxExport().isPresent()) {
            group.setJmxExport(match.getJmxExport().get());
        }
        if (match.getSoftCpuLimit().isPresent() || match.getHardCpuLimit().isPresent()) {
            Preconditions.checkState((boolean)this.cpuQuotaPeriodMillis.isPresent());
            Duration limit = match.getHardCpuLimit().isPresent() ? match.getHardCpuLimit().get() : match.getSoftCpuLimit().get();
            long rate = (long)Math.min(1000.0 * (double)limit.toMillis() / (double)this.cpuQuotaPeriodMillis.get().toMillis(), 9.223372036854776E18);
            rate = Math.max(1L, rate);
            group.setCpuQuotaGenerationMillisPerSecond(rate);
        }
        if (match.getSoftCpuLimit().isPresent()) {
            group.setSoftCpuLimit(match.getSoftCpuLimit().get());
        }
        if (match.getHardCpuLimit().isPresent()) {
            group.setHardCpuLimit(match.getHardCpuLimit().get());
        }
    }

    public List<? extends ResourceGroupSelector> get() {
        return this.selectors;
    }

    public static class SelectorSpec {
        private final Optional<Pattern> userRegex;
        private final Optional<Pattern> sourceRegex;
        private final ResourceGroupIdTemplate group;

        @JsonCreator
        public SelectorSpec(@JsonProperty(value="user") Optional<Pattern> userRegex, @JsonProperty(value="source") Optional<Pattern> sourceRegex, @JsonProperty(value="group") ResourceGroupIdTemplate group) {
            this.userRegex = Objects.requireNonNull(userRegex, "userRegex is null");
            this.sourceRegex = Objects.requireNonNull(sourceRegex, "sourceRegex is null");
            this.group = Objects.requireNonNull(group, "group is null");
        }

        public Optional<Pattern> getUserRegex() {
            return this.userRegex;
        }

        public Optional<Pattern> getSourceRegex() {
            return this.sourceRegex;
        }

        public ResourceGroupIdTemplate getGroup() {
            return this.group;
        }
    }

    public static class ResourceGroupSpec {
        private static final Pattern PERCENT_PATTERN = Pattern.compile("(\\d{1,3}(:?\\.\\d+)?)%");
        private final ResourceGroupNameTemplate name;
        private final Optional<DataSize> softMemoryLimit;
        private final Optional<Double> softMemoryLimitFraction;
        private final int maxQueued;
        private final int maxRunning;
        private final Optional<ResourceGroup.SubGroupSchedulingPolicy> schedulingPolicy;
        private final Optional<Integer> schedulingWeight;
        private final List<ResourceGroupSpec> subGroups;
        private final Optional<Boolean> jmxExport;
        private final Optional<Duration> softCpuLimit;
        private final Optional<Duration> hardCpuLimit;

        @JsonCreator
        public ResourceGroupSpec(@JsonProperty(value="name") ResourceGroupNameTemplate name, @JsonProperty(value="softMemoryLimit") String softMemoryLimit, @JsonProperty(value="maxQueued") int maxQueued, @JsonProperty(value="maxRunning") int maxRunning, @JsonProperty(value="schedulingPolicy") Optional<String> schedulingPolicy, @JsonProperty(value="schedulingWeight") Optional<Integer> schedulingWeight, @JsonProperty(value="subGroups") Optional<List<ResourceGroupSpec>> subGroups, @JsonProperty(value="jmxExport") Optional<Boolean> jmxExport, @JsonProperty(value="softCpuLimit") Optional<Duration> softCpuLimit, @JsonProperty(value="hardCpuLimit") Optional<Duration> hardCpuLimit) {
            Optional<Object> fraction;
            Optional<Object> absoluteSize;
            this.softCpuLimit = Objects.requireNonNull(softCpuLimit, "softCpuLimit is null");
            this.hardCpuLimit = Objects.requireNonNull(hardCpuLimit, "hardCpuLimit is null");
            this.jmxExport = Objects.requireNonNull(jmxExport, "jmxExport is null");
            this.name = Objects.requireNonNull(name, "name is null");
            Preconditions.checkArgument((maxQueued >= 0 ? 1 : 0) != 0, (Object)"maxQueued is negative");
            this.maxQueued = maxQueued;
            Preconditions.checkArgument((maxRunning >= 0 ? 1 : 0) != 0, (Object)"maxRunning is negative");
            this.maxRunning = maxRunning;
            this.schedulingPolicy = Objects.requireNonNull(schedulingPolicy, "schedulingPolicy is null").map(value -> ResourceGroup.SubGroupSchedulingPolicy.valueOf(value.toUpperCase()));
            this.schedulingWeight = Objects.requireNonNull(schedulingWeight, "schedulingWeight is null");
            Objects.requireNonNull(softMemoryLimit, "softMemoryLimit is null");
            Matcher matcher = PERCENT_PATTERN.matcher(softMemoryLimit);
            if (matcher.matches()) {
                absoluteSize = Optional.empty();
                fraction = Optional.of(Double.parseDouble(matcher.group(1)) / 100.0);
            } else {
                absoluteSize = Optional.of(DataSize.valueOf((String)softMemoryLimit));
                fraction = Optional.empty();
            }
            this.softMemoryLimit = absoluteSize;
            this.softMemoryLimitFraction = fraction;
            this.subGroups = ImmutableList.copyOf((Collection)Objects.requireNonNull(subGroups, "subGroups is null").orElse((List<ResourceGroupSpec>)ImmutableList.of()));
            HashSet<ResourceGroupNameTemplate> names = new HashSet<ResourceGroupNameTemplate>();
            for (ResourceGroupSpec subGroup : this.subGroups) {
                Preconditions.checkArgument((!names.contains(subGroup.getName()) ? 1 : 0) != 0, (String)"Duplicated sub group: %s", (Object[])new Object[]{subGroup.getName()});
                names.add(subGroup.getName());
            }
        }

        public Optional<DataSize> getSoftMemoryLimit() {
            return this.softMemoryLimit;
        }

        public Optional<Double> getSoftMemoryLimitFraction() {
            return this.softMemoryLimitFraction;
        }

        public int getMaxQueued() {
            return this.maxQueued;
        }

        public int getMaxRunning() {
            return this.maxRunning;
        }

        public Optional<ResourceGroup.SubGroupSchedulingPolicy> getSchedulingPolicy() {
            return this.schedulingPolicy;
        }

        public Optional<Integer> getSchedulingWeight() {
            return this.schedulingWeight;
        }

        public ResourceGroupNameTemplate getName() {
            return this.name;
        }

        public List<ResourceGroupSpec> getSubGroups() {
            return this.subGroups;
        }

        public Optional<Boolean> getJmxExport() {
            return this.jmxExport;
        }

        public Optional<Duration> getSoftCpuLimit() {
            return this.softCpuLimit;
        }

        public Optional<Duration> getHardCpuLimit() {
            return this.hardCpuLimit;
        }
    }

    public static class ManagerSpec {
        private final List<ResourceGroupSpec> rootGroups;
        private final List<SelectorSpec> selectors;
        private final Optional<Duration> cpuQuotaPeriod;

        @JsonCreator
        public ManagerSpec(@JsonProperty(value="rootGroups") List<ResourceGroupSpec> rootGroups, @JsonProperty(value="selectors") List<SelectorSpec> selectors, @JsonProperty(value="cpuQuotaPeriod") Optional<Duration> cpuQuotaPeriod) {
            this.rootGroups = ImmutableList.copyOf((Collection)Objects.requireNonNull(rootGroups, "rootGroups is null"));
            this.selectors = ImmutableList.copyOf((Collection)Objects.requireNonNull(selectors, "selectors is null"));
            this.cpuQuotaPeriod = Objects.requireNonNull(cpuQuotaPeriod, "cpuQuotaPeriod is null");
            HashSet<ResourceGroupNameTemplate> names = new HashSet<ResourceGroupNameTemplate>();
            for (ResourceGroupSpec group : rootGroups) {
                Preconditions.checkArgument((!names.contains(group.getName()) ? 1 : 0) != 0, (String)"Duplicated root group: %s", (Object[])new Object[]{group.getName()});
                names.add(group.getName());
            }
        }

        public List<ResourceGroupSpec> getRootGroups() {
            return this.rootGroups;
        }

        public List<SelectorSpec> getSelectors() {
            return this.selectors;
        }

        public Optional<Duration> getCpuQuotaPeriod() {
            return this.cpuQuotaPeriod;
        }
    }
}

