/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.execution.QueryId;
import com.facebook.presto.execution.StageId;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.List;
import java.util.Objects;

public class TaskId {
    private final String fullId;

    @JsonCreator
    public static TaskId valueOf(String taskId) {
        return new TaskId(taskId);
    }

    public TaskId(String queryId, String stageId, String id) {
        QueryId.validateId(id);
        this.fullId = queryId + "." + stageId + "." + id;
    }

    public TaskId(StageId stageId, String id) {
        QueryId.validateId(id);
        this.fullId = stageId.getQueryId().getId() + "." + stageId.getId() + "." + id;
    }

    public TaskId(String fullId) {
        this.fullId = fullId;
    }

    public QueryId getQueryId() {
        return new QueryId(QueryId.parseDottedId(this.fullId, 3, "taskId").get(0));
    }

    public StageId getStageId() {
        List<String> ids = QueryId.parseDottedId(this.fullId, 3, "taskId");
        return new StageId(new QueryId(ids.get(0)), ids.get(1));
    }

    public String getId() {
        return QueryId.parseDottedId(this.fullId, 3, "taskId").get(2);
    }

    @JsonValue
    public String toString() {
        return this.fullId;
    }

    public int hashCode() {
        return Objects.hash(this.fullId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TaskId other = (TaskId)obj;
        return Objects.equals(this.fullId, other.fullId);
    }
}

