/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.OutputBuffers;
import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.TaskSource;
import com.facebook.presto.event.query.QueryMonitor;
import com.facebook.presto.execution.BufferResult;
import com.facebook.presto.execution.LocationFactory;
import com.facebook.presto.execution.QueryId;
import com.facebook.presto.execution.SqlTask;
import com.facebook.presto.execution.SqlTaskExecutionFactory;
import com.facebook.presto.execution.SqlTaskIoStats;
import com.facebook.presto.execution.StateMachine;
import com.facebook.presto.execution.TaskExecutor;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.TaskInfo;
import com.facebook.presto.execution.TaskManager;
import com.facebook.presto.execution.TaskManagerConfig;
import com.facebook.presto.execution.TaskState;
import com.facebook.presto.execution.TaskStatus;
import com.facebook.presto.memory.LocalMemoryManager;
import com.facebook.presto.memory.MemoryPoolAssignment;
import com.facebook.presto.memory.MemoryPoolAssignmentsRequest;
import com.facebook.presto.memory.NodeMemoryConfig;
import com.facebook.presto.memory.QueryContext;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.sql.planner.LocalExecutionPlanner;
import com.facebook.presto.sql.planner.PlanFragment;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.airlift.concurrent.ThreadPoolExecutorMBean;
import io.airlift.concurrent.Threads;
import io.airlift.log.Logger;
import io.airlift.node.NodeInfo;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.io.Closeable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.concurrent.GuardedBy;
import javax.inject.Inject;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.weakref.jmx.Flatten;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public class SqlTaskManager
implements TaskManager,
Closeable {
    private static final Logger log = Logger.get(SqlTaskManager.class);
    private final ExecutorService taskNotificationExecutor;
    private final ThreadPoolExecutorMBean taskNotificationExecutorMBean;
    private final ScheduledExecutorService taskManagementExecutor;
    private final ThreadPoolExecutorMBean taskManagementExecutorMBean;
    private final Duration infoCacheTime;
    private final Duration clientTimeout;
    private final LocalMemoryManager localMemoryManager;
    private final LoadingCache<QueryId, QueryContext> queryContexts;
    private final LoadingCache<TaskId, SqlTask> tasks;
    private final SqlTaskIoStats cachedStats = new SqlTaskIoStats();
    private final SqlTaskIoStats finishedTaskStats = new SqlTaskIoStats();
    @GuardedBy(value="this")
    private long currentMemoryPoolAssignmentVersion;
    @GuardedBy(value="this")
    private String coordinatorId;

    @Inject
    public SqlTaskManager(LocalExecutionPlanner planner, final LocationFactory locationFactory, TaskExecutor taskExecutor, QueryMonitor queryMonitor, NodeInfo nodeInfo, final LocalMemoryManager localMemoryManager, TaskManagerConfig config, NodeMemoryConfig nodeMemoryConfig) {
        Objects.requireNonNull(nodeInfo, "nodeInfo is null");
        Objects.requireNonNull(config, "config is null");
        this.infoCacheTime = config.getInfoMaxAge();
        this.clientTimeout = config.getClientTimeout();
        final DataSize maxBufferSize = config.getSinkMaxBufferSize();
        this.taskNotificationExecutor = Executors.newFixedThreadPool(config.getTaskNotificationThreads(), Threads.threadsNamed((String)"task-notification-%s"));
        this.taskNotificationExecutorMBean = new ThreadPoolExecutorMBean((ThreadPoolExecutor)this.taskNotificationExecutor);
        this.taskManagementExecutor = Executors.newScheduledThreadPool(5, Threads.threadsNamed((String)"task-management-%s"));
        this.taskManagementExecutorMBean = new ThreadPoolExecutorMBean((ThreadPoolExecutor)((Object)this.taskManagementExecutor));
        final SqlTaskExecutionFactory sqlTaskExecutionFactory = new SqlTaskExecutionFactory(this.taskNotificationExecutor, taskExecutor, planner, queryMonitor, config);
        this.localMemoryManager = Objects.requireNonNull(localMemoryManager, "localMemoryManager is null");
        final DataSize maxQueryMemoryPerNode = nodeMemoryConfig.getMaxQueryMemoryPerNode();
        this.queryContexts = CacheBuilder.newBuilder().weakValues().build((CacheLoader)new CacheLoader<QueryId, QueryContext>(){

            public QueryContext load(QueryId key) throws Exception {
                return new QueryContext(key, maxQueryMemoryPerNode, localMemoryManager.getPool(LocalMemoryManager.GENERAL_POOL), localMemoryManager.getPool(LocalMemoryManager.SYSTEM_POOL), SqlTaskManager.this.taskNotificationExecutor);
            }
        });
        this.tasks = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<TaskId, SqlTask>(){

            public SqlTask load(TaskId taskId) throws Exception {
                return new SqlTask(taskId, locationFactory.createLocalTaskLocation(taskId), (QueryContext)SqlTaskManager.this.queryContexts.getUnchecked((Object)taskId.getQueryId()), sqlTaskExecutionFactory, SqlTaskManager.this.taskNotificationExecutor, sqlTask -> {
                    SqlTaskManager.this.finishedTaskStats.merge(sqlTask.getIoStats());
                    return null;
                }, maxBufferSize);
            }
        });
    }

    @Override
    public synchronized void updateMemoryPoolAssignments(MemoryPoolAssignmentsRequest assignments) {
        if (this.coordinatorId != null && this.coordinatorId.equals(assignments.getCoordinatorId()) && assignments.getVersion() <= this.currentMemoryPoolAssignmentVersion) {
            return;
        }
        this.currentMemoryPoolAssignmentVersion = assignments.getVersion();
        if (this.coordinatorId != null && !this.coordinatorId.equals(assignments.getCoordinatorId())) {
            log.warn("Switching coordinator affinity from " + this.coordinatorId + " to " + assignments.getCoordinatorId());
        }
        this.coordinatorId = assignments.getCoordinatorId();
        for (MemoryPoolAssignment assignment : assignments.getAssignments()) {
            ((QueryContext)this.queryContexts.getUnchecked((Object)assignment.getQueryId())).setMemoryPool(this.localMemoryManager.getPool(assignment.getPoolId()));
        }
    }

    @PostConstruct
    public void start() {
        this.taskManagementExecutor.scheduleWithFixedDelay(() -> {
            try {
                this.removeOldTasks();
            }
            catch (Throwable e) {
                log.warn(e, "Error removing old tasks");
            }
            try {
                this.failAbandonedTasks();
            }
            catch (Throwable e) {
                log.warn(e, "Error canceling abandoned tasks");
            }
        }, 200L, 200L, TimeUnit.MILLISECONDS);
        this.taskManagementExecutor.scheduleWithFixedDelay(() -> {
            try {
                this.updateStats();
            }
            catch (Throwable e) {
                log.warn(e, "Error updating stats");
            }
        }, 0L, 1L, TimeUnit.SECONDS);
    }

    @Override
    @PreDestroy
    public void close() {
        boolean taskCanceled = false;
        for (SqlTask task : this.tasks.asMap().values()) {
            if (task.getTaskInfo().getTaskStatus().getState().isDone()) continue;
            task.failed(new PrestoException((ErrorCodeSupplier)StandardErrorCode.SERVER_SHUTTING_DOWN, String.format("Server is shutting down. Task %s has been canceled", task.getTaskId())));
            taskCanceled = true;
        }
        if (taskCanceled) {
            try {
                TimeUnit.SECONDS.sleep(5L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        this.taskNotificationExecutor.shutdownNow();
        this.taskManagementExecutor.shutdownNow();
    }

    @Managed
    @Flatten
    public SqlTaskIoStats getIoStats() {
        return this.cachedStats;
    }

    @Managed(description="Task notification executor")
    @Nested
    public ThreadPoolExecutorMBean getTaskNotificationExecutor() {
        return this.taskNotificationExecutorMBean;
    }

    @Managed(description="Task garbage collector executor")
    @Nested
    public ThreadPoolExecutorMBean getTaskManagementExecutor() {
        return this.taskManagementExecutorMBean;
    }

    @Override
    public List<TaskInfo> getAllTaskInfo() {
        return ImmutableList.copyOf((Iterable)Iterables.transform(this.tasks.asMap().values(), SqlTask::getTaskInfo));
    }

    @Override
    public TaskInfo getTaskInfo(TaskId taskId) {
        Objects.requireNonNull(taskId, "taskId is null");
        SqlTask sqlTask = (SqlTask)this.tasks.getUnchecked((Object)taskId);
        sqlTask.recordHeartbeat();
        return sqlTask.getTaskInfo();
    }

    @Override
    public TaskStatus getTaskStatus(TaskId taskId) {
        Objects.requireNonNull(taskId, "taskId is null");
        SqlTask sqlTask = (SqlTask)this.tasks.getUnchecked((Object)taskId);
        sqlTask.recordHeartbeat();
        return sqlTask.getTaskStatus();
    }

    @Override
    public CompletableFuture<TaskInfo> getTaskInfo(TaskId taskId, TaskState currentState) {
        Objects.requireNonNull(taskId, "taskId is null");
        Objects.requireNonNull(currentState, "currentState is null");
        SqlTask sqlTask = (SqlTask)this.tasks.getUnchecked((Object)taskId);
        sqlTask.recordHeartbeat();
        return sqlTask.getTaskInfo(currentState);
    }

    @Override
    public String getTaskInstanceId(TaskId taskId) {
        SqlTask sqlTask = (SqlTask)this.tasks.getUnchecked((Object)taskId);
        sqlTask.recordHeartbeat();
        return sqlTask.getTaskInstanceId();
    }

    @Override
    public CompletableFuture<TaskStatus> getTaskStatus(TaskId taskId, TaskState currentState) {
        Objects.requireNonNull(taskId, "taskId is null");
        Objects.requireNonNull(currentState, "currentState is null");
        SqlTask sqlTask = (SqlTask)this.tasks.getUnchecked((Object)taskId);
        sqlTask.recordHeartbeat();
        return sqlTask.getTaskStatus(currentState);
    }

    @Override
    public TaskInfo updateTask(Session session, TaskId taskId, Optional<PlanFragment> fragment, List<TaskSource> sources, OutputBuffers outputBuffers) {
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(taskId, "taskId is null");
        Objects.requireNonNull(fragment, "fragment is null");
        Objects.requireNonNull(sources, "sources is null");
        Objects.requireNonNull(outputBuffers, "outputBuffers is null");
        if (SystemSessionProperties.resourceOvercommit(session)) {
            ((QueryContext)this.queryContexts.getUnchecked((Object)taskId.getQueryId())).setResourceOvercommit();
        }
        SqlTask sqlTask = (SqlTask)this.tasks.getUnchecked((Object)taskId);
        sqlTask.recordHeartbeat();
        return sqlTask.updateTask(session, fragment, sources, outputBuffers);
    }

    @Override
    public CompletableFuture<BufferResult> getTaskResults(TaskId taskId, TaskId outputName, long startingSequenceId, DataSize maxSize) {
        Objects.requireNonNull(taskId, "taskId is null");
        Objects.requireNonNull(outputName, "outputName is null");
        Preconditions.checkArgument((startingSequenceId >= 0L ? 1 : 0) != 0, (Object)"startingSequenceId is negative");
        Objects.requireNonNull(maxSize, "maxSize is null");
        return ((SqlTask)this.tasks.getUnchecked((Object)taskId)).getTaskResults(outputName, startingSequenceId, maxSize);
    }

    @Override
    public TaskInfo abortTaskResults(TaskId taskId, TaskId outputId) {
        Objects.requireNonNull(taskId, "taskId is null");
        Objects.requireNonNull(outputId, "outputId is null");
        return ((SqlTask)this.tasks.getUnchecked((Object)taskId)).abortTaskResults(outputId);
    }

    @Override
    public TaskInfo cancelTask(TaskId taskId) {
        Objects.requireNonNull(taskId, "taskId is null");
        return ((SqlTask)this.tasks.getUnchecked((Object)taskId)).cancel();
    }

    @Override
    public TaskInfo abortTask(TaskId taskId) {
        Objects.requireNonNull(taskId, "taskId is null");
        return ((SqlTask)this.tasks.getUnchecked((Object)taskId)).abort();
    }

    public void removeOldTasks() {
        DateTime oldestAllowedTask = DateTime.now().minus(this.infoCacheTime.toMillis());
        for (TaskInfo taskInfo : Iterables.filter((Iterable)Iterables.transform(this.tasks.asMap().values(), SqlTask::getTaskInfo), (Predicate)Predicates.notNull())) {
            TaskId taskId = taskInfo.getTaskStatus().getTaskId();
            try {
                DateTime endTime = taskInfo.getStats().getEndTime();
                if (endTime == null || !endTime.isBefore((ReadableInstant)oldestAllowedTask)) continue;
                this.tasks.asMap().remove(taskId);
            }
            catch (RuntimeException e) {
                log.warn((Throwable)e, "Error while inspecting age of complete task %s", new Object[]{taskId});
            }
        }
    }

    public void failAbandonedTasks() {
        DateTime now = DateTime.now();
        DateTime oldestAllowedHeartbeat = now.minus(this.clientTimeout.toMillis());
        for (SqlTask sqlTask : this.tasks.asMap().values()) {
            try {
                DateTime lastHeartbeat;
                TaskInfo taskInfo = sqlTask.getTaskInfo();
                TaskStatus taskStatus = taskInfo.getTaskStatus();
                if (taskStatus.getState().isDone() || (lastHeartbeat = taskInfo.getLastHeartbeat()) == null || !lastHeartbeat.isBefore((ReadableInstant)oldestAllowedHeartbeat)) continue;
                log.info("Failing abandoned task %s", new Object[]{taskStatus.getTaskId()});
                sqlTask.failed(new PrestoException((ErrorCodeSupplier)StandardErrorCode.ABANDONED_TASK, String.format("Task %s has not been accessed since %s: currentTime %s", taskStatus.getTaskId(), lastHeartbeat, now)));
            }
            catch (RuntimeException e) {
                log.warn((Throwable)e, "Error while inspecting age of task %s", new Object[]{sqlTask.getTaskId()});
            }
        }
    }

    private void updateStats() {
        SqlTaskIoStats tempIoStats = new SqlTaskIoStats();
        tempIoStats.merge(this.finishedTaskStats);
        this.tasks.asMap().values().stream().filter(task -> !task.getTaskInfo().getTaskStatus().getState().isDone()).forEach(task -> tempIoStats.merge(task.getIoStats()));
        this.cachedStats.resetTo(tempIoStats);
    }

    @Override
    public void addStateChangeListener(TaskId taskId, StateMachine.StateChangeListener<TaskState> stateChangeListener) {
        Objects.requireNonNull(taskId, "taskId is null");
        ((SqlTask)this.tasks.getUnchecked((Object)taskId)).addStateChangeListener(stateChangeListener);
    }
}

