/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.execution.DataDefinitionTask;
import com.facebook.presto.execution.QueryStateMachine;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.sql.SqlFormatterUtil;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.tree.Deallocate;
import com.facebook.presto.sql.tree.Execute;
import com.facebook.presto.sql.tree.Prepare;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.transaction.TransactionManager;
import com.google.inject.Inject;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public class PrepareTask
implements DataDefinitionTask<Prepare> {
    private final SqlParser sqlParser;

    @Inject
    public PrepareTask(SqlParser sqlParser) {
        this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
    }

    @Override
    public String getName() {
        return "PREPARE";
    }

    @Override
    public String explain(Prepare statement) {
        return "PREPARE " + statement.getName();
    }

    @Override
    public CompletableFuture<?> execute(Prepare prepare, TransactionManager transactionManager, Metadata metadata, AccessControl accessControl, QueryStateMachine stateMachine) {
        Statement statement = prepare.getStatement();
        if (statement instanceof Prepare || statement instanceof Execute || statement instanceof Deallocate) {
            String type = statement.getClass().getSimpleName().toUpperCase(Locale.ENGLISH);
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Invalid statement type for prepared statement: " + type);
        }
        String sql = SqlFormatterUtil.getFormattedSql(statement, this.sqlParser);
        stateMachine.addPreparedStatement(prepare.getName(), sql);
        return CompletableFuture.completedFuture(null);
    }
}

