/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.execution.PageBufferInfo;
import com.facebook.presto.execution.PageSplitterUtil;
import com.facebook.presto.execution.SharedBufferMemoryManager;
import com.facebook.presto.spi.Page;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import io.airlift.units.DataSize;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class PartitionBuffer {
    private final LinkedList<Page> masterBuffer = new LinkedList();
    private final AtomicLong rowsAdded = new AtomicLong();
    private final AtomicLong pagesAdded = new AtomicLong();
    private final AtomicLong masterSequenceId = new AtomicLong();
    private final AtomicLong bufferedBytes = new AtomicLong();
    private final int partition;
    private final SharedBufferMemoryManager memoryManager;

    public PartitionBuffer(int partition, SharedBufferMemoryManager memoryManager) {
        Preconditions.checkArgument((partition >= 0 ? 1 : 0) != 0, (Object)"partition must be >= 0");
        this.partition = partition;
        this.memoryManager = Objects.requireNonNull(memoryManager, "memoryManager is null");
    }

    public synchronized void enqueuePage(Page page) {
        List<Page> pages = PageSplitterUtil.splitPage(page, 0x100000L);
        this.masterBuffer.addAll(pages);
        long rowCount = pages.stream().mapToLong(Page::getPositionCount).sum();
        Preconditions.checkState((rowCount == (long)page.getPositionCount() ? 1 : 0) != 0);
        this.rowsAdded.addAndGet(rowCount);
        this.pagesAdded.addAndGet(pages.size());
        long bytesAdded = 0L;
        for (Page p : pages) {
            bytesAdded += p.getRetainedSizeInBytes();
        }
        this.updateMemoryUsage(bytesAdded);
    }

    public synchronized List<Page> getPages(DataSize maxSize, long sequenceId) {
        long maxBytes = maxSize.toBytes();
        ArrayList<Page> pages = new ArrayList<Page>();
        long bytes = 0L;
        int listOffset = Ints.checkedCast((long)(sequenceId - this.masterSequenceId.get()));
        while (listOffset < this.masterBuffer.size()) {
            Page page = this.masterBuffer.get(listOffset++);
            if (!pages.isEmpty() && (bytes += page.getSizeInBytes()) > maxBytes) break;
            pages.add(page);
        }
        return ImmutableList.copyOf(pages);
    }

    public synchronized boolean hasMorePages(long sequenceId) {
        int listOffset = Ints.checkedCast((long)(sequenceId - this.masterSequenceId.get()));
        return listOffset < this.masterBuffer.size();
    }

    public synchronized void advanceSequenceId(long newSequenceId) {
        long oldMasterSequenceId = this.masterSequenceId.get();
        Preconditions.checkArgument((newSequenceId >= oldMasterSequenceId ? 1 : 0) != 0, (String)"Master sequence id moved backwards: oldMasterSequenceId=%s, newMasterSequenceId=%s", (Object[])new Object[]{oldMasterSequenceId, newSequenceId});
        if (newSequenceId == oldMasterSequenceId) {
            return;
        }
        this.masterSequenceId.set(newSequenceId);
        int pagesToRemove = Ints.checkedCast((long)(newSequenceId - oldMasterSequenceId));
        Preconditions.checkState((this.masterBuffer.size() >= pagesToRemove ? 1 : 0) != 0, (String)"MasterBuffer does not have any pages to remove: pagesToRemove %s oldMasterSequenceId: %s newSequenceId: %s", (Object[])new Object[]{pagesToRemove, oldMasterSequenceId, newSequenceId});
        long bytesRemoved = 0L;
        for (int i = 0; i < pagesToRemove; ++i) {
            Page page = this.masterBuffer.removeFirst();
            bytesRemoved += page.getRetainedSizeInBytes();
        }
        this.updateMemoryUsage(-bytesRemoved);
    }

    public synchronized void destroy() {
        this.masterBuffer.clear();
        this.updateMemoryUsage(-this.bufferedBytes.get());
    }

    private void updateMemoryUsage(long bytesAdded) {
        this.bufferedBytes.addAndGet(bytesAdded);
        this.memoryManager.updateMemoryUsage(bytesAdded);
        Verify.verify((this.bufferedBytes.get() >= 0L ? 1 : 0) != 0);
    }

    public long getRowCount() {
        return this.rowsAdded.get();
    }

    public long getPageCount() {
        return this.pagesAdded.get();
    }

    public long getBufferedBytes() {
        return this.bufferedBytes.get();
    }

    public long getBufferedPageCount() {
        return this.masterBuffer.size();
    }

    public int getPartition() {
        return this.partition;
    }

    public PageBufferInfo getInfo() {
        return new PageBufferInfo(this.partition, this.getBufferedPageCount(), this.getBufferedBytes(), this.rowsAdded.get(), this.pagesAdded.get());
    }
}

