/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto;

import com.facebook.presto.execution.TaskId;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public final class OutputBuffers {
    public static final int BROADCAST_PARTITION_ID = 0;
    public static final OutputBuffers INITIAL_EMPTY_OUTPUT_BUFFERS = new OutputBuffers(0L, false, (Map<TaskId, Integer>)ImmutableMap.of());
    private final long version;
    private final boolean noMoreBufferIds;
    private final Map<TaskId, Integer> buffers;

    @JsonCreator
    public OutputBuffers(@JsonProperty(value="version") long version, @JsonProperty(value="noMoreBufferIds") boolean noMoreBufferIds, @JsonProperty(value="buffers") Map<TaskId, Integer> buffers) {
        this.version = version;
        this.buffers = ImmutableMap.copyOf(Objects.requireNonNull(buffers, "buffers is null"));
        this.noMoreBufferIds = noMoreBufferIds;
    }

    @JsonProperty
    public long getVersion() {
        return this.version;
    }

    @JsonProperty
    public boolean isNoMoreBufferIds() {
        return this.noMoreBufferIds;
    }

    @JsonProperty
    public Map<TaskId, Integer> getBuffers() {
        return this.buffers;
    }

    public void checkValidTransition(OutputBuffers newOutputBuffers) {
        Objects.requireNonNull(newOutputBuffers, "newOutputBuffers is null");
        if (this.version > newOutputBuffers.version) {
            throw new IllegalArgumentException("newOutputBuffers version is older");
        }
        if (this.version == newOutputBuffers.version) {
            Preconditions.checkArgument((boolean)this.equals(newOutputBuffers), (Object)"newOutputBuffers is the same version but contains different information");
        }
        if (this.noMoreBufferIds && !newOutputBuffers.noMoreBufferIds) {
            throw new IllegalArgumentException("Expected newOutputBuffers to have noMoreBufferIds set");
        }
        for (Map.Entry<TaskId, Integer> entry : this.buffers.entrySet()) {
            if (entry.getValue().equals(newOutputBuffers.buffers.get(entry.getKey()))) continue;
            throw new IllegalArgumentException("newOutputBuffers has changed the assignment for task " + entry.getKey());
        }
    }

    public int hashCode() {
        return Objects.hash(this.version, this.noMoreBufferIds, this.buffers);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        OutputBuffers other = (OutputBuffers)obj;
        return Objects.equals(this.version, other.version) && Objects.equals(this.noMoreBufferIds, other.noMoreBufferIds) && Objects.equals(this.buffers, other.buffers);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("version", this.version).add("noMoreBufferIds", this.noMoreBufferIds).add("bufferIds", this.buffers).toString();
    }

    public OutputBuffers withBuffer(TaskId bufferId, int partition) {
        Objects.requireNonNull(bufferId, "bufferId is null");
        if (this.buffers.containsKey(bufferId)) {
            this.checkHasBuffer(bufferId, partition);
            return this;
        }
        Preconditions.checkState((!this.noMoreBufferIds ? 1 : 0) != 0, (Object)"No more buffer ids already set");
        return new OutputBuffers(this.version + 1L, false, (Map<TaskId, Integer>)ImmutableMap.builder().putAll(this.buffers).put((Object)bufferId, (Object)partition).build());
    }

    public OutputBuffers withBuffers(Map<TaskId, Integer> buffers) {
        Objects.requireNonNull(buffers, "buffers is null");
        HashMap<TaskId, Integer> newBuffers = new HashMap<TaskId, Integer>();
        for (Map.Entry<TaskId, Integer> entry : buffers.entrySet()) {
            TaskId bufferId = entry.getKey();
            int partition = entry.getValue();
            if (this.buffers.containsKey(bufferId)) {
                this.checkHasBuffer(bufferId, partition);
                continue;
            }
            newBuffers.put(bufferId, partition);
        }
        if (newBuffers.isEmpty()) {
            return this;
        }
        Preconditions.checkState((!this.noMoreBufferIds ? 1 : 0) != 0, (Object)"No more buffer ids already set");
        newBuffers.putAll(this.buffers);
        return new OutputBuffers(this.version + 1L, false, newBuffers);
    }

    public OutputBuffers withNoMoreBufferIds() {
        if (this.noMoreBufferIds) {
            return this;
        }
        return new OutputBuffers(this.version + 1L, true, this.buffers);
    }

    private void checkHasBuffer(TaskId bufferId, int partition) {
        Preconditions.checkArgument((boolean)Objects.equals(this.buffers.get(bufferId), partition), (String)"OutputBuffers already contains task %s, but partition is set to %s not %s", (Object[])new Object[]{bufferId, this.buffers.get(bufferId), partition});
    }
}

