/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.plan.PlanVisitor;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.concurrent.Immutable;

@Immutable
public class GroupIdNode
extends PlanNode {
    private final PlanNode source;
    private final List<Symbol> inputSymbols;
    private final List<List<Symbol>> groupingSets;
    private final Symbol groupIdSymbol;

    @JsonCreator
    public GroupIdNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source, @JsonProperty(value="inputSymbols") List<Symbol> inputSymbols, @JsonProperty(value="groupingSets") List<List<Symbol>> groupingSets, @JsonProperty(value="groupIdSymbol") Symbol groupIdSymbol) {
        super(id);
        this.source = Objects.requireNonNull(source);
        this.inputSymbols = ImmutableList.copyOf((Collection)Objects.requireNonNull(inputSymbols));
        this.groupingSets = ImmutableList.copyOf((Collection)Objects.requireNonNull(groupingSets));
        this.groupIdSymbol = Objects.requireNonNull(groupIdSymbol);
    }

    @Override
    public List<Symbol> getOutputSymbols() {
        return ImmutableList.builder().addAll(this.source.getOutputSymbols()).add((Object)this.groupIdSymbol).build();
    }

    @Override
    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.source);
    }

    @JsonProperty
    public PlanNode getSource() {
        return this.source;
    }

    @JsonProperty
    public List<Symbol> getInputSymbols() {
        return this.inputSymbols;
    }

    @JsonProperty
    public List<List<Symbol>> getGroupingSets() {
        return this.groupingSets;
    }

    public List<Symbol> getDistinctGroupingColumns() {
        return this.groupingSets.stream().flatMap(Collection::stream).distinct().collect(Collectors.toList());
    }

    @JsonProperty
    public Symbol getGroupIdSymbol() {
        return this.groupIdSymbol;
    }

    @Override
    public <C, R> R accept(PlanVisitor<C, R> visitor, C context) {
        return visitor.visitGroupId(this, context);
    }
}

