/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.spi.LocalProperty;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.optimizations.LocalProperties;
import com.facebook.presto.util.ImmutableCollectors;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.concurrent.Immutable;

class PreferredProperties {
    private final Optional<Global> globalProperties;
    private final List<LocalProperty<Symbol>> localProperties;

    private PreferredProperties(Optional<Global> globalProperties, List<? extends LocalProperty<Symbol>> localProperties) {
        Objects.requireNonNull(globalProperties, "globalProperties is null");
        Objects.requireNonNull(localProperties, "localProperties is null");
        this.globalProperties = globalProperties;
        this.localProperties = ImmutableList.copyOf(localProperties);
    }

    public static PreferredProperties any() {
        return PreferredProperties.builder().build();
    }

    public static PreferredProperties undistributed() {
        return PreferredProperties.builder().global(Global.undistributed()).build();
    }

    public static PreferredProperties partitioned(Set<Symbol> columns) {
        return PreferredProperties.builder().global(Global.distributed(Partitioning.partitioned(columns))).build();
    }

    public static PreferredProperties distributed() {
        return PreferredProperties.builder().global(Global.distributed()).build();
    }

    public static PreferredProperties hashPartitioned(List<Symbol> columns) {
        return PreferredProperties.builder().global(Global.distributed(Partitioning.hashPartitioned(columns))).build();
    }

    public static PreferredProperties hashPartitionedWithLocal(List<Symbol> columns, List<? extends LocalProperty<Symbol>> localProperties) {
        return PreferredProperties.builder().global(Global.distributed(Partitioning.hashPartitioned(columns))).local(localProperties).build();
    }

    public static PreferredProperties partitionedWithLocal(Set<Symbol> columns, List<? extends LocalProperty<Symbol>> localProperties) {
        return PreferredProperties.builder().global(Global.distributed(Partitioning.partitioned(columns))).local(localProperties).build();
    }

    public static PreferredProperties undistributedWithLocal(List<? extends LocalProperty<Symbol>> localProperties) {
        return PreferredProperties.builder().global(Global.undistributed()).local(localProperties).build();
    }

    public static PreferredProperties local(List<? extends LocalProperty<Symbol>> localProperties) {
        return PreferredProperties.builder().local(localProperties).build();
    }

    public Optional<Global> getGlobalProperties() {
        return this.globalProperties;
    }

    public List<LocalProperty<Symbol>> getLocalProperties() {
        return this.localProperties;
    }

    public PreferredProperties translate(Function<Symbol, Optional<Symbol>> translator) {
        Optional<Global> newGlobalProperties = this.globalProperties.map(global -> global.translate(translator));
        List<LocalProperty<Symbol>> newLocalProperties = LocalProperties.translate(this.localProperties, translator);
        return new PreferredProperties(newGlobalProperties, newLocalProperties);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static PreferredProperties derivePreferences(PreferredProperties parentProperties, Set<Symbol> partitioningColumns, List<LocalProperty<Symbol>> localProperties) {
        return PreferredProperties.derivePreferences(parentProperties, partitioningColumns, Optional.empty(), localProperties);
    }

    public static PreferredProperties derivePreferences(PreferredProperties parentProperties, Set<Symbol> partitioningColumns, Optional<List<Symbol>> hashingColumns, List<LocalProperty<Symbol>> localProperties) {
        Global global;
        if (hashingColumns.isPresent()) {
            Preconditions.checkState((boolean)partitioningColumns.equals(ImmutableSet.copyOf((Collection)hashingColumns.get())), (Object)"hashingColumns and partitioningColumns must be the same");
        }
        ImmutableList local = ImmutableList.builder().addAll(localProperties).addAll(parentProperties.getLocalProperties()).build();
        if (hashingColumns.isPresent()) {
            return PreferredProperties.hashPartitionedWithLocal(hashingColumns.get(), (List<? extends LocalProperty<Symbol>>)local);
        }
        if (parentProperties.getGlobalProperties().isPresent() && (global = parentProperties.getGlobalProperties().get()).getPartitioningProperties().isPresent()) {
            Partitioning partitioning = global.getPartitioningProperties().get();
            if (partitioning.getHashingOrder().isPresent() && partitioningColumns.equals(ImmutableSet.copyOf((Collection)partitioning.getHashingOrder().get()))) {
                List<Symbol> hashingSymbols = partitioning.getHashingOrder().get();
                return PreferredProperties.hashPartitionedWithLocal(hashingSymbols, (List<? extends LocalProperty<Symbol>>)local);
            }
            Set<Symbol> parentPartitioningColumns = partitioning.getPartitioningColumns();
            Sets.SetView common = Sets.intersection(partitioningColumns, parentPartitioningColumns);
            if (!common.isEmpty()) {
                return PreferredProperties.partitionedWithLocal((Set<Symbol>)common, (List<? extends LocalProperty<Symbol>>)local);
            }
            return PreferredProperties.partitionedWithLocal(partitioningColumns, (List<? extends LocalProperty<Symbol>>)local);
        }
        return PreferredProperties.partitionedWithLocal(partitioningColumns, (List<? extends LocalProperty<Symbol>>)local);
    }

    @Immutable
    public static final class Partitioning {
        private final Set<Symbol> partitioningColumns;
        private final Optional<List<Symbol>> hashingOrder;

        private Partitioning(Set<Symbol> partitioningColumns, Optional<List<Symbol>> hashingOrder) {
            this.partitioningColumns = ImmutableSet.copyOf((Collection)Objects.requireNonNull(partitioningColumns, "partitioningColumns is null"));
            this.hashingOrder = Objects.requireNonNull(hashingOrder, "hashingOrder is null").map(ImmutableList::copyOf);
        }

        public static Partitioning hashPartitioned(List<Symbol> columns) {
            return new Partitioning((Set<Symbol>)ImmutableSet.copyOf(columns), Optional.of(columns));
        }

        public static Partitioning partitioned(Set<Symbol> columns) {
            return new Partitioning(columns, Optional.empty());
        }

        public static Partitioning singlePartition() {
            return Partitioning.partitioned((Set<Symbol>)ImmutableSet.of());
        }

        public Set<Symbol> getPartitioningColumns() {
            return this.partitioningColumns;
        }

        public Optional<List<Symbol>> getHashingOrder() {
            return this.hashingOrder;
        }

        public Optional<Partitioning> translate(Function<Symbol, Optional<Symbol>> translator) {
            Set newPartitioningColumns = (Set)this.partitioningColumns.stream().map(translator).filter(Optional::isPresent).map(Optional::get).collect(ImmutableCollectors.toImmutableSet());
            if (newPartitioningColumns.isEmpty()) {
                return Optional.empty();
            }
            Optional<List<Symbol>> newHashingOrder = this.hashingOrder.flatMap(columns -> {
                ImmutableList.Builder builder = ImmutableList.builder();
                for (Symbol column : columns) {
                    Optional translated = (Optional)translator.apply(column);
                    if (!translated.isPresent()) {
                        return Optional.empty();
                    }
                    builder.add(translated.get());
                }
                return Optional.of(builder.build());
            });
            return Optional.of(new Partitioning(newPartitioningColumns, newHashingOrder));
        }

        public int hashCode() {
            return Objects.hash(this.partitioningColumns, this.hashingOrder);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Partitioning other = (Partitioning)obj;
            return Objects.equals(this.partitioningColumns, other.partitioningColumns) && Objects.equals(this.hashingOrder, other.hashingOrder);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("partitioningColumns", this.partitioningColumns).add("hashingOrder", this.hashingOrder).toString();
        }
    }

    @Immutable
    public static final class Global {
        private final boolean distributed;
        private final Optional<Partitioning> partitioningProperties;

        private Global(boolean distributed, Optional<Partitioning> partitioningProperties) {
            this.distributed = distributed;
            this.partitioningProperties = Objects.requireNonNull(partitioningProperties, "partitioningProperties is null");
        }

        public static Global undistributed() {
            return new Global(false, Optional.of(Partitioning.singlePartition()));
        }

        public static Global distributed(Optional<Partitioning> partitioningProperties) {
            return new Global(true, partitioningProperties);
        }

        public static Global distributed() {
            return Global.distributed(Optional.empty());
        }

        public static Global distributed(Partitioning partitioning) {
            return Global.distributed(Optional.of(partitioning));
        }

        public boolean isDistributed() {
            return this.distributed;
        }

        public Optional<Partitioning> getPartitioningProperties() {
            return this.partitioningProperties;
        }

        public boolean isHashPartitioned() {
            return this.partitioningProperties.isPresent() && this.partitioningProperties.get().getHashingOrder().isPresent();
        }

        public Global translate(Function<Symbol, Optional<Symbol>> translator) {
            if (!this.isDistributed()) {
                return this;
            }
            return Global.distributed(this.partitioningProperties.flatMap(properties -> properties.translate(translator)));
        }

        public int hashCode() {
            return Objects.hash(this.distributed, this.partitioningProperties);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Global other = (Global)obj;
            return Objects.equals(this.distributed, other.distributed) && Objects.equals(this.partitioningProperties, other.partitioningProperties);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("distributed", this.distributed).add("partitioningProperties", this.partitioningProperties).toString();
        }
    }

    public static class Builder {
        private Optional<Global> globalProperties = Optional.empty();
        private List<LocalProperty<Symbol>> localProperties = ImmutableList.of();

        public Builder global(Global globalProperties) {
            this.globalProperties = Optional.of(globalProperties);
            return this;
        }

        public Builder global(PreferredProperties other) {
            this.globalProperties = other.globalProperties;
            return this;
        }

        public Builder local(List<? extends LocalProperty<Symbol>> localProperties) {
            this.localProperties = ImmutableList.copyOf(localProperties);
            return this;
        }

        public Builder local(PreferredProperties other) {
            this.localProperties = ImmutableList.copyOf((Collection)other.localProperties);
            return this;
        }

        public PreferredProperties build() {
            return new PreferredProperties(this.globalProperties, this.localProperties);
        }
    }
}

