/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.TableLayoutResult;
import com.facebook.presto.operator.aggregation.InternalAggregationFunction;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.GroupingProperty;
import com.facebook.presto.spi.LocalProperty;
import com.facebook.presto.spi.SortingProperty;
import com.facebook.presto.spi.predicate.NullableValue;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.ExpressionUtils;
import com.facebook.presto.sql.analyzer.ExpressionAnalyzer;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.DomainTranslator;
import com.facebook.presto.sql.planner.ExpressionInterpreter;
import com.facebook.presto.sql.planner.LookupSymbolResolver;
import com.facebook.presto.sql.planner.PartitionFunctionBinding;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.SystemPartitioningHandle;
import com.facebook.presto.sql.planner.optimizations.ActualProperties;
import com.facebook.presto.sql.planner.optimizations.LocalProperties;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.optimizations.PreferredProperties;
import com.facebook.presto.sql.planner.optimizations.PropertyDerivations;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.ChildReplacer;
import com.facebook.presto.sql.planner.plan.DeleteNode;
import com.facebook.presto.sql.planner.plan.DistinctLimitNode;
import com.facebook.presto.sql.planner.plan.EnforceSingleRowNode;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.FilterNode;
import com.facebook.presto.sql.planner.plan.IndexJoinNode;
import com.facebook.presto.sql.planner.plan.IndexSourceNode;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.LimitNode;
import com.facebook.presto.sql.planner.plan.MarkDistinctNode;
import com.facebook.presto.sql.planner.plan.OutputNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanVisitor;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.planner.plan.RowNumberNode;
import com.facebook.presto.sql.planner.plan.SemiJoinNode;
import com.facebook.presto.sql.planner.plan.SortNode;
import com.facebook.presto.sql.planner.plan.TableFinishNode;
import com.facebook.presto.sql.planner.plan.TableScanNode;
import com.facebook.presto.sql.planner.plan.TableWriterNode;
import com.facebook.presto.sql.planner.plan.TopNNode;
import com.facebook.presto.sql.planner.plan.TopNRowNumberNode;
import com.facebook.presto.sql.planner.plan.UnionNode;
import com.facebook.presto.sql.planner.plan.UnnestNode;
import com.facebook.presto.sql.planner.plan.ValuesNode;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.facebook.presto.sql.tree.BooleanLiteral;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.NullLiteral;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.QualifiedNameReference;
import com.facebook.presto.util.ImmutableCollectors;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.SetMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class AddExchanges
extends PlanOptimizer {
    private final SqlParser parser;
    private final Metadata metadata;

    public AddExchanges(Metadata metadata, SqlParser parser) {
        this.metadata = metadata;
        this.parser = parser;
    }

    @Override
    public PlanNode optimize(PlanNode plan, Session session, Map<Symbol, Type> types, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator) {
        boolean distributedJoinEnabled = SystemSessionProperties.isDistributedJoinEnabled(session);
        boolean distributedIndexJoinEnabled = SystemSessionProperties.isDistributedIndexJoinEnabled(session);
        boolean redistributeWrites = SystemSessionProperties.isRedistributeWrites(session);
        boolean preferStreamingOperators = SystemSessionProperties.preferStreamingOperators(session);
        PlanWithProperties result = plan.accept(new Rewriter(symbolAllocator, idAllocator, symbolAllocator, session, distributedIndexJoinEnabled, distributedJoinEnabled, preferStreamingOperators, redistributeWrites), new Context(PreferredProperties.any(), false));
        return result.getNode();
    }

    private static Map<Symbol, Symbol> computeIdentityTranslations(Map<Symbol, Expression> assignments) {
        HashMap<Symbol, Symbol> outputToInput = new HashMap<Symbol, Symbol>();
        for (Map.Entry<Symbol, Expression> assignment : assignments.entrySet()) {
            if (!(assignment.getValue() instanceof QualifiedNameReference)) continue;
            outputToInput.put(assignment.getKey(), Symbol.fromQualifiedName(((QualifiedNameReference)assignment.getValue()).getName()));
        }
        return outputToInput;
    }

    @VisibleForTesting
    static Comparator<ActualProperties> streamingExecutionPreference(final PreferredProperties preferred) {
        LoadingCache matchCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<List<LocalProperty<Symbol>>, List<Optional<LocalProperty<Symbol>>>>(){

            public List<Optional<LocalProperty<Symbol>>> load(List<LocalProperty<Symbol>> actualProperties) {
                return LocalProperties.match(actualProperties, preferred.getLocalProperties());
            }
        });
        return (actual1, actual2) -> {
            List matchLayout1 = (List)matchCache.getUnchecked(actual1.getLocalProperties());
            List matchLayout2 = (List)matchCache.getUnchecked(actual2.getLocalProperties());
            return ComparisonChain.start().compareTrueFirst(AddExchanges.hasLocalOptimization(preferred.getLocalProperties(), matchLayout1), AddExchanges.hasLocalOptimization(preferred.getLocalProperties(), matchLayout2)).compareTrueFirst(AddExchanges.meetsPartitioningRequirements(preferred, actual1), AddExchanges.meetsPartitioningRequirements(preferred, actual2)).compare((Object)matchLayout1, (Object)matchLayout2, AddExchanges.matchedLayoutPreference()).result();
        };
    }

    private static <T> boolean hasLocalOptimization(List<LocalProperty<T>> desiredLayout, List<Optional<LocalProperty<T>>> matchResult) {
        Preconditions.checkArgument((desiredLayout.size() == matchResult.size() ? 1 : 0) != 0);
        if (matchResult.isEmpty()) {
            return false;
        }
        return !matchResult.get(0).equals(Optional.of(desiredLayout.get(0)));
    }

    private static boolean meetsPartitioningRequirements(PreferredProperties preferred, ActualProperties actual) {
        if (!preferred.getGlobalProperties().isPresent()) {
            return true;
        }
        PreferredProperties.Global preferredGlobal = preferred.getGlobalProperties().get();
        if (!preferredGlobal.isDistributed()) {
            return actual.isSingleNode();
        }
        if (!preferredGlobal.getPartitioningProperties().isPresent()) {
            return !actual.isSingleNode();
        }
        return actual.isStreamPartitionedOn(preferredGlobal.getPartitioningProperties().get().getPartitioningColumns());
    }

    private static <T> Comparator<List<Optional<LocalProperty<T>>>> matchedLayoutPreference() {
        return (matchLayout1, matchLayout2) -> {
            Iterator match1Iterator = matchLayout1.iterator();
            Iterator match2Iterator = matchLayout2.iterator();
            while (match1Iterator.hasNext() && match2Iterator.hasNext()) {
                Optional match1 = (Optional)match1Iterator.next();
                Optional match2 = (Optional)match2Iterator.next();
                if (match1.isPresent() && match2.isPresent()) {
                    return Integer.compare(((LocalProperty)match1.get()).getColumns().size(), ((LocalProperty)match2.get()).getColumns().size());
                }
                if (match1.isPresent()) {
                    return 1;
                }
                if (!match2.isPresent()) continue;
                return -1;
            }
            Preconditions.checkState((!match1Iterator.hasNext() && !match2Iterator.hasNext() ? 1 : 0) != 0);
            return 0;
        };
    }

    private static final class IsScalarPlanVisitor
    extends PlanVisitor<Void, Boolean> {
        private IsScalarPlanVisitor() {
        }

        @Override
        protected Boolean visitPlan(PlanNode node, Void context) {
            return false;
        }

        @Override
        public Boolean visitEnforceSingleRow(EnforceSingleRowNode node, Void context) {
            return true;
        }

        @Override
        public Boolean visitProject(ProjectNode node, Void context) {
            return node.getSource().accept(this, null);
        }
    }

    @VisibleForTesting
    static class PlanWithProperties {
        private final PlanNode node;
        private final ActualProperties properties;

        public PlanWithProperties(PlanNode node, ActualProperties properties) {
            this.node = node;
            this.properties = properties;
        }

        public PlanNode getNode() {
            return this.node;
        }

        public ActualProperties getProperties() {
            return this.properties;
        }
    }

    private class Rewriter
    extends PlanVisitor<Context, PlanWithProperties> {
        private final SymbolAllocator allocator;
        private final PlanNodeIdAllocator idAllocator;
        private final SymbolAllocator symbolAllocator;
        private final Session session;
        private final boolean distributedIndexJoins;
        private final boolean distributedJoins;
        private final boolean preferStreamingOperators;
        private final boolean redistributeWrites;

        public Rewriter(SymbolAllocator allocator, PlanNodeIdAllocator idAllocator, SymbolAllocator symbolAllocator, Session session, boolean distributedIndexJoins, boolean distributedJoins, boolean preferStreamingOperators, boolean redistributeWrites) {
            this.allocator = allocator;
            this.idAllocator = idAllocator;
            this.symbolAllocator = symbolAllocator;
            this.session = session;
            this.distributedIndexJoins = distributedIndexJoins;
            this.distributedJoins = distributedJoins;
            this.preferStreamingOperators = preferStreamingOperators;
            this.redistributeWrites = redistributeWrites;
        }

        @Override
        protected PlanWithProperties visitPlan(PlanNode node, Context context) {
            return this.rebaseAndDeriveProperties(node, this.planChild(node, context));
        }

        @Override
        public PlanWithProperties visitDelete(DeleteNode node, Context context) {
            return this.rebaseAndDeriveProperties((PlanNode)node, this.planChild(node, context.withHashPartitionedSemiJoinBanned(true)));
        }

        @Override
        public PlanWithProperties visitProject(ProjectNode node, Context context) {
            Map identities = AddExchanges.computeIdentityTranslations(node.getAssignments());
            PreferredProperties translatedPreferred = context.getPreferredProperties().translate(symbol -> Optional.ofNullable(identities.get(symbol)));
            return this.rebaseAndDeriveProperties((PlanNode)node, this.planChild(node, context.withPreferredProperties(translatedPreferred)));
        }

        @Override
        public PlanWithProperties visitOutput(OutputNode node, Context context) {
            PlanWithProperties child = this.planChild(node, context.withPreferredProperties(PreferredProperties.any()));
            if (!child.getProperties().isSingleNode()) {
                child = this.withDerivedProperties(ExchangeNode.gatheringExchange(this.idAllocator.getNextId(), child.getNode()), child.getProperties());
            }
            return this.rebaseAndDeriveProperties((PlanNode)node, child);
        }

        @Override
        public PlanWithProperties visitEnforceSingleRow(EnforceSingleRowNode node, Context context) {
            PlanWithProperties child = this.planChild(node, context.withPreferredProperties(PreferredProperties.any()));
            if (!child.getProperties().isSingleNode()) {
                child = this.withDerivedProperties(ExchangeNode.gatheringExchange(this.idAllocator.getNextId(), child.getNode()), child.getProperties());
            }
            return this.rebaseAndDeriveProperties((PlanNode)node, child);
        }

        @Override
        public PlanWithProperties visitAggregation(AggregationNode node, Context context) {
            FunctionRegistry functionRegistry = AddExchanges.this.metadata.getFunctionRegistry();
            boolean decomposable = node.getFunctions().values().stream().map(functionRegistry::getAggregateFunctionImplementation).allMatch(InternalAggregationFunction::isDecomposable);
            PreferredProperties preferredProperties = node.getGroupBy().isEmpty() ? PreferredProperties.any() : PreferredProperties.derivePreferences(context.getPreferredProperties(), (Set<Symbol>)ImmutableSet.copyOf(node.getGroupBy()), Optional.of(node.getGroupBy()), LocalProperties.grouped(node.getGroupBy()));
            PlanWithProperties child = this.planChild(node, context.withPreferredProperties(preferredProperties));
            if (child.getProperties().isSingleNode()) {
                return this.rebaseAndDeriveProperties((PlanNode)node, child);
            }
            if (node.getGroupBy().isEmpty()) {
                if (decomposable) {
                    return this.splitAggregation(node, child, partial -> ExchangeNode.gatheringExchange(this.idAllocator.getNextId(), partial));
                }
                child = this.withDerivedProperties(ExchangeNode.gatheringExchange(this.idAllocator.getNextId(), child.getNode()), child.getProperties());
                return this.rebaseAndDeriveProperties((PlanNode)node, child);
            }
            if (child.getProperties().isNodePartitionedOn(node.getGroupBy())) {
                return this.rebaseAndDeriveProperties((PlanNode)node, child);
            }
            if (decomposable) {
                Function<PlanNode, PlanNode> exchanger = null;
                if (!child.getProperties().isNodePartitionedOn(node.getGroupBy())) {
                    exchanger = partial -> ExchangeNode.partitionedExchange(this.idAllocator.getNextId(), partial, node.getGroupBy(), node.getHashSymbol());
                }
                return this.splitAggregation(node, child, exchanger);
            }
            child = this.withDerivedProperties(ExchangeNode.partitionedExchange(this.idAllocator.getNextId(), child.getNode(), node.getGroupBy(), node.getHashSymbol()), child.getProperties());
            return this.rebaseAndDeriveProperties((PlanNode)node, child);
        }

        private PlanWithProperties splitAggregation(AggregationNode node, PlanWithProperties newChild, Function<PlanNode, PlanNode> exchanger) {
            Map<Symbol, Symbol> masks = node.getMasks();
            HashMap<Symbol, FunctionCall> finalCalls = new HashMap<Symbol, FunctionCall>();
            HashMap<Symbol, FunctionCall> intermediateCalls = new HashMap<Symbol, FunctionCall>();
            HashMap<Symbol, Signature> intermediateFunctions = new HashMap<Symbol, Signature>();
            HashMap<Symbol, Symbol> intermediateMask = new HashMap<Symbol, Symbol>();
            for (Map.Entry<Symbol, FunctionCall> entry : node.getAggregations().entrySet()) {
                Signature signature = node.getFunctions().get(entry.getKey());
                InternalAggregationFunction function = AddExchanges.this.metadata.getFunctionRegistry().getAggregateFunctionImplementation(signature);
                Symbol intermediateSymbol = this.allocator.newSymbol(signature.getName(), function.getIntermediateType());
                intermediateCalls.put(intermediateSymbol, entry.getValue());
                intermediateFunctions.put(intermediateSymbol, signature);
                if (masks.containsKey(entry.getKey())) {
                    intermediateMask.put(intermediateSymbol, masks.get(entry.getKey()));
                }
                finalCalls.put(entry.getKey(), new FunctionCall(QualifiedName.of((String)signature.getName(), (String[])new String[0]), (List)ImmutableList.of((Object)new QualifiedNameReference(intermediateSymbol.toQualifiedName()))));
            }
            PlanWithProperties partial = this.withDerivedProperties(new AggregationNode(this.idAllocator.getNextId(), newChild.getNode(), node.getGroupBy(), intermediateCalls, intermediateFunctions, intermediateMask, AggregationNode.Step.PARTIAL, node.getSampleWeight(), node.getConfidence(), node.getHashSymbol()), newChild.getProperties());
            PlanNode source = partial.getNode();
            if (exchanger != null) {
                source = exchanger.apply(source);
            }
            return this.withDerivedProperties(new AggregationNode(node.getId(), source, node.getGroupBy(), finalCalls, node.getFunctions(), (Map<Symbol, Symbol>)ImmutableMap.of(), AggregationNode.Step.FINAL, Optional.empty(), node.getConfidence(), node.getHashSymbol()), this.deriveProperties(source, partial.getProperties()));
        }

        @Override
        public PlanWithProperties visitMarkDistinct(MarkDistinctNode node, Context context) {
            PreferredProperties preferredChildProperties = PreferredProperties.derivePreferences(context.getPreferredProperties(), (Set<Symbol>)ImmutableSet.copyOf(node.getDistinctSymbols()), Optional.of(node.getDistinctSymbols()), LocalProperties.grouped(node.getDistinctSymbols()));
            PlanWithProperties child = node.getSource().accept(this, context.withPreferredProperties(preferredChildProperties));
            if (child.getProperties().isSingleNode() || !child.getProperties().isStreamPartitionedOn(node.getDistinctSymbols())) {
                child = this.withDerivedProperties(ExchangeNode.partitionedExchange(this.idAllocator.getNextId(), child.getNode(), node.getDistinctSymbols(), node.getHashSymbol()), child.getProperties());
            }
            return this.rebaseAndDeriveProperties((PlanNode)node, child);
        }

        @Override
        public PlanWithProperties visitWindow(WindowNode node, Context context) {
            ArrayList desiredProperties = new ArrayList();
            if (!node.getPartitionBy().isEmpty()) {
                desiredProperties.add(new GroupingProperty(node.getPartitionBy()));
            }
            for (Symbol symbol2 : node.getOrderBy()) {
                desiredProperties.add((LocalProperty<Symbol>)new SortingProperty((Object)symbol2, node.getOrderings().get(symbol2)));
            }
            PlanWithProperties child = this.planChild(node, context.withPreferredProperties(PreferredProperties.derivePreferences(context.getPreferredProperties(), (Set<Symbol>)ImmutableSet.copyOf(node.getPartitionBy()), desiredProperties)));
            if (!child.getProperties().isStreamPartitionedOn(node.getPartitionBy())) {
                child = node.getPartitionBy().isEmpty() ? this.withDerivedProperties(ExchangeNode.gatheringExchange(this.idAllocator.getNextId(), child.getNode()), child.getProperties()) : this.withDerivedProperties(ExchangeNode.partitionedExchange(this.idAllocator.getNextId(), child.getNode(), node.getPartitionBy(), node.getHashSymbol()), child.getProperties());
            }
            Iterator matchIterator = LocalProperties.match(child.getProperties().getLocalProperties(), desiredProperties).iterator();
            Object prePartitionedInputs = ImmutableSet.of();
            if (!node.getPartitionBy().isEmpty()) {
                Optional<LocalProperty<LocalProperty>> groupingRequirement = matchIterator.next();
                Set unPartitionedInputs = groupingRequirement.map(LocalProperty::getColumns).orElse((Set)ImmutableSet.of());
                prePartitionedInputs = (Set)node.getPartitionBy().stream().filter(symbol -> !unPartitionedInputs.contains(symbol)).collect(ImmutableCollectors.toImmutableSet());
            }
            int preSortedOrderPrefix = 0;
            if (prePartitionedInputs.equals(ImmutableSet.copyOf(node.getPartitionBy()))) {
                while (matchIterator.hasNext() && !matchIterator.next().isPresent()) {
                    ++preSortedOrderPrefix;
                }
            }
            return this.withDerivedProperties(new WindowNode(node.getId(), child.getNode(), node.getPartitionBy(), node.getOrderBy(), node.getOrderings(), node.getFrame(), node.getWindowFunctions(), node.getSignatures(), node.getHashSymbol(), (Set<Symbol>)prePartitionedInputs, preSortedOrderPrefix), child.getProperties());
        }

        @Override
        public PlanWithProperties visitRowNumber(RowNumberNode node, Context context) {
            if (node.getPartitionBy().isEmpty()) {
                PlanWithProperties child = this.planChild(node, context.withPreferredProperties(PreferredProperties.undistributed()));
                if (!child.getProperties().isSingleNode()) {
                    child = this.withDerivedProperties(ExchangeNode.gatheringExchange(this.idAllocator.getNextId(), child.getNode()), child.getProperties());
                }
                return this.rebaseAndDeriveProperties((PlanNode)node, child);
            }
            PlanWithProperties child = this.planChild(node, context.withPreferredProperties(PreferredProperties.derivePreferences(context.getPreferredProperties(), (Set<Symbol>)ImmutableSet.copyOf(node.getPartitionBy()), LocalProperties.grouped(node.getPartitionBy()))));
            if (!child.getProperties().isStreamPartitionedOn(node.getPartitionBy())) {
                child = this.withDerivedProperties(ExchangeNode.partitionedExchange(this.idAllocator.getNextId(), child.getNode(), node.getPartitionBy(), node.getHashSymbol()), child.getProperties());
            }
            return this.rebaseAndDeriveProperties((PlanNode)node, child);
        }

        @Override
        public PlanWithProperties visitTopNRowNumber(TopNRowNumberNode node, Context context) {
            Function<PlanNode, PlanNode> addExchange;
            PreferredProperties preferredChildProperties;
            if (node.getPartitionBy().isEmpty()) {
                preferredChildProperties = PreferredProperties.any();
                addExchange = partial -> ExchangeNode.gatheringExchange(this.idAllocator.getNextId(), partial);
            } else {
                preferredChildProperties = PreferredProperties.derivePreferences(context.getPreferredProperties(), (Set<Symbol>)ImmutableSet.copyOf(node.getPartitionBy()), LocalProperties.grouped(node.getPartitionBy()));
                addExchange = partial -> ExchangeNode.partitionedExchange(this.idAllocator.getNextId(), partial, node.getPartitionBy(), node.getHashSymbol());
            }
            PlanWithProperties child = this.planChild(node, context.withPreferredProperties(preferredChildProperties));
            if (!child.getProperties().isStreamPartitionedOn(node.getPartitionBy())) {
                child = this.withDerivedProperties(new TopNRowNumberNode(this.idAllocator.getNextId(), child.getNode(), node.getPartitionBy(), node.getOrderBy(), node.getOrderings(), node.getRowNumberSymbol(), node.getMaxRowCountPerPartition(), true, node.getHashSymbol()), child.getProperties());
                child = this.withDerivedProperties(addExchange.apply(child.getNode()), child.getProperties());
            }
            return this.rebaseAndDeriveProperties((PlanNode)node, child);
        }

        @Override
        public PlanWithProperties visitTopN(TopNNode node, Context context) {
            PlanWithProperties child = this.planChild(node, context.withPreferredProperties(PreferredProperties.any()));
            if (!child.getProperties().isSingleNode()) {
                child = this.withDerivedProperties(new TopNNode(this.idAllocator.getNextId(), child.getNode(), node.getCount(), node.getOrderBy(), node.getOrderings(), true), child.getProperties());
                child = this.withDerivedProperties(ExchangeNode.gatheringExchange(this.idAllocator.getNextId(), child.getNode()), child.getProperties());
            }
            return this.rebaseAndDeriveProperties((PlanNode)node, child);
        }

        @Override
        public PlanWithProperties visitSort(SortNode node, Context context) {
            PlanWithProperties child = this.planChild(node, context.withPreferredProperties(PreferredProperties.undistributed()));
            if (!child.getProperties().isSingleNode()) {
                child = this.withDerivedProperties(ExchangeNode.gatheringExchange(this.idAllocator.getNextId(), child.getNode()), child.getProperties());
            }
            return this.rebaseAndDeriveProperties((PlanNode)node, child);
        }

        @Override
        public PlanWithProperties visitLimit(LimitNode node, Context context) {
            PlanWithProperties child = this.planChild(node, context.withPreferredProperties(PreferredProperties.any()));
            if (!child.getProperties().isSingleNode()) {
                child = this.withDerivedProperties(new LimitNode(this.idAllocator.getNextId(), child.getNode(), node.getCount()), child.getProperties());
                child = this.withDerivedProperties(ExchangeNode.gatheringExchange(this.idAllocator.getNextId(), child.getNode()), child.getProperties());
            }
            return this.rebaseAndDeriveProperties((PlanNode)node, child);
        }

        @Override
        public PlanWithProperties visitDistinctLimit(DistinctLimitNode node, Context context) {
            PlanWithProperties child = this.planChild(node, context.withPreferredProperties(PreferredProperties.any()));
            if (!child.getProperties().isSingleNode()) {
                child = this.withDerivedProperties(ExchangeNode.gatheringExchange(this.idAllocator.getNextId(), new DistinctLimitNode(this.idAllocator.getNextId(), child.getNode(), node.getLimit(), node.getHashSymbol())), child.getProperties());
            }
            return this.rebaseAndDeriveProperties((PlanNode)node, child);
        }

        @Override
        public PlanWithProperties visitFilter(FilterNode node, Context context) {
            if (node.getSource() instanceof TableScanNode) {
                return this.planTableScan((TableScanNode)node.getSource(), node.getPredicate(), context);
            }
            return this.rebaseAndDeriveProperties((PlanNode)node, this.planChild(node, context));
        }

        @Override
        public PlanWithProperties visitTableScan(TableScanNode node, Context context) {
            return this.planTableScan(node, (Expression)BooleanLiteral.TRUE_LITERAL, context);
        }

        @Override
        public PlanWithProperties visitTableWriter(TableWriterNode node, Context context) {
            PlanWithProperties source = node.getSource().accept(this, context);
            Optional<PartitionFunctionBinding> partitionFunction = node.getPartitionFunction();
            if (!partitionFunction.isPresent() && this.redistributeWrites) {
                partitionFunction = Optional.of(new PartitionFunctionBinding(SystemPartitioningHandle.FIXED_RANDOM_DISTRIBUTION, source.getNode().getOutputSymbols(), (List<PartitionFunctionBinding.PartitionFunctionArgumentBinding>)ImmutableList.of()));
            }
            if (partitionFunction.isPresent()) {
                source = this.withDerivedProperties(ExchangeNode.partitionedExchange(this.idAllocator.getNextId(), source.getNode(), partitionFunction.get()), source.getProperties());
            }
            return this.rebaseAndDeriveProperties((PlanNode)node, source);
        }

        private PlanWithProperties planTableScan(TableScanNode node, Expression predicate, Context context) {
            Expression deterministicPredicate = ExpressionUtils.stripNonDeterministicConjuncts(predicate);
            DomainTranslator.ExtractionResult decomposedPredicate = DomainTranslator.fromPredicate(AddExchanges.this.metadata, this.session, deterministicPredicate, this.symbolAllocator.getTypes());
            TupleDomain simplifiedConstraint = decomposedPredicate.getTupleDomain().transform(node.getAssignments()::get).intersect(node.getCurrentConstraint());
            ImmutableBiMap assignments = ImmutableBiMap.copyOf(node.getAssignments()).inverse();
            Expression[] expressionArray = new Expression[2];
            expressionArray[0] = deterministicPredicate;
            expressionArray[1] = DomainTranslator.toPredicate((TupleDomain<Symbol>)node.getCurrentConstraint().transform(((Map)assignments)::get));
            Expression constraint = ExpressionUtils.combineConjuncts(expressionArray);
            List<TableLayoutResult> layouts = AddExchanges.this.metadata.getLayouts(this.session, node.getTable(), (Constraint<ColumnHandle>)new Constraint(simplifiedConstraint, bindings -> !this.shouldPrune(constraint, node.getAssignments(), (Map<ColumnHandle, NullableValue>)bindings)), Optional.of(node.getOutputSymbols().stream().map(node.getAssignments()::get).collect(ImmutableCollectors.toImmutableSet())));
            if (layouts.isEmpty()) {
                return new PlanWithProperties(new ValuesNode(this.idAllocator.getNextId(), node.getOutputSymbols(), (List<List<Expression>>)ImmutableList.of()), ActualProperties.builder().global(ActualProperties.Global.singleStreamPartition()).build());
            }
            Preconditions.checkState((!(layouts = layouts.stream().filter(this.layoutHasAllNeededOutputs(node)).collect(Collectors.toList())).isEmpty() ? 1 : 0) != 0, (String)"No usable layouts for %s", (Object[])new Object[]{node});
            List<PlanWithProperties> possiblePlans = layouts.stream().map(arg_0 -> this.lambda$planTableScan$395(node, simplifiedConstraint, predicate, (Map)assignments, decomposedPredicate, arg_0)).collect(Collectors.toList());
            return this.pickPlan(possiblePlans, context);
        }

        private Predicate<TableLayoutResult> layoutHasAllNeededOutputs(TableScanNode node) {
            return layout -> {
                if (!layout.getLayout().getColumns().isPresent()) return true;
                if (!layout.getLayout().getColumns().get().containsAll(Lists.transform(node.getOutputSymbols(), node.getAssignments()::get))) return false;
                return true;
            };
        }

        private PlanWithProperties pickPlan(List<PlanWithProperties> possiblePlans, Context context) {
            Preconditions.checkArgument((!possiblePlans.isEmpty() ? 1 : 0) != 0);
            if (this.preferStreamingOperators) {
                possiblePlans = new ArrayList<PlanWithProperties>(possiblePlans);
                Collections.sort(possiblePlans, Comparator.comparing(PlanWithProperties::getProperties, AddExchanges.streamingExecutionPreference(context.getPreferredProperties())));
            }
            return possiblePlans.get(0);
        }

        private boolean shouldPrune(Expression predicate, Map<Symbol, ColumnHandle> assignments, Map<ColumnHandle, NullableValue> bindings) {
            List<Expression> conjuncts = ExpressionUtils.extractConjuncts(predicate);
            IdentityHashMap<Expression, Type> expressionTypes = ExpressionAnalyzer.getExpressionTypes(this.session, AddExchanges.this.metadata, AddExchanges.this.parser, this.symbolAllocator.getTypes(), predicate);
            LookupSymbolResolver inputs = new LookupSymbolResolver(assignments, bindings);
            for (Expression expression : conjuncts) {
                ExpressionInterpreter optimizer = ExpressionInterpreter.expressionOptimizer(expression, AddExchanges.this.metadata, this.session, expressionTypes);
                Object optimized = optimizer.optimize(inputs);
                if (!Boolean.FALSE.equals(optimized) && optimized != null && !(optimized instanceof NullLiteral)) continue;
                return true;
            }
            return false;
        }

        @Override
        public PlanWithProperties visitValues(ValuesNode node, Context context) {
            return new PlanWithProperties(node, ActualProperties.builder().global(ActualProperties.Global.singleStreamPartition()).build());
        }

        @Override
        public PlanWithProperties visitTableFinish(TableFinishNode node, Context context) {
            PlanWithProperties child = this.planChild(node, context.withPreferredProperties(PreferredProperties.any()));
            if (child.getNode() instanceof ExchangeNode && ((ExchangeNode)child.getNode()).getType().equals((Object)ExchangeNode.Type.GATHER)) {
                return this.rebaseAndDeriveProperties((PlanNode)node, child);
            }
            if (!child.getProperties().isSingleNode() || !child.getProperties().isCoordinatorOnly()) {
                child = this.withDerivedProperties(ExchangeNode.gatheringExchange(this.idAllocator.getNextId(), child.getNode()), child.getProperties());
            }
            return this.rebaseAndDeriveProperties((PlanNode)node, child);
        }

        @Override
        public PlanWithProperties visitJoin(JoinNode node, Context context) {
            PlanWithProperties right;
            PlanWithProperties left;
            List leftSymbols = Lists.transform(node.getCriteria(), JoinNode.EquiJoinClause::getLeft);
            List rightSymbols = Lists.transform(node.getCriteria(), JoinNode.EquiJoinClause::getRight);
            JoinNode.Type type = node.getType();
            boolean isCrossJoin = type == JoinNode.Type.INNER && leftSymbols.isEmpty();
            boolean joinWithNonScalar = node.getRight().accept(new IsScalarPlanVisitor(), null);
            if (this.distributedJoins && !isCrossJoin && !joinWithNonScalar || type == JoinNode.Type.FULL || type == JoinNode.Type.RIGHT) {
                left = node.getLeft().accept(this, context.withPreferredProperties(PreferredProperties.hashPartitioned(leftSymbols)));
                right = node.getRight().accept(this, context.withPreferredProperties(PreferredProperties.hashPartitioned(rightSymbols)));
                if (!left.getProperties().isNodePartitionedOn(leftSymbols) || this.distributedJoins && left.getProperties().isSingleNode()) {
                    left = this.withDerivedProperties(ExchangeNode.partitionedExchange(this.idAllocator.getNextId(), left.getNode(), leftSymbols, node.getLeftHashSymbol()), left.getProperties());
                }
                if (left.getProperties().isSingleNode()) {
                    if (!right.getProperties().isSingleNode()) {
                        right = this.withDerivedProperties(ExchangeNode.gatheringExchange(this.idAllocator.getNextId(), right.getNode()), right.getProperties());
                    }
                } else {
                    HashMultimap leftToRight = HashMultimap.create();
                    for (int i = 0; i < leftSymbols.size(); ++i) {
                        leftToRight.put(leftSymbols.get(i), rightSymbols.get(i));
                    }
                    if (!left.getProperties().isNodePartitionedWith(right.getProperties(), arg_0 -> ((SetMultimap)leftToRight).get(arg_0))) {
                        Function<Symbol, Optional<Symbol>> leftToRightTranslator = arg_0 -> Rewriter.lambda$visitJoin$397((SetMultimap)leftToRight, arg_0);
                        Optional<List<PartitionFunctionBinding.PartitionFunctionArgumentBinding>> rightPartitionColumns = left.getProperties().translate(leftToRightTranslator).getNodePartitioningColumns();
                        Verify.verify((boolean)rightPartitionColumns.isPresent(), (String)"Could not translate JOIN probe partitioning to build symbols", (Object[])new Object[0]);
                        PartitionFunctionBinding partitionFunction = new PartitionFunctionBinding(left.getProperties().getNodePartitioningHandle().get(), node.getRight().getOutputSymbols(), rightPartitionColumns.get(), Optional.empty());
                        right = this.withDerivedProperties(ExchangeNode.partitionedExchange(this.idAllocator.getNextId(), right.getNode(), partitionFunction), right.getProperties());
                    }
                }
            } else {
                left = node.getLeft().accept(this, context.withPreferredProperties(PreferredProperties.any()));
                right = node.getRight().accept(this, context.withPreferredProperties(PreferredProperties.any()));
                if (left.getProperties().isSingleNode() && !right.getProperties().isSingleNode()) {
                    right = this.withDerivedProperties(ExchangeNode.gatheringExchange(this.idAllocator.getNextId(), right.getNode()), right.getProperties());
                } else if (!(left.getProperties().isSingleNode() || left.getProperties().isNodePartitionedOn(SystemPartitioningHandle.FIXED_HASH_DISTRIBUTION, leftSymbols) && right.getProperties().isNodePartitionedOn(SystemPartitioningHandle.FIXED_HASH_DISTRIBUTION, rightSymbols))) {
                    right = this.withDerivedProperties(ExchangeNode.replicatedExchange(this.idAllocator.getNextId(), right.getNode()), right.getProperties());
                }
            }
            JoinNode result = new JoinNode(node.getId(), type, left.getNode(), right.getNode(), node.getCriteria(), node.getLeftHashSymbol(), node.getRightHashSymbol());
            return new PlanWithProperties(result, this.deriveProperties((PlanNode)result, (List<ActualProperties>)ImmutableList.of((Object)left.getProperties(), (Object)right.getProperties())));
        }

        @Override
        public PlanWithProperties visitUnnest(UnnestNode node, Context context) {
            PreferredProperties translatedPreferred = context.getPreferredProperties().translate(symbol -> node.getReplicateSymbols().contains(symbol) ? Optional.of(symbol) : Optional.empty());
            return this.rebaseAndDeriveProperties((PlanNode)node, this.planChild(node, context.withPreferredProperties(translatedPreferred)));
        }

        @Override
        public PlanWithProperties visitSemiJoin(SemiJoinNode node, Context context) {
            PlanWithProperties filteringSource;
            PlanWithProperties source;
            if (this.distributedJoins && !context.isDownstreamIsDelete()) {
                ImmutableList sourceSymbols = ImmutableList.of((Object)node.getSourceJoinSymbol());
                ImmutableList filteringSourceSymbols = ImmutableList.of((Object)node.getFilteringSourceJoinSymbol());
                source = node.getSource().accept(this, context.withPreferredProperties(PreferredProperties.hashPartitioned((List<Symbol>)sourceSymbols)));
                filteringSource = node.getFilteringSource().accept(this, context.withPreferredProperties(PreferredProperties.any()));
                if (!source.getProperties().isNodePartitionedOn(SystemPartitioningHandle.FIXED_HASH_DISTRIBUTION, (List<Symbol>)sourceSymbols)) {
                    source = this.withDerivedProperties(ExchangeNode.partitionedExchange(this.idAllocator.getNextId(), source.getNode(), (List<Symbol>)sourceSymbols, node.getSourceHashSymbol()), source.getProperties());
                }
                PartitionFunctionBinding partitionFunction = new PartitionFunctionBinding(SystemPartitioningHandle.FIXED_HASH_DISTRIBUTION, filteringSource.getNode().getOutputSymbols(), (List)filteringSourceSymbols.stream().map(PartitionFunctionBinding.PartitionFunctionArgumentBinding::new).collect(ImmutableCollectors.toImmutableList()), node.getFilteringSourceHashSymbol(), true, Optional.empty());
                filteringSource = this.withDerivedProperties(ExchangeNode.partitionedExchange(this.idAllocator.getNextId(), filteringSource.getNode(), partitionFunction), filteringSource.getProperties());
            } else {
                source = node.getSource().accept(this, context.withPreferredProperties(PreferredProperties.any()));
                filteringSource = node.getFilteringSource().accept(this, context.withPreferredProperties(PreferredProperties.any()).withHashPartitionedSemiJoinBanned(false));
                filteringSource = source.getProperties().isSingleNode() ? this.withDerivedProperties(ExchangeNode.gatheringExchange(this.idAllocator.getNextId(), filteringSource.getNode()), filteringSource.getProperties()) : this.withDerivedProperties(ExchangeNode.replicatedExchange(this.idAllocator.getNextId(), filteringSource.getNode()), filteringSource.getProperties());
            }
            return this.rebaseAndDeriveProperties((PlanNode)node, (List<PlanWithProperties>)ImmutableList.of((Object)source, (Object)filteringSource));
        }

        @Override
        public PlanWithProperties visitIndexJoin(IndexJoinNode node, Context context) {
            List joinColumns = Lists.transform(node.getCriteria(), IndexJoinNode.EquiJoinClause::getProbe);
            Object desiredLocalProperties = context.getPreferredProperties().getLocalProperties().isEmpty() ? LocalProperties.grouped(joinColumns) : ImmutableList.of();
            PlanWithProperties probeSource = node.getProbeSource().accept(this, context.withPreferredProperties(PreferredProperties.derivePreferences(context.getPreferredProperties(), (Set<Symbol>)ImmutableSet.copyOf((Collection)joinColumns), (List<LocalProperty<Symbol>>)desiredLocalProperties)));
            ActualProperties probeProperties = probeSource.getProperties();
            PlanWithProperties indexSource = node.getIndexSource().accept(this, context.withPreferredProperties(PreferredProperties.any()));
            if (this.shouldRepartitionForIndexJoin(joinColumns, context.getPreferredProperties(), probeProperties)) {
                probeSource = this.withDerivedProperties(ExchangeNode.partitionedExchange(this.idAllocator.getNextId(), probeSource.getNode(), joinColumns, node.getProbeHashSymbol()), probeProperties);
            }
            PlanNode result = ChildReplacer.replaceChildren(node, (List<PlanNode>)ImmutableList.of((Object)probeSource.getNode(), (Object)node.getIndexSource()));
            return new PlanWithProperties(result, this.deriveProperties(result, (List<ActualProperties>)ImmutableList.of((Object)probeSource.getProperties(), (Object)indexSource.getProperties())));
        }

        private boolean shouldRepartitionForIndexJoin(List<Symbol> joinColumns, PreferredProperties parentPreferredProperties, ActualProperties probeProperties) {
            if (!this.distributedIndexJoins) {
                return false;
            }
            if (probeProperties.isSingleNode()) {
                return false;
            }
            Optional<Boolean> parentPartitioningPreferences = parentPreferredProperties.getGlobalProperties().flatMap(PreferredProperties.Global::getPartitioningProperties);
            boolean parentAlreadyPartitionedOnChild = parentPartitioningPreferences.map(partitioning -> probeProperties.isStreamPartitionedOn(partitioning.getPartitioningColumns())).orElse(false);
            if (this.preferStreamingOperators && parentAlreadyPartitionedOnChild) {
                return false;
            }
            if (!probeProperties.isStreamPartitionedOn(joinColumns)) {
                return true;
            }
            return probeProperties.isEffectivelySingleStream() && probeProperties.isStreamRepartitionEffective(joinColumns);
        }

        @Override
        public PlanWithProperties visitIndexSource(IndexSourceNode node, Context context) {
            return new PlanWithProperties(node, ActualProperties.builder().global(ActualProperties.Global.singleStreamPartition()).build());
        }

        @Override
        public PlanWithProperties visitUnion(UnionNode node, Context context) {
            if (!context.getPreferredProperties().getGlobalProperties().isPresent() || !context.getPreferredProperties().getGlobalProperties().get().isHashPartitioned()) {
                ArrayList<PlanNode> unpartitionedChildren = new ArrayList<PlanNode>();
                ArrayList<List<Symbol>> unpartitionedOutputLayouts = new ArrayList<List<Symbol>>();
                ArrayList<PlanNode> partitionedChildren = new ArrayList<PlanNode>();
                ArrayList<List<Symbol>> partitionedOutputLayouts = new ArrayList<List<Symbol>>();
                List<PlanNode> sources = node.getSources();
                for (int i = 0; i < sources.size(); ++i) {
                    PlanWithProperties child = sources.get(i).accept(this, context.withPreferredProperties(PreferredProperties.any()));
                    if (child.getProperties().isSingleNode()) {
                        unpartitionedChildren.add(child.getNode());
                        unpartitionedOutputLayouts.add(node.sourceOutputLayout(i));
                        continue;
                    }
                    partitionedChildren.add(child.getNode());
                    partitionedOutputLayouts.add(node.sourceOutputLayout(i));
                }
                PlanNode result = null;
                if (!partitionedChildren.isEmpty()) {
                    result = new ExchangeNode(this.idAllocator.getNextId(), ExchangeNode.Type.GATHER, new PartitionFunctionBinding(SystemPartitioningHandle.SINGLE_DISTRIBUTION, node.getOutputSymbols(), (List<PartitionFunctionBinding.PartitionFunctionArgumentBinding>)ImmutableList.of()), partitionedChildren, partitionedOutputLayouts);
                    unpartitionedChildren.add(result);
                    unpartitionedOutputLayouts.add(((PlanNode)result).getOutputSymbols());
                }
                if (unpartitionedChildren.size() > 1) {
                    ImmutableListMultimap.Builder mappings = ImmutableListMultimap.builder();
                    for (int i = 0; i < node.getOutputSymbols().size(); ++i) {
                        for (List list : unpartitionedOutputLayouts) {
                            mappings.put((Object)node.getOutputSymbols().get(i), list.get(i));
                        }
                    }
                    result = new UnionNode(node.getId(), unpartitionedChildren, (ListMultimap<Symbol, Symbol>)mappings.build(), (List<Symbol>)ImmutableList.copyOf((Collection)mappings.build().keySet()));
                }
                return new PlanWithProperties(result, ActualProperties.builder().global(ActualProperties.Global.singleStreamPartition()).build());
            }
            List<Symbol> hashingColumns = context.getPreferredProperties().getGlobalProperties().get().getPartitioningProperties().get().getHashingOrder().get();
            ImmutableList.Builder partitionedSources = ImmutableList.builder();
            ImmutableListMultimap.Builder outputToSourcesMapping = ImmutableListMultimap.builder();
            for (int sourceIndex = 0; sourceIndex < node.getSources().size(); ++sourceIndex) {
                ImmutableList.Builder hashColumnsBuilder = ImmutableList.builder();
                for (Symbol column : hashingColumns) {
                    hashColumnsBuilder.add(node.getSymbolMapping().get((Object)column).get(sourceIndex));
                }
                ImmutableList sourceHashColumns = hashColumnsBuilder.build();
                PlanWithProperties source = node.getSources().get(sourceIndex).accept(this, context.withPreferredProperties(PreferredProperties.hashPartitioned((List<Symbol>)sourceHashColumns)));
                if (!source.getProperties().isNodePartitionedOn(SystemPartitioningHandle.FIXED_HASH_DISTRIBUTION, (List<Symbol>)sourceHashColumns)) {
                    source = this.withDerivedProperties(ExchangeNode.partitionedExchange(this.idAllocator.getNextId(), source.getNode(), (List<Symbol>)sourceHashColumns, Optional.empty()), source.getProperties());
                }
                partitionedSources.add((Object)source.getNode());
                for (int column = 0; column < node.getOutputSymbols().size(); ++column) {
                    outputToSourcesMapping.put((Object)node.getOutputSymbols().get(column), (Object)node.sourceOutputLayout(sourceIndex).get(column));
                }
            }
            UnionNode newNode = new UnionNode(node.getId(), (List<PlanNode>)partitionedSources.build(), (ListMultimap<Symbol, Symbol>)outputToSourcesMapping.build(), (List<Symbol>)ImmutableList.copyOf((Collection)outputToSourcesMapping.build().keySet()));
            List hashArguments = (List)hashingColumns.stream().map(PartitionFunctionBinding.PartitionFunctionArgumentBinding::new).collect(ImmutableCollectors.toImmutableList());
            return new PlanWithProperties(newNode, ActualProperties.builder().global(ActualProperties.Global.partitionedOn(SystemPartitioningHandle.FIXED_HASH_DISTRIBUTION, hashArguments, Optional.of(hashArguments))).build());
        }

        private PlanWithProperties planChild(PlanNode node, Context context) {
            return ((PlanNode)Iterables.getOnlyElement(node.getSources())).accept(this, context);
        }

        private PlanWithProperties rebaseAndDeriveProperties(PlanNode node, PlanWithProperties child) {
            return this.withDerivedProperties(ChildReplacer.replaceChildren(node, (List<PlanNode>)ImmutableList.of((Object)child.getNode())), child.getProperties());
        }

        private PlanWithProperties rebaseAndDeriveProperties(PlanNode node, List<PlanWithProperties> children) {
            PlanNode result = ChildReplacer.replaceChildren(node, children.stream().map(PlanWithProperties::getNode).collect(Collectors.toList()));
            return new PlanWithProperties(result, this.deriveProperties(result, children.stream().map(PlanWithProperties::getProperties).collect(Collectors.toList())));
        }

        private PlanWithProperties withDerivedProperties(PlanNode node, ActualProperties inputProperties) {
            return new PlanWithProperties(node, this.deriveProperties(node, inputProperties));
        }

        private ActualProperties deriveProperties(PlanNode result, ActualProperties inputProperties) {
            return PropertyDerivations.deriveProperties(result, inputProperties, AddExchanges.this.metadata, this.session, this.symbolAllocator.getTypes(), AddExchanges.this.parser);
        }

        private ActualProperties deriveProperties(PlanNode result, List<ActualProperties> inputProperties) {
            return PropertyDerivations.deriveProperties(result, inputProperties, AddExchanges.this.metadata, this.session, this.symbolAllocator.getTypes(), AddExchanges.this.parser);
        }

        private static /* synthetic */ Optional lambda$visitJoin$397(SetMultimap leftToRight, Symbol leftSymbol) {
            return leftToRight.get((Object)leftSymbol).stream().findAny();
        }

        private /* synthetic */ PlanWithProperties lambda$planTableScan$395(TableScanNode node, TupleDomain simplifiedConstraint, Expression predicate, Map assignments, DomainTranslator.ExtractionResult decomposedPredicate, TableLayoutResult layout) {
            TableScanNode tableScan = new TableScanNode(node.getId(), node.getTable(), node.getOutputSymbols(), node.getAssignments(), Optional.of(layout.getLayout().getHandle()), (TupleDomain<ColumnHandle>)simplifiedConstraint.intersect(layout.getLayout().getPredicate()), Optional.ofNullable(node.getOriginalConstraint()).orElse(predicate));
            PlanWithProperties result = new PlanWithProperties(tableScan, this.deriveProperties((PlanNode)tableScan, (List<ActualProperties>)ImmutableList.of()));
            Expression[] expressionArray = new Expression[3];
            expressionArray[0] = DomainTranslator.toPredicate((TupleDomain<Symbol>)layout.getUnenforcedConstraint().transform(assignments::get));
            expressionArray[1] = ExpressionUtils.stripDeterministicConjuncts(predicate);
            expressionArray[2] = decomposedPredicate.getRemainingExpression();
            Expression resultingPredicate = ExpressionUtils.combineConjuncts(expressionArray);
            if (!BooleanLiteral.TRUE_LITERAL.equals((Object)resultingPredicate)) {
                return this.withDerivedProperties(new FilterNode(this.idAllocator.getNextId(), result.getNode(), resultingPredicate), this.deriveProperties((PlanNode)tableScan, (List<ActualProperties>)ImmutableList.of()));
            }
            return result;
        }
    }

    private static class Context {
        private PreferredProperties preferredProperties;
        private boolean downstreamIsDelete;

        Context(PreferredProperties preferredProperties, boolean downstreamIsDelete) {
            this.preferredProperties = preferredProperties;
            this.downstreamIsDelete = downstreamIsDelete;
        }

        Context withPreferredProperties(PreferredProperties preferredProperties) {
            return new Context(preferredProperties, this.downstreamIsDelete);
        }

        Context withHashPartitionedSemiJoinBanned(boolean hashPartitionedSemiJoinBanned) {
            return new Context(this.preferredProperties, hashPartitionedSemiJoinBanned);
        }

        PreferredProperties getPreferredProperties() {
            return this.preferredProperties;
        }

        boolean isDownstreamIsDelete() {
            return this.downstreamIsDelete;
        }
    }
}

