/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.execution.SharedBuffer;
import com.facebook.presto.execution.TaskManagerConfig;
import com.facebook.presto.index.IndexManager;
import com.facebook.presto.metadata.FunctionKind;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.operator.AggregationOperator;
import com.facebook.presto.operator.CursorProcessor;
import com.facebook.presto.operator.DeleteOperator;
import com.facebook.presto.operator.DistinctLimitOperator;
import com.facebook.presto.operator.DriverFactory;
import com.facebook.presto.operator.EnforceSingleRowOperator;
import com.facebook.presto.operator.ExchangeClientSupplier;
import com.facebook.presto.operator.ExchangeOperator;
import com.facebook.presto.operator.FilterAndProjectOperator;
import com.facebook.presto.operator.FilterFunction;
import com.facebook.presto.operator.FilterFunctions;
import com.facebook.presto.operator.GenericCursorProcessor;
import com.facebook.presto.operator.GenericPageProcessor;
import com.facebook.presto.operator.GroupIdOperator;
import com.facebook.presto.operator.HashAggregationOperator;
import com.facebook.presto.operator.HashBuilderOperator;
import com.facebook.presto.operator.HashPartitionMaskOperator;
import com.facebook.presto.operator.HashSemiJoinOperator;
import com.facebook.presto.operator.InMemoryExchange;
import com.facebook.presto.operator.InMemoryExchangeSourceOperator;
import com.facebook.presto.operator.JoinOperatorFactory;
import com.facebook.presto.operator.LimitOperator;
import com.facebook.presto.operator.LocalPlannerAware;
import com.facebook.presto.operator.LookupJoinOperators;
import com.facebook.presto.operator.LookupOuterOperator;
import com.facebook.presto.operator.LookupSourceSupplier;
import com.facebook.presto.operator.MarkDistinctOperator;
import com.facebook.presto.operator.MetadataDeleteOperator;
import com.facebook.presto.operator.NestedLoopBuildOperator;
import com.facebook.presto.operator.NestedLoopJoinOperator;
import com.facebook.presto.operator.NestedLoopJoinPagesSupplier;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.OrderByOperator;
import com.facebook.presto.operator.OutputFactory;
import com.facebook.presto.operator.PageProcessor;
import com.facebook.presto.operator.ParallelHashBuilder;
import com.facebook.presto.operator.PartitionFunction;
import com.facebook.presto.operator.PartitionedOutputOperator;
import com.facebook.presto.operator.ProjectionFunction;
import com.facebook.presto.operator.ProjectionFunctions;
import com.facebook.presto.operator.RowNumberOperator;
import com.facebook.presto.operator.SampleOperator;
import com.facebook.presto.operator.ScanFilterAndProjectOperator;
import com.facebook.presto.operator.SetBuilderOperator;
import com.facebook.presto.operator.TableFinishOperator;
import com.facebook.presto.operator.TableScanOperator;
import com.facebook.presto.operator.TableWriterOperator;
import com.facebook.presto.operator.TaskOutputOperator;
import com.facebook.presto.operator.TopNOperator;
import com.facebook.presto.operator.TopNRowNumberOperator;
import com.facebook.presto.operator.UnnestOperator;
import com.facebook.presto.operator.ValuesOperator;
import com.facebook.presto.operator.WindowFunctionDefinition;
import com.facebook.presto.operator.WindowOperator;
import com.facebook.presto.operator.aggregation.AccumulatorFactory;
import com.facebook.presto.operator.index.DynamicTupleFilterFactory;
import com.facebook.presto.operator.index.FieldSetFilteringRecordSet;
import com.facebook.presto.operator.index.IndexBuildDriverFactoryProvider;
import com.facebook.presto.operator.index.IndexJoinLookupStats;
import com.facebook.presto.operator.index.IndexLookupSourceSupplier;
import com.facebook.presto.operator.index.IndexSourceOperator;
import com.facebook.presto.operator.window.FrameInfo;
import com.facebook.presto.operator.window.WindowFunctionSupplier;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorIndex;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.RecordSet;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.SortOrder;
import com.facebook.presto.spi.predicate.NullableValue;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeUtils;
import com.facebook.presto.split.MappedRecordSet;
import com.facebook.presto.split.PageSinkManager;
import com.facebook.presto.split.PageSourceProvider;
import com.facebook.presto.sql.analyzer.ExpressionAnalyzer;
import com.facebook.presto.sql.gen.ExpressionCompiler;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.CompilerConfig;
import com.facebook.presto.sql.planner.ExpressionInterpreter;
import com.facebook.presto.sql.planner.InterpretedFilterFunction;
import com.facebook.presto.sql.planner.InterpretedProjectionFunction;
import com.facebook.presto.sql.planner.NodePartitioningManager;
import com.facebook.presto.sql.planner.PartitionFunctionBinding;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolToInputRewriter;
import com.facebook.presto.sql.planner.SystemPartitioningHandle;
import com.facebook.presto.sql.planner.optimizations.IndexJoinOptimizer;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.DeleteNode;
import com.facebook.presto.sql.planner.plan.DistinctLimitNode;
import com.facebook.presto.sql.planner.plan.EnforceSingleRowNode;
import com.facebook.presto.sql.planner.plan.FilterNode;
import com.facebook.presto.sql.planner.plan.GroupIdNode;
import com.facebook.presto.sql.planner.plan.IndexJoinNode;
import com.facebook.presto.sql.planner.plan.IndexSourceNode;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.LimitNode;
import com.facebook.presto.sql.planner.plan.MarkDistinctNode;
import com.facebook.presto.sql.planner.plan.MetadataDeleteNode;
import com.facebook.presto.sql.planner.plan.OutputNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.plan.PlanVisitor;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.planner.plan.RemoteSourceNode;
import com.facebook.presto.sql.planner.plan.RowNumberNode;
import com.facebook.presto.sql.planner.plan.SampleNode;
import com.facebook.presto.sql.planner.plan.SemiJoinNode;
import com.facebook.presto.sql.planner.plan.SortNode;
import com.facebook.presto.sql.planner.plan.TableFinishNode;
import com.facebook.presto.sql.planner.plan.TableScanNode;
import com.facebook.presto.sql.planner.plan.TableWriterNode;
import com.facebook.presto.sql.planner.plan.TopNNode;
import com.facebook.presto.sql.planner.plan.TopNRowNumberNode;
import com.facebook.presto.sql.planner.plan.UnionNode;
import com.facebook.presto.sql.planner.plan.UnnestNode;
import com.facebook.presto.sql.planner.plan.ValuesNode;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.facebook.presto.sql.relational.ConstantExpression;
import com.facebook.presto.sql.relational.InputReferenceExpression;
import com.facebook.presto.sql.relational.RowExpression;
import com.facebook.presto.sql.relational.SqlToRowExpressionTranslator;
import com.facebook.presto.sql.tree.BooleanLiteral;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.ExpressionRewriter;
import com.facebook.presto.sql.tree.ExpressionTreeRewriter;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.QualifiedNameReference;
import com.facebook.presto.util.ImmutableCollectors;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import com.google.common.collect.SetMultimap;
import com.google.common.primitives.Ints;
import io.airlift.log.Logger;
import io.airlift.slice.Slice;
import io.airlift.units.DataSize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;

public class LocalExecutionPlanner {
    private static final Logger log = Logger.get(LocalExecutionPlanner.class);
    private final Metadata metadata;
    private final SqlParser sqlParser;
    private final PageSourceProvider pageSourceProvider;
    private final IndexManager indexManager;
    private final NodePartitioningManager nodePartitioningManager;
    private final PageSinkManager pageSinkManager;
    private final ExchangeClientSupplier exchangeClientSupplier;
    private final ExpressionCompiler compiler;
    private final boolean interpreterEnabled;
    private final DataSize maxIndexMemorySize;
    private final IndexJoinLookupStats indexJoinLookupStats;
    private final DataSize maxPartialAggregationMemorySize;

    @Inject
    public LocalExecutionPlanner(Metadata metadata, SqlParser sqlParser, PageSourceProvider pageSourceProvider, IndexManager indexManager, NodePartitioningManager nodePartitioningManager, PageSinkManager pageSinkManager, ExchangeClientSupplier exchangeClientSupplier, ExpressionCompiler compiler, IndexJoinLookupStats indexJoinLookupStats, CompilerConfig compilerConfig, TaskManagerConfig taskManagerConfig) {
        Objects.requireNonNull(compilerConfig, "compilerConfig is null");
        this.pageSourceProvider = Objects.requireNonNull(pageSourceProvider, "pageSourceProvider is null");
        this.indexManager = Objects.requireNonNull(indexManager, "indexManager is null");
        this.nodePartitioningManager = Objects.requireNonNull(nodePartitioningManager, "nodePartitioningManager is null");
        this.exchangeClientSupplier = exchangeClientSupplier;
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
        this.pageSinkManager = Objects.requireNonNull(pageSinkManager, "pageSinkManager is null");
        this.compiler = Objects.requireNonNull(compiler, "compiler is null");
        this.indexJoinLookupStats = Objects.requireNonNull(indexJoinLookupStats, "indexJoinLookupStats is null");
        this.maxIndexMemorySize = Objects.requireNonNull(taskManagerConfig, "taskManagerConfig is null").getMaxIndexMemoryUsage();
        this.maxPartialAggregationMemorySize = taskManagerConfig.getMaxPartialAggregationMemoryUsage();
        this.interpreterEnabled = compilerConfig.isInterpreterEnabled();
    }

    public LocalExecutionPlan plan(Session session, PlanNode plan, Map<Symbol, Type> types, PartitionFunctionBinding functionBinding, SharedBuffer sharedBuffer, boolean singleNode, boolean allowLocalParallel) {
        Object partitionChannelTypes;
        Object partitionConstants;
        Object partitionChannels;
        List<Symbol> outputLayout = functionBinding.getOutputLayout();
        if (functionBinding.getPartitioningHandle().equals(SystemPartitioningHandle.FIXED_BROADCAST_DISTRIBUTION) || functionBinding.getPartitioningHandle().equals(SystemPartitioningHandle.SINGLE_DISTRIBUTION) || functionBinding.getPartitioningHandle().equals(SystemPartitioningHandle.COORDINATOR_DISTRIBUTION)) {
            return this.plan(session, plan, outputLayout, types, new TaskOutputOperator.TaskOutputFactory(sharedBuffer), singleNode, allowLocalParallel);
        }
        if (functionBinding.getHashColumn().isPresent()) {
            partitionChannels = ImmutableList.of((Object)outputLayout.indexOf(functionBinding.getHashColumn().get()));
            partitionConstants = ImmutableList.of(Optional.empty());
            partitionChannelTypes = ImmutableList.of((Object)BigintType.BIGINT);
        } else {
            partitionChannels = (List)functionBinding.getPartitionFunctionArguments().stream().map(PartitionFunctionBinding.PartitionFunctionArgumentBinding::getColumn).map(outputLayout::indexOf).collect(ImmutableCollectors.toImmutableList());
            partitionConstants = (List)functionBinding.getPartitionFunctionArguments().stream().map(argument -> {
                if (argument.isConstant()) {
                    return Optional.of(argument.getConstant());
                }
                return Optional.empty();
            }).collect(ImmutableCollectors.toImmutableList());
            partitionChannelTypes = (List)functionBinding.getPartitionFunctionArguments().stream().map(argument -> {
                if (argument.isConstant()) {
                    return argument.getConstant().getType();
                }
                return (Type)types.get(argument.getColumn());
            }).collect(ImmutableCollectors.toImmutableList());
        }
        PartitionFunction partitionFunction = this.nodePartitioningManager.getPartitionFunction(session, functionBinding, (List<Type>)partitionChannelTypes);
        OptionalInt nullChannel = OptionalInt.empty();
        if (functionBinding.isReplicateNulls()) {
            Preconditions.checkArgument((functionBinding.getPartitionFunctionArguments().size() == 1 ? 1 : 0) != 0);
            Preconditions.checkArgument((boolean)functionBinding.getPartitionFunctionArguments().get(0).isVariable());
            nullChannel = OptionalInt.of(outputLayout.indexOf(((PartitionFunctionBinding.PartitionFunctionArgumentBinding)Iterables.getOnlyElement(functionBinding.getPartitionFunctionArguments())).getColumn()));
        }
        return this.plan(session, plan, outputLayout, types, new PartitionedOutputOperator.PartitionedOutputFactory(partitionFunction, (List<Integer>)partitionChannels, (List<Optional<NullableValue>>)partitionConstants, nullChannel, sharedBuffer), singleNode, allowLocalParallel);
    }

    public LocalExecutionPlan plan(Session session, PlanNode plan, List<Symbol> outputLayout, Map<Symbol, Type> types, OutputFactory outputOperatorFactory, boolean singleNode, boolean allowLocalParallel) {
        LocalExecutionPlanContext context = new LocalExecutionPlanContext(session, types, singleNode, allowLocalParallel);
        PhysicalOperation physicalOperation = this.enforceLayout(plan.getId(), outputLayout, context, plan.accept(new Visitor(session), context));
        DriverFactory driverFactory = new DriverFactory(context.isInputDriver(), true, (List<OperatorFactory>)ImmutableList.builder().addAll((Iterable)physicalOperation.getOperatorFactories()).add((Object)outputOperatorFactory.createOutputOperator(context.getNextOperatorId(), plan.getId(), physicalOperation.getTypes())).build(), context.getDriverInstanceCount());
        context.addDriverFactory(driverFactory);
        LocalExecutionPlanner.addLookupOuterDrivers(context);
        context.getDriverFactories().stream().map(DriverFactory::getOperatorFactories).flatMap(Collection::stream).filter(LocalPlannerAware.class::isInstance).map(LocalPlannerAware.class::cast).forEach(LocalPlannerAware::localPlannerComplete);
        return new LocalExecutionPlan(context.getDriverFactories());
    }

    private static void addLookupOuterDrivers(LocalExecutionPlanContext context) {
        for (DriverFactory factory : context.getDriverFactories()) {
            List<OperatorFactory> operatorFactories = factory.getOperatorFactories();
            for (int i = 0; i < operatorFactories.size(); ++i) {
                JoinOperatorFactory lookupJoin;
                Optional<OperatorFactory> outerOperatorFactory;
                OperatorFactory operatorFactory = operatorFactories.get(i);
                if (!(operatorFactory instanceof JoinOperatorFactory) || !(outerOperatorFactory = (lookupJoin = (JoinOperatorFactory)operatorFactory).createOuterOperatorFactory()).isPresent()) continue;
                ImmutableList.Builder newOperators = ImmutableList.builder();
                newOperators.add((Object)outerOperatorFactory.get());
                operatorFactories.subList(i + 1, operatorFactories.size()).stream().map(OperatorFactory::duplicate).forEach(arg_0 -> ((ImmutableList.Builder)newOperators).add(arg_0));
                context.addDriverFactory(new DriverFactory(false, factory.isOutputDriver(), (List<OperatorFactory>)newOperators.build()));
            }
        }
    }

    private PhysicalOperation enforceLayout(PlanNodeId planNodeId, List<Symbol> outputLayout, LocalExecutionPlanContext context, PhysicalOperation physicalOperation) {
        boolean projectionMatchesOutput = physicalOperation.getLayout().entrySet().stream().sorted(Ordering.natural().onResultOf(Map.Entry::getValue)).map(Map.Entry::getKey).collect(ImmutableCollectors.toImmutableList()).equals(outputLayout);
        if (!projectionMatchesOutput) {
            IdentityProjectionInfo projectionInfo = LocalExecutionPlanner.computeIdentityProjectionInfo(outputLayout, physicalOperation.getLayout(), context.getTypes());
            List<RowExpression> projections = projectionInfo.getProjections();
            FilterAndProjectOperator.FilterAndProjectOperatorFactory operatorFactory = new FilterAndProjectOperator.FilterAndProjectOperatorFactory(context.getNextOperatorId(), planNodeId, this.compiler.compilePageProcessor(LocalExecutionPlanner.trueExpression(), projections), (List)projections.stream().map(RowExpression::getType).collect(ImmutableCollectors.toImmutableList()));
            physicalOperation = new PhysicalOperation(operatorFactory, projectionInfo.getOutputLayout(), physicalOperation);
        }
        return physicalOperation;
    }

    private static RowExpression trueExpression() {
        return new ConstantExpression(Boolean.TRUE, (Type)BooleanType.BOOLEAN);
    }

    public static List<Type> toTypes(List<ProjectionFunction> projections) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ProjectionFunction projection : projections) {
            builder.add((Object)projection.getType());
        }
        return builder.build();
    }

    private static TableFinishOperator.TableFinisher createTableFinisher(final Session session, TableFinishNode node, final Metadata metadata) {
        final TableWriterNode.WriterTarget target = node.getTarget();
        return new TableFinishOperator.TableFinisher(){

            @Override
            public void finishTable(Collection<Slice> fragments) {
                if (target instanceof TableWriterNode.CreateHandle) {
                    metadata.finishCreateTable(session, ((TableWriterNode.CreateHandle)target).getHandle(), fragments);
                } else if (target instanceof TableWriterNode.InsertHandle) {
                    metadata.finishInsert(session, ((TableWriterNode.InsertHandle)target).getHandle(), fragments);
                } else if (target instanceof TableWriterNode.DeleteHandle) {
                    metadata.finishDelete(session, ((TableWriterNode.DeleteHandle)target).getHandle(), fragments);
                } else {
                    throw new AssertionError((Object)("Unhandled target type: " + target.getClass().getName()));
                }
            }
        };
    }

    private static IdentityProjectionInfo computeIdentityProjectionInfo(List<Symbol> symbols, Map<Symbol, Integer> inputLayout, Map<Symbol, Type> types) {
        HashMap<Symbol, Integer> outputMappings = new HashMap<Symbol, Integer>();
        ArrayList<RowExpression> projections = new ArrayList<RowExpression>();
        int channel = 0;
        for (Symbol symbol : symbols) {
            Type type = types.get(symbol);
            InputReferenceExpression expression = new InputReferenceExpression(inputLayout.get(symbol), type);
            projections.add(expression);
            if (outputMappings.containsKey(symbol)) continue;
            outputMappings.put(symbol, channel);
            ++channel;
        }
        return new IdentityProjectionInfo(projections, outputMappings);
    }

    private static List<Integer> getChannelsForSymbols(List<Symbol> symbols, Map<Symbol, Integer> layout) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Symbol symbol : symbols) {
            builder.add((Object)layout.get(symbol));
        }
        return builder.build();
    }

    private static Function<Symbol, Integer> channelGetter(PhysicalOperation source) {
        return input -> {
            Preconditions.checkArgument((boolean)source.getLayout().containsKey(input));
            return source.getLayout().get(input);
        };
    }

    private static class PhysicalOperation {
        private final List<OperatorFactory> operatorFactories;
        private final Map<Symbol, Integer> layout;
        private final List<Type> types;

        public PhysicalOperation(OperatorFactory operatorFactory, Map<Symbol, Integer> layout) {
            Objects.requireNonNull(operatorFactory, "operatorFactory is null");
            Objects.requireNonNull(layout, "layout is null");
            this.operatorFactories = ImmutableList.of((Object)operatorFactory);
            this.layout = ImmutableMap.copyOf(layout);
            this.types = operatorFactory.getTypes();
        }

        public PhysicalOperation(OperatorFactory operatorFactory, Map<Symbol, Integer> layout, PhysicalOperation source) {
            Objects.requireNonNull(operatorFactory, "operatorFactory is null");
            Objects.requireNonNull(layout, "layout is null");
            Objects.requireNonNull(source, "source is null");
            this.operatorFactories = ImmutableList.builder().addAll(source.getOperatorFactories()).add((Object)operatorFactory).build();
            this.layout = ImmutableMap.copyOf(layout);
            this.types = operatorFactory.getTypes();
        }

        public int symbolToChannel(Symbol input) {
            Preconditions.checkArgument((boolean)this.layout.containsKey(input));
            return this.layout.get(input);
        }

        public List<Type> getTypes() {
            return this.types;
        }

        public Map<Symbol, Integer> getLayout() {
            return this.layout;
        }

        private List<OperatorFactory> getOperatorFactories() {
            return this.operatorFactories;
        }
    }

    private static class IdentityProjectionInfo {
        private final List<RowExpression> projections;
        private final Map<Symbol, Integer> outputLayout;

        public IdentityProjectionInfo(List<RowExpression> projections, Map<Symbol, Integer> outputLayout) {
            this.projections = Objects.requireNonNull(projections, "projections is null");
            this.outputLayout = Objects.requireNonNull(outputLayout, "outputLayout is null");
        }

        public List<RowExpression> getProjections() {
            return this.projections;
        }

        public Map<Symbol, Integer> getOutputLayout() {
            return this.outputLayout;
        }
    }

    private class Visitor
    extends PlanVisitor<LocalExecutionPlanContext, PhysicalOperation> {
        private final Session session;

        private Visitor(Session session) {
            this.session = session;
        }

        @Override
        public PhysicalOperation visitRemoteSource(RemoteSourceNode node, LocalExecutionPlanContext context) {
            List<Type> types = this.getSourceOperatorTypes(node, context.getTypes());
            ExchangeOperator.ExchangeOperatorFactory operatorFactory = new ExchangeOperator.ExchangeOperatorFactory(context.getNextOperatorId(), node.getId(), LocalExecutionPlanner.this.exchangeClientSupplier, types);
            return new PhysicalOperation(operatorFactory, (Map<Symbol, Integer>)this.makeLayout(node));
        }

        @Override
        public PhysicalOperation visitOutput(OutputNode node, LocalExecutionPlanContext context) {
            return node.getSource().accept(this, context);
        }

        @Override
        public PhysicalOperation visitRowNumber(RowNumberNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = node.getSource().accept(this, context);
            List<Symbol> partitionBySymbols = node.getPartitionBy();
            List partitionChannels = LocalExecutionPlanner.getChannelsForSymbols(partitionBySymbols, source.getLayout());
            List partitionTypes = (List)partitionChannels.stream().map(channel -> source.getTypes().get((int)channel)).collect(ImmutableCollectors.toImmutableList());
            ImmutableList.Builder outputChannels = ImmutableList.builder();
            for (int i = 0; i < source.getTypes().size(); ++i) {
                outputChannels.add((Object)i);
            }
            ImmutableMap.Builder outputMappings = ImmutableMap.builder();
            outputMappings.putAll(source.getLayout());
            int channel2 = source.getTypes().size();
            outputMappings.put((Object)node.getRowNumberSymbol(), (Object)channel2);
            Optional<Integer> hashChannel = node.getHashSymbol().map(LocalExecutionPlanner.channelGetter(source));
            RowNumberOperator.RowNumberOperatorFactory operatorFactory = new RowNumberOperator.RowNumberOperatorFactory(context.getNextOperatorId(), node.getId(), source.getTypes(), (List<Integer>)outputChannels.build(), partitionChannels, partitionTypes, node.getMaxRowCountPerPartition(), hashChannel, 10000);
            return new PhysicalOperation(operatorFactory, (Map<Symbol, Integer>)outputMappings.build(), source);
        }

        @Override
        public PhysicalOperation visitTopNRowNumber(TopNRowNumberNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = node.getSource().accept(this, context);
            List<Symbol> partitionBySymbols = node.getPartitionBy();
            List partitionChannels = LocalExecutionPlanner.getChannelsForSymbols(partitionBySymbols, source.getLayout());
            List partitionTypes = (List)partitionChannels.stream().map(channel -> source.getTypes().get((int)channel)).collect(ImmutableCollectors.toImmutableList());
            List<Symbol> orderBySymbols = node.getOrderBy();
            List sortChannels = LocalExecutionPlanner.getChannelsForSymbols(orderBySymbols, source.getLayout());
            List sortOrder = (List)orderBySymbols.stream().map(symbol -> node.getOrderings().get(symbol)).collect(ImmutableCollectors.toImmutableList());
            ImmutableList.Builder outputChannels = ImmutableList.builder();
            for (int i = 0; i < source.getTypes().size(); ++i) {
                outputChannels.add((Object)i);
            }
            ImmutableMap.Builder outputMappings = ImmutableMap.builder();
            outputMappings.putAll(source.getLayout());
            if (!node.isPartial() || !partitionChannels.isEmpty()) {
                int channel2 = source.getTypes().size();
                outputMappings.put((Object)node.getRowNumberSymbol(), (Object)channel2);
            }
            Optional<Integer> hashChannel = node.getHashSymbol().map(LocalExecutionPlanner.channelGetter(source));
            TopNRowNumberOperator.TopNRowNumberOperatorFactory operatorFactory = new TopNRowNumberOperator.TopNRowNumberOperatorFactory(context.getNextOperatorId(), node.getId(), source.getTypes(), (List<Integer>)outputChannels.build(), partitionChannels, partitionTypes, sortChannels, sortOrder, node.getMaxRowCountPerPartition(), node.isPartial(), hashChannel, 1000);
            return new PhysicalOperation(operatorFactory, (Map<Symbol, Integer>)this.makeLayout(node), source);
        }

        @Override
        public PhysicalOperation visitWindow(WindowNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = node.getSource().accept(this, context);
            List<Symbol> partitionBySymbols = node.getPartitionBy();
            List<Symbol> orderBySymbols = node.getOrderBy();
            ImmutableList partitionChannels = ImmutableList.copyOf((Collection)LocalExecutionPlanner.getChannelsForSymbols(partitionBySymbols, source.getLayout()));
            ImmutableList preGroupedChannels = ImmutableList.copyOf((Collection)LocalExecutionPlanner.getChannelsForSymbols((List)ImmutableList.copyOf(node.getPrePartitionedInputs()), source.getLayout()));
            List sortChannels = LocalExecutionPlanner.getChannelsForSymbols(orderBySymbols, source.getLayout());
            List sortOrder = (List)orderBySymbols.stream().map(symbol -> node.getOrderings().get(symbol)).collect(ImmutableCollectors.toImmutableList());
            Optional<Integer> frameStartChannel = Optional.empty();
            Optional<Integer> frameEndChannel = Optional.empty();
            WindowNode.Frame frame = node.getFrame();
            if (frame.getStartValue().isPresent()) {
                frameStartChannel = Optional.of(source.getLayout().get(frame.getStartValue().get()));
            }
            if (frame.getEndValue().isPresent()) {
                frameEndChannel = Optional.of(source.getLayout().get(frame.getEndValue().get()));
            }
            ImmutableList.Builder outputChannels = ImmutableList.builder();
            for (int i = 0; i < source.getTypes().size(); ++i) {
                outputChannels.add((Object)i);
            }
            ImmutableList.Builder windowFunctionsBuilder = ImmutableList.builder();
            ImmutableList.Builder windowFunctionOutputSymbolsBuilder = ImmutableList.builder();
            for (Map.Entry<Symbol, FunctionCall> entry : node.getWindowFunctions().entrySet()) {
                ImmutableList.Builder arguments = ImmutableList.builder();
                for (Expression expression : entry.getValue().getArguments()) {
                    Symbol argumentSymbol = Symbol.fromQualifiedName(((QualifiedNameReference)expression).getName());
                    arguments.add((Object)source.getLayout().get(argumentSymbol));
                }
                Symbol symbol2 = entry.getKey();
                Signature signature = node.getSignatures().get(symbol2);
                WindowFunctionSupplier windowFunctionSupplier = LocalExecutionPlanner.this.metadata.getFunctionRegistry().getWindowFunctionImplementation(signature);
                Type type = LocalExecutionPlanner.this.metadata.getType(signature.getReturnType());
                windowFunctionsBuilder.add((Object)WindowFunctionDefinition.window(windowFunctionSupplier, type, (List<Integer>)arguments.build()));
                windowFunctionOutputSymbolsBuilder.add((Object)symbol2);
            }
            ImmutableList windowFunctionOutputSymbols = windowFunctionOutputSymbolsBuilder.build();
            ImmutableList windowFunctions = windowFunctionsBuilder.build();
            ImmutableMap.Builder outputMappings = ImmutableMap.builder();
            for (Symbol symbol2 : node.getSource().getOutputSymbols()) {
                outputMappings.put((Object)symbol2, (Object)source.getLayout().get(symbol2));
            }
            int channel = source.getTypes().size();
            for (Symbol symbol4 : windowFunctionOutputSymbols) {
                outputMappings.put((Object)symbol4, (Object)channel);
                ++channel;
            }
            WindowOperator.WindowOperatorFactory windowOperatorFactory = new WindowOperator.WindowOperatorFactory(context.getNextOperatorId(), node.getId(), source.getTypes(), (List<Integer>)outputChannels.build(), (List<WindowFunctionDefinition>)windowFunctions, (List<Integer>)partitionChannels, (List<Integer>)preGroupedChannels, sortChannels, sortOrder, node.getPreSortedOrderPrefix(), new FrameInfo(frame.getType(), frame.getStartType(), frameStartChannel, frame.getEndType(), frameEndChannel), 10000);
            return new PhysicalOperation(windowOperatorFactory, (Map<Symbol, Integer>)outputMappings.build(), source);
        }

        @Override
        public PhysicalOperation visitTopN(TopNNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = node.getSource().accept(this, context);
            List<Symbol> orderBySymbols = node.getOrderBy();
            ArrayList<Integer> sortChannels = new ArrayList<Integer>();
            ArrayList<SortOrder> sortOrders = new ArrayList<SortOrder>();
            for (Symbol symbol : orderBySymbols) {
                sortChannels.add(source.getLayout().get(symbol));
                sortOrders.add(node.getOrderings().get(symbol));
            }
            TopNOperator.TopNOperatorFactory operator = new TopNOperator.TopNOperatorFactory(context.getNextOperatorId(), node.getId(), source.getTypes(), (int)node.getCount(), sortChannels, sortOrders, node.isPartial());
            return new PhysicalOperation(operator, source.getLayout(), source);
        }

        @Override
        public PhysicalOperation visitSort(SortNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = node.getSource().accept(this, context);
            List<Symbol> orderBySymbols = node.getOrderBy();
            List orderByChannels = LocalExecutionPlanner.getChannelsForSymbols(orderBySymbols, source.getLayout());
            ImmutableList.Builder sortOrder = ImmutableList.builder();
            for (Symbol symbol : orderBySymbols) {
                sortOrder.add((Object)node.getOrderings().get(symbol));
            }
            ImmutableList.Builder outputChannels = ImmutableList.builder();
            for (int i = 0; i < source.getTypes().size(); ++i) {
                outputChannels.add((Object)i);
            }
            OrderByOperator.OrderByOperatorFactory operator = new OrderByOperator.OrderByOperatorFactory(context.getNextOperatorId(), node.getId(), source.getTypes(), (List<Integer>)outputChannels.build(), 10000, orderByChannels, (List<SortOrder>)sortOrder.build());
            return new PhysicalOperation(operator, source.getLayout(), source);
        }

        @Override
        public PhysicalOperation visitLimit(LimitNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = node.getSource().accept(this, context);
            LimitOperator.LimitOperatorFactory operatorFactory = new LimitOperator.LimitOperatorFactory(context.getNextOperatorId(), node.getId(), source.getTypes(), node.getCount());
            return new PhysicalOperation(operatorFactory, source.getLayout(), source);
        }

        @Override
        public PhysicalOperation visitDistinctLimit(DistinctLimitNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = node.getSource().accept(this, context);
            Optional<Integer> hashChannel = node.getHashSymbol().map(LocalExecutionPlanner.channelGetter(source));
            List distinctChannels = LocalExecutionPlanner.getChannelsForSymbols(node.getDistinctSymbols(), source.getLayout());
            DistinctLimitOperator.DistinctLimitOperatorFactory operatorFactory = new DistinctLimitOperator.DistinctLimitOperatorFactory(context.getNextOperatorId(), node.getId(), source.getTypes(), distinctChannels, node.getLimit(), hashChannel);
            return new PhysicalOperation(operatorFactory, source.getLayout(), source);
        }

        @Override
        public PhysicalOperation visitGroupId(GroupIdNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = node.getSource().accept(this, context);
            int groupIdChannel = source.getLayout().values().stream().mapToInt(Integer::intValue).max().orElse(-1) + 1;
            ImmutableMap newLayout = ImmutableMap.builder().putAll(source.getLayout()).put((Object)node.getGroupIdSymbol(), (Object)groupIdChannel).build();
            List groupingSetChannels = (List)node.getGroupingSets().stream().map(groupingSet -> LocalExecutionPlanner.getChannelsForSymbols(groupingSet, source.getLayout())).collect(ImmutableCollectors.toImmutableList());
            GroupIdOperator.GroupIdOperatorFactory groupIdOperatorFactory = new GroupIdOperator.GroupIdOperatorFactory(context.getNextOperatorId(), node.getId(), source.getTypes(), groupingSetChannels);
            return new PhysicalOperation(groupIdOperatorFactory, (Map<Symbol, Integer>)newLayout, source);
        }

        @Override
        public PhysicalOperation visitAggregation(AggregationNode node, LocalExecutionPlanContext context) {
            if (node.getGroupBy().isEmpty()) {
                PhysicalOperation source = node.getSource().accept(this, context);
                return this.planGlobalAggregation(context.getNextOperatorId(), node, source);
            }
            if (this.needsLocalGather(node)) {
                LocalExecutionPlanContext intermediateContext = context.createSubContext();
                intermediateContext.setInputDriver(context.isInputDriver());
                PhysicalOperation source = node.getSource().accept(this, intermediateContext);
                InMemoryExchange exchange = new InMemoryExchange(source.getTypes());
                ImmutableList factories = ImmutableList.builder().addAll((Iterable)source.getOperatorFactories()).add((Object)exchange.createSinkFactory(intermediateContext.getNextOperatorId(), node.getId())).build();
                context.addDriverFactory(new DriverFactory(intermediateContext.isInputDriver(), false, (List<OperatorFactory>)factories));
                InMemoryExchangeSourceOperator.InMemoryExchangeSourceOperatorFactory exchangeSource = InMemoryExchangeSourceOperator.InMemoryExchangeSourceOperatorFactory.createRandomDistribution(context.getNextOperatorId(), node.getId(), exchange);
                source = new PhysicalOperation(exchangeSource, source.getLayout());
                return this.planGroupByAggregation(node, source, context.getNextOperatorId(), Optional.empty());
            }
            int aggregationConcurrency = SystemSessionProperties.getTaskAggregationConcurrency(this.session);
            if (node.getStep() == AggregationNode.Step.PARTIAL || !context.isAllowLocalParallel() || context.getDriverInstanceCount() > 1 || aggregationConcurrency <= 1) {
                PhysicalOperation source = node.getSource().accept(this, context);
                return this.planGroupByAggregation(node, source, context.getNextOperatorId(), Optional.empty());
            }
            LocalExecutionPlanContext parallelContext = context.createSubContext();
            parallelContext.setDriverInstanceCount(aggregationConcurrency);
            LocalExecutionPlanContext sourceContext = parallelContext.createSubContext();
            parallelContext.setInputDriver(false);
            PhysicalOperation source = node.getSource().accept(this, sourceContext);
            InMemoryExchange exchange = new InMemoryExchange(source.getTypes(), aggregationConcurrency);
            ImmutableList factories = ImmutableList.builder().addAll((Iterable)source.getOperatorFactories()).add((Object)exchange.createSinkFactory(sourceContext.getNextOperatorId(), node.getId())).build();
            parallelContext.addDriverFactory(new DriverFactory(sourceContext.isInputDriver(), false, (List<OperatorFactory>)factories));
            InMemoryExchangeSourceOperator.InMemoryExchangeSourceOperatorFactory exchangeSource = InMemoryExchangeSourceOperator.InMemoryExchangeSourceOperatorFactory.createBroadcastDistribution(parallelContext.getNextOperatorId(), node.getId(), exchange);
            source = new PhysicalOperation(exchangeSource, source.getLayout());
            HashPartitionMaskOperator.HashPartitionMaskOperatorFactory hashPartitionMask = new HashPartitionMaskOperator.HashPartitionMaskOperatorFactory(parallelContext.getNextOperatorId(), node.getId(), aggregationConcurrency, exchangeSource.getTypes(), LocalExecutionPlanner.getChannelsForSymbols((List)ImmutableList.copyOf(node.getMasks().values()), source.getLayout()), LocalExecutionPlanner.getChannelsForSymbols((List)ImmutableList.copyOf(node.getGroupBy()), source.getLayout()), node.getHashSymbol().map(LocalExecutionPlanner.channelGetter(source)));
            int defaultMaskChannel = hashPartitionMask.getDefaultMaskChannel();
            source = new PhysicalOperation(hashPartitionMask, source.getLayout(), source);
            PhysicalOperation operation = this.planGroupByAggregation(node, source, parallelContext.getNextOperatorId(), Optional.of(defaultMaskChannel));
            operation = this.addInMemoryExchange(context, node.getId(), operation, parallelContext);
            return operation;
        }

        private boolean needsLocalGather(AggregationNode node) {
            if (node.getStep() == AggregationNode.Step.INTERMEDIATE) {
                return true;
            }
            if (node.getStep() != AggregationNode.Step.FINAL || node.getSources().size() != 1) {
                return false;
            }
            PlanNode source = node.getSources().get(0);
            return source instanceof AggregationNode && ((AggregationNode)source).getStep() == AggregationNode.Step.PARTIAL;
        }

        @Override
        public PhysicalOperation visitMarkDistinct(MarkDistinctNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = node.getSource().accept(this, context);
            List channels = LocalExecutionPlanner.getChannelsForSymbols(node.getDistinctSymbols(), source.getLayout());
            Optional<Integer> hashChannel = node.getHashSymbol().map(LocalExecutionPlanner.channelGetter(source));
            MarkDistinctOperator.MarkDistinctOperatorFactory operator = new MarkDistinctOperator.MarkDistinctOperatorFactory(context.getNextOperatorId(), node.getId(), source.getTypes(), channels, hashChannel);
            return new PhysicalOperation(operator, (Map<Symbol, Integer>)this.makeLayout(node), source);
        }

        @Override
        public PhysicalOperation visitSample(SampleNode node, LocalExecutionPlanContext context) {
            if (node.getSampleType() == SampleNode.Type.SYSTEM) {
                return node.getSource().accept(this, context);
            }
            if (node.getSampleType() == SampleNode.Type.POISSONIZED) {
                PhysicalOperation source = node.getSource().accept(this, context);
                SampleOperator.SampleOperatorFactory operatorFactory = new SampleOperator.SampleOperatorFactory(context.getNextOperatorId(), node.getId(), node.getSampleRatio(), node.isRescaled(), source.getTypes());
                Preconditions.checkState((boolean)node.getSampleWeightSymbol().isPresent(), (Object)"sample weight symbol missing");
                return new PhysicalOperation(operatorFactory, (Map<Symbol, Integer>)this.makeLayout(node), source);
            }
            throw new UnsupportedOperationException("not yet implemented: " + node);
        }

        @Override
        public PhysicalOperation visitFilter(FilterNode node, LocalExecutionPlanContext context) {
            PlanNode sourceNode = node.getSource();
            Expression filterExpression = node.getPredicate();
            List<Symbol> outputSymbols = node.getOutputSymbols();
            Map<Symbol, Expression> projectionExpressions = outputSymbols.stream().collect(Collectors.toMap(x -> x, Symbol::toQualifiedNameReference));
            return this.visitScanFilterAndProject(context, node.getId(), sourceNode, filterExpression, projectionExpressions, outputSymbols);
        }

        @Override
        public PhysicalOperation visitProject(ProjectNode node, LocalExecutionPlanContext context) {
            BooleanLiteral filterExpression;
            PlanNode sourceNode;
            if (node.getSource() instanceof FilterNode) {
                FilterNode filterNode = (FilterNode)node.getSource();
                sourceNode = filterNode.getSource();
                filterExpression = filterNode.getPredicate();
            } else {
                sourceNode = node.getSource();
                filterExpression = BooleanLiteral.TRUE_LITERAL;
            }
            List<Symbol> outputSymbols = node.getOutputSymbols();
            return this.visitScanFilterAndProject(context, node.getId(), sourceNode, (Expression)filterExpression, node.getAssignments(), outputSymbols);
        }

        private PhysicalOperation visitScanFilterAndProject(LocalExecutionPlanContext context, PlanNodeId planNodeId, PlanNode sourceNode, Expression filterExpression, Map<Symbol, Expression> projectionExpressions, List<Symbol> outputSymbols) {
            LinkedHashMap<Integer, Type> sourceTypes;
            LinkedHashMap<Symbol, Integer> sourceLayout;
            ArrayList<ColumnHandle> columns = null;
            PhysicalOperation source = null;
            if (sourceNode instanceof TableScanNode) {
                TableScanNode tableScanNode = (TableScanNode)sourceNode;
                sourceLayout = new LinkedHashMap();
                sourceTypes = new LinkedHashMap();
                columns = new ArrayList<ColumnHandle>();
                int channel = 0;
                for (Symbol symbol : tableScanNode.getOutputSymbols()) {
                    columns.add(tableScanNode.getAssignments().get(symbol));
                    Integer input = channel;
                    sourceLayout.put(symbol, input);
                    Type type = Objects.requireNonNull(context.getTypes().get(symbol), String.format("No type for symbol %s", symbol));
                    sourceTypes.put(input, type);
                    ++channel;
                }
            } else {
                source = sourceNode.accept(this, context);
                sourceLayout = source.getLayout();
                sourceTypes = this.getInputTypes(source.getLayout(), source.getTypes());
            }
            ImmutableMap.Builder outputMappingsBuilder = ImmutableMap.builder();
            for (int i = 0; i < outputSymbols.size(); ++i) {
                Symbol symbol = outputSymbols.get(i);
                outputMappingsBuilder.put((Object)symbol, (Object)i);
            }
            ImmutableMap outputMappings = outputMappingsBuilder.build();
            SymbolToInputRewriter symbolToInputRewriter = new SymbolToInputRewriter(sourceLayout);
            Expression rewrittenFilter = ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)symbolToInputRewriter, (Expression)filterExpression);
            ArrayList<Expression> rewrittenProjections = new ArrayList<Expression>();
            for (Symbol symbol : outputSymbols) {
                rewrittenProjections.add(ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)symbolToInputRewriter, (Expression)projectionExpressions.get(symbol)));
            }
            IdentityHashMap<Expression, Type> expressionTypes = ExpressionAnalyzer.getExpressionTypesFromInput(context.getSession(), LocalExecutionPlanner.this.metadata, LocalExecutionPlanner.this.sqlParser, sourceTypes, Iterables.concat(Collections.singleton(rewrittenFilter), rewrittenProjections));
            RowExpression translatedFilter = this.toRowExpression(rewrittenFilter, expressionTypes);
            List translatedProjections = (List)rewrittenProjections.stream().map(expression -> this.toRowExpression((Expression)expression, expressionTypes)).collect(ImmutableCollectors.toImmutableList());
            try {
                if (columns != null) {
                    CursorProcessor cursorProcessor = LocalExecutionPlanner.this.compiler.compileCursorProcessor(translatedFilter, translatedProjections, sourceNode.getId());
                    Supplier<PageProcessor> pageProcessor = LocalExecutionPlanner.this.compiler.compilePageProcessor(translatedFilter, translatedProjections);
                    ScanFilterAndProjectOperator.ScanFilterAndProjectOperatorFactory operatorFactory = new ScanFilterAndProjectOperator.ScanFilterAndProjectOperatorFactory(context.getNextOperatorId(), planNodeId, sourceNode.getId(), LocalExecutionPlanner.this.pageSourceProvider, cursorProcessor, pageProcessor, columns, Lists.transform(rewrittenProjections, (com.google.common.base.Function)Functions.forMap(expressionTypes)));
                    return new PhysicalOperation(operatorFactory, (Map<Symbol, Integer>)outputMappings);
                }
                Supplier<PageProcessor> processor = LocalExecutionPlanner.this.compiler.compilePageProcessor(translatedFilter, translatedProjections);
                FilterAndProjectOperator.FilterAndProjectOperatorFactory operatorFactory = new FilterAndProjectOperator.FilterAndProjectOperatorFactory(context.getNextOperatorId(), planNodeId, processor, Lists.transform(rewrittenProjections, (com.google.common.base.Function)Functions.forMap(expressionTypes)));
                return new PhysicalOperation(operatorFactory, (Map<Symbol, Integer>)outputMappings, source);
            }
            catch (RuntimeException e) {
                Object operatorFactory;
                if (!LocalExecutionPlanner.this.interpreterEnabled) {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.COMPILER_ERROR, "Compiler failed and interpreter is disabled", (Throwable)e);
                }
                log.error((Throwable)e, "Compile failed for filter=%s projections=%s sourceTypes=%s error=%s", new Object[]{filterExpression, projectionExpressions, sourceTypes, e});
                FilterFunction filterFunction = filterExpression != BooleanLiteral.TRUE_LITERAL ? new InterpretedFilterFunction(filterExpression, context.getTypes(), sourceLayout, LocalExecutionPlanner.this.metadata, LocalExecutionPlanner.this.sqlParser, context.getSession()) : FilterFunctions.TRUE_FUNCTION;
                ArrayList<ProjectionFunction> projectionFunctions = new ArrayList<ProjectionFunction>();
                for (Symbol symbol : outputSymbols) {
                    ProjectionFunction function;
                    Expression expression2 = projectionExpressions.get(symbol);
                    if (expression2 instanceof QualifiedNameReference) {
                        Symbol reference = Symbol.fromQualifiedName(((QualifiedNameReference)expression2).getName());
                        function = ProjectionFunctions.singleColumn(context.getTypes().get(reference), (Integer)sourceLayout.get(reference));
                    } else {
                        function = new InterpretedProjectionFunction(expression2, context.getTypes(), sourceLayout, LocalExecutionPlanner.this.metadata, LocalExecutionPlanner.this.sqlParser, context.getSession());
                    }
                    projectionFunctions.add(function);
                }
                if (columns != null) {
                    operatorFactory = new ScanFilterAndProjectOperator.ScanFilterAndProjectOperatorFactory(context.getNextOperatorId(), planNodeId, sourceNode.getId(), LocalExecutionPlanner.this.pageSourceProvider, new GenericCursorProcessor(filterFunction, projectionFunctions), () -> new GenericPageProcessor(filterFunction, projectionFunctions), columns, LocalExecutionPlanner.toTypes(projectionFunctions));
                    return new PhysicalOperation((OperatorFactory)operatorFactory, (Map<Symbol, Integer>)outputMappings);
                }
                operatorFactory = new FilterAndProjectOperator.FilterAndProjectOperatorFactory(context.getNextOperatorId(), planNodeId, () -> new GenericPageProcessor(filterFunction, projectionFunctions), LocalExecutionPlanner.toTypes(projectionFunctions));
                return new PhysicalOperation((OperatorFactory)operatorFactory, (Map<Symbol, Integer>)outputMappings, source);
            }
        }

        private RowExpression toRowExpression(Expression expression, IdentityHashMap<Expression, Type> types) {
            return SqlToRowExpressionTranslator.translate(expression, FunctionKind.SCALAR, types, LocalExecutionPlanner.this.metadata.getFunctionRegistry(), LocalExecutionPlanner.this.metadata.getTypeManager(), this.session, true);
        }

        private Map<Integer, Type> getInputTypes(Map<Symbol, Integer> layout, List<Type> types) {
            ImmutableMap.Builder inputTypes = ImmutableMap.builder();
            for (Integer input : ImmutableSet.copyOf(layout.values())) {
                Type type = types.get(input);
                inputTypes.put((Object)input, (Object)type);
            }
            return inputTypes.build();
        }

        @Override
        public PhysicalOperation visitTableScan(TableScanNode node, LocalExecutionPlanContext context) {
            ArrayList<ColumnHandle> columns = new ArrayList<ColumnHandle>();
            for (Symbol symbol : node.getOutputSymbols()) {
                columns.add(node.getAssignments().get(symbol));
            }
            List<Type> types = this.getSourceOperatorTypes(node, context.getTypes());
            TableScanOperator.TableScanOperatorFactory operatorFactory = new TableScanOperator.TableScanOperatorFactory(context.getNextOperatorId(), node.getId(), LocalExecutionPlanner.this.pageSourceProvider, types, columns);
            return new PhysicalOperation(operatorFactory, (Map<Symbol, Integer>)this.makeLayout(node));
        }

        @Override
        public PhysicalOperation visitValues(ValuesNode node, LocalExecutionPlanContext context) {
            ArrayList<Type> outputTypes = new ArrayList<Type>();
            for (Symbol symbol : node.getOutputSymbols()) {
                Type type = Objects.requireNonNull(context.getTypes().get(symbol), String.format("No type for symbol %s", symbol));
                outputTypes.add(type);
            }
            if (node.getRows().isEmpty()) {
                ValuesOperator.ValuesOperatorFactory operatorFactory = new ValuesOperator.ValuesOperatorFactory(context.getNextOperatorId(), node.getId(), outputTypes, (List<Page>)ImmutableList.of());
                return new PhysicalOperation(operatorFactory, (Map<Symbol, Integer>)this.makeLayout(node));
            }
            PageBuilder pageBuilder = new PageBuilder(outputTypes);
            for (List<Expression> list : node.getRows()) {
                pageBuilder.declarePosition();
                IdentityHashMap<Expression, Type> expressionTypes = ExpressionAnalyzer.getExpressionTypes(context.getSession(), LocalExecutionPlanner.this.metadata, LocalExecutionPlanner.this.sqlParser, (Map<Symbol, Type>)ImmutableMap.of(), (Iterable<? extends Expression>)ImmutableList.copyOf(list));
                for (int i = 0; i < list.size(); ++i) {
                    Object result = ExpressionInterpreter.expressionInterpreter(list.get(i), LocalExecutionPlanner.this.metadata, context.getSession(), expressionTypes).evaluate(0, new Block[0]);
                    TypeUtils.writeNativeValue((Type)((Type)outputTypes.get(i)), (BlockBuilder)pageBuilder.getBlockBuilder(i), (Object)result);
                }
            }
            ValuesOperator.ValuesOperatorFactory valuesOperatorFactory = new ValuesOperator.ValuesOperatorFactory(context.getNextOperatorId(), node.getId(), outputTypes, (List<Page>)ImmutableList.of((Object)pageBuilder.build()));
            return new PhysicalOperation(valuesOperatorFactory, (Map<Symbol, Integer>)this.makeLayout(node));
        }

        @Override
        public PhysicalOperation visitUnnest(UnnestNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = node.getSource().accept(this, context);
            ImmutableList.Builder replicateTypes = ImmutableList.builder();
            for (Symbol symbol : node.getReplicateSymbols()) {
                replicateTypes.add((Object)context.getTypes().get(symbol));
            }
            ImmutableList unnestSymbols = ImmutableList.copyOf(node.getUnnestSymbols().keySet());
            ImmutableList.Builder unnestTypes = ImmutableList.builder();
            for (Symbol symbol : unnestSymbols) {
                unnestTypes.add((Object)context.getTypes().get(symbol));
            }
            Optional<Symbol> ordinalitySymbol = node.getOrdinalitySymbol();
            Optional<Type> ordinalityType = ordinalitySymbol.map(context.getTypes()::get);
            ordinalityType.ifPresent(type -> Preconditions.checkState((boolean)type.equals(BigintType.BIGINT), (Object)"Type of ordinalitySymbol must always be BIGINT."));
            List replicateChannels = LocalExecutionPlanner.getChannelsForSymbols(node.getReplicateSymbols(), source.getLayout());
            List unnestChannels = LocalExecutionPlanner.getChannelsForSymbols((List)unnestSymbols, source.getLayout());
            ImmutableMap.Builder outputMappings = ImmutableMap.builder();
            int channel = 0;
            for (Symbol symbol : node.getReplicateSymbols()) {
                outputMappings.put((Object)symbol, (Object)channel);
                ++channel;
            }
            for (Symbol symbol : unnestSymbols) {
                for (Symbol unnestedSymbol : node.getUnnestSymbols().get(symbol)) {
                    outputMappings.put((Object)unnestedSymbol, (Object)channel);
                    ++channel;
                }
            }
            if (ordinalitySymbol.isPresent()) {
                outputMappings.put((Object)ordinalitySymbol.get(), (Object)channel);
                ++channel;
            }
            UnnestOperator.UnnestOperatorFactory operatorFactory = new UnnestOperator.UnnestOperatorFactory(context.getNextOperatorId(), node.getId(), replicateChannels, (List<Type>)replicateTypes.build(), unnestChannels, (List<Type>)unnestTypes.build(), ordinalityType.isPresent());
            return new PhysicalOperation(operatorFactory, (Map<Symbol, Integer>)outputMappings.build(), source);
        }

        private ImmutableMap<Symbol, Integer> makeLayout(PlanNode node) {
            ImmutableMap.Builder outputMappings = ImmutableMap.builder();
            int channel = 0;
            for (Symbol symbol : node.getOutputSymbols()) {
                outputMappings.put((Object)symbol, (Object)channel);
                ++channel;
            }
            return outputMappings.build();
        }

        @Override
        public PhysicalOperation visitIndexSource(IndexSourceNode node, LocalExecutionPlanContext context) {
            Preconditions.checkState((boolean)context.getIndexSourceContext().isPresent(), (Object)"Must be in an index source context");
            IndexSourceContext indexSourceContext = context.getIndexSourceContext().get();
            SetMultimap indexLookupToProbeInput = indexSourceContext.getIndexLookupToProbeInput();
            Preconditions.checkState((boolean)indexLookupToProbeInput.keySet().equals(node.getLookupSymbols()));
            ImmutableList lookupSymbolSchema = ImmutableList.copyOf(node.getLookupSymbols());
            ImmutableList.Builder remappedProbeKeyChannelsBuilder = ImmutableList.builder();
            ImmutableList.Builder overlappingFieldSetsBuilder = ImmutableList.builder();
            for (Symbol lookupSymbol : lookupSymbolSchema) {
                Set potentialProbeInputs = indexLookupToProbeInput.get((Object)lookupSymbol);
                Preconditions.checkState((!potentialProbeInputs.isEmpty() ? 1 : 0) != 0, (Object)"Must have at least one source from the probe input");
                if (potentialProbeInputs.size() > 1) {
                    overlappingFieldSetsBuilder.add(potentialProbeInputs.stream().collect(ImmutableCollectors.toImmutableSet()));
                }
                remappedProbeKeyChannelsBuilder.add(Iterables.getFirst((Iterable)potentialProbeInputs, null));
            }
            ImmutableList overlappingFieldSets = overlappingFieldSetsBuilder.build();
            ImmutableList remappedProbeKeyChannels = remappedProbeKeyChannelsBuilder.build();
            Function<RecordSet, RecordSet> probeKeyNormalizer = arg_0 -> this.lambda$visitIndexSource$312((List)overlappingFieldSets, (List)remappedProbeKeyChannels, arg_0);
            List lookupSchema = Lists.transform((List)lookupSymbolSchema, (com.google.common.base.Function)Functions.forMap(node.getAssignments()));
            List outputSchema = Lists.transform(node.getOutputSymbols(), (com.google.common.base.Function)Functions.forMap(node.getAssignments()));
            ConnectorIndex index = LocalExecutionPlanner.this.indexManager.getIndex(this.session, node.getIndexHandle(), lookupSchema, outputSchema);
            List<Type> types = this.getSourceOperatorTypes(node, context.getTypes());
            IndexSourceOperator.IndexSourceOperatorFactory operatorFactory = new IndexSourceOperator.IndexSourceOperatorFactory(context.getNextOperatorId(), node.getId(), index, types, probeKeyNormalizer);
            return new PhysicalOperation(operatorFactory, (Map<Symbol, Integer>)this.makeLayout(node));
        }

        private SetMultimap<Symbol, Integer> mapIndexSourceLookupSymbolToProbeKeyInput(IndexJoinNode node, Map<Symbol, Integer> probeKeyLayout) {
            Set indexJoinSymbols = (Set)node.getCriteria().stream().map(IndexJoinNode.EquiJoinClause::getIndex).collect(ImmutableCollectors.toImmutableSet());
            Map<Symbol, Symbol> indexKeyTrace = IndexJoinOptimizer.IndexKeyTracer.trace(node.getIndexSource(), indexJoinSymbols);
            HashMultimap indexToProbeKeyInput = HashMultimap.create();
            for (IndexJoinNode.EquiJoinClause clause : node.getCriteria()) {
                indexToProbeKeyInput.put((Object)clause.getIndex(), (Object)probeKeyLayout.get(clause.getProbe()));
            }
            ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
            for (Map.Entry<Symbol, Symbol> entry : indexKeyTrace.entrySet()) {
                Symbol indexJoinSymbol = entry.getKey();
                Symbol indexLookupSymbol = entry.getValue();
                builder.putAll((Object)indexLookupSymbol, (Iterable)indexToProbeKeyInput.get((Object)indexJoinSymbol));
            }
            return builder.build();
        }

        @Override
        public PhysicalOperation visitIndexJoin(IndexJoinNode node, LocalExecutionPlanContext context) {
            OperatorFactory lookupJoinOperatorFactory;
            List<IndexJoinNode.EquiJoinClause> clauses = node.getCriteria();
            List probeSymbols = Lists.transform(clauses, IndexJoinNode.EquiJoinClause::getProbe);
            List indexSymbols = Lists.transform(clauses, IndexJoinNode.EquiJoinClause::getIndex);
            PhysicalOperation probeSource = node.getProbeSource().accept(this, context);
            List probeChannels = LocalExecutionPlanner.getChannelsForSymbols(probeSymbols, probeSource.getLayout());
            Optional<Integer> probeHashChannel = node.getProbeHashSymbol().map(LocalExecutionPlanner.channelGetter(probeSource));
            HashMap<Symbol, Integer> probeKeyLayout = new HashMap<Symbol, Integer>();
            for (int i = 0; i < probeSymbols.size(); ++i) {
                probeKeyLayout.put((Symbol)probeSymbols.get(i), i);
            }
            SetMultimap<Symbol, Integer> indexLookupToProbeInput = this.mapIndexSourceLookupSymbolToProbeKeyInput(node, probeKeyLayout);
            LocalExecutionPlanContext indexContext = context.createIndexSourceSubContext(new IndexSourceContext(indexLookupToProbeInput));
            PhysicalOperation indexSource = node.getIndexSource().accept(this, indexContext);
            List indexOutputChannels = LocalExecutionPlanner.getChannelsForSymbols(indexSymbols, indexSource.getLayout());
            Optional<Integer> indexHashChannel = node.getIndexHashSymbol().map(LocalExecutionPlanner.channelGetter(indexSource));
            Set<Symbol> indexSymbolsNeededBySource = IndexJoinOptimizer.IndexKeyTracer.trace(node.getIndexSource(), (Set<Symbol>)ImmutableSet.copyOf((Collection)indexSymbols)).keySet();
            Set lookupSourceInputChannels = (Set)node.getCriteria().stream().filter(equiJoinClause -> indexSymbolsNeededBySource.contains(equiJoinClause.getIndex())).map(IndexJoinNode.EquiJoinClause::getProbe).map(probeKeyLayout::get).collect(ImmutableCollectors.toImmutableSet());
            Optional<DynamicTupleFilterFactory> dynamicTupleFilterFactory = Optional.empty();
            if (lookupSourceInputChannels.size() < probeKeyLayout.values().size()) {
                int[] nonLookupInputChannels = Ints.toArray((Collection)((Collection)node.getCriteria().stream().filter(equiJoinClause -> !indexSymbolsNeededBySource.contains(equiJoinClause.getIndex())).map(IndexJoinNode.EquiJoinClause::getProbe).map(probeKeyLayout::get).collect(ImmutableCollectors.toImmutableList())));
                int[] nonLookupOutputChannels = Ints.toArray((Collection)((Collection)node.getCriteria().stream().filter(equiJoinClause -> !indexSymbolsNeededBySource.contains(equiJoinClause.getIndex())).map(IndexJoinNode.EquiJoinClause::getIndex).map(indexSource.getLayout()::get).collect(ImmutableCollectors.toImmutableList())));
                int filterOperatorId = indexContext.getNextOperatorId();
                dynamicTupleFilterFactory = Optional.of(new DynamicTupleFilterFactory(filterOperatorId, node.getId(), nonLookupInputChannels, nonLookupOutputChannels, indexSource.getTypes()));
            }
            IndexBuildDriverFactoryProvider indexBuildDriverFactoryProvider = new IndexBuildDriverFactoryProvider(indexContext.getNextOperatorId(), node.getId(), indexContext.isInputDriver(), indexSource.getOperatorFactories(), dynamicTupleFilterFactory);
            IndexLookupSourceSupplier indexLookupSourceSupplier = new IndexLookupSourceSupplier(lookupSourceInputChannels, indexOutputChannels, indexHashChannel, indexSource.getTypes(), indexBuildDriverFactoryProvider, LocalExecutionPlanner.this.maxIndexMemorySize, LocalExecutionPlanner.this.indexJoinLookupStats, SystemSessionProperties.isShareIndexLoading(this.session));
            ImmutableMap.Builder outputMappings = ImmutableMap.builder();
            outputMappings.putAll(probeSource.getLayout());
            int offset = probeSource.getTypes().size();
            for (Map.Entry<Symbol, Integer> entry : indexSource.getLayout().entrySet()) {
                Integer input = entry.getValue();
                outputMappings.put((Object)entry.getKey(), (Object)(offset + input));
            }
            switch (node.getType()) {
                case INNER: {
                    lookupJoinOperatorFactory = LookupJoinOperators.innerJoin(context.getNextOperatorId(), node.getId(), indexLookupSourceSupplier, probeSource.getTypes(), probeChannels, probeHashChannel);
                    break;
                }
                case SOURCE_OUTER: {
                    lookupJoinOperatorFactory = LookupJoinOperators.probeOuterJoin(context.getNextOperatorId(), node.getId(), indexLookupSourceSupplier, probeSource.getTypes(), probeChannels, probeHashChannel);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unknown type: " + (Object)((Object)node.getType())));
                }
            }
            return new PhysicalOperation(lookupJoinOperatorFactory, (Map<Symbol, Integer>)outputMappings.build(), probeSource);
        }

        @Override
        public PhysicalOperation visitJoin(JoinNode node, LocalExecutionPlanContext context) {
            List<JoinNode.EquiJoinClause> clauses = node.getCriteria();
            if (clauses.isEmpty()) {
                return this.createNestedLoopJoin(node, context);
            }
            List leftSymbols = Lists.transform(clauses, JoinNode.EquiJoinClause::getLeft);
            List rightSymbols = Lists.transform(clauses, JoinNode.EquiJoinClause::getRight);
            switch (node.getType()) {
                case INNER: 
                case LEFT: 
                case RIGHT: 
                case FULL: {
                    return this.createLookupJoin(node, node.getLeft(), leftSymbols, node.getLeftHashSymbol(), node.getRight(), rightSymbols, node.getRightHashSymbol(), context);
                }
            }
            throw new UnsupportedOperationException("Unsupported join type: " + (Object)((Object)node.getType()));
        }

        private PhysicalOperation createNestedLoopJoin(JoinNode node, LocalExecutionPlanContext context) {
            PhysicalOperation probeSource = node.getLeft().accept(this, context);
            LocalExecutionPlanContext buildContext = context.createSubContext();
            PhysicalOperation buildSource = node.getRight().accept(this, buildContext);
            NestedLoopBuildOperator.NestedLoopBuildOperatorFactory nestedLoopBuildOperatorFactory = new NestedLoopBuildOperator.NestedLoopBuildOperatorFactory(buildContext.getNextOperatorId(), node.getId(), buildSource.getTypes());
            context.addDriverFactory(new DriverFactory(buildContext.isInputDriver(), false, (List<OperatorFactory>)ImmutableList.builder().addAll((Iterable)buildSource.getOperatorFactories()).add((Object)nestedLoopBuildOperatorFactory).build()));
            NestedLoopJoinPagesSupplier nestedLoopJoinPagesSupplier = nestedLoopBuildOperatorFactory.getNestedLoopJoinPagesSupplier();
            ImmutableMap.Builder outputMappings = ImmutableMap.builder();
            outputMappings.putAll(probeSource.getLayout());
            int offset = probeSource.getTypes().size();
            for (Map.Entry<Symbol, Integer> entry : buildSource.getLayout().entrySet()) {
                outputMappings.put((Object)entry.getKey(), (Object)(offset + entry.getValue()));
            }
            NestedLoopJoinOperator.NestedLoopJoinOperatorFactory operatorFactory = new NestedLoopJoinOperator.NestedLoopJoinOperatorFactory(context.getNextOperatorId(), node.getId(), nestedLoopJoinPagesSupplier, probeSource.getTypes());
            PhysicalOperation operation = new PhysicalOperation(operatorFactory, (Map<Symbol, Integer>)outputMappings.build(), probeSource);
            return operation;
        }

        private PhysicalOperation createLookupJoin(JoinNode node, PlanNode probeNode, List<Symbol> probeSymbols, Optional<Symbol> probeHashSymbol, PlanNode buildNode, List<Symbol> buildSymbols, Optional<Symbol> buildHashSymbol, LocalExecutionPlanContext context) {
            PhysicalOperation probeSource;
            LookupSourceSupplier lookupSourceSupplier = this.createLookupJoinSource(node, buildNode, buildSymbols, buildHashSymbol, context);
            LocalExecutionPlanContext parallelParentContext = null;
            int joinConcurrency = SystemSessionProperties.getTaskJoinConcurrency(this.session);
            if (context.isAllowLocalParallel() && context.getDriverInstanceCount() == 1 && joinConcurrency > 1) {
                parallelParentContext = context;
                context = context.createSubContext();
                probeSource = this.createInMemoryExchange(probeNode, context);
                context.setDriverInstanceCount(joinConcurrency);
            } else if (context.isSingleNode() && this.isBuildOuter(node)) {
                parallelParentContext = context;
                context = context.createSubContext();
                probeSource = probeNode.accept(this, context);
            } else {
                probeSource = probeNode.accept(this, context);
            }
            OperatorFactory operator = this.createLookupJoin(node, probeSource, probeSymbols, probeHashSymbol, lookupSourceSupplier, context);
            ImmutableMap.Builder outputMappings = ImmutableMap.builder();
            List<Symbol> outputSymbols = node.getOutputSymbols();
            for (int i = 0; i < outputSymbols.size(); ++i) {
                Symbol symbol = outputSymbols.get(i);
                outputMappings.put((Object)symbol, (Object)i);
            }
            PhysicalOperation operation = new PhysicalOperation(operator, (Map<Symbol, Integer>)outputMappings.build(), probeSource);
            if (parallelParentContext != null) {
                operation = this.addInMemoryExchange(parallelParentContext, node.getId(), operation, context);
            }
            return operation;
        }

        private boolean isBuildOuter(JoinNode node) {
            return node.getType() == JoinNode.Type.RIGHT || node.getType() == JoinNode.Type.FULL;
        }

        private LookupSourceSupplier createLookupJoinSource(JoinNode node, PlanNode buildNode, List<Symbol> buildSymbols, Optional<Symbol> buildHashSymbol, LocalExecutionPlanContext context) {
            LookupSourceSupplier lookupSourceSupplier;
            LocalExecutionPlanContext buildContext = context.createSubContext();
            PhysicalOperation buildSource = buildNode.accept(this, buildContext);
            ImmutableList buildChannels = ImmutableList.copyOf((Collection)LocalExecutionPlanner.getChannelsForSymbols(buildSymbols, buildSource.getLayout()));
            Optional<Integer> buildHashChannel = buildHashSymbol.map(LocalExecutionPlanner.channelGetter(buildSource));
            int hashBuildConcurrency = SystemSessionProperties.getTaskHashBuildConcurrency(this.session);
            if (this.isBuildOuter(node) || hashBuildConcurrency <= 1) {
                HashBuilderOperator.HashBuilderOperatorFactory hashBuilderOperatorFactory = new HashBuilderOperator.HashBuilderOperatorFactory(buildContext.getNextOperatorId(), node.getId(), buildSource.getTypes(), (List<Integer>)buildChannels, buildHashChannel, 10000);
                context.addDriverFactory(new DriverFactory(buildContext.isInputDriver(), false, (List<OperatorFactory>)ImmutableList.builder().addAll((Iterable)buildSource.getOperatorFactories()).add((Object)hashBuilderOperatorFactory).build()));
                lookupSourceSupplier = hashBuilderOperatorFactory.getLookupSourceSupplier();
            } else {
                int parallelBuildCount = Integer.highestOneBit(hashBuildConcurrency);
                ParallelHashBuilder parallelHashBuilder = new ParallelHashBuilder(buildSource.getTypes(), (List<Integer>)buildChannels, buildHashChannel, 10000, parallelBuildCount);
                context.addDriverFactory(new DriverFactory(buildContext.isInputDriver(), false, (List<OperatorFactory>)ImmutableList.builder().addAll((Iterable)buildSource.getOperatorFactories()).add((Object)parallelHashBuilder.getCollectOperatorFactory(buildContext.getNextOperatorId(), node.getId())).build()));
                context.addDriverFactory(new DriverFactory(false, false, (List<OperatorFactory>)ImmutableList.of((Object)parallelHashBuilder.getBuildOperatorFactory(node.getId())), parallelBuildCount));
                lookupSourceSupplier = parallelHashBuilder.getLookupSourceSupplier();
            }
            if (node.getType() == JoinNode.Type.RIGHT || node.getType() == JoinNode.Type.FULL) {
                lookupSourceSupplier = new LookupOuterOperator.OuterLookupSourceSupplier(lookupSourceSupplier);
            }
            return lookupSourceSupplier;
        }

        private OperatorFactory createLookupJoin(JoinNode node, PhysicalOperation probeSource, List<Symbol> probeSymbols, Optional<Symbol> probeHashSymbol, LookupSourceSupplier lookupSourceSupplier, LocalExecutionPlanContext context) {
            List<Type> probeTypes = probeSource.getTypes();
            ImmutableList probeJoinChannels = ImmutableList.copyOf((Collection)LocalExecutionPlanner.getChannelsForSymbols(probeSymbols, probeSource.getLayout()));
            Optional<Integer> probeHashChannel = probeHashSymbol.map(LocalExecutionPlanner.channelGetter(probeSource));
            switch (node.getType()) {
                case INNER: {
                    return LookupJoinOperators.innerJoin(context.getNextOperatorId(), node.getId(), lookupSourceSupplier, probeTypes, (List<Integer>)probeJoinChannels, probeHashChannel);
                }
                case LEFT: {
                    return LookupJoinOperators.probeOuterJoin(context.getNextOperatorId(), node.getId(), lookupSourceSupplier, probeTypes, (List<Integer>)probeJoinChannels, probeHashChannel);
                }
                case RIGHT: {
                    return LookupJoinOperators.lookupOuterJoin(context.getNextOperatorId(), node.getId(), lookupSourceSupplier, probeTypes, (List<Integer>)probeJoinChannels, probeHashChannel);
                }
                case FULL: {
                    return LookupJoinOperators.fullOuterJoin(context.getNextOperatorId(), node.getId(), lookupSourceSupplier, probeTypes, (List<Integer>)probeJoinChannels, probeHashChannel);
                }
            }
            throw new UnsupportedOperationException("Unsupported join type: " + (Object)((Object)node.getType()));
        }

        @Override
        public PhysicalOperation visitSemiJoin(SemiJoinNode node, LocalExecutionPlanContext context) {
            PhysicalOperation probeSource;
            LocalExecutionPlanContext parallelParentContext = null;
            int joinConcurrency = SystemSessionProperties.getTaskJoinConcurrency(this.session);
            if (context.isAllowLocalParallel() && context.getDriverInstanceCount() == 1 && joinConcurrency > 1) {
                parallelParentContext = context;
                context = context.createSubContext();
                probeSource = this.createInMemoryExchange(node.getSource(), context);
                context.setDriverInstanceCount(joinConcurrency);
            } else {
                probeSource = node.getSource().accept(this, context);
            }
            LocalExecutionPlanContext buildContext = context.createSubContext();
            PhysicalOperation buildSource = node.getFilteringSource().accept(this, buildContext);
            int probeChannel = probeSource.getLayout().get(node.getSourceJoinSymbol());
            int buildChannel = buildSource.getLayout().get(node.getFilteringSourceJoinSymbol());
            Optional<Integer> buildHashChannel = node.getFilteringSourceHashSymbol().map(LocalExecutionPlanner.channelGetter(buildSource));
            SetBuilderOperator.SetBuilderOperatorFactory setBuilderOperatorFactory = new SetBuilderOperator.SetBuilderOperatorFactory(buildContext.getNextOperatorId(), node.getId(), buildSource.getTypes().get(buildChannel), buildChannel, buildHashChannel, 10000);
            SetBuilderOperator.SetSupplier setProvider = setBuilderOperatorFactory.getSetProvider();
            DriverFactory buildDriverFactory = new DriverFactory(buildContext.isInputDriver(), false, (List<OperatorFactory>)ImmutableList.builder().addAll((Iterable)buildSource.getOperatorFactories()).add((Object)setBuilderOperatorFactory).build());
            context.addDriverFactory(buildDriverFactory);
            ImmutableMap outputMappings = ImmutableMap.builder().putAll(probeSource.getLayout()).put((Object)node.getSemiJoinOutput(), (Object)probeSource.getLayout().size()).build();
            HashSemiJoinOperator.HashSemiJoinOperatorFactory operator = new HashSemiJoinOperator.HashSemiJoinOperatorFactory(context.getNextOperatorId(), node.getId(), setProvider, probeSource.getTypes(), probeChannel);
            PhysicalOperation operation = new PhysicalOperation(operator, (Map<Symbol, Integer>)outputMappings, probeSource);
            if (parallelParentContext != null) {
                operation = this.addInMemoryExchange(parallelParentContext, node.getId(), operation, context);
            }
            return operation;
        }

        @Override
        public PhysicalOperation visitTableWriter(TableWriterNode node, LocalExecutionPlanContext context) {
            PhysicalOperation exchange = this.createInMemoryExchange(node.getSource(), context);
            Optional<Integer> sampleWeightChannel = node.getSampleWeightSymbol().map(exchange::symbolToChannel);
            context.setDriverInstanceCount(SystemSessionProperties.getTaskWriterCount(this.session));
            List inputChannels = (List)node.getColumns().stream().map(exchange::symbolToChannel).collect(ImmutableCollectors.toImmutableList());
            TableWriterOperator.TableWriterOperatorFactory operatorFactory = new TableWriterOperator.TableWriterOperatorFactory(context.getNextOperatorId(), node.getId(), LocalExecutionPlanner.this.pageSinkManager, node.getTarget(), inputChannels, sampleWeightChannel, this.session);
            ImmutableMap layout = ImmutableMap.builder().put((Object)node.getOutputSymbols().get(0), (Object)0).put((Object)node.getOutputSymbols().get(1), (Object)1).build();
            return new PhysicalOperation(operatorFactory, (Map<Symbol, Integer>)layout, exchange);
        }

        private PhysicalOperation createInMemoryExchange(PlanNode node, LocalExecutionPlanContext context) {
            LocalExecutionPlanContext subContext = context.createSubContext();
            PhysicalOperation source = node.accept(this, subContext);
            return this.addInMemoryExchange(context, node.getId(), source, subContext);
        }

        private PhysicalOperation addInMemoryExchange(LocalExecutionPlanContext context, PlanNodeId planNodeId, PhysicalOperation source, LocalExecutionPlanContext sourceContext) {
            InMemoryExchange exchange = new InMemoryExchange(source.getTypes());
            ImmutableList factories = ImmutableList.builder().addAll((Iterable)source.getOperatorFactories()).add((Object)exchange.createSinkFactory(sourceContext.getNextOperatorId(), planNodeId)).build();
            context.addDriverFactory(new DriverFactory(sourceContext.isInputDriver(), false, (List<OperatorFactory>)factories, sourceContext.getDriverInstanceCount()));
            context.setInputDriver(false);
            InMemoryExchangeSourceOperator.InMemoryExchangeSourceOperatorFactory factory = InMemoryExchangeSourceOperator.InMemoryExchangeSourceOperatorFactory.createRandomDistribution(context.getNextOperatorId(), planNodeId, exchange);
            return new PhysicalOperation(factory, source.getLayout());
        }

        @Override
        public PhysicalOperation visitTableFinish(TableFinishNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = node.getSource().accept(this, context);
            TableFinishOperator.TableFinishOperatorFactory operatorFactory = new TableFinishOperator.TableFinishOperatorFactory(context.getNextOperatorId(), node.getId(), LocalExecutionPlanner.createTableFinisher(this.session, node, LocalExecutionPlanner.this.metadata));
            ImmutableMap layout = ImmutableMap.of((Object)node.getOutputSymbols().get(0), (Object)0);
            return new PhysicalOperation(operatorFactory, (Map<Symbol, Integer>)layout, source);
        }

        @Override
        public PhysicalOperation visitDelete(DeleteNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = node.getSource().accept(this, context);
            DeleteOperator.DeleteOperatorFactory operatorFactory = new DeleteOperator.DeleteOperatorFactory(context.getNextOperatorId(), node.getId(), source.getLayout().get(node.getRowId()));
            ImmutableMap layout = ImmutableMap.builder().put((Object)node.getOutputSymbols().get(0), (Object)0).put((Object)node.getOutputSymbols().get(1), (Object)1).build();
            return new PhysicalOperation(operatorFactory, (Map<Symbol, Integer>)layout, source);
        }

        @Override
        public PhysicalOperation visitMetadataDelete(MetadataDeleteNode node, LocalExecutionPlanContext context) {
            MetadataDeleteOperator.MetadataDeleteOperatorFactory operatorFactory = new MetadataDeleteOperator.MetadataDeleteOperatorFactory(context.getNextOperatorId(), node.getId(), node.getTableLayout(), LocalExecutionPlanner.this.metadata, this.session, node.getTarget().getHandle());
            return new PhysicalOperation(operatorFactory, (Map<Symbol, Integer>)this.makeLayout(node));
        }

        @Override
        public PhysicalOperation visitUnion(UnionNode node, LocalExecutionPlanContext context) {
            List<Type> types = this.getSourceOperatorTypes(node, context.getTypes());
            InMemoryExchange inMemoryExchange = new InMemoryExchange(types);
            for (int i = 0; i < node.getSources().size(); ++i) {
                PlanNode subplan = node.getSources().get(i);
                List<Symbol> expectedLayout = node.sourceOutputLayout(i);
                LocalExecutionPlanContext subContext = context.createSubContext();
                PhysicalOperation source = subplan.accept(this, subContext);
                ArrayList<OperatorFactory> operatorFactories = new ArrayList<OperatorFactory>(source.getOperatorFactories());
                boolean projectionMatchesOutput = source.getLayout().entrySet().stream().sorted(Ordering.natural().onResultOf(Map.Entry::getValue)).map(Map.Entry::getKey).collect(ImmutableCollectors.toImmutableList()).equals(expectedLayout);
                if (!projectionMatchesOutput) {
                    IdentityProjectionInfo projectionInfo = LocalExecutionPlanner.computeIdentityProjectionInfo(expectedLayout, source.getLayout(), context.getTypes());
                    List<RowExpression> projections = projectionInfo.getProjections();
                    FilterAndProjectOperator.FilterAndProjectOperatorFactory operatorFactory = new FilterAndProjectOperator.FilterAndProjectOperatorFactory(subContext.getNextOperatorId(), node.getId(), LocalExecutionPlanner.this.compiler.compilePageProcessor(LocalExecutionPlanner.trueExpression(), projections), (List)projections.stream().map(RowExpression::getType).collect(ImmutableCollectors.toImmutableList()));
                    operatorFactories.add(operatorFactory);
                }
                operatorFactories.add(inMemoryExchange.createSinkFactory(subContext.getNextOperatorId(), node.getId()));
                DriverFactory driverFactory = new DriverFactory(subContext.isInputDriver(), false, operatorFactories);
                context.addDriverFactory(driverFactory);
            }
            context.setInputDriver(false);
            return new PhysicalOperation(InMemoryExchangeSourceOperator.InMemoryExchangeSourceOperatorFactory.createRandomDistribution(context.getNextOperatorId(), node.getId(), inMemoryExchange), (Map<Symbol, Integer>)this.makeLayout(node));
        }

        @Override
        public PhysicalOperation visitEnforceSingleRow(EnforceSingleRowNode node, LocalExecutionPlanContext context) {
            PhysicalOperation source = node.getSource().accept(this, context);
            Symbol symbol = (Symbol)Iterables.getOnlyElement(node.getOutputSymbols());
            Type type = Objects.requireNonNull(context.getTypes().get(symbol), String.format("No type for symbol %s", symbol));
            EnforceSingleRowOperator.EnforceSingleRowOperatorFactory operatorFactory = new EnforceSingleRowOperator.EnforceSingleRowOperatorFactory(context.getNextOperatorId(), node.getId(), type);
            return new PhysicalOperation(operatorFactory, (Map<Symbol, Integer>)this.makeLayout(node), source);
        }

        @Override
        protected PhysicalOperation visitPlan(PlanNode node, LocalExecutionPlanContext context) {
            throw new UnsupportedOperationException("not yet implemented");
        }

        private List<Type> getSourceOperatorTypes(PlanNode node, Map<Symbol, Type> types) {
            return this.getSymbolTypes(node.getOutputSymbols(), types);
        }

        private List<Type> getSymbolTypes(List<Symbol> symbols, Map<Symbol, Type> types) {
            return (List)symbols.stream().map(types::get).collect(ImmutableCollectors.toImmutableList());
        }

        private AccumulatorFactory buildAccumulatorFactory(PhysicalOperation source, Signature function, FunctionCall call, @Nullable Symbol mask, Optional<Integer> defaultMaskChannel, Optional<Symbol> sampleWeight, double confidence) {
            ArrayList<Integer> arguments = new ArrayList<Integer>();
            for (Expression argument : call.getArguments()) {
                Symbol argumentSymbol = Symbol.fromQualifiedName(((QualifiedNameReference)argument).getName());
                arguments.add(source.getLayout().get(argumentSymbol));
            }
            Optional<Integer> maskChannel = defaultMaskChannel;
            if (mask != null) {
                maskChannel = Optional.of(source.getLayout().get(mask));
            }
            Optional<Integer> sampleWeightChannel = Optional.empty();
            if (sampleWeight.isPresent()) {
                sampleWeightChannel = Optional.of(source.getLayout().get(sampleWeight.get()));
            }
            return LocalExecutionPlanner.this.metadata.getFunctionRegistry().getAggregateFunctionImplementation(function).bind(arguments, maskChannel, sampleWeightChannel, confidence);
        }

        private PhysicalOperation planGlobalAggregation(int operatorId, AggregationNode node, PhysicalOperation source) {
            int outputChannel = 0;
            ImmutableMap.Builder outputMappings = ImmutableMap.builder();
            ArrayList<AccumulatorFactory> accumulatorFactories = new ArrayList<AccumulatorFactory>();
            for (Map.Entry<Symbol, FunctionCall> entry : node.getAggregations().entrySet()) {
                Symbol symbol = entry.getKey();
                accumulatorFactories.add(this.buildAccumulatorFactory(source, node.getFunctions().get(symbol), entry.getValue(), node.getMasks().get(entry.getKey()), Optional.empty(), node.getSampleWeight(), node.getConfidence()));
                outputMappings.put((Object)symbol, (Object)outputChannel);
                ++outputChannel;
            }
            AggregationOperator.AggregationOperatorFactory operatorFactory = new AggregationOperator.AggregationOperatorFactory(operatorId, node.getId(), node.getStep(), accumulatorFactories);
            return new PhysicalOperation(operatorFactory, (Map<Symbol, Integer>)outputMappings.build(), source);
        }

        private PhysicalOperation planGroupByAggregation(AggregationNode node, PhysicalOperation source, int operatorId, Optional<Integer> defaultMaskChannel) {
            List<Symbol> groupBySymbols = node.getGroupBy();
            ArrayList aggregationOutputSymbols = new ArrayList();
            ArrayList<AccumulatorFactory> accumulatorFactories = new ArrayList<AccumulatorFactory>();
            for (Map.Entry<Symbol, FunctionCall> entry2 : node.getAggregations().entrySet()) {
                Iterator symbol = entry2.getKey();
                accumulatorFactories.add(this.buildAccumulatorFactory(source, node.getFunctions().get(symbol), entry2.getValue(), node.getMasks().get(entry2.getKey()), defaultMaskChannel, node.getSampleWeight(), node.getConfidence()));
                aggregationOutputSymbols.add(symbol);
            }
            ImmutableMap.Builder outputMappings = ImmutableMap.builder();
            int channel = 0;
            for (Symbol symbol : groupBySymbols) {
                outputMappings.put((Object)symbol, (Object)channel);
                ++channel;
            }
            if (node.getHashSymbol().isPresent()) {
                outputMappings.put((Object)node.getHashSymbol().get(), (Object)channel++);
            }
            for (Symbol symbol : aggregationOutputSymbols) {
                outputMappings.put((Object)symbol, (Object)channel);
                ++channel;
            }
            List groupByChannels = LocalExecutionPlanner.getChannelsForSymbols(groupBySymbols, source.getLayout());
            List list = (List)groupByChannels.stream().map(entry -> source.getTypes().get((int)entry)).collect(ImmutableCollectors.toImmutableList());
            Optional<Integer> hashChannel = node.getHashSymbol().map(LocalExecutionPlanner.channelGetter(source));
            HashAggregationOperator.HashAggregationOperatorFactory operatorFactory = new HashAggregationOperator.HashAggregationOperatorFactory(operatorId, node.getId(), list, groupByChannels, node.getStep(), accumulatorFactories, defaultMaskChannel, hashChannel, 10000, LocalExecutionPlanner.this.maxPartialAggregationMemorySize);
            return new PhysicalOperation(operatorFactory, (Map<Symbol, Integer>)outputMappings.build(), source);
        }

        private /* synthetic */ RecordSet lambda$visitIndexSource$312(List overlappingFieldSets, List remappedProbeKeyChannels, RecordSet recordSet) {
            if (!overlappingFieldSets.isEmpty()) {
                recordSet = new FieldSetFilteringRecordSet(LocalExecutionPlanner.this.metadata.getFunctionRegistry(), recordSet, overlappingFieldSets);
            }
            return new MappedRecordSet(recordSet, remappedProbeKeyChannels);
        }
    }

    public static class LocalExecutionPlan {
        private final List<DriverFactory> driverFactories;

        public LocalExecutionPlan(List<DriverFactory> driverFactories) {
            this.driverFactories = ImmutableList.copyOf((Collection)Objects.requireNonNull(driverFactories, "driverFactories is null"));
        }

        public List<DriverFactory> getDriverFactories() {
            return this.driverFactories;
        }
    }

    private static class IndexSourceContext {
        private final SetMultimap<Symbol, Integer> indexLookupToProbeInput;

        public IndexSourceContext(SetMultimap<Symbol, Integer> indexLookupToProbeInput) {
            this.indexLookupToProbeInput = ImmutableSetMultimap.copyOf((Multimap)((Multimap)Objects.requireNonNull(indexLookupToProbeInput, "indexLookupToProbeInput is null")));
        }

        private SetMultimap<Symbol, Integer> getIndexLookupToProbeInput() {
            return this.indexLookupToProbeInput;
        }
    }

    private static class LocalExecutionPlanContext {
        private final Session session;
        private final Map<Symbol, Type> types;
        private final boolean singleNode;
        private final boolean allowLocalParallel;
        private final List<DriverFactory> driverFactories;
        private final Optional<IndexSourceContext> indexSourceContext;
        private int nextOperatorId;
        private boolean inputDriver = true;
        private int driverInstanceCount = 1;

        public LocalExecutionPlanContext(Session session, Map<Symbol, Type> types, boolean singleNode, boolean allowLocalParallel) {
            this(session, types, singleNode, allowLocalParallel, new ArrayList<DriverFactory>(), Optional.empty());
        }

        private LocalExecutionPlanContext(Session session, Map<Symbol, Type> types, boolean singleNode, boolean allowLocalParallel, List<DriverFactory> driverFactories, Optional<IndexSourceContext> indexSourceContext) {
            this.session = session;
            this.types = types;
            this.singleNode = singleNode;
            this.allowLocalParallel = allowLocalParallel;
            this.driverFactories = driverFactories;
            this.indexSourceContext = indexSourceContext;
        }

        public void addDriverFactory(DriverFactory driverFactory) {
            this.driverFactories.add(Objects.requireNonNull(driverFactory, "driverFactory is null"));
        }

        private List<DriverFactory> getDriverFactories() {
            return ImmutableList.copyOf(this.driverFactories);
        }

        public Session getSession() {
            return this.session;
        }

        public Map<Symbol, Type> getTypes() {
            return this.types;
        }

        public Optional<IndexSourceContext> getIndexSourceContext() {
            return this.indexSourceContext;
        }

        private int getNextOperatorId() {
            return this.nextOperatorId++;
        }

        private boolean isInputDriver() {
            return this.inputDriver;
        }

        private void setInputDriver(boolean inputDriver) {
            this.inputDriver = inputDriver;
        }

        public LocalExecutionPlanContext createSubContext() {
            Preconditions.checkState((!this.indexSourceContext.isPresent() ? 1 : 0) != 0, (Object)"index build plan can not have sub-contexts");
            return new LocalExecutionPlanContext(this.session, this.types, this.singleNode, this.allowLocalParallel, this.driverFactories, this.indexSourceContext);
        }

        public LocalExecutionPlanContext createIndexSourceSubContext(IndexSourceContext indexSourceContext) {
            return new LocalExecutionPlanContext(this.session, this.types, true, false, this.driverFactories, Optional.of(indexSourceContext));
        }

        public boolean isSingleNode() {
            return this.singleNode;
        }

        public boolean isAllowLocalParallel() {
            return this.allowLocalParallel;
        }

        public int getDriverInstanceCount() {
            return this.driverInstanceCount;
        }

        public void setDriverInstanceCount(int driverInstanceCount) {
            Preconditions.checkArgument((driverInstanceCount > 0 ? 1 : 0) != 0, (Object)"driverInstanceCount must be > 0");
            this.driverInstanceCount = driverInstanceCount;
        }
    }
}

