/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.Scope;
import com.facebook.presto.sql.relational.CallExpression;
import com.facebook.presto.sql.relational.ConstantExpression;
import com.facebook.presto.sql.relational.InputReferenceExpression;
import com.facebook.presto.sql.relational.RowExpression;
import com.facebook.presto.sql.relational.RowExpressionVisitor;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;

public class TryExpressionExtractor
implements RowExpressionVisitor<Scope, BytecodeNode> {
    private final ImmutableList.Builder<CallExpression> tryExpressions = ImmutableList.builder();

    @Override
    public BytecodeNode visitInputReference(InputReferenceExpression node, Scope scope) {
        return null;
    }

    @Override
    public BytecodeNode visitCall(CallExpression call, Scope scope) {
        if (call.getSignature().getName().equals("TRY")) {
            Preconditions.checkState((call.getArguments().size() == 1 ? 1 : 0) != 0, (Object)"try call expressions must have a single argument");
            Preconditions.checkState((boolean)(Iterables.getOnlyElement(call.getArguments()) instanceof CallExpression), (Object)"try call expression argument must be a call expression");
            this.tryExpressions.add((Object)((CallExpression)Iterables.getOnlyElement(call.getArguments())));
        }
        for (RowExpression rowExpression : call.getArguments()) {
            rowExpression.accept(this, null);
        }
        return null;
    }

    @Override
    public BytecodeNode visitConstant(ConstantExpression literal, Scope scope) {
        return null;
    }

    public List<CallExpression> getTryExpressionsPreOrder() {
        return this.tryExpressions.build().reverse();
    }
}

