/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.bytecode.BytecodeBlock;
import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.OpCode;
import com.facebook.presto.bytecode.Scope;
import com.facebook.presto.bytecode.Variable;
import com.facebook.presto.bytecode.control.IfStatement;
import com.facebook.presto.bytecode.expression.BytecodeExpression;
import com.facebook.presto.bytecode.expression.BytecodeExpressions;
import com.facebook.presto.bytecode.instruction.LabelNode;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementation;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.gen.Binding;
import com.facebook.presto.sql.gen.Bootstrap;
import com.facebook.presto.sql.gen.CallSiteBinder;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.primitives.Primitives;
import io.airlift.slice.Slice;
import java.lang.constant.Constable;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public final class BytecodeUtils {
    private BytecodeUtils() {
    }

    public static BytecodeNode ifWasNullPopAndGoto(Scope scope, LabelNode label, Class<?> returnType, Class<?> ... stackArgsToPop) {
        return BytecodeUtils.handleNullValue(scope, label, returnType, ImmutableList.copyOf((Object[])stackArgsToPop), false);
    }

    public static BytecodeNode ifWasNullPopAndGoto(Scope scope, LabelNode label, Class<?> returnType, Iterable<? extends Class<?>> stackArgsToPop) {
        return BytecodeUtils.handleNullValue(scope, label, returnType, ImmutableList.copyOf(stackArgsToPop), false);
    }

    public static BytecodeNode ifWasNullClearPopAndGoto(Scope scope, LabelNode label, Class<?> returnType, Class<?> ... stackArgsToPop) {
        return BytecodeUtils.handleNullValue(scope, label, returnType, ImmutableList.copyOf((Object[])stackArgsToPop), true);
    }

    public static BytecodeNode handleNullValue(Scope scope, LabelNode label, Class<?> returnType, List<Class<?>> stackArgsToPop, boolean clearNullFlag) {
        Variable wasNull = scope.getVariable("wasNull");
        BytecodeBlock nullCheck = new BytecodeBlock().setDescription("ifWasNullGoto").append((BytecodeNode)wasNull);
        String clearComment = null;
        if (clearNullFlag) {
            nullCheck.append((BytecodeNode)wasNull.set(BytecodeExpressions.constantFalse()));
            clearComment = "clear wasNull";
        }
        BytecodeBlock isNull = new BytecodeBlock();
        for (Class<?> parameterType : stackArgsToPop) {
            isNull.pop(parameterType);
        }
        isNull.pushJavaDefault(returnType);
        String loadDefaultComment = null;
        if (returnType != Void.TYPE) {
            loadDefaultComment = String.format("loadJavaDefault(%s)", returnType.getName());
        }
        isNull.gotoLabel(label);
        String popComment = null;
        if (!stackArgsToPop.isEmpty()) {
            popComment = String.format("pop(%s)", Joiner.on((String)", ").join(stackArgsToPop));
        }
        return new IfStatement("if wasNull then %s", new Object[]{Joiner.on((String)", ").skipNulls().join((Object)clearComment, (Object)popComment, new Object[]{loadDefaultComment, "goto " + label.getLabel()})}).condition((BytecodeNode)nullCheck).ifTrue((BytecodeNode)isNull);
    }

    public static BytecodeNode boxPrimitive(Class<?> type) {
        BytecodeBlock block = new BytecodeBlock().comment("box primitive");
        if (type == Long.TYPE) {
            return block.invokeStatic(Long.class, "valueOf", Long.class, new Class[]{Long.TYPE});
        }
        if (type == Double.TYPE) {
            return block.invokeStatic(Double.class, "valueOf", Double.class, new Class[]{Double.TYPE});
        }
        if (type == Boolean.TYPE) {
            return block.invokeStatic(Boolean.class, "valueOf", Boolean.class, new Class[]{Boolean.TYPE});
        }
        if (type.isPrimitive()) {
            throw new UnsupportedOperationException("not yet implemented: " + type);
        }
        return OpCode.NOP;
    }

    public static BytecodeNode unboxPrimitive(Class<?> unboxedType) {
        BytecodeBlock block = new BytecodeBlock().comment("unbox primitive");
        if (unboxedType == Long.TYPE) {
            return block.invokeVirtual(Long.class, "longValue", Long.TYPE, new Class[0]);
        }
        if (unboxedType == Double.TYPE) {
            return block.invokeVirtual(Double.class, "doubleValue", Double.TYPE, new Class[0]);
        }
        if (unboxedType == Boolean.TYPE) {
            return block.invokeVirtual(Boolean.class, "booleanValue", Boolean.TYPE, new Class[0]);
        }
        throw new UnsupportedOperationException("not yet implemented: " + unboxedType);
    }

    public static BytecodeExpression loadConstant(CallSiteBinder callSiteBinder, Object constant, Class<?> type) {
        Binding binding = callSiteBinder.bind(MethodHandles.constant(type, constant));
        return BytecodeUtils.loadConstant(binding);
    }

    public static BytecodeExpression loadConstant(Binding binding) {
        return BytecodeExpressions.invokeDynamic((Method)Bootstrap.BOOTSTRAP_METHOD, (Iterable)ImmutableList.of((Object)binding.getBindingId()), (String)("constant_" + binding.getBindingId()), (Class)binding.getType().returnType(), (BytecodeExpression[])new BytecodeExpression[0]);
    }

    public static BytecodeNode generateInvocation(Scope scope, String name, ScalarFunctionImplementation function, Optional<BytecodeNode> instance, List<BytecodeNode> arguments, Binding binding) {
        MethodType methodType = binding.getType();
        TypeDescriptor.OfField returnType = methodType.returnType();
        Class unboxedReturnType = Primitives.unwrap((Class)returnType);
        LabelNode end = new LabelNode("end");
        BytecodeBlock block = new BytecodeBlock().setDescription("invoke " + name);
        ArrayList stackTypes = new ArrayList();
        if (function.getInstanceFactory().isPresent()) {
            Preconditions.checkArgument((boolean)instance.isPresent());
        }
        int index = 0;
        boolean boundInstance = false;
        for (Class<?> type : methodType.parameterArray()) {
            stackTypes.add(type);
            if (function.getInstanceFactory().isPresent() && !boundInstance) {
                Preconditions.checkState((boolean)type.equals(function.getInstanceFactory().get().type().returnType()), (Object)"Mismatched type for instance parameter");
                block.append(instance.get());
                boundInstance = true;
                continue;
            }
            if (type == ConnectorSession.class) {
                block.append((BytecodeNode)scope.getVariable("session"));
                continue;
            }
            block.append(arguments.get(index));
            if (!function.getNullableArguments().get(index).booleanValue()) {
                Preconditions.checkArgument((!Primitives.isWrapperType(type) ? 1 : 0) != 0, (Object)"Non-nullable argument must not be primitive wrapper type");
                block.append(BytecodeUtils.ifWasNullPopAndGoto(scope, end, unboxedReturnType, Lists.reverse(stackTypes)));
            } else {
                block.append(BytecodeUtils.boxPrimitiveIfNecessary(scope, type));
                block.append((BytecodeNode)scope.getVariable("wasNull").set(BytecodeExpressions.constantFalse()));
            }
            ++index;
        }
        block.append(BytecodeUtils.invoke(binding, name));
        if (function.isNullable()) {
            block.append((BytecodeNode)BytecodeUtils.unboxPrimitiveIfNecessary(scope, returnType));
        }
        block.visitLabel(end);
        return block;
    }

    public static BytecodeBlock unboxPrimitiveIfNecessary(Scope scope, Class<?> boxedType) {
        BytecodeBlock block = new BytecodeBlock();
        LabelNode end = new LabelNode("end");
        Class unboxedType = Primitives.unwrap(boxedType);
        Variable wasNull = scope.getVariable("wasNull");
        if (unboxedType == Void.TYPE) {
            block.pop(boxedType).append((BytecodeNode)wasNull.set(BytecodeExpressions.constantTrue()));
        } else if (unboxedType.isPrimitive()) {
            LabelNode notNull = new LabelNode("notNull");
            block.dup(boxedType).ifNotNullGoto(notNull).append((BytecodeNode)wasNull.set(BytecodeExpressions.constantTrue())).comment("swap boxed null with unboxed default").pop(boxedType).pushJavaDefault(unboxedType).gotoLabel(end).visitLabel(notNull).append(BytecodeUtils.unboxPrimitive(unboxedType));
        } else {
            block.dup(boxedType).ifNotNullGoto(end).append((BytecodeNode)wasNull.set(BytecodeExpressions.constantTrue()));
        }
        block.visitLabel(end);
        return block;
    }

    public static BytecodeNode boxPrimitiveIfNecessary(Scope scope, Class<?> type) {
        Class<Constable> expectedCurrentStackType;
        if (!Primitives.isWrapperType(type)) {
            return OpCode.NOP;
        }
        BytecodeBlock notNull = new BytecodeBlock().comment("box primitive");
        if (type == Long.class) {
            notNull.invokeStatic(Long.class, "valueOf", Long.class, new Class[]{Long.TYPE});
            expectedCurrentStackType = Long.TYPE;
        } else if (type == Double.class) {
            notNull.invokeStatic(Double.class, "valueOf", Double.class, new Class[]{Double.TYPE});
            expectedCurrentStackType = Double.TYPE;
        } else if (type == Boolean.class) {
            notNull.invokeStatic(Boolean.class, "valueOf", Boolean.class, new Class[]{Boolean.TYPE});
            expectedCurrentStackType = Boolean.TYPE;
        } else {
            if (type == Void.class) {
                notNull.pushNull().checkCast(Void.class);
                return notNull;
            }
            throw new UnsupportedOperationException("not yet implemented: " + type);
        }
        BytecodeBlock condition = new BytecodeBlock().append((BytecodeNode)scope.getVariable("wasNull"));
        BytecodeBlock wasNull = new BytecodeBlock().pop(expectedCurrentStackType).pushNull().checkCast(type);
        return new IfStatement().condition((BytecodeNode)condition).ifTrue((BytecodeNode)wasNull).ifFalse((BytecodeNode)notNull);
    }

    public static BytecodeNode invoke(Binding binding, String name) {
        return BytecodeExpressions.invokeDynamic((Method)Bootstrap.BOOTSTRAP_METHOD, (Iterable)ImmutableList.of((Object)binding.getBindingId()), (String)name, (MethodType)binding.getType(), (BytecodeExpression[])new BytecodeExpression[0]);
    }

    public static BytecodeNode invoke(Binding binding, Signature signature) {
        return BytecodeUtils.invoke(binding, signature.getName());
    }

    public static BytecodeNode generateWrite(CallSiteBinder callSiteBinder, Scope scope, Variable wasNullVariable, Type type) {
        if (type.getJavaType() == Void.TYPE) {
            return new BytecodeBlock().comment("output.appendNull();").invokeInterface(BlockBuilder.class, "appendNull", BlockBuilder.class, new Class[0]).pop();
        }
        Class<Object> valueJavaType = type.getJavaType();
        if (!valueJavaType.isPrimitive() && valueJavaType != Slice.class) {
            valueJavaType = Object.class;
        }
        String methodName = "write" + Primitives.wrap(valueJavaType).getSimpleName();
        Variable tempValue = scope.createTempVariable(valueJavaType);
        Variable tempOutput = scope.createTempVariable(BlockBuilder.class);
        return new BytecodeBlock().comment("if (wasNull)").append((BytecodeNode)new IfStatement().condition((BytecodeNode)wasNullVariable).ifTrue((BytecodeNode)new BytecodeBlock().comment("output.appendNull();").pop(valueJavaType).invokeInterface(BlockBuilder.class, "appendNull", BlockBuilder.class, new Class[0]).pop()).ifFalse((BytecodeNode)new BytecodeBlock().comment("%s.%s(output, %s)", new Object[]{type.getTypeSignature(), methodName, valueJavaType.getSimpleName()}).putVariable(tempValue).putVariable(tempOutput).append((BytecodeNode)BytecodeUtils.loadConstant(callSiteBinder.bind(type, Type.class))).getVariable(tempOutput).getVariable(tempValue).invokeInterface(Type.class, methodName, Void.TYPE, new Class[]{BlockBuilder.class, valueJavaType})));
    }
}

