/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.analyzer;

import com.facebook.presto.metadata.QualifiedObjectName;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.TableHandle;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.analyzer.ExpressionAnalysis;
import com.facebook.presto.sql.analyzer.Field;
import com.facebook.presto.sql.analyzer.FieldOrExpression;
import com.facebook.presto.sql.analyzer.RelationType;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.InPredicate;
import com.facebook.presto.sql.tree.Join;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.Query;
import com.facebook.presto.sql.tree.QuerySpecification;
import com.facebook.presto.sql.tree.Relation;
import com.facebook.presto.sql.tree.SampledRelation;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.sql.tree.SubqueryExpression;
import com.facebook.presto.sql.tree.Table;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.concurrent.Immutable;

public class Analysis {
    private Statement statement;
    private String updateType;
    private final IdentityHashMap<Table, Query> namedQueries = new IdentityHashMap();
    private RelationType outputDescriptor;
    private final IdentityHashMap<Node, RelationType> outputDescriptors = new IdentityHashMap();
    private final IdentityHashMap<Expression, Integer> resolvedNames = new IdentityHashMap();
    private final IdentityHashMap<QuerySpecification, List<FunctionCall>> aggregates = new IdentityHashMap();
    private final IdentityHashMap<QuerySpecification, List<List<FieldOrExpression>>> groupByExpressions = new IdentityHashMap();
    private final IdentityHashMap<Node, Expression> where = new IdentityHashMap();
    private final IdentityHashMap<QuerySpecification, Expression> having = new IdentityHashMap();
    private final IdentityHashMap<Node, List<FieldOrExpression>> orderByExpressions = new IdentityHashMap();
    private final IdentityHashMap<Node, List<FieldOrExpression>> outputExpressions = new IdentityHashMap();
    private final IdentityHashMap<QuerySpecification, List<FunctionCall>> windowFunctions = new IdentityHashMap();
    private final IdentityHashMap<Join, Expression> joins = new IdentityHashMap();
    private final ListMultimap<Node, InPredicate> inPredicates = ArrayListMultimap.create();
    private final ListMultimap<Node, SubqueryExpression> scalarSubqueries = ArrayListMultimap.create();
    private final IdentityHashMap<Join, JoinInPredicates> joinInPredicates = new IdentityHashMap();
    private final IdentityHashMap<Table, TableHandle> tables = new IdentityHashMap();
    private final IdentityHashMap<Expression, Type> types = new IdentityHashMap();
    private final IdentityHashMap<Expression, Type> coercions = new IdentityHashMap();
    private final IdentityHashMap<Relation, Type[]> relationCoercions = new IdentityHashMap();
    private final IdentityHashMap<FunctionCall, Signature> functionSignature = new IdentityHashMap();
    private final IdentityHashMap<Field, ColumnHandle> columns = new IdentityHashMap();
    private final IdentityHashMap<SampledRelation, Double> sampleRatios = new IdentityHashMap();
    private Optional<QualifiedObjectName> createTableDestination = Optional.empty();
    private Map<String, Expression> createTableProperties = ImmutableMap.of();
    private boolean createTableAsSelectWithData = true;
    private boolean createTableAsSelectNoOp = false;
    private Optional<Insert> insert = Optional.empty();

    public Statement getStatement() {
        return this.statement;
    }

    public void setStatement(Statement statement) {
        this.statement = statement;
    }

    public String getUpdateType() {
        return this.updateType;
    }

    public void setUpdateType(String updateType) {
        this.updateType = updateType;
    }

    public boolean isCreateTableAsSelectWithData() {
        return this.createTableAsSelectWithData;
    }

    public void setCreateTableAsSelectWithData(boolean createTableAsSelectWithData) {
        this.createTableAsSelectWithData = createTableAsSelectWithData;
    }

    public boolean isCreateTableAsSelectNoOp() {
        return this.createTableAsSelectNoOp;
    }

    public void setCreateTableAsSelectNoOp(boolean createTableAsSelectNoOp) {
        this.createTableAsSelectNoOp = createTableAsSelectNoOp;
    }

    public void addResolvedNames(Map<Expression, Integer> mappings) {
        this.resolvedNames.putAll(mappings);
    }

    public Optional<Integer> getFieldIndex(Expression expression) {
        return Optional.ofNullable(this.resolvedNames.get(expression));
    }

    public void setAggregates(QuerySpecification node, List<FunctionCall> aggregates) {
        this.aggregates.put(node, aggregates);
    }

    public List<FunctionCall> getAggregates(QuerySpecification query) {
        return this.aggregates.get(query);
    }

    public IdentityHashMap<Expression, Type> getTypes() {
        return new IdentityHashMap<Expression, Type>(this.types);
    }

    public Type getType(Expression expression) {
        Preconditions.checkArgument((boolean)this.types.containsKey(expression), (String)"Expression not analyzed: %s", (Object[])new Object[]{expression});
        return this.types.get(expression);
    }

    public Type[] getRelationCoercion(Relation relation) {
        return this.relationCoercions.get(relation);
    }

    public void addRelationCoercion(Relation relation, Type[] types) {
        this.relationCoercions.put(relation, types);
    }

    public IdentityHashMap<Expression, Type> getCoercions() {
        return this.coercions;
    }

    public Type getCoercion(Expression expression) {
        return this.coercions.get(expression);
    }

    public void setGroupingSets(QuerySpecification node, List<List<FieldOrExpression>> expressions) {
        this.groupByExpressions.put(node, expressions);
    }

    public List<List<FieldOrExpression>> getGroupingSets(QuerySpecification node) {
        return this.groupByExpressions.get(node);
    }

    public void setWhere(Node node, Expression expression) {
        this.where.put(node, expression);
    }

    public Expression getWhere(QuerySpecification node) {
        return this.where.get(node);
    }

    public void setOrderByExpressions(Node node, List<FieldOrExpression> items) {
        this.orderByExpressions.put(node, items);
    }

    public List<FieldOrExpression> getOrderByExpressions(Node node) {
        return this.orderByExpressions.get(node);
    }

    public void setOutputExpressions(Node node, List<FieldOrExpression> expressions) {
        this.outputExpressions.put(node, expressions);
    }

    public List<FieldOrExpression> getOutputExpressions(Node node) {
        return this.outputExpressions.get(node);
    }

    public void setHaving(QuerySpecification node, Expression expression) {
        this.having.put(node, expression);
    }

    public void setJoinCriteria(Join node, Expression criteria) {
        this.joins.put(node, criteria);
    }

    public Expression getJoinCriteria(Join join) {
        return this.joins.get(join);
    }

    public void recordSubqueries(Node node, ExpressionAnalysis expressionAnalysis) {
        this.inPredicates.putAll((Object)node, expressionAnalysis.getSubqueryInPredicates());
        this.scalarSubqueries.putAll((Object)node, expressionAnalysis.getScalarSubqueries());
    }

    public List<InPredicate> getInPredicates(Node node) {
        return this.inPredicates.get((Object)node);
    }

    public List<SubqueryExpression> getScalarSubqueries(Node node) {
        return this.scalarSubqueries.get((Object)node);
    }

    public void addJoinInPredicates(Join node, JoinInPredicates joinInPredicates) {
        this.joinInPredicates.put(node, joinInPredicates);
    }

    public JoinInPredicates getJoinInPredicates(Join node) {
        return this.joinInPredicates.get(node);
    }

    public void setWindowFunctions(QuerySpecification node, List<FunctionCall> functions) {
        this.windowFunctions.put(node, functions);
    }

    public Map<QuerySpecification, List<FunctionCall>> getWindowFunctions() {
        return this.windowFunctions;
    }

    public List<FunctionCall> getWindowFunctions(QuerySpecification query) {
        return this.windowFunctions.get(query);
    }

    public void setOutputDescriptor(RelationType descriptor) {
        this.outputDescriptor = descriptor;
    }

    public RelationType getOutputDescriptor() {
        return this.outputDescriptor;
    }

    public void setOutputDescriptor(Node node, RelationType descriptor) {
        this.outputDescriptors.put(node, descriptor);
    }

    public RelationType getOutputDescriptor(Node node) {
        Preconditions.checkState((boolean)this.outputDescriptors.containsKey(node), (String)"Output descriptor missing for %s. Broken analysis?", (Object[])new Object[]{node});
        return this.outputDescriptors.get(node);
    }

    public TableHandle getTableHandle(Table table) {
        return this.tables.get(table);
    }

    public void registerTable(Table table, TableHandle handle) {
        this.tables.put(table, handle);
    }

    public Signature getFunctionSignature(FunctionCall function) {
        return this.functionSignature.get(function);
    }

    public void addFunctionSignatures(IdentityHashMap<FunctionCall, Signature> infos) {
        this.functionSignature.putAll(infos);
    }

    public Set<Expression> getColumnReferences() {
        return this.resolvedNames.keySet();
    }

    public void addTypes(IdentityHashMap<Expression, Type> types) {
        this.types.putAll(types);
    }

    public void addCoercion(Expression expression, Type type) {
        this.coercions.put(expression, type);
    }

    public void addCoercions(IdentityHashMap<Expression, Type> coercions) {
        this.coercions.putAll(coercions);
    }

    public Expression getHaving(QuerySpecification query) {
        return this.having.get(query);
    }

    public void setColumn(Field field, ColumnHandle handle) {
        this.columns.put(field, handle);
    }

    public ColumnHandle getColumn(Field field) {
        return this.columns.get(field);
    }

    public void setCreateTableDestination(QualifiedObjectName destination) {
        this.createTableDestination = Optional.of(destination);
    }

    public Optional<QualifiedObjectName> getCreateTableDestination() {
        return this.createTableDestination;
    }

    public void setCreateTableProperties(Map<String, Expression> createTableProperties) {
        this.createTableProperties = createTableProperties;
    }

    public Map<String, Expression> getCreateTableProperties() {
        return this.createTableProperties;
    }

    public void setInsert(Insert insert) {
        this.insert = Optional.of(insert);
    }

    public Optional<Insert> getInsert() {
        return this.insert;
    }

    public Query getNamedQuery(Table table) {
        return this.namedQueries.get(table);
    }

    public void registerNamedQuery(Table tableReference, Query query) {
        Objects.requireNonNull(tableReference, "tableReference is null");
        Objects.requireNonNull(query, "query is null");
        this.namedQueries.put(tableReference, query);
    }

    public void setSampleRatio(SampledRelation relation, double ratio) {
        this.sampleRatios.put(relation, ratio);
    }

    public double getSampleRatio(SampledRelation relation) {
        Preconditions.checkState((boolean)this.sampleRatios.containsKey(relation), (String)"Sample ratio missing for %s. Broken analysis?", (Object[])new Object[]{relation});
        return this.sampleRatios.get(relation);
    }

    @Immutable
    public static final class Insert {
        private final TableHandle target;
        private final List<ColumnHandle> columns;

        public Insert(TableHandle target, List<ColumnHandle> columns) {
            this.target = Objects.requireNonNull(target, "target is null");
            this.columns = Objects.requireNonNull(columns, "columns is null");
            Preconditions.checkArgument((columns.size() > 0 ? 1 : 0) != 0, (Object)"No columns given to insert");
        }

        public List<ColumnHandle> getColumns() {
            return this.columns;
        }

        public TableHandle getTarget() {
            return this.target;
        }
    }

    public static class JoinInPredicates {
        private final Set<InPredicate> leftInPredicates;
        private final Set<InPredicate> rightInPredicates;

        public JoinInPredicates(Set<InPredicate> leftInPredicates, Set<InPredicate> rightInPredicates) {
            this.leftInPredicates = ImmutableSet.copyOf((Collection)Objects.requireNonNull(leftInPredicates, "leftInPredicates is null"));
            this.rightInPredicates = ImmutableSet.copyOf((Collection)Objects.requireNonNull(rightInPredicates, "rightInPredicates is null"));
        }

        public Set<InPredicate> getLeftInPredicates() {
            return this.leftInPredicates;
        }

        public Set<InPredicate> getRightInPredicates() {
            return this.rightInPredicates;
        }

        public int hashCode() {
            return Objects.hash(this.leftInPredicates, this.rightInPredicates);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            JoinInPredicates other = (JoinInPredicates)obj;
            return Objects.equals(this.leftInPredicates, other.leftInPredicates) && Objects.equals(this.rightInPredicates, other.rightInPredicates);
        }
    }
}

