/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.annotation.UsedByGeneratedCode;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.SqlScalarFunction;
import com.facebook.presto.metadata.TypeParameterRequirement;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementation;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.sql.QueryUtil;
import com.facebook.presto.type.RowType;
import com.facebook.presto.util.Reflection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slice;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class RowFieldReference
extends SqlScalarFunction {
    private static final Map<String, MethodHandle> METHOD_HANDLE_MAP;
    private final MethodHandle methodHandle;
    private static final MethodHandle METHOD_HANDLE_OBJECT;

    public RowFieldReference(RowType type, Type returnType, int index, String fieldName) {
        super(QueryUtil.mangleFieldReference((String)fieldName), (List<TypeParameterRequirement>)ImmutableList.of(), returnType.getTypeSignature().toString(), (List<String>)ImmutableList.of((Object)type.getTypeSignature().toString()));
        String stackType = returnType.getJavaType().getSimpleName().toLowerCase();
        MethodHandle methodHandle = METHOD_HANDLE_MAP.containsKey(stackType) ? METHOD_HANDLE_MAP.get(stackType) : METHOD_HANDLE_OBJECT;
        this.methodHandle = methodHandle.bindTo(returnType).bindTo(index);
    }

    @Override
    public boolean isHidden() {
        return true;
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public ScalarFunctionImplementation specialize(Map<String, Type> types, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        Objects.requireNonNull(this.methodHandle, "methodHandle is null");
        return new ScalarFunctionImplementation(true, (List<Boolean>)ImmutableList.of((Object)false), this.methodHandle, this.isDeterministic());
    }

    @UsedByGeneratedCode
    public static Long longAccessor(Type type, Integer field, Block row) {
        return row.isNull(field.intValue()) ? null : Long.valueOf(type.getLong(row, field.intValue()));
    }

    @UsedByGeneratedCode
    public static Boolean booleanAccessor(Type type, Integer field, Block row) {
        return row.isNull(field.intValue()) ? null : Boolean.valueOf(type.getBoolean(row, field.intValue()));
    }

    @UsedByGeneratedCode
    public static Double doubleAccessor(Type type, Integer field, Block row) {
        return row.isNull(field.intValue()) ? null : Double.valueOf(type.getDouble(row, field.intValue()));
    }

    @UsedByGeneratedCode
    public static Slice sliceAccessor(Type type, Integer field, Block row) {
        return row.isNull(field.intValue()) ? null : type.getSlice(row, field.intValue());
    }

    @UsedByGeneratedCode
    public static Object objectAccessor(Type type, Integer field, Block row) {
        return row.isNull(field.intValue()) ? null : type.getObject(row, field.intValue());
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"long", (Object)Reflection.methodHandle(RowFieldReference.class, "longAccessor", Type.class, Integer.class, Block.class));
        builder.put((Object)"double", (Object)Reflection.methodHandle(RowFieldReference.class, "doubleAccessor", Type.class, Integer.class, Block.class));
        builder.put((Object)"boolean", (Object)Reflection.methodHandle(RowFieldReference.class, "booleanAccessor", Type.class, Integer.class, Block.class));
        builder.put((Object)"slice", (Object)Reflection.methodHandle(RowFieldReference.class, "sliceAccessor", Type.class, Integer.class, Block.class));
        METHOD_HANDLE_MAP = builder.build();
        METHOD_HANDLE_OBJECT = Reflection.methodHandle(RowFieldReference.class, "objectAccessor", Type.class, Integer.class, Block.class);
    }
}

