/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.bytecode.Access;
import com.facebook.presto.bytecode.BytecodeBlock;
import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.ClassDefinition;
import com.facebook.presto.bytecode.CompilerUtils;
import com.facebook.presto.bytecode.DynamicClassLoader;
import com.facebook.presto.bytecode.MethodDefinition;
import com.facebook.presto.bytecode.Parameter;
import com.facebook.presto.bytecode.ParameterizedType;
import com.facebook.presto.bytecode.Scope;
import com.facebook.presto.bytecode.Variable;
import com.facebook.presto.bytecode.expression.BytecodeExpression;
import com.facebook.presto.bytecode.expression.BytecodeExpressions;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.SqlScalarFunction;
import com.facebook.presto.metadata.TypeParameterRequirement;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementation;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.util.ImmutableCollectors;
import com.facebook.presto.util.Reflection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.lang.invoke.MethodHandle;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;

public final class ConcatFunction
extends SqlScalarFunction {
    public static final ConcatFunction CONCAT = new ConcatFunction();

    public ConcatFunction() {
        super("concat", (List<TypeParameterRequirement>)ImmutableList.of(), "varchar", (List<String>)ImmutableList.of((Object)"varchar"), true);
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }

    @Override
    public String getDescription() {
        return "concatenates given strings";
    }

    @Override
    public ScalarFunctionImplementation specialize(Map<String, Type> types, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        if (arity < 2) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "There must be two or more concatenation arguments");
        }
        Class<?> clazz = ConcatFunction.generateConcat(arity);
        MethodHandle methodHandle = Reflection.methodHandle(clazz, "concat", Collections.nCopies(arity, Slice.class).toArray(new Class[arity]));
        ImmutableList nullableParameters = ImmutableList.copyOf(Collections.nCopies(arity, false));
        return new ScalarFunctionImplementation(false, (List<Boolean>)nullableParameters, methodHandle, this.isDeterministic());
    }

    private static Class<?> generateConcat(int arity) {
        ClassDefinition definition = new ClassDefinition(Access.a((Access[])new Access[]{Access.PUBLIC, Access.FINAL}), CompilerUtils.makeClassName((String)("Concat" + arity + "ScalarFunction")), ParameterizedType.type(Object.class), new ParameterizedType[0]);
        definition.declareDefaultConstructor(Access.a((Access[])new Access[]{Access.PRIVATE}));
        List parameters = (List)IntStream.range(0, arity).mapToObj(i -> Parameter.arg((String)("arg" + i), Slice.class)).collect(ImmutableCollectors.toImmutableList());
        MethodDefinition method = definition.declareMethod(Access.a((Access[])new Access[]{Access.PUBLIC, Access.STATIC}), "concat", ParameterizedType.type(Slice.class), (Iterable)parameters);
        Scope scope = method.getScope();
        BytecodeBlock body = method.getBody();
        Variable length = scope.declareVariable(Integer.TYPE, "length");
        body.append((BytecodeNode)length.set(BytecodeExpressions.constantInt((int)0)));
        for (int i2 = 0; i2 < arity; ++i2) {
            body.append((BytecodeNode)length.set(ConcatFunction.generateCheckedAdd((BytecodeExpression)length, ((Parameter)parameters.get(i2)).invoke("length", Integer.TYPE, new BytecodeExpression[0]))));
        }
        Variable result = scope.declareVariable(Slice.class, "result");
        body.append((BytecodeNode)result.set(BytecodeExpressions.invokeStatic(Slices.class, (String)"allocate", Slice.class, (BytecodeExpression[])new BytecodeExpression[]{length})));
        Variable position = scope.declareVariable(Integer.TYPE, "position");
        body.append((BytecodeNode)position.set(BytecodeExpressions.constantInt((int)0)));
        for (int i3 = 0; i3 < arity; ++i3) {
            body.append((BytecodeNode)result.invoke("setBytes", Void.TYPE, new BytecodeExpression[]{position, (BytecodeExpression)parameters.get(i3)}));
            body.append((BytecodeNode)position.set(BytecodeExpressions.add((BytecodeExpression)position, (BytecodeExpression)((Parameter)parameters.get(i3)).invoke("length", Integer.TYPE, new BytecodeExpression[0]))));
        }
        body.getVariable(result).retObject();
        return CompilerUtils.defineClass((ClassDefinition)definition, Object.class, (Map)ImmutableMap.of(), (ClassLoader)new DynamicClassLoader(ConcatFunction.class.getClassLoader()));
    }

    private static BytecodeExpression generateCheckedAdd(BytecodeExpression x, BytecodeExpression y) {
        return BytecodeExpressions.invokeStatic(ConcatFunction.class, (String)"checkedAdd", Integer.TYPE, (BytecodeExpression[])new BytecodeExpression[]{x, y});
    }

    public static int checkedAdd(int x, int y) {
        try {
            return Math.addExact(x, y);
        }
        catch (ArithmeticException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Concatenated string is too large");
        }
    }
}

