/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.index;

import com.facebook.presto.operator.LookupSource;
import com.facebook.presto.operator.LookupSourceSupplier;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.index.IndexBuildDriverFactoryProvider;
import com.facebook.presto.operator.index.IndexJoinLookupStats;
import com.facebook.presto.operator.index.IndexLoader;
import com.facebook.presto.operator.index.IndexLookupSource;
import com.facebook.presto.spi.type.Type;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.units.DataSize;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;

public class IndexLookupSourceSupplier
implements LookupSourceSupplier {
    private final List<Type> outputTypes;
    private final Supplier<IndexLoader> indexLoaderSupplier;

    public IndexLookupSourceSupplier(Set<Integer> lookupSourceInputChannels, List<Integer> keyOutputChannels, Optional<Integer> keyOutputHashChannel, List<Type> outputTypes, IndexBuildDriverFactoryProvider indexBuildDriverFactoryProvider, DataSize maxIndexMemorySize, IndexJoinLookupStats stats, boolean shareIndexLoading) {
        this.outputTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(outputTypes, "outputTypes is null"));
        if (shareIndexLoading) {
            IndexLoader shared = new IndexLoader(lookupSourceInputChannels, keyOutputChannels, keyOutputHashChannel, outputTypes, indexBuildDriverFactoryProvider, 10000, maxIndexMemorySize, stats);
            this.indexLoaderSupplier = () -> shared;
        } else {
            this.indexLoaderSupplier = () -> new IndexLoader(lookupSourceInputChannels, keyOutputChannels, keyOutputHashChannel, outputTypes, indexBuildDriverFactoryProvider, 10000, maxIndexMemorySize, stats);
        }
    }

    @Override
    public List<Type> getTypes() {
        return this.outputTypes;
    }

    @Override
    public ListenableFuture<LookupSource> getLookupSource(OperatorContext operatorContext) {
        IndexLoader indexLoader = this.indexLoaderSupplier.get();
        indexLoader.setContext(operatorContext.getDriverContext().getPipelineContext().getTaskContext());
        return Futures.immediateFuture((Object)new IndexLookupSource(indexLoader));
    }

    @Override
    public void release() {
    }

    @Override
    public void retain() {
    }
}

