/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.state;

import com.facebook.presto.operator.aggregation.state.AbstractGroupedAccumulatorState;
import com.facebook.presto.operator.aggregation.state.AccumulatorStateFactory;
import com.facebook.presto.operator.aggregation.state.DigestAndPercentileArrayState;
import com.facebook.presto.util.array.ObjectBigArray;
import io.airlift.stats.QuantileDigest;
import java.util.List;
import java.util.Objects;

public class DigestAndPercentileArrayStateFactory
implements AccumulatorStateFactory<DigestAndPercentileArrayState> {
    @Override
    public DigestAndPercentileArrayState createSingleState() {
        return new SingleDigestAndPercentileArrayState();
    }

    @Override
    public Class<? extends DigestAndPercentileArrayState> getSingleStateClass() {
        return SingleDigestAndPercentileArrayState.class;
    }

    @Override
    public DigestAndPercentileArrayState createGroupedState() {
        return new GroupedDigestAndPercentileArrayState();
    }

    @Override
    public Class<? extends DigestAndPercentileArrayState> getGroupedStateClass() {
        return GroupedDigestAndPercentileArrayState.class;
    }

    public static class SingleDigestAndPercentileArrayState
    implements DigestAndPercentileArrayState {
        private QuantileDigest digest;
        private List<Double> percentiles;

        @Override
        public QuantileDigest getDigest() {
            return this.digest;
        }

        @Override
        public void setDigest(QuantileDigest digest) {
            this.digest = Objects.requireNonNull(digest, "digest is null");
        }

        @Override
        public List<Double> getPercentiles() {
            return this.percentiles;
        }

        @Override
        public void setPercentiles(List<Double> percentiles) {
            this.percentiles = Objects.requireNonNull(percentiles, "percentiles is null");
        }

        @Override
        public void addMemoryUsage(int value) {
        }

        @Override
        public long getEstimatedSize() {
            if (this.digest == null) {
                return 8L;
            }
            return this.digest.estimatedInMemorySizeInBytes() + 8;
        }
    }

    public static class GroupedDigestAndPercentileArrayState
    extends AbstractGroupedAccumulatorState
    implements DigestAndPercentileArrayState {
        private final ObjectBigArray<QuantileDigest> digests = new ObjectBigArray();
        private final ObjectBigArray<List<Double>> percentilesArray = new ObjectBigArray();
        private long size;

        @Override
        public void ensureCapacity(long size) {
            this.digests.ensureCapacity(size);
            this.percentilesArray.ensureCapacity(size);
        }

        @Override
        public QuantileDigest getDigest() {
            return this.digests.get(this.getGroupId());
        }

        @Override
        public void setDigest(QuantileDigest digest) {
            this.digests.set(this.getGroupId(), Objects.requireNonNull(digest, "digest is null"));
        }

        @Override
        public List<Double> getPercentiles() {
            return this.percentilesArray.get(this.getGroupId());
        }

        @Override
        public void setPercentiles(List<Double> percentiles) {
            this.percentilesArray.set(this.getGroupId(), Objects.requireNonNull(percentiles, "percentiles is null"));
        }

        @Override
        public void addMemoryUsage(int value) {
            this.size += (long)value;
        }

        @Override
        public long getEstimatedSize() {
            return this.size + this.digests.sizeOf() + this.percentilesArray.sizeOf();
        }
    }
}

