/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.aggregation.NumericHistogram;
import com.facebook.presto.operator.aggregation.NumericHistogramAggregation;
import com.facebook.presto.operator.aggregation.state.AbstractGroupedAccumulatorState;
import com.facebook.presto.operator.aggregation.state.AccumulatorStateFactory;
import com.facebook.presto.util.array.ObjectBigArray;
import java.util.Objects;

public class NumericHistogramStateFactory
implements AccumulatorStateFactory<NumericHistogramAggregation.State> {
    @Override
    public NumericHistogramAggregation.State createSingleState() {
        return new SingleState();
    }

    @Override
    public Class<? extends NumericHistogramAggregation.State> getSingleStateClass() {
        return SingleState.class;
    }

    @Override
    public NumericHistogramAggregation.State createGroupedState() {
        return new GroupedState();
    }

    @Override
    public Class<? extends NumericHistogramAggregation.State> getGroupedStateClass() {
        return GroupedState.class;
    }

    public static class SingleState
    implements NumericHistogramAggregation.State {
        private NumericHistogram histogram;

        @Override
        public NumericHistogram get() {
            return this.histogram;
        }

        @Override
        public void set(NumericHistogram value) {
            this.histogram = value;
        }

        @Override
        public long getEstimatedSize() {
            if (this.histogram == null) {
                return 0L;
            }
            return this.histogram.estimatedInMemorySize();
        }
    }

    public static class GroupedState
    extends AbstractGroupedAccumulatorState
    implements NumericHistogramAggregation.State {
        private final ObjectBigArray<NumericHistogram> histograms = new ObjectBigArray();
        private long size;

        @Override
        public void ensureCapacity(long size) {
            this.histograms.ensureCapacity(size);
        }

        @Override
        public NumericHistogram get() {
            return this.histograms.get(this.getGroupId());
        }

        @Override
        public void set(NumericHistogram value) {
            Objects.requireNonNull(value, "value is null");
            NumericHistogram previous = this.get();
            if (previous != null) {
                this.size -= previous.estimatedInMemorySize();
            }
            this.histograms.set(this.getGroupId(), value);
            this.size += value.estimatedInMemorySize();
        }

        @Override
        public long getEstimatedSize() {
            return this.size + this.histograms.sizeOf();
        }
    }
}

