/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.aggregation.TypedSet;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.block.InterleavedBlockBuilder;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.type.ArrayType;
import com.facebook.presto.type.TypeUtils;
import com.facebook.presto.util.array.ObjectBigArray;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

public class KeyValuePairs {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(KeyValuePairs.class).instanceSize();
    private static final int EXPECTED_ENTRIES = 10;
    private static final int EXPECTED_ENTRY_SIZE = 16;
    private final TypedSet keySet;
    private final BlockBuilder keyBlockBuilder;
    private final Type keyType;
    private final BlockBuilder valueBlockBuilder;
    private final Type valueType;
    private final boolean isMultiValue;

    public KeyValuePairs(Type keyType, Type valueType) {
        this(keyType, valueType, false);
    }

    public KeyValuePairs(Type keyType, Type valueType, boolean isMultiValue) {
        this.keyType = Objects.requireNonNull(keyType, "keyType is null");
        this.valueType = Objects.requireNonNull(valueType, "valueType is null");
        this.keySet = new TypedSet(keyType, 10);
        this.keyBlockBuilder = this.keyType.createBlockBuilder(new BlockBuilderStatus(), 10, TypeUtils.expectedValueSize(keyType, 16));
        this.valueBlockBuilder = this.valueType.createBlockBuilder(new BlockBuilderStatus(), 10, TypeUtils.expectedValueSize(valueType, 16));
        this.isMultiValue = isMultiValue;
    }

    public KeyValuePairs(Block serialized, Type keyType, Type valueType, boolean isMultiValue) {
        this(keyType, valueType, isMultiValue);
        this.deserialize(Objects.requireNonNull(serialized, "serialized is null"));
    }

    public Block getKeys() {
        return this.keyBlockBuilder.build();
    }

    public Block getValues() {
        return this.valueBlockBuilder.build();
    }

    private void deserialize(Block block) {
        for (int i = 0; i < block.getPositionCount(); i += 2) {
            this.add(block, block, i, i + 1);
        }
    }

    public Block serialize() {
        Block keys = this.keyBlockBuilder.build();
        Block values = this.valueBlockBuilder.build();
        InterleavedBlockBuilder blockBuilder = new InterleavedBlockBuilder((List)ImmutableList.of((Object)this.keyType, (Object)this.valueType), new BlockBuilderStatus(), keys.getPositionCount() * 2);
        for (int i = 0; i < keys.getPositionCount(); ++i) {
            this.keyType.appendTo(keys, i, (BlockBuilder)blockBuilder);
            this.valueType.appendTo(values, i, (BlockBuilder)blockBuilder);
        }
        return blockBuilder.build();
    }

    public Block toMapNativeEncoding() {
        if (this.isMultiValue) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INTERNAL_ERROR, "This KeyValuePairs is multimap.");
        }
        return this.serialize();
    }

    public Block toMultimapNativeEncoding() {
        if (!this.isMultiValue) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INTERNAL_ERROR, "This KeyValuePairs is not multimap.");
        }
        Block keys = this.keyBlockBuilder.build();
        Block values = this.valueBlockBuilder.build();
        BlockBuilder distinctKeyBlockBuilder = this.keyType.createBlockBuilder(new BlockBuilderStatus(), keys.getPositionCount(), TypeUtils.expectedValueSize(this.keyType, 16));
        ObjectBigArray<BlockBuilder> valueArrayBlockBuilders = new ObjectBigArray<BlockBuilder>();
        valueArrayBlockBuilders.ensureCapacity(keys.getPositionCount());
        TypedSet keySet = new TypedSet(this.keyType, keys.getPositionCount());
        for (int keyValueIndex = 0; keyValueIndex < keys.getPositionCount(); ++keyValueIndex) {
            if (!keySet.contains(keys, keyValueIndex)) {
                keySet.add(keys, keyValueIndex);
                this.keyType.appendTo(keys, keyValueIndex, distinctKeyBlockBuilder);
                BlockBuilder valueArrayBuilder = this.valueType.createBlockBuilder(new BlockBuilderStatus(), 10, TypeUtils.expectedValueSize(this.valueType, 16));
                valueArrayBlockBuilders.set(keySet.positionOf(keys, keyValueIndex), valueArrayBuilder);
            }
            this.valueType.appendTo(values, keyValueIndex, (BlockBuilder)valueArrayBlockBuilders.get(keySet.positionOf(keys, keyValueIndex)));
        }
        Block distinctKeys = distinctKeyBlockBuilder.build();
        ArrayType valueArrayType = new ArrayType(this.valueType);
        InterleavedBlockBuilder multimapBlockBuilder = new InterleavedBlockBuilder((List)ImmutableList.of((Object)this.keyType, (Object)((Object)valueArrayType)), new BlockBuilderStatus(), distinctKeyBlockBuilder.getPositionCount());
        for (int i = 0; i < distinctKeys.getPositionCount(); ++i) {
            this.keyType.appendTo(distinctKeys, i, (BlockBuilder)multimapBlockBuilder);
            valueArrayType.writeObject((BlockBuilder)multimapBlockBuilder, ((BlockBuilder)valueArrayBlockBuilders.get(i)).build());
        }
        return multimapBlockBuilder.build();
    }

    public long estimatedInMemorySize() {
        long size = INSTANCE_SIZE;
        size += (long)this.keyBlockBuilder.getRetainedSizeInBytes();
        size += (long)this.valueBlockBuilder.getRetainedSizeInBytes();
        return size += this.keySet.getRetainedSizeInBytes();
    }

    public void add(Block key, Block value, int keyPosition, int valuePosition) {
        if (this.isMultiValue || !this.keySet.contains(key, keyPosition)) {
            this.keySet.add(key, keyPosition);
            this.keyType.appendTo(key, keyPosition, this.keyBlockBuilder);
            if (value.isNull(valuePosition)) {
                this.valueBlockBuilder.appendNull();
            } else {
                this.valueType.appendTo(value, valuePosition, this.valueBlockBuilder);
            }
        }
    }
}

