/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.aggregation.AggregationFunction;
import com.facebook.presto.operator.aggregation.AggregationUtils;
import com.facebook.presto.operator.aggregation.CombineFunction;
import com.facebook.presto.operator.aggregation.InputFunction;
import com.facebook.presto.operator.aggregation.OutputFunction;
import com.facebook.presto.operator.aggregation.state.CovarianceState;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.type.SqlType;

@AggregationFunction(value="")
public class CovarianceAggregation {
    private CovarianceAggregation() {
    }

    @InputFunction
    public static void input(CovarianceState state, @SqlType(value="double") double dependentValue, @SqlType(value="double") double independentValue) {
        AggregationUtils.updateCovarianceState(state, independentValue, dependentValue);
    }

    @CombineFunction
    public static void combine(CovarianceState state, CovarianceState otherState) {
        AggregationUtils.mergeCovarianceState(state, otherState);
    }

    @AggregationFunction(value="covar_samp")
    @OutputFunction(value="double")
    public static void covarSamp(CovarianceState state, BlockBuilder out) {
        if (state.getCount() <= 1L) {
            out.appendNull();
        } else {
            double result = (state.getSumXY() - state.getSumX() * state.getSumY() / (double)state.getCount()) / (double)(state.getCount() - 1L);
            DoubleType.DOUBLE.writeDouble(out, result);
        }
    }

    @AggregationFunction(value="covar_pop")
    @OutputFunction(value="double")
    public static void covarPop(CovarianceState state, BlockBuilder out) {
        if (state.getCount() == 0L) {
            out.appendNull();
        } else {
            double result = (state.getSumXY() - state.getSumX() * state.getSumY() / (double)state.getCount()) / (double)state.getCount();
            DoubleType.DOUBLE.writeDouble(out, result);
        }
    }
}

