/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.GroupByHash;
import com.facebook.presto.operator.GroupByIdBlock;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.util.array.LongBigArray;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class RowNumberOperator
implements Operator {
    private final OperatorContext operatorContext;
    private boolean finishing;
    private final int[] outputChannels;
    private final List<Type> types;
    private GroupByIdBlock partitionIds;
    private final Optional<GroupByHash> groupByHash;
    private Page inputPage;
    private final LongBigArray partitionRowCount;
    private final Optional<Integer> maxRowsPerPartition;

    public RowNumberOperator(OperatorContext operatorContext, List<Type> sourceTypes, List<Integer> outputChannels, List<Integer> partitionChannels, List<Type> partitionTypes, Optional<Integer> maxRowsPerPartition, Optional<Integer> hashChannel, int expectedPositions) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.outputChannels = Ints.toArray(outputChannels);
        this.maxRowsPerPartition = maxRowsPerPartition;
        this.partitionRowCount = new LongBigArray(0L);
        if (partitionChannels.isEmpty()) {
            this.groupByHash = Optional.empty();
        } else {
            int[] channels = Ints.toArray(partitionChannels);
            this.groupByHash = Optional.of(GroupByHash.createGroupByHash(operatorContext.getSession(), partitionTypes, channels, Optional.empty(), hashChannel, expectedPositions));
        }
        this.types = RowNumberOperator.toTypes(sourceTypes, outputChannels);
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public List<Type> getTypes() {
        return this.types;
    }

    @Override
    public void finish() {
        this.finishing = true;
    }

    @Override
    public boolean isFinished() {
        if (this.isSinglePartition() && this.maxRowsPerPartition.isPresent()) {
            if (this.finishing && this.inputPage == null) {
                return true;
            }
            return this.partitionRowCount.get(0L) == (long)this.maxRowsPerPartition.get().intValue();
        }
        return this.finishing && this.inputPage == null;
    }

    @Override
    public boolean needsInput() {
        if (this.isSinglePartition() && this.maxRowsPerPartition.isPresent()) {
            return this.partitionRowCount.get(0L) < (long)this.maxRowsPerPartition.get().intValue() && !this.finishing && this.inputPage == null;
        }
        return !this.finishing && this.inputPage == null;
    }

    private long getEstimatedByteSize() {
        return this.groupByHash.map(GroupByHash::getEstimatedSize).orElse(0L) + this.partitionRowCount.sizeOf();
    }

    @Override
    public void addInput(Page page) {
        Preconditions.checkState((!this.finishing ? 1 : 0) != 0, (Object)"Operator is already finishing");
        Objects.requireNonNull(page, "page is null");
        Preconditions.checkState((this.inputPage == null ? 1 : 0) != 0);
        this.inputPage = page;
        if (this.groupByHash.isPresent()) {
            this.partitionIds = this.groupByHash.get().getGroupIds(this.inputPage);
            this.partitionRowCount.ensureCapacity(this.partitionIds.getGroupCount());
        }
        this.operatorContext.setMemoryReservation(this.getEstimatedByteSize());
    }

    @Override
    public Page getOutput() {
        if (this.inputPage == null) {
            return null;
        }
        Page outputPage = this.maxRowsPerPartition.isPresent() ? this.getSelectedRows() : this.getRowsWithRowNumber();
        this.inputPage = null;
        this.operatorContext.setMemoryReservation(this.getEstimatedByteSize());
        return outputPage;
    }

    private boolean isSinglePartition() {
        return !this.groupByHash.isPresent();
    }

    private Page getRowsWithRowNumber() {
        Block rowNumberBlock = this.createRowNumberBlock();
        Block[] sourceBlocks = new Block[this.inputPage.getChannelCount()];
        for (int i = 0; i < this.outputChannels.length; ++i) {
            sourceBlocks[i] = this.inputPage.getBlock(this.outputChannels[i]);
        }
        Block[] outputBlocks = Arrays.copyOf(sourceBlocks, sourceBlocks.length + 1);
        outputBlocks[sourceBlocks.length] = rowNumberBlock;
        return new Page(this.inputPage.getPositionCount(), outputBlocks);
    }

    private Block createRowNumberBlock() {
        BlockBuilder rowNumberBlock = BigintType.BIGINT.createFixedSizeBlockBuilder(this.inputPage.getPositionCount());
        for (int currentPosition = 0; currentPosition < this.inputPage.getPositionCount(); ++currentPosition) {
            long partitionId = this.getPartitionId(currentPosition);
            long nextRowCount = this.partitionRowCount.get(partitionId) + 1L;
            BigintType.BIGINT.writeLong(rowNumberBlock, nextRowCount);
            this.partitionRowCount.set(partitionId, nextRowCount);
        }
        return rowNumberBlock.build();
    }

    private Page getSelectedRows() {
        PageBuilder pageBuilder = new PageBuilder(this.types);
        int rowNumberChannel = this.types.size() - 1;
        for (int currentPosition = 0; currentPosition < this.inputPage.getPositionCount(); ++currentPosition) {
            long partitionId = this.getPartitionId(currentPosition);
            long rowCount = this.partitionRowCount.get(partitionId);
            if (rowCount == (long)this.maxRowsPerPartition.get().intValue()) continue;
            pageBuilder.declarePosition();
            for (int i = 0; i < this.outputChannels.length; ++i) {
                int channel = this.outputChannels[i];
                Type type = this.types.get(channel);
                type.appendTo(this.inputPage.getBlock(channel), currentPosition, pageBuilder.getBlockBuilder(i));
            }
            BigintType.BIGINT.writeLong(pageBuilder.getBlockBuilder(rowNumberChannel), rowCount + 1L);
            this.partitionRowCount.set(partitionId, rowCount + 1L);
        }
        if (pageBuilder.isEmpty()) {
            return null;
        }
        return pageBuilder.build();
    }

    private long getPartitionId(int position) {
        return this.isSinglePartition() ? 0L : this.partitionIds.getGroupId(position);
    }

    private static List<Type> toTypes(List<? extends Type> sourceTypes, List<Integer> outputChannels) {
        ImmutableList.Builder types = ImmutableList.builder();
        for (int channel : outputChannels) {
            types.add((Object)sourceTypes.get(channel));
        }
        types.add((Object)BigintType.BIGINT);
        return types.build();
    }

    public static class RowNumberOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final Optional<Integer> maxRowsPerPartition;
        private final List<Type> sourceTypes;
        private final List<Integer> outputChannels;
        private final List<Integer> partitionChannels;
        private final List<Type> partitionTypes;
        private final Optional<Integer> hashChannel;
        private final int expectedPositions;
        private final List<Type> types;
        private boolean closed;

        public RowNumberOperatorFactory(int operatorId, PlanNodeId planNodeId, List<? extends Type> sourceTypes, List<Integer> outputChannels, List<Integer> partitionChannels, List<? extends Type> partitionTypes, Optional<Integer> maxRowsPerPartition, Optional<Integer> hashChannel, int expectedPositions) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.sourceTypes = ImmutableList.copyOf(sourceTypes);
            this.outputChannels = ImmutableList.copyOf((Collection)Objects.requireNonNull(outputChannels, "outputChannels is null"));
            this.partitionChannels = ImmutableList.copyOf((Collection)Objects.requireNonNull(partitionChannels, "partitionChannels is null"));
            this.partitionTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(partitionTypes, "partitionTypes is null"));
            this.maxRowsPerPartition = Objects.requireNonNull(maxRowsPerPartition, "maxRowsPerPartition is null");
            this.hashChannel = Objects.requireNonNull(hashChannel, "hashChannel is null");
            Preconditions.checkArgument((expectedPositions > 0 ? 1 : 0) != 0, (Object)"expectedPositions < 0");
            this.expectedPositions = expectedPositions;
            this.types = RowNumberOperator.toTypes(sourceTypes, outputChannels);
        }

        @Override
        public List<Type> getTypes() {
            return this.types;
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.planNodeId, RowNumberOperator.class.getSimpleName());
            return new RowNumberOperator(operatorContext, this.sourceTypes, this.outputChannels, this.partitionChannels, this.partitionTypes, this.maxRowsPerPartition, this.hashChannel, this.expectedPositions);
        }

        @Override
        public void close() {
            this.closed = true;
        }

        @Override
        public OperatorFactory duplicate() {
            return new RowNumberOperatorFactory(this.operatorId, this.planNodeId, this.sourceTypes, this.outputChannels, this.partitionChannels, this.partitionTypes, this.maxRowsPerPartition, this.hashChannel, this.expectedPositions);
        }
    }
}

