/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.scheduler;

import com.facebook.presto.execution.SqlStageExecution;
import com.facebook.presto.execution.StageState;
import com.facebook.presto.execution.scheduler.ExecutionSchedule;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;

public class LegacyExecutionSchedule
implements ExecutionSchedule {
    private final Set<SqlStageExecution> schedulingStages;

    public LegacyExecutionSchedule(Collection<SqlStageExecution> stages) {
        this.schedulingStages = new HashSet<SqlStageExecution>(Objects.requireNonNull(stages, "stages is null"));
    }

    @Override
    public Set<SqlStageExecution> getStagesToSchedule() {
        Iterator<SqlStageExecution> iterator = this.schedulingStages.iterator();
        while (iterator.hasNext()) {
            StageState state = iterator.next().getState();
            if (state != StageState.SCHEDULED && state != StageState.RUNNING && !state.isDone()) continue;
            iterator.remove();
        }
        return this.schedulingStages;
    }

    @Override
    public boolean isFinished() {
        return this.schedulingStages.isEmpty();
    }
}

