/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto;

import com.facebook.presto.Session;
import com.facebook.presto.execution.QueryManagerConfig;
import com.facebook.presto.execution.TaskManagerConfig;
import com.facebook.presto.memory.MemoryManagerConfig;
import com.facebook.presto.spi.session.PropertyMetadata;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.google.common.collect.ImmutableList;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.util.List;
import javax.inject.Inject;

public final class SystemSessionProperties {
    public static final String OPTIMIZE_HASH_GENERATION = "optimize_hash_generation";
    public static final String DISTRIBUTED_JOIN = "distributed_join";
    public static final String DISTRIBUTED_INDEX_JOIN = "distributed_index_join";
    public static final String HASH_PARTITION_COUNT = "hash_partition_count";
    public static final String PREFER_STREAMING_OPERATORS = "prefer_streaming_operators";
    public static final String TASK_WRITER_COUNT = "task_writer_count";
    public static final String TASK_JOIN_CONCURRENCY = "task_join_concurrency";
    public static final String TASK_HASH_BUILD_CONCURRENCY = "task_hash_build_concurrency";
    public static final String TASK_AGGREGATION_CONCURRENCY = "task_aggregation_concurrency";
    public static final String TASK_INTERMEDIATE_AGGREGATION = "task_intermediate_aggregation";
    public static final String TASK_SHARE_INDEX_LOADING = "task_share_index_loading";
    public static final String QUERY_MAX_MEMORY = "query_max_memory";
    public static final String QUERY_MAX_RUN_TIME = "query_max_run_time";
    public static final String RESOURCE_OVERCOMMIT = "resource_overcommit";
    public static final String REDISTRIBUTE_WRITES = "redistribute_writes";
    public static final String PUSH_TABLE_WRITE_THROUGH_UNION = "push_table_write_through_union";
    public static final String EXECUTION_POLICY = "execution_policy";
    public static final String COLUMNAR_PROCESSING = "columnar_processing";
    public static final String COLUMNAR_PROCESSING_DICTIONARY = "columnar_processing_dictionary";
    public static final String DICTIONARY_AGGREGATION = "dictionary_aggregation";
    public static final String PLAN_WITH_TABLE_NODE_PARTITIONING = "plan_with_table_node_partitioning";
    public static final String INITIAL_SPLITS_PER_NODE = "initial_splits_per_node";
    public static final String SPLIT_CONCURRENCY_ADJUSTMENT_INTERVAL = "split_concurrency_adjustment_interval";
    public static final String OPTIMIZE_METADATA_QUERIES = "optimize_metadata_queries";
    private final List<PropertyMetadata<?>> sessionProperties;

    public SystemSessionProperties() {
        this(new QueryManagerConfig(), new TaskManagerConfig(), new MemoryManagerConfig(), new FeaturesConfig());
    }

    @Inject
    public SystemSessionProperties(QueryManagerConfig queryManagerConfig, TaskManagerConfig taskManagerConfig, MemoryManagerConfig memoryManagerConfig, FeaturesConfig featuresConfig) {
        this.sessionProperties = ImmutableList.of((Object)PropertyMetadata.stringSessionProperty((String)EXECUTION_POLICY, (String)"Policy used for scheduling query tasks", (String)queryManagerConfig.getQueryExecutionPolicy(), (boolean)false), (Object)PropertyMetadata.booleanSessionProperty((String)OPTIMIZE_HASH_GENERATION, (String)"Compute hash codes for distribution, joins, and aggregations early in query plan", (Boolean)featuresConfig.isOptimizeHashGeneration(), (boolean)false), (Object)PropertyMetadata.booleanSessionProperty((String)DISTRIBUTED_JOIN, (String)"Use a distributed join instead of a broadcast join", (Boolean)featuresConfig.isDistributedJoinsEnabled(), (boolean)false), (Object)PropertyMetadata.booleanSessionProperty((String)DISTRIBUTED_INDEX_JOIN, (String)"Distribute index joins on join keys instead of executing inline", (Boolean)featuresConfig.isDistributedIndexJoinsEnabled(), (boolean)false), (Object)PropertyMetadata.integerSessionProperty((String)HASH_PARTITION_COUNT, (String)"Number of partitions for distributed joins and aggregations", (Integer)queryManagerConfig.getInitialHashPartitions(), (boolean)false), (Object)PropertyMetadata.booleanSessionProperty((String)PREFER_STREAMING_OPERATORS, (String)"Prefer source table layouts that produce streaming operators", (Boolean)false, (boolean)false), (Object)PropertyMetadata.integerSessionProperty((String)TASK_WRITER_COUNT, (String)"Default number of local parallel table writer jobs per worker", (Integer)taskManagerConfig.getWriterCount(), (boolean)false), (Object)PropertyMetadata.booleanSessionProperty((String)REDISTRIBUTE_WRITES, (String)"Force parallel distributed writes", (Boolean)featuresConfig.isRedistributeWrites(), (boolean)false), (Object)PropertyMetadata.booleanSessionProperty((String)PUSH_TABLE_WRITE_THROUGH_UNION, (String)"Parallelize writes when using UNION ALL in queries that write data", (Boolean)featuresConfig.isPushTableWriteThroughUnion(), (boolean)false), (Object)PropertyMetadata.integerSessionProperty((String)TASK_JOIN_CONCURRENCY, (String)"Experimental: Default number of local parallel join jobs per worker", (Integer)taskManagerConfig.getTaskJoinConcurrency(), (boolean)false), (Object)PropertyMetadata.integerSessionProperty((String)TASK_HASH_BUILD_CONCURRENCY, (String)"Experimental: Default number of local parallel hash build jobs per worker", (Integer)taskManagerConfig.getTaskDefaultConcurrency(), (boolean)false), (Object)PropertyMetadata.integerSessionProperty((String)TASK_AGGREGATION_CONCURRENCY, (String)"Experimental: Default number of local parallel aggregation jobs per worker", (Integer)taskManagerConfig.getTaskDefaultConcurrency(), (boolean)false), (Object[])new PropertyMetadata[]{PropertyMetadata.booleanSessionProperty((String)TASK_INTERMEDIATE_AGGREGATION, (String)"Experimental: add intermediate aggregation jobs per worker", (Boolean)featuresConfig.isIntermediateAggregationsEnabled(), (boolean)false), PropertyMetadata.booleanSessionProperty((String)TASK_SHARE_INDEX_LOADING, (String)"Share index join lookups and caching within a task", (Boolean)taskManagerConfig.isShareIndexLoading(), (boolean)false), new PropertyMetadata(QUERY_MAX_RUN_TIME, "Maximum run time of a query", (Type)VarcharType.VARCHAR, Duration.class, (Object)queryManagerConfig.getQueryMaxRunTime(), false, value -> Duration.valueOf((String)((String)value))), new PropertyMetadata(QUERY_MAX_MEMORY, "Maximum amount of distributed memory a query can use", (Type)VarcharType.VARCHAR, DataSize.class, (Object)memoryManagerConfig.getMaxQueryMemory(), true, value -> DataSize.valueOf((String)((String)value))), PropertyMetadata.booleanSessionProperty((String)RESOURCE_OVERCOMMIT, (String)"Use resources which are not guaranteed to be available to the query", (Boolean)false, (boolean)false), PropertyMetadata.booleanSessionProperty((String)COLUMNAR_PROCESSING, (String)"Use columnar processing", (Boolean)featuresConfig.isColumnarProcessing(), (boolean)false), PropertyMetadata.booleanSessionProperty((String)COLUMNAR_PROCESSING_DICTIONARY, (String)"Use columnar processing with optimizations for dictionaries", (Boolean)featuresConfig.isColumnarProcessingDictionary(), (boolean)false), PropertyMetadata.booleanSessionProperty((String)DICTIONARY_AGGREGATION, (String)"Enable optimization for aggregations on dictionaries", (Boolean)featuresConfig.isDictionaryAggregation(), (boolean)false), PropertyMetadata.integerSessionProperty((String)INITIAL_SPLITS_PER_NODE, (String)"The number of splits each node will run per task, initially", (Integer)taskManagerConfig.getInitialSplitsPerNode(), (boolean)false), new PropertyMetadata(SPLIT_CONCURRENCY_ADJUSTMENT_INTERVAL, "Experimental: Interval between changes to the number of concurrent splits per node", (Type)VarcharType.VARCHAR, Duration.class, (Object)taskManagerConfig.getSplitConcurrencyAdjustmentInterval(), false, value -> Duration.valueOf((String)((String)value))), PropertyMetadata.booleanSessionProperty((String)OPTIMIZE_METADATA_QUERIES, (String)"Enable optimization for metadata queries", (Boolean)featuresConfig.isOptimizeMetadataQueries(), (boolean)false), PropertyMetadata.booleanSessionProperty((String)PLAN_WITH_TABLE_NODE_PARTITIONING, (String)"Experimental: Adapt plan to pre-partitioned tables", (Boolean)true, (boolean)false)});
    }

    public List<PropertyMetadata<?>> getSessionProperties() {
        return this.sessionProperties;
    }

    public static String getExecutionPolicy(Session session) {
        return session.getProperty(EXECUTION_POLICY, String.class);
    }

    public static boolean isOptimizeHashGenerationEnabled(Session session) {
        return session.getProperty(OPTIMIZE_HASH_GENERATION, Boolean.class);
    }

    public static boolean isDistributedJoinEnabled(Session session) {
        return session.getProperty(DISTRIBUTED_JOIN, Boolean.class);
    }

    public static boolean isDistributedIndexJoinEnabled(Session session) {
        return session.getProperty(DISTRIBUTED_INDEX_JOIN, Boolean.class);
    }

    public static int getHashPartitionCount(Session session) {
        return session.getProperty(HASH_PARTITION_COUNT, Integer.class);
    }

    public static boolean preferStreamingOperators(Session session) {
        return session.getProperty(PREFER_STREAMING_OPERATORS, Boolean.class);
    }

    public static int getTaskWriterCount(Session session) {
        return session.getProperty(TASK_WRITER_COUNT, Integer.class);
    }

    public static boolean isRedistributeWrites(Session session) {
        return session.getProperty(REDISTRIBUTE_WRITES, Boolean.class);
    }

    public static boolean isPushTableWriteThroughUnion(Session session) {
        return session.getProperty(PUSH_TABLE_WRITE_THROUGH_UNION, Boolean.class);
    }

    public static int getTaskJoinConcurrency(Session session) {
        return session.getProperty(TASK_JOIN_CONCURRENCY, Integer.class);
    }

    public static int getTaskHashBuildConcurrency(Session session) {
        return session.getProperty(TASK_HASH_BUILD_CONCURRENCY, Integer.class);
    }

    public static int getTaskAggregationConcurrency(Session session) {
        return session.getProperty(TASK_AGGREGATION_CONCURRENCY, Integer.class);
    }

    public static boolean isIntermediateAggregation(Session session) {
        return session.getProperty(TASK_INTERMEDIATE_AGGREGATION, Boolean.class);
    }

    public static boolean isShareIndexLoading(Session session) {
        return session.getProperty(TASK_SHARE_INDEX_LOADING, Boolean.class);
    }

    public static boolean isColumnarProcessingEnabled(Session session) {
        return session.getProperty(COLUMNAR_PROCESSING, Boolean.class);
    }

    public static boolean isColumnarProcessingDictionaryEnabled(Session session) {
        return session.getProperty(COLUMNAR_PROCESSING_DICTIONARY, Boolean.class);
    }

    public static boolean isDictionaryAggregationEnabled(Session session) {
        return session.getProperty(DICTIONARY_AGGREGATION, Boolean.class);
    }

    public static boolean isOptimizeMetadataQueries(Session session) {
        return session.getProperty(OPTIMIZE_METADATA_QUERIES, Boolean.class);
    }

    public static DataSize getQueryMaxMemory(Session session) {
        return session.getProperty(QUERY_MAX_MEMORY, DataSize.class);
    }

    public static Duration getQueryMaxRunTime(Session session) {
        return session.getProperty(QUERY_MAX_RUN_TIME, Duration.class);
    }

    public static boolean resourceOvercommit(Session session) {
        return session.getProperty(RESOURCE_OVERCOMMIT, Boolean.class);
    }

    public static boolean planWithTableNodePartitioning(Session session) {
        return session.getProperty(PLAN_WITH_TABLE_NODE_PARTITIONING, Boolean.class);
    }

    public static int getInitialSplitsPerNode(Session session) {
        return session.getProperty(INITIAL_SPLITS_PER_NODE, Integer.class);
    }

    public static Duration getSplitConcurrencyAdjustmentInterval(Session session) {
        return session.getProperty(SPLIT_CONCURRENCY_ADJUSTMENT_INTERVAL, Duration.class);
    }
}

