/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.sql.analyzer.RelationType;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

class RelationPlan {
    private final PlanNode root;
    private final List<Symbol> outputSymbols;
    private final RelationType descriptor;
    private final Optional<Symbol> sampleWeight;

    public RelationPlan(PlanNode root, RelationType descriptor, List<Symbol> outputSymbols, Optional<Symbol> sampleWeight) {
        Objects.requireNonNull(root, "root is null");
        Objects.requireNonNull(outputSymbols, "outputSymbols is null");
        Objects.requireNonNull(descriptor, "descriptor is null");
        Objects.requireNonNull(descriptor, "sampleWeight is null");
        Preconditions.checkArgument((descriptor.getAllFieldCount() == outputSymbols.size() ? 1 : 0) != 0, (String)"Number of outputs (%s) doesn't match descriptor size (%s)", (Object[])new Object[]{outputSymbols.size(), descriptor.getAllFieldCount()});
        this.root = root;
        this.descriptor = descriptor;
        this.outputSymbols = ImmutableList.copyOf(outputSymbols);
        this.sampleWeight = sampleWeight;
    }

    public Optional<Symbol> getSampleWeight() {
        return this.sampleWeight;
    }

    public Symbol getSymbol(int fieldIndex) {
        Preconditions.checkArgument((fieldIndex >= 0 && fieldIndex < this.outputSymbols.size() && this.outputSymbols.get(fieldIndex) != null ? 1 : 0) != 0, (String)"No field->symbol mapping for field %s", (Object[])new Object[]{fieldIndex});
        return this.outputSymbols.get(fieldIndex);
    }

    public PlanNode getRoot() {
        return this.root;
    }

    public List<Symbol> getOutputSymbols() {
        return this.outputSymbols;
    }

    public RelationType getDescriptor() {
        return this.descriptor;
    }
}

