/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.spi.predicate.NullableValue;
import com.facebook.presto.sql.planner.PartitioningHandle;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.util.ImmutableCollectors;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class PartitionFunctionBinding {
    private final PartitioningHandle partitioningHandle;
    private final List<Symbol> outputLayout;
    private final List<PartitionFunctionArgumentBinding> partitionFunctionArguments;
    private final Optional<Symbol> hashColumn;
    private final boolean replicateNulls;
    private final Optional<int[]> bucketToPartition;

    public PartitionFunctionBinding(PartitioningHandle partitioningHandle, List<Symbol> outputLayout, List<PartitionFunctionArgumentBinding> partitionFunctionArguments) {
        this(partitioningHandle, outputLayout, partitionFunctionArguments, Optional.empty(), false, Optional.empty());
    }

    public PartitionFunctionBinding(PartitioningHandle partitioningHandle, List<Symbol> outputLayout, List<PartitionFunctionArgumentBinding> partitionFunctionArguments, Optional<Symbol> hashColumn) {
        this(partitioningHandle, outputLayout, partitionFunctionArguments, hashColumn, false, Optional.empty());
    }

    @JsonCreator
    public PartitionFunctionBinding(@JsonProperty(value="partitioningHandle") PartitioningHandle partitioningHandle, @JsonProperty(value="outputLayout") List<Symbol> outputLayout, @JsonProperty(value="partitionFunctionArguments") List<PartitionFunctionArgumentBinding> partitionFunctionArguments, @JsonProperty(value="hashColumn") Optional<Symbol> hashColumn, @JsonProperty(value="replicateNulls") boolean replicateNulls, @JsonProperty(value="bucketToPartition") Optional<int[]> bucketToPartition) {
        this.partitioningHandle = Objects.requireNonNull(partitioningHandle, "partitioningHandle is null");
        this.outputLayout = ImmutableList.copyOf((Collection)Objects.requireNonNull(outputLayout, "outputLayout is null"));
        this.partitionFunctionArguments = ImmutableList.copyOf((Collection)Objects.requireNonNull(partitionFunctionArguments, "partitionFunctionArguments is null"));
        List partitionFunctionColumns = (List)partitionFunctionArguments.stream().filter(PartitionFunctionArgumentBinding::isVariable).map(PartitionFunctionArgumentBinding::getColumn).collect(ImmutableCollectors.toImmutableList());
        Preconditions.checkArgument((boolean)ImmutableSet.copyOf(outputLayout).containsAll((Collection)partitionFunctionColumns), (String)"Output layout (%s) don't include all partition columns (%s)", (Object[])new Object[]{outputLayout, partitionFunctionColumns});
        this.hashColumn = Objects.requireNonNull(hashColumn, "hashColumn is null");
        hashColumn.ifPresent(column -> Preconditions.checkArgument((boolean)outputLayout.contains(column), (String)"Output layout (%s) don't include hash column (%s)", (Object[])new Object[]{outputLayout, column}));
        Preconditions.checkArgument((!replicateNulls || partitionFunctionArguments.size() == 1 ? 1 : 0) != 0, (Object)"size of partitionFunctionArguments is not 1 when nullPartition is REPLICATE.");
        Preconditions.checkArgument((!replicateNulls || partitionFunctionArguments.get(0).isVariable() ? 1 : 0) != 0, (Object)"partition function argument must be variable when nullPartition is REPLICATE.");
        this.replicateNulls = replicateNulls;
        this.bucketToPartition = Objects.requireNonNull(bucketToPartition, "bucketToPartition is null");
    }

    @JsonProperty
    public PartitioningHandle getPartitioningHandle() {
        return this.partitioningHandle;
    }

    @JsonProperty
    public List<Symbol> getOutputLayout() {
        return this.outputLayout;
    }

    @JsonProperty
    public List<PartitionFunctionArgumentBinding> getPartitionFunctionArguments() {
        return this.partitionFunctionArguments;
    }

    @JsonProperty
    public Optional<Symbol> getHashColumn() {
        return this.hashColumn;
    }

    @JsonProperty
    public boolean isReplicateNulls() {
        return this.replicateNulls;
    }

    @JsonProperty
    public Optional<int[]> getBucketToPartition() {
        return this.bucketToPartition;
    }

    public PartitionFunctionBinding withBucketToPartition(Optional<int[]> bucketToPartition) {
        return new PartitionFunctionBinding(this.partitioningHandle, this.outputLayout, this.partitionFunctionArguments, this.hashColumn, this.replicateNulls, bucketToPartition);
    }

    public PartitionFunctionBinding translateOutputLayout(List<Symbol> newOutputLayout) {
        Objects.requireNonNull(newOutputLayout, "newOutputLayout is null");
        Preconditions.checkArgument((newOutputLayout.size() == this.outputLayout.size() ? 1 : 0) != 0);
        List newPartitioningColumns = (List)this.partitionFunctionArguments.stream().map(argument -> this.translateOutputLayout((PartitionFunctionArgumentBinding)argument, newOutputLayout)).collect(ImmutableCollectors.toImmutableList());
        Optional<Symbol> newHashSymbol = this.hashColumn.map(this.outputLayout::indexOf).map(newOutputLayout::get);
        return new PartitionFunctionBinding(this.partitioningHandle, newOutputLayout, newPartitioningColumns, newHashSymbol, this.replicateNulls, this.bucketToPartition);
    }

    private PartitionFunctionArgumentBinding translateOutputLayout(PartitionFunctionArgumentBinding argumentBinding, List<Symbol> newOutputLayout) {
        if (argumentBinding.isConstant()) {
            return argumentBinding;
        }
        int symbolIndex = this.outputLayout.indexOf(argumentBinding.getColumn());
        return new PartitionFunctionArgumentBinding(newOutputLayout.get(symbolIndex));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartitionFunctionBinding that = (PartitionFunctionBinding)o;
        return Objects.equals(this.partitioningHandle, that.partitioningHandle) && Objects.equals(this.outputLayout, that.outputLayout) && Objects.equals(this.partitionFunctionArguments, that.partitionFunctionArguments) && this.replicateNulls == that.replicateNulls && Objects.equals(this.bucketToPartition, that.bucketToPartition);
    }

    public int hashCode() {
        return Objects.hash(this.partitioningHandle, this.outputLayout, this.partitionFunctionArguments, this.replicateNulls, this.bucketToPartition);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("partitioningHandle", (Object)this.partitioningHandle).add("outputLayout", this.outputLayout).add("partitioningChannels", this.partitionFunctionArguments).add("hashChannel", this.hashColumn).add("replicateNulls", this.replicateNulls).add("bucketToPartition", this.bucketToPartition).toString();
    }

    public static final class PartitionFunctionArgumentBinding {
        private final Symbol column;
        private final NullableValue constant;

        public PartitionFunctionArgumentBinding(Symbol column) {
            this.column = Objects.requireNonNull(column, "column is null");
            this.constant = null;
        }

        public PartitionFunctionArgumentBinding(NullableValue constant) {
            this.constant = Objects.requireNonNull(constant, "constant is null");
            this.column = null;
        }

        @JsonCreator
        public PartitionFunctionArgumentBinding(@JsonProperty(value="column") Symbol column, @JsonProperty(value="constant") NullableValue constant) {
            this.column = column;
            this.constant = constant;
            Preconditions.checkArgument((column == null != (constant == null) ? 1 : 0) != 0, (Object)"Column or constant be set");
        }

        public boolean isConstant() {
            return this.constant != null;
        }

        public boolean isVariable() {
            return this.column != null;
        }

        @JsonProperty
        public Symbol getColumn() {
            return this.column;
        }

        @JsonProperty
        public NullableValue getConstant() {
            return this.constant;
        }

        public String toString() {
            if (this.constant != null) {
                return this.constant.toString();
            }
            return "\"" + this.column + "\"";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PartitionFunctionArgumentBinding that = (PartitionFunctionArgumentBinding)o;
            return Objects.equals(this.column, that.column) && Objects.equals(this.constant, that.constant);
        }

        public int hashCode() {
            return Objects.hash(this.column, this.constant);
        }
    }
}

