/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.analyzer;

import com.facebook.presto.Session;
import com.facebook.presto.connector.informationSchema.InformationSchemaMetadata;
import com.facebook.presto.metadata.FunctionKind;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.metadata.QualifiedObjectName;
import com.facebook.presto.metadata.SessionPropertyManager;
import com.facebook.presto.metadata.SqlFunction;
import com.facebook.presto.metadata.TableHandle;
import com.facebook.presto.metadata.TableLayout;
import com.facebook.presto.metadata.TableLayoutResult;
import com.facebook.presto.metadata.TableMetadata;
import com.facebook.presto.metadata.ViewDefinition;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.security.AllowAllAccessControl;
import com.facebook.presto.security.ViewAccessControl;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.security.Identity;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.ExpressionUtils;
import com.facebook.presto.sql.QueryUtil;
import com.facebook.presto.sql.analyzer.AggregateExtractor;
import com.facebook.presto.sql.analyzer.AggregationAnalyzer;
import com.facebook.presto.sql.analyzer.Analysis;
import com.facebook.presto.sql.analyzer.AnalysisContext;
import com.facebook.presto.sql.analyzer.Analyzer;
import com.facebook.presto.sql.analyzer.ExpressionAnalysis;
import com.facebook.presto.sql.analyzer.ExpressionAnalyzer;
import com.facebook.presto.sql.analyzer.Field;
import com.facebook.presto.sql.analyzer.FieldOrExpression;
import com.facebook.presto.sql.analyzer.QueryExplainer;
import com.facebook.presto.sql.analyzer.RelationType;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.analyzer.WindowFunctionExtractor;
import com.facebook.presto.sql.analyzer.WindowFunctionValidator;
import com.facebook.presto.sql.parser.ParsingException;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.DependencyExtractor;
import com.facebook.presto.sql.planner.ExpressionInterpreter;
import com.facebook.presto.sql.planner.NoOpSymbolResolver;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.optimizations.CanonicalizeExpressions;
import com.facebook.presto.sql.tree.AliasedRelation;
import com.facebook.presto.sql.tree.AllColumns;
import com.facebook.presto.sql.tree.BooleanLiteral;
import com.facebook.presto.sql.tree.Cast;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.CreateTableAsSelect;
import com.facebook.presto.sql.tree.CreateView;
import com.facebook.presto.sql.tree.DefaultTraversalVisitor;
import com.facebook.presto.sql.tree.Delete;
import com.facebook.presto.sql.tree.DereferenceExpression;
import com.facebook.presto.sql.tree.Except;
import com.facebook.presto.sql.tree.Explain;
import com.facebook.presto.sql.tree.ExplainFormat;
import com.facebook.presto.sql.tree.ExplainOption;
import com.facebook.presto.sql.tree.ExplainType;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FrameBound;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.GroupingElement;
import com.facebook.presto.sql.tree.Insert;
import com.facebook.presto.sql.tree.Intersect;
import com.facebook.presto.sql.tree.Join;
import com.facebook.presto.sql.tree.JoinCriteria;
import com.facebook.presto.sql.tree.JoinOn;
import com.facebook.presto.sql.tree.JoinUsing;
import com.facebook.presto.sql.tree.LikePredicate;
import com.facebook.presto.sql.tree.LongLiteral;
import com.facebook.presto.sql.tree.NaturalJoin;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.QualifiedNameReference;
import com.facebook.presto.sql.tree.Query;
import com.facebook.presto.sql.tree.QuerySpecification;
import com.facebook.presto.sql.tree.Relation;
import com.facebook.presto.sql.tree.Row;
import com.facebook.presto.sql.tree.SampledRelation;
import com.facebook.presto.sql.tree.Select;
import com.facebook.presto.sql.tree.SelectItem;
import com.facebook.presto.sql.tree.ShowCatalogs;
import com.facebook.presto.sql.tree.ShowColumns;
import com.facebook.presto.sql.tree.ShowFunctions;
import com.facebook.presto.sql.tree.ShowPartitions;
import com.facebook.presto.sql.tree.ShowSchemas;
import com.facebook.presto.sql.tree.ShowSession;
import com.facebook.presto.sql.tree.ShowTables;
import com.facebook.presto.sql.tree.SimpleGroupBy;
import com.facebook.presto.sql.tree.SingleColumn;
import com.facebook.presto.sql.tree.SortItem;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.sql.tree.StringLiteral;
import com.facebook.presto.sql.tree.Table;
import com.facebook.presto.sql.tree.TableSubquery;
import com.facebook.presto.sql.tree.Union;
import com.facebook.presto.sql.tree.Unnest;
import com.facebook.presto.sql.tree.Use;
import com.facebook.presto.sql.tree.Values;
import com.facebook.presto.sql.tree.Window;
import com.facebook.presto.sql.tree.WindowFrame;
import com.facebook.presto.sql.tree.With;
import com.facebook.presto.sql.tree.WithQuery;
import com.facebook.presto.type.ArrayType;
import com.facebook.presto.type.MapType;
import com.facebook.presto.type.RowType;
import com.facebook.presto.type.TypeRegistry;
import com.facebook.presto.type.UnknownType;
import com.facebook.presto.util.ImmutableCollectors;
import com.facebook.presto.util.Types;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

class StatementAnalyzer
extends DefaultTraversalVisitor<RelationType, AnalysisContext> {
    private final Analysis analysis;
    private final Metadata metadata;
    private final Session session;
    private final Optional<QueryExplainer> queryExplainer;
    private final boolean experimentalSyntaxEnabled;
    private final SqlParser sqlParser;
    private final AccessControl accessControl;

    public StatementAnalyzer(Analysis analysis, Metadata metadata, SqlParser sqlParser, AccessControl accessControl, Session session, boolean experimentalSyntaxEnabled, Optional<QueryExplainer> queryExplainer) {
        this.analysis = Objects.requireNonNull(analysis, "analysis is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
        this.session = Objects.requireNonNull(session, "session is null");
        this.experimentalSyntaxEnabled = experimentalSyntaxEnabled;
        this.queryExplainer = Objects.requireNonNull(queryExplainer, "queryExplainer is null");
    }

    protected RelationType visitShowTables(ShowTables showTables, AnalysisContext context) {
        String catalogName = this.session.getCatalog().orElse(null);
        String schemaName = this.session.getSchema().orElse(null);
        Optional schema = showTables.getSchema();
        if (schema.isPresent()) {
            List parts = ((QualifiedName)schema.get()).getParts();
            if (parts.size() > 2) {
                throw new SemanticException(SemanticErrorCode.INVALID_SCHEMA_NAME, (Node)showTables, "Too many parts in schema name: %s", schema.get());
            }
            if (parts.size() == 2) {
                catalogName = (String)parts.get(0);
            }
            schemaName = ((QualifiedName)schema.get()).getSuffix();
        }
        if (catalogName == null) {
            throw new SemanticException(SemanticErrorCode.CATALOG_NOT_SPECIFIED, (Node)showTables, "Catalog must be specified when session catalog is not set", new Object[0]);
        }
        if (schemaName == null) {
            throw new SemanticException(SemanticErrorCode.SCHEMA_NOT_SPECIFIED, (Node)showTables, "Schema must be specified when session schema is not set", new Object[0]);
        }
        if (!this.metadata.listSchemaNames(this.session, catalogName).contains(schemaName)) {
            throw new SemanticException(SemanticErrorCode.MISSING_SCHEMA, (Node)showTables, "Schema '%s' does not exist", schemaName);
        }
        Expression predicate = QueryUtil.equal((Expression)QueryUtil.nameReference((String)"table_schema"), (Expression)new StringLiteral(schemaName));
        Optional likePattern = showTables.getLikePattern();
        if (likePattern.isPresent()) {
            LikePredicate likePredicate = new LikePredicate(QueryUtil.nameReference((String)"table_name"), (Expression)new StringLiteral((String)likePattern.get()), null);
            predicate = QueryUtil.logicalAnd((Expression)predicate, (Expression)likePredicate);
        }
        Query query = QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{QueryUtil.aliasedName((String)"table_name", (String)"Table")}), (Relation)StatementAnalyzer.from(catalogName, InformationSchemaMetadata.TABLE_TABLES), (Expression)predicate, (List)QueryUtil.ordering((SortItem[])new SortItem[]{QueryUtil.ascending((String)"table_name")}));
        return (RelationType)this.process((Node)query, context);
    }

    protected RelationType visitShowSchemas(ShowSchemas node, AnalysisContext context) {
        if (!node.getCatalog().isPresent() && !this.session.getCatalog().isPresent()) {
            throw new SemanticException(SemanticErrorCode.CATALOG_NOT_SPECIFIED, (Node)node, "Catalog must be specified when session catalog is not set", new Object[0]);
        }
        Query query = QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{QueryUtil.aliasedName((String)"schema_name", (String)"Schema")}), (Relation)StatementAnalyzer.from(node.getCatalog().orElseGet(() -> this.session.getCatalog().get()), InformationSchemaMetadata.TABLE_SCHEMATA), (List)QueryUtil.ordering((SortItem[])new SortItem[]{QueryUtil.ascending((String)"schema_name")}));
        return (RelationType)this.process((Node)query, context);
    }

    protected RelationType visitShowCatalogs(ShowCatalogs node, AnalysisContext context) {
        List rows = this.metadata.getCatalogNames().keySet().stream().map(name -> QueryUtil.row((Expression[])new Expression[]{new StringLiteral(name)})).collect(Collectors.toList());
        Query query = QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)QueryUtil.aliased((Relation)new Values(rows), (String)"catalogs", (List)ImmutableList.of((Object)"Catalog")));
        return (RelationType)this.process((Node)query, context);
    }

    protected RelationType visitShowColumns(ShowColumns showColumns, AnalysisContext context) {
        QualifiedObjectName tableName = MetadataUtil.createQualifiedObjectName(this.session, (Node)showColumns, showColumns.getTable());
        if (!this.metadata.getView(this.session, tableName).isPresent() && !this.metadata.getTableHandle(this.session, tableName).isPresent()) {
            throw new SemanticException(SemanticErrorCode.MISSING_TABLE, (Node)showColumns, "Table '%s' does not exist", tableName);
        }
        Query query = QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{QueryUtil.aliasedName((String)"column_name", (String)"Column"), QueryUtil.aliasedName((String)"data_type", (String)"Type"), QueryUtil.aliasedNullToEmpty((String)"comment", (String)"Comment")}), (Relation)StatementAnalyzer.from(tableName.getCatalogName(), InformationSchemaMetadata.TABLE_COLUMNS), (Expression)QueryUtil.logicalAnd((Expression)QueryUtil.equal((Expression)QueryUtil.nameReference((String)"table_schema"), (Expression)new StringLiteral(tableName.getSchemaName())), (Expression)QueryUtil.equal((Expression)QueryUtil.nameReference((String)"table_name"), (Expression)new StringLiteral(tableName.getObjectName()))), (List)QueryUtil.ordering((SortItem[])new SortItem[]{QueryUtil.ascending((String)"ordinal_position")}));
        return (RelationType)this.process((Node)query, context);
    }

    protected RelationType visitUse(Use node, AnalysisContext context) {
        this.analysis.setUpdateType("USE");
        throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "USE statement is not supported", new Object[0]);
    }

    protected RelationType visitShowPartitions(ShowPartitions showPartitions, AnalysisContext context) {
        QualifiedObjectName table = MetadataUtil.createQualifiedObjectName(this.session, (Node)showPartitions, showPartitions.getTable());
        Optional<TableHandle> tableHandle = this.metadata.getTableHandle(this.session, table);
        if (!tableHandle.isPresent()) {
            throw new SemanticException(SemanticErrorCode.MISSING_TABLE, (Node)showPartitions, "Table '%s' does not exist", table);
        }
        List<TableLayoutResult> layouts = this.metadata.getLayouts(this.session, tableHandle.get(), (Constraint<ColumnHandle>)Constraint.alwaysTrue(), Optional.empty());
        if (layouts.size() != 1) {
            throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)showPartitions, "Table does not have exactly one layout: %s", table);
        }
        TableLayout layout = ((TableLayoutResult)Iterables.getOnlyElement(layouts)).getLayout();
        if (!layout.getDiscretePredicates().isPresent()) {
            throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)showPartitions, "Table does not have partition columns: %s", table);
        }
        List partitionColumns = layout.getDiscretePredicates().get().getColumns();
        ImmutableList.Builder selectList = ImmutableList.builder();
        ImmutableList.Builder wrappedList = ImmutableList.builder();
        selectList.add((Object)QueryUtil.unaliasedName((String)"partition_number"));
        for (ColumnHandle columnHandle : partitionColumns) {
            ColumnMetadata column = this.metadata.getColumnMetadata(this.session, tableHandle.get(), columnHandle);
            Expression key = QueryUtil.equal((Expression)QueryUtil.nameReference((String)"partition_key"), (Expression)new StringLiteral(column.getName()));
            Expression value = QueryUtil.caseWhen((Expression)key, (Expression)QueryUtil.nameReference((String)"partition_value"));
            value = new Cast(value, column.getType().getTypeSignature().toString());
            Expression function = QueryUtil.functionCall((String)"max", (Expression[])new Expression[]{value});
            selectList.add((Object)new SingleColumn(function, column.getName()));
            wrappedList.add((Object)QueryUtil.unaliasedName((String)column.getName()));
        }
        Query query = QueryUtil.simpleQuery((Select)QueryUtil.selectAll((List)selectList.build()), (Relation)StatementAnalyzer.from(table.getCatalogName(), InformationSchemaMetadata.TABLE_INTERNAL_PARTITIONS), Optional.of(QueryUtil.logicalAnd((Expression)QueryUtil.equal((Expression)QueryUtil.nameReference((String)"table_schema"), (Expression)new StringLiteral(table.getSchemaName())), (Expression)QueryUtil.equal((Expression)QueryUtil.nameReference((String)"table_name"), (Expression)new StringLiteral(table.getObjectName())))), (List)ImmutableList.of((Object)new SimpleGroupBy((List)ImmutableList.of((Object)QueryUtil.nameReference((String)"partition_number")))), Optional.empty(), (List)ImmutableList.of(), Optional.empty());
        query = QueryUtil.simpleQuery((Select)QueryUtil.selectAll((List)wrappedList.build()), (Relation)QueryUtil.subquery((Query)query), (Optional)showPartitions.getWhere(), (List)ImmutableList.of(), Optional.empty(), (List)ImmutableList.builder().addAll((Iterable)showPartitions.getOrderBy()).add((Object)QueryUtil.ascending((String)"partition_number")).build(), (Optional)showPartitions.getLimit());
        return (RelationType)this.process((Node)query, context);
    }

    protected RelationType visitShowFunctions(ShowFunctions node, AnalysisContext context) {
        ImmutableList.Builder rows = ImmutableList.builder();
        for (SqlFunction function : this.metadata.listFunctions()) {
            if (function.getSignature().getKind() == FunctionKind.APPROXIMATE_AGGREGATE) continue;
            rows.add((Object)QueryUtil.row((Expression[])new Expression[]{new StringLiteral(function.getSignature().getName()), new StringLiteral(function.getSignature().getReturnType().toString()), new StringLiteral(Joiner.on((String)", ").join(function.getSignature().getArgumentTypes())), new StringLiteral(StatementAnalyzer.getFunctionType(function)), function.isDeterministic() ? BooleanLiteral.TRUE_LITERAL : BooleanLiteral.FALSE_LITERAL, new StringLiteral(Strings.nullToEmpty((String)function.getDescription()))}));
        }
        ImmutableMap columns = ImmutableMap.builder().put((Object)"function_name", (Object)"Function").put((Object)"return_type", (Object)"Return Type").put((Object)"argument_types", (Object)"Argument Types").put((Object)"function_type", (Object)"Function Type").put((Object)"deterministic", (Object)"Deterministic").put((Object)"description", (Object)"Description").build();
        Query query = QueryUtil.simpleQuery((Select)QueryUtil.selectAll((List)((List)columns.entrySet().stream().map(entry -> QueryUtil.aliasedName((String)((String)entry.getKey()), (String)((String)entry.getValue()))).collect(ImmutableCollectors.toImmutableList()))), (Relation)QueryUtil.aliased((Relation)new Values((List)rows.build()), (String)"functions", (List)ImmutableList.copyOf(columns.keySet())), (List)QueryUtil.ordering((SortItem[])new SortItem[]{QueryUtil.ascending((String)"function_name"), QueryUtil.ascending((String)"return_type"), QueryUtil.ascending((String)"argument_types"), QueryUtil.ascending((String)"function_type")}));
        return (RelationType)this.process((Node)query, context);
    }

    private static String getFunctionType(SqlFunction function) {
        FunctionKind kind = function.getSignature().getKind();
        switch (kind) {
            case AGGREGATE: 
            case APPROXIMATE_AGGREGATE: {
                return "aggregate";
            }
            case WINDOW: {
                return "window";
            }
            case SCALAR: {
                return "scalar";
            }
        }
        throw new IllegalArgumentException("Unsupported function kind: " + (Object)((Object)kind));
    }

    protected RelationType visitShowSession(ShowSession node, AnalysisContext context) {
        ImmutableList.Builder rows = ImmutableList.builder();
        List<SessionPropertyManager.SessionPropertyValue> sessionProperties = this.metadata.getSessionPropertyManager().getAllSessionProperties(this.session);
        for (SessionPropertyManager.SessionPropertyValue sessionProperty : sessionProperties) {
            if (sessionProperty.isHidden()) continue;
            String value = sessionProperty.getValue();
            String defaultValue = sessionProperty.getDefaultValue();
            rows.add((Object)QueryUtil.row((Expression[])new Expression[]{new StringLiteral(sessionProperty.getFullyQualifiedName()), new StringLiteral(Strings.nullToEmpty((String)value)), new StringLiteral(Strings.nullToEmpty((String)defaultValue)), new StringLiteral(sessionProperty.getType()), new StringLiteral(sessionProperty.getDescription()), BooleanLiteral.TRUE_LITERAL}));
        }
        StringLiteral empty = new StringLiteral("");
        rows.add((Object)QueryUtil.row((Expression[])new Expression[]{empty, empty, empty, empty, empty, BooleanLiteral.FALSE_LITERAL}));
        Query query = QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{QueryUtil.aliasedName((String)"name", (String)"Name"), QueryUtil.aliasedName((String)"value", (String)"Value"), QueryUtil.aliasedName((String)"default", (String)"Default"), QueryUtil.aliasedName((String)"type", (String)"Type"), QueryUtil.aliasedName((String)"description", (String)"Description")}), (Relation)QueryUtil.aliased((Relation)new Values((List)rows.build()), (String)"session", (List)ImmutableList.of((Object)"name", (Object)"value", (Object)"default", (Object)"type", (Object)"description", (Object)"include")), (Expression)QueryUtil.nameReference((String)"include"));
        return (RelationType)this.process((Node)query, context);
    }

    protected RelationType visitInsert(Insert insert, AnalysisContext context) {
        List insertColumns;
        QualifiedObjectName targetTable = MetadataUtil.createQualifiedObjectName(this.session, (Node)insert, insert.getTarget());
        if (this.metadata.getView(this.session, targetTable).isPresent()) {
            throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)insert, "Inserting into views is not supported", new Object[0]);
        }
        this.analysis.setUpdateType("INSERT");
        RelationType queryDescriptor = (RelationType)this.process((Node)insert.getQuery(), context);
        Optional<TableHandle> targetTableHandle = this.metadata.getTableHandle(this.session, targetTable);
        if (!targetTableHandle.isPresent()) {
            throw new SemanticException(SemanticErrorCode.MISSING_TABLE, (Node)insert, "Table '%s' does not exist", targetTable);
        }
        this.accessControl.checkCanInsertIntoTable(this.session.getRequiredTransactionId(), this.session.getIdentity(), targetTable);
        TableMetadata tableMetadata = this.metadata.getTableMetadata(this.session, targetTableHandle.get());
        List tableColumns = tableMetadata.getVisibleColumnNames();
        if (insert.getColumns().isPresent()) {
            insertColumns = (List)((List)insert.getColumns().get()).stream().map(String::toLowerCase).collect(ImmutableCollectors.toImmutableList());
            HashSet<String> columnNames = new HashSet<String>();
            for (String insertColumn2 : insertColumns) {
                if (!tableColumns.contains(insertColumn2)) {
                    throw new SemanticException(SemanticErrorCode.MISSING_COLUMN, (Node)insert, "Insert column name does not exist in target table: %s", insertColumn2);
                }
                if (columnNames.add(insertColumn2)) continue;
                throw new SemanticException(SemanticErrorCode.DUPLICATE_COLUMN_NAME, (Node)insert, "Insert column name is specified more than once: %s", insertColumn2);
            }
        } else {
            insertColumns = tableColumns;
        }
        Map<String, ColumnHandle> columnHandles = this.metadata.getColumnHandles(this.session, targetTableHandle.get());
        this.analysis.setInsert(new Analysis.Insert(targetTableHandle.get(), (List)insertColumns.stream().map(columnHandles::get).collect(ImmutableCollectors.toImmutableList())));
        Iterable tableTypes = (Iterable)insertColumns.stream().map(insertColumn -> tableMetadata.getColumn((String)insertColumn).getType()).collect(ImmutableCollectors.toImmutableList());
        Iterable queryTypes = Iterables.transform(queryDescriptor.getVisibleFields(), Field::getType);
        if (!StatementAnalyzer.typesMatchForInsert(tableTypes, queryTypes)) {
            throw new SemanticException(SemanticErrorCode.MISMATCHED_SET_COLUMN_TYPES, (Node)insert, "Insert query has mismatched column types: Table: [" + Joiner.on((String)", ").join(tableTypes) + "], " + "Query: [" + Joiner.on((String)", ").join(queryTypes) + "]", new Object[0]);
        }
        return new RelationType(Field.newUnqualified("rows", (Type)BigintType.BIGINT));
    }

    private static boolean typesMatchForInsert(Iterable<Type> tableTypes, Iterable<Type> queryTypes) {
        if (Iterables.size(tableTypes) != Iterables.size(queryTypes)) {
            return false;
        }
        Iterator<Type> tableTypesIterator = tableTypes.iterator();
        Iterator<Type> queryTypesIterator = queryTypes.iterator();
        while (tableTypesIterator.hasNext()) {
            Type tableType = tableTypesIterator.next();
            Type queryType = queryTypesIterator.next();
            if (StatementAnalyzer.isStructuralType(tableType)) {
                if (!tableType.getTypeSignature().getBase().equals(queryType.getTypeSignature().getBase())) {
                    return false;
                }
                if (StatementAnalyzer.typesMatchForInsert(tableType.getTypeParameters(), queryType.getTypeParameters())) continue;
                return false;
            }
            if (Objects.equals(tableType, queryType) || TypeRegistry.isTypeOnlyCoercion(queryType.getTypeSignature(), tableType.getTypeSignature())) continue;
            return false;
        }
        return true;
    }

    private static boolean isStructuralType(Type type) {
        String baseName = type.getTypeSignature().getBase();
        return baseName.equals("map") || baseName.equals("array") || baseName.equals("row");
    }

    protected RelationType visitDelete(Delete node, AnalysisContext context) {
        Table table = node.getTable();
        QualifiedObjectName tableName = MetadataUtil.createQualifiedObjectName(this.session, (Node)table, table.getName());
        if (this.metadata.getView(this.session, tableName).isPresent()) {
            throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "Deleting from views is not supported", new Object[0]);
        }
        this.analysis.setUpdateType("DELETE");
        this.analysis.setDelete(node);
        StatementAnalyzer analyzer = new StatementAnalyzer(this.analysis, this.metadata, this.sqlParser, new AllowAllAccessControl(), this.session, this.experimentalSyntaxEnabled, this.queryExplainer);
        RelationType descriptor = (RelationType)analyzer.process((Node)table, context);
        node.getWhere().ifPresent(where -> analyzer.analyzeWhere((Node)node, descriptor, context, (Expression)where));
        this.accessControl.checkCanDeleteFromTable(this.session.getRequiredTransactionId(), this.session.getIdentity(), tableName);
        return new RelationType(Field.newUnqualified("rows", (Type)BigintType.BIGINT));
    }

    protected RelationType visitCreateTableAsSelect(CreateTableAsSelect node, AnalysisContext context) {
        this.analysis.setUpdateType("CREATE TABLE");
        QualifiedObjectName targetTable = MetadataUtil.createQualifiedObjectName(this.session, (Node)node, node.getName());
        this.analysis.setCreateTableDestination(targetTable);
        for (Expression expression : node.getProperties().values()) {
            ExpressionAnalyzer.createConstantAnalyzer(this.metadata, this.session).analyze(expression, new RelationType(new Field[0]), context);
        }
        this.analysis.setCreateTableProperties(node.getProperties());
        Optional<TableHandle> targetTableHandle = this.metadata.getTableHandle(this.session, targetTable);
        if (targetTableHandle.isPresent()) {
            throw new SemanticException(SemanticErrorCode.TABLE_ALREADY_EXISTS, (Node)node, "Destination table '%s' already exists", targetTable);
        }
        this.accessControl.checkCanCreateTable(this.session.getRequiredTransactionId(), this.session.getIdentity(), targetTable);
        this.analysis.setCreateTableAsSelectWithData(node.isWithData());
        RelationType descriptor = (RelationType)this.process((Node)node.getQuery(), context);
        StatementAnalyzer.validateColumns((Statement)node, descriptor);
        return new RelationType(Field.newUnqualified("rows", (Type)BigintType.BIGINT));
    }

    protected RelationType visitCreateView(CreateView node, AnalysisContext context) {
        this.analysis.setUpdateType("CREATE VIEW");
        StatementAnalyzer analyzer = new StatementAnalyzer(this.analysis, this.metadata, this.sqlParser, new ViewAccessControl(this.accessControl), this.session, this.experimentalSyntaxEnabled, this.queryExplainer);
        RelationType descriptor = (RelationType)analyzer.process((Node)node.getQuery(), new AnalysisContext());
        QualifiedObjectName viewName = MetadataUtil.createQualifiedObjectName(this.session, (Node)node, node.getName());
        this.accessControl.checkCanCreateView(this.session.getRequiredTransactionId(), this.session.getIdentity(), viewName);
        StatementAnalyzer.validateColumns((Statement)node, descriptor);
        return descriptor;
    }

    private static void validateColumns(Statement node, RelationType descriptor) {
        HashSet<String> names = new HashSet<String>();
        for (Field field : descriptor.getVisibleFields()) {
            Optional<String> fieldName = field.getName();
            if (!fieldName.isPresent()) {
                throw new SemanticException(SemanticErrorCode.COLUMN_NAME_NOT_SPECIFIED, (Node)node, "Column name not specified at position %s", descriptor.indexOf(field) + 1);
            }
            if (!names.add(fieldName.get())) {
                throw new SemanticException(SemanticErrorCode.DUPLICATE_COLUMN_NAME, (Node)node, "Column name '%s' specified more than once", fieldName.get());
            }
            if (!field.getType().equals((Object)UnknownType.UNKNOWN)) continue;
            throw new SemanticException(SemanticErrorCode.COLUMN_TYPE_UNKNOWN, (Node)node, "Column type is unknown: %s", fieldName.get());
        }
    }

    protected RelationType visitExplain(Explain node, AnalysisContext context) throws SemanticException {
        Preconditions.checkState((boolean)this.queryExplainer.isPresent(), (Object)"query explainer not available");
        ExplainType.Type planType = ExplainType.Type.LOGICAL;
        ExplainFormat.Type planFormat = ExplainFormat.Type.TEXT;
        List options = node.getOptions();
        for (ExplainOption option : options) {
            if (!(option instanceof ExplainType)) continue;
            planType = ((ExplainType)option).getType();
            break;
        }
        for (ExplainOption option : options) {
            if (!(option instanceof ExplainFormat)) continue;
            planFormat = ((ExplainFormat)option).getType();
            break;
        }
        String queryPlan = this.getQueryPlan(node, planType, planFormat);
        Query query = QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)QueryUtil.aliased((Relation)QueryUtil.values((Row[])new Row[]{QueryUtil.row((Expression[])new Expression[]{new StringLiteral(queryPlan)})}), (String)"plan", (List)ImmutableList.of((Object)"Query Plan")));
        return (RelationType)this.process((Node)query, context);
    }

    private String getQueryPlan(Explain node, ExplainType.Type planType, ExplainFormat.Type planFormat) throws IllegalArgumentException {
        switch (planFormat) {
            case GRAPHVIZ: {
                return this.queryExplainer.get().getGraphvizPlan(this.session, node.getStatement(), planType);
            }
            case TEXT: {
                return this.queryExplainer.get().getPlan(this.session, node.getStatement(), planType);
            }
        }
        throw new IllegalArgumentException("Invalid Explain Format: " + planFormat.toString());
    }

    protected RelationType visitQuery(Query node, AnalysisContext parentContext) {
        AnalysisContext context = new AnalysisContext(parentContext);
        if (node.getApproximate().isPresent()) {
            if (!this.experimentalSyntaxEnabled) {
                throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "approximate queries are not enabled", new Object[0]);
            }
            context.setApproximate(true);
        }
        this.analyzeWith(node, context);
        RelationType descriptor = (RelationType)this.process((Node)node.getQueryBody(), context);
        this.analyzeOrderBy(node, descriptor, context);
        this.analysis.setOutputDescriptor((Node)node, descriptor);
        this.analysis.setOutputExpressions((Node)node, StatementAnalyzer.descriptorToFields(descriptor));
        this.analysis.setQuery(node);
        return descriptor;
    }

    protected RelationType visitUnnest(Unnest node, AnalysisContext context) {
        ImmutableList.Builder outputFields = ImmutableList.builder();
        for (Expression expression : node.getExpressions()) {
            ExpressionAnalysis expressionAnalysis = this.analyzeExpression(expression, context.getLateralTupleDescriptor(), context);
            Type expressionType = expressionAnalysis.getType(expression);
            if (expressionType instanceof ArrayType) {
                outputFields.add((Object)Field.newUnqualified(Optional.empty(), ((ArrayType)expressionType).getElementType()));
                continue;
            }
            if (expressionType instanceof MapType) {
                outputFields.add((Object)Field.newUnqualified(Optional.empty(), ((MapType)expressionType).getKeyType()));
                outputFields.add((Object)Field.newUnqualified(Optional.empty(), ((MapType)expressionType).getValueType()));
                continue;
            }
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Cannot unnest type: " + expressionType);
        }
        if (node.isWithOrdinality()) {
            outputFields.add((Object)Field.newUnqualified(Optional.empty(), (Type)BigintType.BIGINT));
        }
        RelationType descriptor = new RelationType((List<Field>)outputFields.build());
        this.analysis.setOutputDescriptor((Node)node, descriptor);
        return descriptor;
    }

    protected RelationType visitTable(Table table, AnalysisContext context) {
        Object name;
        Query query;
        if (!table.getName().getPrefix().isPresent() && (query = context.getNamedQuery((String)(name = table.getName().getSuffix()))) != null) {
            this.analysis.registerNamedQuery(table, query);
            RelationType queryDescriptor = this.analysis.getOutputDescriptor((Node)query);
            ImmutableList.Builder fields = ImmutableList.builder();
            for (Field field : queryDescriptor.getAllFields()) {
                fields.add((Object)Field.newQualified(QualifiedName.of((String)name, (String[])new String[0]), field.getName(), field.getType(), false));
            }
            RelationType descriptor = new RelationType((List<Field>)fields.build());
            this.analysis.setOutputDescriptor((Node)table, descriptor);
            return descriptor;
        }
        name = MetadataUtil.createQualifiedObjectName(this.session, (Node)table, table.getName());
        Optional<ViewDefinition> optionalView = this.metadata.getView(this.session, (QualifiedObjectName)name);
        if (optionalView.isPresent()) {
            ViewDefinition view = optionalView.get();
            Query query2 = this.parseView(view.getOriginalSql(), (QualifiedObjectName)name, table);
            this.analysis.registerNamedQuery(table, query2);
            this.accessControl.checkCanSelectFromView(this.session.getRequiredTransactionId(), this.session.getIdentity(), (QualifiedObjectName)name);
            RelationType descriptor = this.analyzeView(query2, (QualifiedObjectName)name, view.getCatalog(), view.getSchema(), view.getOwner(), table);
            if (StatementAnalyzer.isViewStale(view.getColumns(), descriptor.getVisibleFields())) {
                throw new SemanticException(SemanticErrorCode.VIEW_IS_STALE, (Node)table, "View '%s' is stale; it must be re-created", name);
            }
            List outputFields = (List)view.getColumns().stream().map(column -> Field.newUnqualified(column.getName(), column.getType())).collect(ImmutableCollectors.toImmutableList());
            this.analysis.addRelationCoercion((Relation)table, (Type[])outputFields.stream().map(Field::getType).toArray(Type[]::new));
            this.analysis.setOutputDescriptor((Node)table, new RelationType(outputFields));
            return descriptor;
        }
        Optional<TableHandle> tableHandle = this.metadata.getTableHandle(this.session, (QualifiedObjectName)name);
        if (!tableHandle.isPresent()) {
            if (!this.metadata.getCatalogNames().containsKey(((QualifiedObjectName)name).getCatalogName())) {
                throw new SemanticException(SemanticErrorCode.MISSING_CATALOG, (Node)table, "Catalog %s does not exist", ((QualifiedObjectName)name).getCatalogName());
            }
            if (!this.metadata.listSchemaNames(this.session, ((QualifiedObjectName)name).getCatalogName()).contains(((QualifiedObjectName)name).getSchemaName())) {
                throw new SemanticException(SemanticErrorCode.MISSING_SCHEMA, (Node)table, "Schema %s does not exist", ((QualifiedObjectName)name).getSchemaName());
            }
            if (table.getName().getSuffix().equalsIgnoreCase("DUAL")) {
                throw new SemanticException(SemanticErrorCode.MISSING_TABLE, (Node)table, "DUAL table is no longer supported. Please use VALUES or FROM-less queries instead", new Object[0]);
            }
            throw new SemanticException(SemanticErrorCode.MISSING_TABLE, (Node)table, "Table %s does not exist", name);
        }
        this.accessControl.checkCanSelectFromTable(this.session.getRequiredTransactionId(), this.session.getIdentity(), (QualifiedObjectName)name);
        TableMetadata tableMetadata = this.metadata.getTableMetadata(this.session, tableHandle.get());
        Map<String, ColumnHandle> columnHandles = this.metadata.getColumnHandles(this.session, tableHandle.get());
        ImmutableList.Builder fields = ImmutableList.builder();
        for (ColumnMetadata column2 : tableMetadata.getColumns()) {
            Field field = Field.newQualified(table.getName(), Optional.of(column2.getName()), column2.getType(), column2.isHidden());
            fields.add((Object)field);
            ColumnHandle columnHandle = columnHandles.get(column2.getName());
            Preconditions.checkArgument((columnHandle != null ? 1 : 0) != 0, (String)"Unknown field %s", (Object[])new Object[]{field});
            this.analysis.setColumn(field, columnHandle);
        }
        this.analysis.registerTable(table, tableHandle.get());
        RelationType descriptor = new RelationType((List<Field>)fields.build());
        this.analysis.setOutputDescriptor((Node)table, descriptor);
        return descriptor;
    }

    protected RelationType visitAliasedRelation(AliasedRelation relation, AnalysisContext context) {
        int totalColumns;
        RelationType child = (RelationType)this.process((Node)relation.getRelation(), context);
        if (relation.getColumnNames() != null && (totalColumns = child.getVisibleFieldCount()) != relation.getColumnNames().size()) {
            throw new SemanticException(SemanticErrorCode.MISMATCHED_COLUMN_ALIASES, (Node)relation, "Column alias list has %s entries but '%s' has %s columns available", relation.getColumnNames().size(), relation.getAlias(), totalColumns);
        }
        RelationType descriptor = child.withAlias(relation.getAlias(), relation.getColumnNames());
        this.analysis.setOutputDescriptor((Node)relation, descriptor);
        return descriptor;
    }

    protected RelationType visitSampledRelation(SampledRelation relation, AnalysisContext context) {
        if (relation.getColumnsToStratifyOn().isPresent()) {
            throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)relation, "STRATIFY ON is not yet implemented", new Object[0]);
        }
        if (!DependencyExtractor.extractNames(relation.getSamplePercentage(), this.analysis.getColumnReferences()).isEmpty()) {
            throw new SemanticException(SemanticErrorCode.NON_NUMERIC_SAMPLE_PERCENTAGE, (Node)relation.getSamplePercentage(), "Sample percentage cannot contain column references", new Object[0]);
        }
        IdentityHashMap<Expression, Type> expressionTypes = ExpressionAnalyzer.getExpressionTypes(this.session, this.metadata, this.sqlParser, (Map<Symbol, Type>)ImmutableMap.of(), relation.getSamplePercentage());
        ExpressionInterpreter samplePercentageEval = ExpressionInterpreter.expressionOptimizer(relation.getSamplePercentage(), this.metadata, this.session, expressionTypes);
        Object samplePercentageObject = samplePercentageEval.optimize(symbol -> {
            throw new SemanticException(SemanticErrorCode.NON_NUMERIC_SAMPLE_PERCENTAGE, (Node)relation.getSamplePercentage(), "Sample percentage cannot contain column references", new Object[0]);
        });
        if (!(samplePercentageObject instanceof Number)) {
            throw new SemanticException(SemanticErrorCode.NON_NUMERIC_SAMPLE_PERCENTAGE, (Node)relation.getSamplePercentage(), "Sample percentage should evaluate to a numeric expression", new Object[0]);
        }
        double samplePercentageValue = ((Number)samplePercentageObject).doubleValue();
        if (samplePercentageValue < 0.0) {
            throw new SemanticException(SemanticErrorCode.SAMPLE_PERCENTAGE_OUT_OF_RANGE, (Node)relation.getSamplePercentage(), "Sample percentage must be greater than or equal to 0", new Object[0]);
        }
        if (samplePercentageValue > 100.0 && (relation.getType() != SampledRelation.Type.POISSONIZED || relation.isRescaled())) {
            throw new SemanticException(SemanticErrorCode.SAMPLE_PERCENTAGE_OUT_OF_RANGE, (Node)relation.getSamplePercentage(), "Sample percentage must be less than or equal to 100", new Object[0]);
        }
        if (relation.isRescaled() && !this.experimentalSyntaxEnabled) {
            throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)relation, "Rescaling is not enabled", new Object[0]);
        }
        RelationType descriptor = (RelationType)this.process((Node)relation.getRelation(), context);
        this.analysis.setOutputDescriptor((Node)relation, descriptor);
        this.analysis.setSampleRatio(relation, samplePercentageValue / 100.0);
        return descriptor;
    }

    protected RelationType visitTableSubquery(TableSubquery node, AnalysisContext context) {
        StatementAnalyzer analyzer = new StatementAnalyzer(this.analysis, this.metadata, this.sqlParser, this.accessControl, this.session, this.experimentalSyntaxEnabled, Optional.empty());
        RelationType descriptor = (RelationType)analyzer.process((Node)node.getQuery(), context);
        this.analysis.setOutputDescriptor((Node)node, descriptor);
        return descriptor;
    }

    protected RelationType visitQuerySpecification(QuerySpecification node, AnalysisContext parentContext) {
        AnalysisContext context = new AnalysisContext(parentContext);
        RelationType tupleDescriptor = this.analyzeFrom(node, context);
        node.getWhere().ifPresent(where -> this.analyzeWhere((Node)node, tupleDescriptor, context, (Expression)where));
        List<FieldOrExpression> outputExpressions = this.analyzeSelect(node, tupleDescriptor, context);
        List<List<FieldOrExpression>> groupByExpressions = this.analyzeGroupBy(node, tupleDescriptor, context, outputExpressions);
        List<FieldOrExpression> orderByExpressions = this.analyzeOrderBy(node, tupleDescriptor, context, outputExpressions);
        this.analyzeHaving(node, tupleDescriptor, context);
        this.analyzeAggregations(node, tupleDescriptor, groupByExpressions, outputExpressions, orderByExpressions, context, this.analysis.getColumnReferences());
        this.analyzeWindowFunctions(node, outputExpressions, orderByExpressions);
        RelationType descriptor = this.computeOutputDescriptor(node, tupleDescriptor);
        this.analysis.setOutputDescriptor((Node)node, descriptor);
        return descriptor;
    }

    protected RelationType visitUnion(Union node, AnalysisContext context) {
        Preconditions.checkState((node.getRelations().size() >= 2 ? 1 : 0) != 0);
        RelationType[] descriptors = (RelationType[])node.getRelations().stream().map(relation -> ((RelationType)this.process((Node)relation, context)).withOnlyVisibleFields()).toArray(RelationType[]::new);
        Type[] outputFieldTypes = (Type[])descriptors[0].getVisibleFields().stream().map(Field::getType).toArray(Type[]::new);
        RelationType[] relationTypeArray = descriptors;
        int n = relationTypeArray.length;
        for (int i = 0; i < n; ++i) {
            int outputFieldSize = outputFieldTypes.length;
            RelationType descriptor = relationTypeArray[i];
            int descFieldSize = descriptor.getVisibleFields().size();
            if (outputFieldSize != descFieldSize) {
                throw new SemanticException(SemanticErrorCode.MISMATCHED_SET_COLUMN_TYPES, (Node)node, "union query has different number of fields: %d, %d", outputFieldSize, descFieldSize);
            }
            for (int i2 = 0; i2 < descriptor.getVisibleFields().size(); ++i2) {
                Type descFieldType = descriptor.getFieldByIndex(i2).getType();
                Optional commonSuperType = this.metadata.getTypeManager().getCommonSuperType(outputFieldTypes[i2], descFieldType);
                if (!commonSuperType.isPresent()) {
                    throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node, "column %d in union query has incompatible types: %s, %s", i2, outputFieldTypes[i2].getDisplayName(), descFieldType.getDisplayName());
                }
                outputFieldTypes[i2] = (Type)commonSuperType.get();
            }
        }
        Field[] outputDescriptorFields = new Field[outputFieldTypes.length];
        RelationType firstDescriptor = descriptors[0].withOnlyVisibleFields();
        for (int i = 0; i < outputFieldTypes.length; ++i) {
            Field oldField = firstDescriptor.getFieldByIndex(i);
            outputDescriptorFields[i] = new Field(oldField.getRelationAlias(), oldField.getName(), outputFieldTypes[i], oldField.isHidden());
        }
        RelationType outputDescriptor = new RelationType(outputDescriptorFields);
        this.analysis.setOutputDescriptor((Node)node, outputDescriptor);
        block3: for (int i = 0; i < node.getRelations().size(); ++i) {
            Relation relation2 = (Relation)node.getRelations().get(i);
            RelationType descriptor = descriptors[i];
            for (int j = 0; j < descriptor.getVisibleFields().size(); ++j) {
                Type outputFieldType = outputFieldTypes[j];
                Type descFieldType = descriptor.getFieldByIndex(j).getType();
                if (outputFieldType.equals(descFieldType)) continue;
                this.analysis.addRelationCoercion(relation2, outputFieldTypes);
                continue block3;
            }
        }
        return outputDescriptor;
    }

    protected RelationType visitIntersect(Intersect node, AnalysisContext context) {
        throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "INTERSECT not yet implemented", new Object[0]);
    }

    protected RelationType visitExcept(Except node, AnalysisContext context) {
        throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "EXCEPT not yet implemented", new Object[0]);
    }

    protected RelationType visitJoin(Join node, AnalysisContext context) {
        JoinCriteria criteria = node.getCriteria().orElse(null);
        if (criteria instanceof NaturalJoin) {
            throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "Natural join not supported", new Object[0]);
        }
        AnalysisContext leftContext = new AnalysisContext(context);
        RelationType left = (RelationType)this.process((Node)node.getLeft(), context);
        leftContext.setLateralTupleDescriptor(left);
        RelationType right = (RelationType)this.process((Node)node.getRight(), leftContext);
        Sets.SetView duplicateAliases = Sets.intersection(left.getRelationAliases(), right.getRelationAliases());
        if (!duplicateAliases.isEmpty()) {
            throw new SemanticException(SemanticErrorCode.DUPLICATE_RELATION, (Node)node, "Relations appear more than once: %s", duplicateAliases);
        }
        RelationType output = left.joinWith(right);
        if (node.getType() == Join.Type.CROSS || node.getType() == Join.Type.IMPLICIT) {
            this.analysis.setOutputDescriptor((Node)node, output);
            return output;
        }
        if (criteria instanceof JoinUsing) {
            List columns = ((JoinUsing)criteria).getColumns();
            ArrayList<Expression> expressions = new ArrayList<Expression>();
            for (String column : columns) {
                QualifiedNameReference leftExpression = new QualifiedNameReference(QualifiedName.of((String)column, (String[])new String[0]));
                QualifiedNameReference rightExpression = new QualifiedNameReference(QualifiedName.of((String)column, (String[])new String[0]));
                ExpressionAnalysis leftExpressionAnalysis = this.analyzeExpression((Expression)leftExpression, left, context);
                ExpressionAnalysis rightExpressionAnalysis = this.analyzeExpression((Expression)rightExpression, right, context);
                Preconditions.checkState((boolean)leftExpressionAnalysis.getSubqueryInPredicates().isEmpty(), (Object)"INVARIANT");
                Preconditions.checkState((boolean)rightExpressionAnalysis.getSubqueryInPredicates().isEmpty(), (Object)"INVARIANT");
                this.addCoercionForJoinCriteria(node, (Expression)leftExpression, (Expression)rightExpression);
                expressions.add((Expression)new ComparisonExpression(ComparisonExpression.Type.EQUAL, (Expression)leftExpression, (Expression)rightExpression));
            }
            this.analysis.setJoinCriteria(node, ExpressionUtils.and(expressions));
        } else if (criteria instanceof JoinOn) {
            Expression expression = ((JoinOn)criteria).getExpression();
            ExpressionAnalyzer analyzer = ExpressionAnalyzer.create(this.analysis, this.session, this.metadata, this.sqlParser, this.accessControl, this.experimentalSyntaxEnabled);
            analyzer.analyze(expression, output, context);
            Analyzer.verifyNoAggregatesOrWindowFunctions(this.metadata, expression, "JOIN");
            Expression canonicalized = CanonicalizeExpressions.canonicalizeExpression(expression);
            analyzer.analyze(canonicalized, output, context);
            Object optimizedExpression = ExpressionInterpreter.expressionOptimizer(canonicalized, this.metadata, this.session, analyzer.getExpressionTypes()).optimize(NoOpSymbolResolver.INSTANCE);
            if (!(optimizedExpression instanceof Expression) && optimizedExpression instanceof Boolean) {
                optimizedExpression = optimizedExpression.equals(Boolean.TRUE) ? new ComparisonExpression(ComparisonExpression.Type.EQUAL, (Expression)new LongLiteral("0"), (Expression)new LongLiteral("0")) : new ComparisonExpression(ComparisonExpression.Type.EQUAL, (Expression)new LongLiteral("0"), (Expression)new LongLiteral("1"));
            }
            if (!(optimizedExpression instanceof Expression)) {
                throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node, "Join clause must be a boolean expression", new Object[0]);
            }
            analyzer = ExpressionAnalyzer.create(this.analysis, this.session, this.metadata, this.sqlParser, this.accessControl, this.experimentalSyntaxEnabled);
            analyzer.analyze((Expression)optimizedExpression, output, context);
            this.analysis.addCoercions(analyzer.getExpressionCoercions());
            for (Expression conjunct : ExpressionUtils.extractConjuncts((Expression)optimizedExpression)) {
                Expression rightExpression;
                Expression leftExpression;
                if (!((conjunct = ExpressionUtils.normalize(conjunct)) instanceof ComparisonExpression)) {
                    throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "Non-equi joins not supported: %s", conjunct);
                }
                ComparisonExpression comparison = (ComparisonExpression)conjunct;
                Set<QualifiedName> firstDependencies = DependencyExtractor.extractNames(comparison.getLeft(), analyzer.getColumnReferences());
                Set<QualifiedName> secondDependencies = DependencyExtractor.extractNames(comparison.getRight(), analyzer.getColumnReferences());
                if (firstDependencies.stream().allMatch(left.canResolvePredicate()) && secondDependencies.stream().allMatch(right.canResolvePredicate())) {
                    leftExpression = comparison.getLeft();
                    rightExpression = comparison.getRight();
                } else if (firstDependencies.stream().allMatch(right.canResolvePredicate()) && secondDependencies.stream().allMatch(left.canResolvePredicate())) {
                    leftExpression = comparison.getRight();
                    rightExpression = comparison.getLeft();
                } else {
                    throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "Non-equi joins not supported: %s", conjunct);
                }
                ExpressionAnalysis leftExpressionAnalysis = this.analyzeExpression(leftExpression, left, context);
                ExpressionAnalysis rightExpressionAnalysis = this.analyzeExpression(rightExpression, right, context);
                this.addCoercionForJoinCriteria(node, leftExpression, rightExpression);
                this.analysis.addJoinInPredicates(node, new Analysis.JoinInPredicates(leftExpressionAnalysis.getSubqueryInPredicates(), rightExpressionAnalysis.getSubqueryInPredicates()));
            }
            this.analysis.setJoinCriteria(node, (Expression)optimizedExpression);
        } else {
            throw new UnsupportedOperationException("unsupported join criteria: " + criteria.getClass().getName());
        }
        this.analysis.setOutputDescriptor((Node)node, output);
        return output;
    }

    private void addCoercionForJoinCriteria(Join node, Expression leftExpression, Expression rightExpression) {
        Type leftType = this.analysis.getType(leftExpression);
        Type rightType = this.analysis.getType(rightExpression);
        Optional superType = this.metadata.getTypeManager().getCommonSuperType(leftType, rightType);
        if (!superType.isPresent()) {
            throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node, "Join criteria has incompatible types: %s, %s", leftType.getDisplayName(), rightType.getDisplayName());
        }
        if (!leftType.equals(superType.get())) {
            this.analysis.addCoercion(leftExpression, (Type)superType.get());
        }
        if (!rightType.equals(superType.get())) {
            this.analysis.addCoercion(rightExpression, (Type)superType.get());
        }
    }

    protected RelationType visitValues(Values node, AnalysisContext context) {
        Preconditions.checkState((node.getRows().size() >= 1 ? 1 : 0) != 0);
        Set rowTypes = (Set)node.getRows().stream().map(row -> this.analyzeExpression((Expression)row, new RelationType(new Field[0]), context).getType((Expression)row)).map(type -> {
            if (type instanceof RowType) {
                return type.getTypeParameters();
            }
            return ImmutableList.of((Object)type);
        }).collect(ImmutableCollectors.toImmutableSet());
        ArrayList fieldTypes = new ArrayList((Collection)rowTypes.iterator().next());
        for (List rowType : rowTypes) {
            for (int i = 0; i < rowType.size(); ++i) {
                Type fieldType = (Type)rowType.get(i);
                Type superType = (Type)fieldTypes.get(i);
                Optional commonSuperType = this.metadata.getTypeManager().getCommonSuperType(fieldType, superType);
                if (!commonSuperType.isPresent()) {
                    throw new SemanticException(SemanticErrorCode.MISMATCHED_SET_COLUMN_TYPES, (Node)node, "Values rows have mismatched types: %s vs %s", Iterables.get((Iterable)rowTypes, (int)0), Iterables.get((Iterable)rowTypes, (int)1));
                }
                fieldTypes.set(i, commonSuperType.get());
            }
        }
        for (Expression row2 : node.getRows()) {
            if (row2 instanceof Row) {
                List items = ((Row)row2).getItems();
                for (int i = 0; i < items.size(); ++i) {
                    Type expectedType = (Type)fieldTypes.get(i);
                    Expression item = (Expression)items.get(i);
                    if (this.analysis.getType(item).equals(expectedType)) continue;
                    this.analysis.addCoercion(item, expectedType);
                }
                continue;
            }
            Type expectedType = (Type)fieldTypes.get(0);
            if (this.analysis.getType(row2).equals(expectedType)) continue;
            this.analysis.addCoercion(row2, expectedType);
        }
        RelationType descriptor = new RelationType((List)fieldTypes.stream().map(valueType -> Field.newUnqualified(Optional.empty(), valueType)).collect(ImmutableCollectors.toImmutableList()));
        this.analysis.setOutputDescriptor((Node)node, descriptor);
        return descriptor;
    }

    private void analyzeWindowFunctions(QuerySpecification node, List<FieldOrExpression> outputExpressions, List<FieldOrExpression> orderByExpressions) {
        WindowFunctionExtractor extractor = new WindowFunctionExtractor();
        for (FieldOrExpression fieldOrExpression : Iterables.concat(outputExpressions, orderByExpressions)) {
            if (!fieldOrExpression.isExpression()) continue;
            extractor.process((Node)fieldOrExpression.getExpression(), null);
            new WindowFunctionValidator().process((Node)fieldOrExpression.getExpression(), this.analysis);
        }
        List<FunctionCall> windowFunctions = extractor.getWindowFunctions();
        for (FunctionCall windowFunction : windowFunctions) {
            Window window = (Window)windowFunction.getWindow().get();
            WindowFunctionExtractor nestedExtractor = new WindowFunctionExtractor();
            for (Expression argument : windowFunction.getArguments()) {
                nestedExtractor.process((Node)argument, null);
            }
            for (Expression expression2 : window.getPartitionBy()) {
                nestedExtractor.process((Node)expression2, null);
            }
            for (SortItem sortItem : window.getOrderBy()) {
                nestedExtractor.process((Node)sortItem.getSortKey(), null);
            }
            if (window.getFrame().isPresent()) {
                nestedExtractor.process((Node)window.getFrame().get(), null);
            }
            if (!nestedExtractor.getWindowFunctions().isEmpty()) {
                throw new SemanticException(SemanticErrorCode.NESTED_WINDOW, (Node)node, "Cannot nest window functions inside window function '%s': %s", windowFunction, extractor.getWindowFunctions());
            }
            if (windowFunction.isDistinct()) {
                throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "DISTINCT in window function parameters not yet supported: %s", windowFunction);
            }
            if (window.getFrame().isPresent()) {
                StatementAnalyzer.analyzeWindowFrame((WindowFrame)window.getFrame().get());
            }
            List argumentTypes = Lists.transform((List)windowFunction.getArguments(), expression -> this.analysis.getType((Expression)expression).getTypeSignature());
            FunctionKind kind = this.metadata.getFunctionRegistry().resolveFunction(windowFunction.getName(), argumentTypes, false).getKind();
            if (kind == FunctionKind.AGGREGATE || kind == FunctionKind.APPROXIMATE_AGGREGATE || kind == FunctionKind.WINDOW) continue;
            throw new SemanticException(SemanticErrorCode.MUST_BE_WINDOW_FUNCTION, (Node)node, "Not a window function: %s", windowFunction.getName());
        }
        this.analysis.setWindowFunctions(node, windowFunctions);
    }

    private static void analyzeWindowFrame(WindowFrame frame) {
        FrameBound.Type startType = frame.getStart().getType();
        FrameBound.Type endType = frame.getEnd().orElse(new FrameBound(FrameBound.Type.CURRENT_ROW)).getType();
        if (startType == FrameBound.Type.UNBOUNDED_FOLLOWING) {
            throw new SemanticException(SemanticErrorCode.INVALID_WINDOW_FRAME, (Node)frame, "Window frame start cannot be UNBOUNDED FOLLOWING", new Object[0]);
        }
        if (endType == FrameBound.Type.UNBOUNDED_PRECEDING) {
            throw new SemanticException(SemanticErrorCode.INVALID_WINDOW_FRAME, (Node)frame, "Window frame end cannot be UNBOUNDED PRECEDING", new Object[0]);
        }
        if (startType == FrameBound.Type.CURRENT_ROW && endType == FrameBound.Type.PRECEDING) {
            throw new SemanticException(SemanticErrorCode.INVALID_WINDOW_FRAME, (Node)frame, "Window frame starting from CURRENT ROW cannot end with PRECEDING", new Object[0]);
        }
        if (startType == FrameBound.Type.FOLLOWING && endType == FrameBound.Type.PRECEDING) {
            throw new SemanticException(SemanticErrorCode.INVALID_WINDOW_FRAME, (Node)frame, "Window frame starting from FOLLOWING cannot end with PRECEDING", new Object[0]);
        }
        if (startType == FrameBound.Type.FOLLOWING && endType == FrameBound.Type.CURRENT_ROW) {
            throw new SemanticException(SemanticErrorCode.INVALID_WINDOW_FRAME, (Node)frame, "Window frame starting from FOLLOWING cannot end with CURRENT ROW", new Object[0]);
        }
        if (frame.getType() == WindowFrame.Type.RANGE && (startType == FrameBound.Type.PRECEDING || endType == FrameBound.Type.PRECEDING)) {
            throw new SemanticException(SemanticErrorCode.INVALID_WINDOW_FRAME, (Node)frame, "Window frame RANGE PRECEDING is only supported with UNBOUNDED", new Object[0]);
        }
        if (frame.getType() == WindowFrame.Type.RANGE && (startType == FrameBound.Type.FOLLOWING || endType == FrameBound.Type.FOLLOWING)) {
            throw new SemanticException(SemanticErrorCode.INVALID_WINDOW_FRAME, (Node)frame, "Window frame RANGE FOLLOWING is only supported with UNBOUNDED", new Object[0]);
        }
    }

    private void analyzeHaving(QuerySpecification node, RelationType tupleDescriptor, AnalysisContext context) {
        if (node.getHaving().isPresent()) {
            Expression predicate = (Expression)node.getHaving().get();
            ExpressionAnalysis expressionAnalysis = this.analyzeExpression(predicate, tupleDescriptor, context);
            this.analysis.recordSubqueries((Node)node, expressionAnalysis);
            Type predicateType = expressionAnalysis.getType(predicate);
            if (!predicateType.equals(BooleanType.BOOLEAN) && !predicateType.equals((Object)UnknownType.UNKNOWN)) {
                throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)predicate, "HAVING clause must evaluate to a boolean: actual type %s", predicateType);
            }
            this.analysis.setHaving(node, predicate);
        }
    }

    private List<FieldOrExpression> analyzeOrderBy(QuerySpecification node, RelationType tupleDescriptor, AnalysisContext context, List<FieldOrExpression> outputExpressions) {
        List items = node.getOrderBy();
        ImmutableList.Builder orderByExpressionsBuilder = ImmutableList.builder();
        if (!items.isEmpty()) {
            ImmutableMultimap.Builder byAliasBuilder = ImmutableMultimap.builder();
            for (SelectItem item : node.getSelect().getSelectItems()) {
                Optional alias;
                if (!(item instanceof SingleColumn) || !(alias = ((SingleColumn)item).getAlias()).isPresent()) continue;
                byAliasBuilder.put((Object)QualifiedName.of((String)((String)alias.get()), (String[])new String[0]), (Object)((SingleColumn)item).getExpression());
            }
            ImmutableMultimap byAlias = byAliasBuilder.build();
            for (SortItem item : items) {
                Expression expression = item.getSortKey();
                FieldOrExpression orderByExpression = null;
                if (expression instanceof QualifiedNameReference && !((QualifiedNameReference)expression).getName().getPrefix().isPresent()) {
                    QualifiedName name = ((QualifiedNameReference)expression).getName();
                    Collection expressions = byAlias.get((Object)name);
                    if (expressions.size() > 1) {
                        throw new SemanticException(SemanticErrorCode.AMBIGUOUS_ATTRIBUTE, (Node)expression, "'%s' in ORDER BY is ambiguous", name.getSuffix());
                    }
                    if (expressions.size() == 1) {
                        orderByExpression = new FieldOrExpression((Expression)Iterables.getOnlyElement((Iterable)expressions));
                    }
                } else if (expression instanceof LongLiteral) {
                    Type type;
                    long ordinal = ((LongLiteral)expression).getValue();
                    if (ordinal < 1L || ordinal > (long)outputExpressions.size()) {
                        throw new SemanticException(SemanticErrorCode.INVALID_ORDINAL, (Node)expression, "ORDER BY position %s is not in select list", ordinal);
                    }
                    orderByExpression = outputExpressions.get(Ints.checkedCast((long)(ordinal - 1L)));
                    if (orderByExpression.isExpression()) {
                        type = this.analysis.getType(orderByExpression.getExpression());
                        if (!type.isOrderable()) {
                            throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node, "The type of expression in position %s is not orderable (actual: %s), and therefore cannot be used in ORDER BY: %s", ordinal, type, orderByExpression);
                        }
                    } else {
                        type = tupleDescriptor.getFieldByIndex(orderByExpression.getFieldIndex()).getType();
                        if (!type.isOrderable()) {
                            throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node, "The type of expression in position %s is not orderable (actual: %s), and therefore cannot be used in ORDER BY", ordinal, type);
                        }
                    }
                }
                if (orderByExpression == null) {
                    orderByExpression = new FieldOrExpression(expression);
                }
                if (orderByExpression.isExpression()) {
                    ExpressionAnalysis expressionAnalysis = this.analyzeExpression(orderByExpression.getExpression(), tupleDescriptor, context);
                    this.analysis.recordSubqueries((Node)node, expressionAnalysis);
                    Type type = expressionAnalysis.getType(orderByExpression.getExpression());
                    if (!type.isOrderable()) {
                        throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node, "Type %s is not orderable, and therefore cannot be used in ORDER BY: %s", type, expression);
                    }
                }
                orderByExpressionsBuilder.add((Object)orderByExpression);
            }
        }
        ImmutableList orderByExpressions = orderByExpressionsBuilder.build();
        this.analysis.setOrderByExpressions((Node)node, (List<FieldOrExpression>)orderByExpressions);
        if (node.getSelect().isDistinct() && !outputExpressions.containsAll((Collection<?>)orderByExpressions)) {
            throw new SemanticException(SemanticErrorCode.ORDER_BY_MUST_BE_IN_SELECT, (Node)node.getSelect(), "For SELECT DISTINCT, ORDER BY expressions must appear in select list", new Object[0]);
        }
        return orderByExpressions;
    }

    private List<List<FieldOrExpression>> analyzeGroupBy(QuerySpecification node, RelationType tupleDescriptor, AnalysisContext context, List<FieldOrExpression> outputExpressions) {
        List enumeratedGroupingSets = (List)node.getGroupBy().stream().map(GroupingElement::enumerateGroupingSets).distinct().collect(ImmutableCollectors.toImmutableList());
        Object computedGroupingSets = ImmutableList.of();
        if (!enumeratedGroupingSets.isEmpty()) {
            computedGroupingSets = (List)Sets.cartesianProduct((List)enumeratedGroupingSets).stream().map(groupingSetList -> groupingSetList.stream().flatMap(Collection::stream).distinct().collect(ImmutableCollectors.toImmutableList())).distinct().collect(ImmutableCollectors.toImmutableList());
        }
        if (computedGroupingSets.isEmpty() && !this.extractAggregates(node).isEmpty()) {
            computedGroupingSets = ImmutableList.of((Object)ImmutableList.of());
        }
        if (computedGroupingSets.size() > 1) {
            throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "Grouping by multiple sets of columns is not yet supported", new Object[0]);
        }
        List analyzedGroupingSets = (List)computedGroupingSets.stream().map(groupingSet -> this.analyzeGroupingColumns((List<Expression>)groupingSet, node, tupleDescriptor, context, outputExpressions)).collect(ImmutableCollectors.toImmutableList());
        this.analysis.setGroupingSets(node, analyzedGroupingSets);
        return analyzedGroupingSets;
    }

    private List<FieldOrExpression> analyzeGroupingColumns(List<Expression> groupingColumns, QuerySpecification node, RelationType tupleDescriptor, AnalysisContext context, List<FieldOrExpression> outputExpressions) {
        ImmutableList.Builder groupingColumnsBuilder = ImmutableList.builder();
        for (Expression groupingColumn : groupingColumns) {
            Type type;
            FieldOrExpression groupByExpression;
            if (groupingColumn instanceof LongLiteral) {
                long ordinal = ((LongLiteral)groupingColumn).getValue();
                if (ordinal < 1L || ordinal > (long)outputExpressions.size()) {
                    throw new SemanticException(SemanticErrorCode.INVALID_ORDINAL, (Node)groupingColumn, "GROUP BY position %s is not in select list", ordinal);
                }
                groupByExpression = outputExpressions.get(Ints.checkedCast((long)(ordinal - 1L)));
            } else {
                ExpressionAnalysis expressionAnalysis = this.analyzeExpression(groupingColumn, tupleDescriptor, context);
                this.analysis.recordSubqueries((Node)node, expressionAnalysis);
                groupByExpression = new FieldOrExpression(groupingColumn);
            }
            if (groupByExpression.isExpression()) {
                Analyzer.verifyNoAggregatesOrWindowFunctions(this.metadata, groupByExpression.getExpression(), "GROUP BY");
                type = this.analysis.getType(groupByExpression.getExpression());
            } else {
                type = tupleDescriptor.getFieldByIndex(groupByExpression.getFieldIndex()).getType();
            }
            if (!type.isComparable()) {
                throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node, "%s is not comparable, and therefore cannot be used in GROUP BY", type);
            }
            groupingColumnsBuilder.add((Object)groupByExpression);
        }
        return groupingColumnsBuilder.build();
    }

    private RelationType computeOutputDescriptor(QuerySpecification node, RelationType inputTupleDescriptor) {
        ImmutableList.Builder outputFields = ImmutableList.builder();
        for (SelectItem item : node.getSelect().getSelectItems()) {
            if (item instanceof AllColumns) {
                Optional starPrefix = ((AllColumns)item).getPrefix();
                for (Field field : inputTupleDescriptor.resolveFieldsWithPrefix(starPrefix)) {
                    outputFields.add((Object)Field.newUnqualified(field.getName(), field.getType()));
                }
                continue;
            }
            if (item instanceof SingleColumn) {
                SingleColumn column = (SingleColumn)item;
                Expression expression = column.getExpression();
                Optional<Object> alias = column.getAlias();
                if (!alias.isPresent()) {
                    QualifiedName name = null;
                    if (expression instanceof QualifiedNameReference) {
                        name = ((QualifiedNameReference)expression).getName();
                    } else if (expression instanceof DereferenceExpression) {
                        name = DereferenceExpression.getQualifiedName((DereferenceExpression)((DereferenceExpression)expression));
                    }
                    if (name != null) {
                        alias = Optional.of(Iterables.getLast((Iterable)name.getOriginalParts()));
                    }
                }
                outputFields.add((Object)Field.newUnqualified((Optional<String>)alias, this.analysis.getType(expression)));
                continue;
            }
            throw new IllegalArgumentException("Unsupported SelectItem type: " + item.getClass().getName());
        }
        return new RelationType((List<Field>)outputFields.build());
    }

    private List<FieldOrExpression> analyzeSelect(QuerySpecification node, RelationType tupleDescriptor, AnalysisContext context) {
        ImmutableList.Builder outputExpressionBuilder = ImmutableList.builder();
        for (SelectItem item : node.getSelect().getSelectItems()) {
            if (item instanceof AllColumns) {
                Optional starPrefix = ((AllColumns)item).getPrefix();
                List<Field> fields = tupleDescriptor.resolveFieldsWithPrefix(starPrefix);
                if (fields.isEmpty()) {
                    if (starPrefix.isPresent()) {
                        throw new SemanticException(SemanticErrorCode.MISSING_TABLE, (Node)item, "Table '%s' not found", starPrefix.get());
                    }
                    throw new SemanticException(SemanticErrorCode.WILDCARD_WITHOUT_FROM, (Node)item, "SELECT * not allowed in queries without FROM clause", new Object[0]);
                }
                for (Field field : fields) {
                    int fieldIndex = tupleDescriptor.indexOf(field);
                    outputExpressionBuilder.add((Object)new FieldOrExpression(fieldIndex));
                    if (!node.getSelect().isDistinct() || field.getType().isComparable()) continue;
                    throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node.getSelect(), "DISTINCT can only be applied to comparable types (actual: %s)", field.getType());
                }
                continue;
            }
            if (item instanceof SingleColumn) {
                SingleColumn column = (SingleColumn)item;
                ExpressionAnalysis expressionAnalysis = this.analyzeExpression(column.getExpression(), tupleDescriptor, context);
                this.analysis.recordSubqueries((Node)node, expressionAnalysis);
                outputExpressionBuilder.add((Object)new FieldOrExpression(column.getExpression()));
                Type type = expressionAnalysis.getType(column.getExpression());
                if (!node.getSelect().isDistinct() || type.isComparable()) continue;
                throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node.getSelect(), "DISTINCT can only be applied to comparable types (actual: %s): %s", type, column.getExpression());
            }
            throw new IllegalArgumentException("Unsupported SelectItem type: " + item.getClass().getName());
        }
        ImmutableList result = outputExpressionBuilder.build();
        this.analysis.setOutputExpressions((Node)node, (List<FieldOrExpression>)result);
        return result;
    }

    public void analyzeWhere(Node node, RelationType tupleDescriptor, AnalysisContext context, Expression predicate) {
        Analyzer.verifyNoAggregatesOrWindowFunctions(this.metadata, predicate, "WHERE");
        ExpressionAnalysis expressionAnalysis = this.analyzeExpression(predicate, tupleDescriptor, context);
        this.analysis.recordSubqueries(node, expressionAnalysis);
        Type predicateType = expressionAnalysis.getType(predicate);
        if (!predicateType.equals(BooleanType.BOOLEAN)) {
            if (!predicateType.equals((Object)UnknownType.UNKNOWN)) {
                throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)predicate, "WHERE clause must evaluate to a boolean: actual type %s", predicateType);
            }
            this.analysis.addCoercion(predicate, (Type)BooleanType.BOOLEAN);
        }
        this.analysis.setWhere(node, predicate);
    }

    private RelationType analyzeFrom(QuerySpecification node, AnalysisContext context) {
        RelationType fromDescriptor = new RelationType(new Field[0]);
        if (node.getFrom().isPresent()) {
            fromDescriptor = (RelationType)this.process((Node)node.getFrom().get(), context);
        }
        return fromDescriptor;
    }

    private void analyzeAggregations(QuerySpecification node, RelationType tupleDescriptor, List<List<FieldOrExpression>> groupingSets, List<FieldOrExpression> outputExpressions, List<FieldOrExpression> orderByExpressions, AnalysisContext context, Set<Expression> columnReferences) {
        List<FunctionCall> aggregates = this.extractAggregates(node);
        if (context.isApproximate() && aggregates.stream().anyMatch(FunctionCall::isDistinct)) {
            throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "DISTINCT aggregations not supported for approximate queries", new Object[0]);
        }
        ImmutableList allGroupingColumns = groupingSets.stream().flatMap(Collection::stream).distinct().collect(ImmutableCollectors.toImmutableList());
        if (!groupingSets.isEmpty()) {
            for (FieldOrExpression fieldOrExpression : Iterables.concat(outputExpressions, orderByExpressions)) {
                this.verifyAggregations(node, (List<FieldOrExpression>)allGroupingColumns, tupleDescriptor, fieldOrExpression, columnReferences);
            }
            if (node.getHaving().isPresent()) {
                this.verifyAggregations(node, (List<FieldOrExpression>)allGroupingColumns, tupleDescriptor, new FieldOrExpression((Expression)node.getHaving().get()), columnReferences);
            }
        }
    }

    private List<FunctionCall> extractAggregates(QuerySpecification node) {
        AggregateExtractor extractor = new AggregateExtractor(this.metadata);
        for (SelectItem item : node.getSelect().getSelectItems()) {
            if (!(item instanceof SingleColumn)) continue;
            extractor.process((Node)((SingleColumn)item).getExpression(), null);
        }
        for (SelectItem item : node.getOrderBy()) {
            extractor.process((Node)item.getSortKey(), null);
        }
        if (node.getHaving().isPresent()) {
            extractor.process((Node)node.getHaving().get(), null);
        }
        List<FunctionCall> aggregates = extractor.getAggregates();
        this.analysis.setAggregates(node, aggregates);
        return aggregates;
    }

    private void verifyAggregations(QuerySpecification node, List<FieldOrExpression> groupByExpressions, RelationType tupleDescriptor, FieldOrExpression fieldOrExpression, Set<Expression> columnReferences) {
        AggregationAnalyzer analyzer = new AggregationAnalyzer(groupByExpressions, this.metadata, tupleDescriptor, columnReferences);
        if (fieldOrExpression.isExpression()) {
            analyzer.analyze(fieldOrExpression.getExpression());
        } else {
            int fieldIndex = fieldOrExpression.getFieldIndex();
            if (!analyzer.analyze(fieldIndex)) {
                Field field = tupleDescriptor.getFieldByIndex(fieldIndex);
                if (field.getRelationAlias().isPresent()) {
                    if (field.getName().isPresent()) {
                        throw new SemanticException(SemanticErrorCode.MUST_BE_AGGREGATE_OR_GROUP_BY, (Node)node, "Column '%s.%s' not in GROUP BY clause", field.getRelationAlias().get(), field.getName().get());
                    }
                    throw new SemanticException(SemanticErrorCode.MUST_BE_AGGREGATE_OR_GROUP_BY, (Node)node, "Columns from '%s' not in GROUP BY clause", field.getRelationAlias().get());
                }
                if (field.getName().isPresent()) {
                    throw new SemanticException(SemanticErrorCode.MUST_BE_AGGREGATE_OR_GROUP_BY, (Node)node, "Column '%s' not in GROUP BY clause", field.getName().get());
                }
                throw new SemanticException(SemanticErrorCode.MUST_BE_AGGREGATE_OR_GROUP_BY, (Node)node, "Some columns from FROM clause not in GROUP BY clause", new Object[0]);
            }
        }
    }

    private RelationType analyzeView(Query query, QualifiedObjectName name, Optional<String> catalog, Optional<String> schema, Optional<String> owner, Table node) {
        try {
            AccessControl viewAccessControl;
            Identity identity;
            if (owner.isPresent()) {
                identity = new Identity(owner.get(), Optional.empty());
                viewAccessControl = new ViewAccessControl(this.accessControl);
            } else {
                identity = this.session.getIdentity();
                viewAccessControl = this.accessControl;
            }
            Session viewSession = Session.builder(this.metadata.getSessionPropertyManager()).setQueryId(this.session.getQueryId()).setTransactionId(this.session.getTransactionId().orElse(null)).setIdentity(identity).setSource(this.session.getSource().orElse(null)).setCatalog(catalog.orElse(null)).setSchema(schema.orElse(null)).setTimeZoneKey(this.session.getTimeZoneKey()).setLocale(this.session.getLocale()).setRemoteUserAddress(this.session.getRemoteUserAddress().orElse(null)).setUserAgent(this.session.getUserAgent().orElse(null)).setStartTime(this.session.getStartTime()).build();
            StatementAnalyzer analyzer = new StatementAnalyzer(this.analysis, this.metadata, this.sqlParser, viewAccessControl, viewSession, this.experimentalSyntaxEnabled, Optional.empty());
            return (RelationType)analyzer.process((Node)query, new AnalysisContext());
        }
        catch (RuntimeException e) {
            throw new SemanticException(SemanticErrorCode.VIEW_ANALYSIS_ERROR, (Node)node, "Failed analyzing stored view '%s': %s", name, e.getMessage());
        }
    }

    private Query parseView(String view, QualifiedObjectName name, Table node) {
        try {
            Statement statement = this.sqlParser.createStatement(view);
            return Types.checkType(statement, Query.class, "parsed view");
        }
        catch (ParsingException e) {
            throw new SemanticException(SemanticErrorCode.VIEW_PARSE_ERROR, (Node)node, "Failed parsing stored view '%s': %s", name, e.getMessage());
        }
    }

    private static boolean isViewStale(List<ViewDefinition.ViewColumn> columns, Collection<Field> fields) {
        if (columns.size() != fields.size()) {
            return true;
        }
        ImmutableList fieldList = ImmutableList.copyOf(fields);
        for (int i = 0; i < columns.size(); ++i) {
            ViewDefinition.ViewColumn column = columns.get(i);
            Field field = (Field)fieldList.get(i);
            if (column.getName().equals(field.getName().orElse(null)) && TypeRegistry.canCoerce(field.getType(), column.getType())) continue;
            return true;
        }
        return false;
    }

    private ExpressionAnalysis analyzeExpression(Expression expression, RelationType tupleDescriptor, AnalysisContext context) {
        return ExpressionAnalyzer.analyzeExpression(this.session, this.metadata, this.accessControl, this.sqlParser, tupleDescriptor, this.analysis, this.experimentalSyntaxEnabled, context, expression);
    }

    private static List<FieldOrExpression> descriptorToFields(RelationType tupleDescriptor) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int fieldIndex = 0; fieldIndex < tupleDescriptor.getAllFieldCount(); ++fieldIndex) {
            builder.add((Object)new FieldOrExpression(fieldIndex));
        }
        return builder.build();
    }

    private void analyzeWith(Query node, AnalysisContext context) {
        if (!node.getWith().isPresent()) {
            return;
        }
        With with = (With)node.getWith().get();
        if (with.isRecursive()) {
            throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)with, "Recursive WITH queries are not supported", new Object[0]);
        }
        for (WithQuery withQuery : with.getQueries()) {
            if (withQuery.getColumnNames() != null && !withQuery.getColumnNames().isEmpty()) {
                throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)withQuery, "Column alias not supported in WITH queries", new Object[0]);
            }
            Query query = withQuery.getQuery();
            this.process((Node)query, context);
            String name = withQuery.getName();
            if (context.isNamedQueryDeclared(name)) {
                throw new SemanticException(SemanticErrorCode.DUPLICATE_RELATION, (Node)withQuery, "WITH query name '%s' specified more than once", name);
            }
            context.addNamedQuery(name, query);
        }
    }

    private void analyzeOrderBy(Query node, RelationType tupleDescriptor, AnalysisContext context) {
        List items = node.getOrderBy();
        ImmutableList.Builder orderByFieldsBuilder = ImmutableList.builder();
        if (!items.isEmpty()) {
            for (SortItem item : items) {
                FieldOrExpression orderByField;
                Expression expression = item.getSortKey();
                if (expression instanceof LongLiteral) {
                    long ordinal = ((LongLiteral)expression).getValue();
                    if (ordinal < 1L || ordinal > (long)tupleDescriptor.getVisibleFieldCount()) {
                        throw new SemanticException(SemanticErrorCode.INVALID_ORDINAL, (Node)expression, "ORDER BY position %s is not in select list", ordinal);
                    }
                    orderByField = new FieldOrExpression(Ints.checkedCast((long)(ordinal - 1L)));
                } else {
                    orderByField = new FieldOrExpression(expression);
                    ExpressionAnalysis expressionAnalysis = ExpressionAnalyzer.analyzeExpression(this.session, this.metadata, this.accessControl, this.sqlParser, tupleDescriptor, this.analysis, this.experimentalSyntaxEnabled, context, orderByField.getExpression());
                    this.analysis.recordSubqueries((Node)node, expressionAnalysis);
                }
                orderByFieldsBuilder.add((Object)orderByField);
            }
        }
        this.analysis.setOrderByExpressions((Node)node, (List<FieldOrExpression>)orderByFieldsBuilder.build());
    }

    private static Relation from(String catalog, SchemaTableName table) {
        return QueryUtil.table((QualifiedName)QualifiedName.of((String)catalog, (String[])new String[]{table.getSchemaName(), table.getTableName()}));
    }
}

