/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql;

import com.facebook.presto.sql.planner.DependencyExtractor;
import com.facebook.presto.sql.planner.DeterminismEvaluator;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.tree.BooleanLiteral;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.IsNullPredicate;
import com.facebook.presto.sql.tree.LogicalBinaryExpression;
import com.facebook.presto.sql.tree.NotExpression;
import com.facebook.presto.sql.tree.QualifiedNameReference;
import com.facebook.presto.util.ImmutableCollectors;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public final class ExpressionUtils {
    private ExpressionUtils() {
    }

    public static List<Expression> extractConjuncts(Expression expression) {
        return ExpressionUtils.extractPredicates(LogicalBinaryExpression.Type.AND, expression);
    }

    public static List<Expression> extractDisjuncts(Expression expression) {
        return ExpressionUtils.extractPredicates(LogicalBinaryExpression.Type.OR, expression);
    }

    public static List<Expression> extractPredicates(LogicalBinaryExpression expression) {
        return ExpressionUtils.extractPredicates(expression.getType(), (Expression)expression);
    }

    public static List<Expression> extractPredicates(LogicalBinaryExpression.Type type, Expression expression) {
        if (expression instanceof LogicalBinaryExpression && ((LogicalBinaryExpression)expression).getType() == type) {
            LogicalBinaryExpression logicalBinaryExpression = (LogicalBinaryExpression)expression;
            return ImmutableList.builder().addAll(ExpressionUtils.extractPredicates(type, logicalBinaryExpression.getLeft())).addAll(ExpressionUtils.extractPredicates(type, logicalBinaryExpression.getRight())).build();
        }
        return ImmutableList.of((Object)expression);
    }

    public static Expression and(Expression ... expressions) {
        return ExpressionUtils.and(Arrays.asList(expressions));
    }

    public static Expression and(Iterable<Expression> expressions) {
        return ExpressionUtils.binaryExpression(LogicalBinaryExpression.Type.AND, expressions);
    }

    public static Expression or(Expression ... expressions) {
        return ExpressionUtils.or(Arrays.asList(expressions));
    }

    public static Expression or(Iterable<Expression> expressions) {
        return ExpressionUtils.binaryExpression(LogicalBinaryExpression.Type.OR, expressions);
    }

    public static Expression binaryExpression(LogicalBinaryExpression.Type type, Iterable<Expression> expressions) {
        Objects.requireNonNull(type, "type is null");
        Objects.requireNonNull(expressions, "expressions is null");
        Preconditions.checkArgument((!Iterables.isEmpty(expressions) ? 1 : 0) != 0, (Object)"expressions is empty");
        ArrayDeque<LogicalBinaryExpression> queue = new ArrayDeque<LogicalBinaryExpression>(Lists.newArrayList(expressions));
        while (queue.size() > 1) {
            queue.add(new LogicalBinaryExpression(type, (Expression)queue.remove(), (Expression)queue.remove()));
        }
        return (Expression)queue.remove();
    }

    public static Expression combinePredicates(LogicalBinaryExpression.Type type, Expression ... expressions) {
        return ExpressionUtils.combinePredicates(type, Arrays.asList(expressions));
    }

    public static Expression combinePredicates(LogicalBinaryExpression.Type type, Iterable<Expression> expressions) {
        if (type == LogicalBinaryExpression.Type.AND) {
            return ExpressionUtils.combineConjuncts(expressions);
        }
        return ExpressionUtils.combineDisjuncts(expressions);
    }

    public static Expression combineConjuncts(Expression ... expressions) {
        return ExpressionUtils.combineConjuncts(Arrays.asList(expressions));
    }

    public static Expression combineConjuncts(Iterable<Expression> expressions) {
        return ExpressionUtils.combineConjunctsWithDefault(expressions, (Expression)BooleanLiteral.TRUE_LITERAL);
    }

    public static Expression combineConjunctsWithDefault(Iterable<Expression> expressions, Expression emptyDefault) {
        Objects.requireNonNull(expressions, "expressions is null");
        expressions = Iterables.concat((Iterable)Iterables.transform(expressions, ExpressionUtils::extractConjuncts));
        expressions = Iterables.filter((Iterable)expressions, (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)BooleanLiteral.TRUE_LITERAL)));
        expressions = ExpressionUtils.removeDuplicates(expressions);
        if (Iterables.contains(expressions, (Object)BooleanLiteral.FALSE_LITERAL)) {
            return BooleanLiteral.FALSE_LITERAL;
        }
        return Iterables.isEmpty(expressions) ? emptyDefault : ExpressionUtils.and(expressions);
    }

    public static Expression combineDisjuncts(Expression ... expressions) {
        return ExpressionUtils.combineDisjuncts(Arrays.asList(expressions));
    }

    public static Expression combineDisjuncts(Iterable<Expression> expressions) {
        return ExpressionUtils.combineDisjunctsWithDefault(expressions, (Expression)BooleanLiteral.FALSE_LITERAL);
    }

    public static Expression combineDisjunctsWithDefault(Iterable<Expression> expressions, Expression emptyDefault) {
        Objects.requireNonNull(expressions, "expressions is null");
        expressions = Iterables.concat((Iterable)Iterables.transform(expressions, ExpressionUtils::extractDisjuncts));
        expressions = Iterables.filter((Iterable)expressions, (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)BooleanLiteral.FALSE_LITERAL)));
        expressions = ExpressionUtils.removeDuplicates(expressions);
        if (Iterables.contains(expressions, (Object)BooleanLiteral.TRUE_LITERAL)) {
            return BooleanLiteral.TRUE_LITERAL;
        }
        return Iterables.isEmpty(expressions) ? emptyDefault : ExpressionUtils.or(expressions);
    }

    public static Expression stripNonDeterministicConjuncts(Expression expression) {
        return ExpressionUtils.combineConjuncts(Iterables.filter(ExpressionUtils.extractConjuncts(expression), DeterminismEvaluator::isDeterministic));
    }

    public static Expression stripDeterministicConjuncts(Expression expression) {
        return ExpressionUtils.combineConjuncts((Iterable)ExpressionUtils.extractConjuncts(expression).stream().filter(conjunct -> !DeterminismEvaluator.isDeterministic(conjunct)).collect(ImmutableCollectors.toImmutableList()));
    }

    public static Function<Expression, Expression> expressionOrNullSymbols(Predicate<Symbol> ... nullSymbolScopes) {
        return expression -> {
            ImmutableList.Builder resultDisjunct = ImmutableList.builder();
            resultDisjunct.add(expression);
            for (Predicate nullSymbolScope : nullSymbolScopes) {
                Iterable symbols = Iterables.filter(DependencyExtractor.extractUnique(expression), (Predicate)nullSymbolScope);
                if (Iterables.isEmpty((Iterable)symbols)) continue;
                ImmutableList.Builder nullConjuncts = ImmutableList.builder();
                for (Symbol symbol : symbols) {
                    nullConjuncts.add((Object)new IsNullPredicate((Expression)new QualifiedNameReference(symbol.toQualifiedName())));
                }
                resultDisjunct.add((Object)ExpressionUtils.and((Iterable<Expression>)nullConjuncts.build()));
            }
            return ExpressionUtils.or((Iterable<Expression>)resultDisjunct.build());
        };
    }

    private static Iterable<Expression> removeDuplicates(Iterable<Expression> expressions) {
        Iterable nonDeterministicDisjuncts = Iterables.filter(expressions, (Predicate)Predicates.not(DeterminismEvaluator::isDeterministic));
        ImmutableSet deterministicDisjuncts = ImmutableSet.copyOf((Iterable)Iterables.filter(expressions, DeterminismEvaluator::isDeterministic));
        return Iterables.concat((Iterable)nonDeterministicDisjuncts, (Iterable)deterministicDisjuncts);
    }

    public static Expression normalize(Expression expression) {
        NotExpression not;
        if (expression instanceof NotExpression && (not = (NotExpression)expression).getValue() instanceof ComparisonExpression && ((ComparisonExpression)not.getValue()).getType() != ComparisonExpression.Type.IS_DISTINCT_FROM) {
            ComparisonExpression comparison = (ComparisonExpression)not.getValue();
            return new ComparisonExpression(comparison.getType().negate(), comparison.getLeft(), comparison.getRight());
        }
        return expression;
    }
}

