/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.google.common.base.StandardSystemProperty;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.nio.ByteOrder;
import org.joda.time.DateTime;

final class PrestoSystemRequirements {
    private PrestoSystemRequirements() {
    }

    public static void verifyJvmRequirements() {
        String dataModel;
        String vendor;
        String specVersion = StandardSystemProperty.JAVA_SPECIFICATION_VERSION.value();
        if (specVersion == null || specVersion.compareTo("1.8") < 0) {
            PrestoSystemRequirements.failRequirement("Presto requires Java 1.8+ (found %s)", specVersion);
        }
        if (!"Oracle Corporation".equals(vendor = StandardSystemProperty.JAVA_VENDOR.value())) {
            PrestoSystemRequirements.failRequirement("Presto requires an Oracle or OpenJDK JVM (found %s)", vendor);
        }
        if (!"64".equals(dataModel = System.getProperty("sun.arch.data.model"))) {
            PrestoSystemRequirements.failRequirement("Presto requires a 64-bit JVM (found %s)", dataModel);
        }
        String osName = StandardSystemProperty.OS_NAME.value();
        String osArch = StandardSystemProperty.OS_ARCH.value();
        if ("Linux".equals(osName)) {
            if (!"amd64".equals(osArch)) {
                PrestoSystemRequirements.failRequirement("Presto requires x86-64 or amd64 on Linux (found %s)", osArch);
            }
        } else if ("Mac OS X".equals(osName)) {
            if (!"x86_64".equals(osArch)) {
                PrestoSystemRequirements.failRequirement("Presto requires x86_64 on Mac OS X (found %s)", osArch);
            }
        } else {
            PrestoSystemRequirements.failRequirement("Presto requires Linux or Mac OS X (found %s)", osName);
        }
        if (!ByteOrder.nativeOrder().equals(ByteOrder.LITTLE_ENDIAN)) {
            PrestoSystemRequirements.failRequirement("Presto requires a little endian platform (found %s)", ByteOrder.nativeOrder());
        }
        PrestoSystemRequirements.verifySlice();
    }

    private static void verifySlice() {
        Slice slice = Slices.wrappedBuffer((byte[])new byte[5]);
        slice.setByte(4, 222);
        slice.setByte(3, 173);
        slice.setByte(2, 190);
        slice.setByte(1, 239);
        if (slice.getInt(1) != -559038737) {
            PrestoSystemRequirements.failRequirement("Slice library produced an unexpected result", new Object[0]);
        }
    }

    public static void verifySystemTimeIsReasonable() {
        int currentYear = DateTime.now().year().get();
        if (currentYear < 2015) {
            PrestoSystemRequirements.failRequirement("Presto requires the system time to be current (found year %s)", currentYear);
        }
    }

    private static void failRequirement(String format, Object ... args) {
        System.err.println(String.format(format, args));
        System.exit(100);
    }
}

