/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.SqlOperator;
import com.facebook.presto.metadata.TypeParameterRequirement;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementation;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeUtils;
import com.facebook.presto.util.Reflection;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Map;

public class ArrayEqualOperator
extends SqlOperator {
    public static final ArrayEqualOperator ARRAY_EQUAL = new ArrayEqualOperator();
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(ArrayEqualOperator.class, "equals", MethodHandle.class, Type.class, Block.class, Block.class);

    private ArrayEqualOperator() {
        super(OperatorType.EQUAL, (List<TypeParameterRequirement>)ImmutableList.of((Object)Signature.comparableTypeParameter("T")), "boolean", (List<String>)ImmutableList.of((Object)"array(T)", (Object)"array(T)"));
    }

    @Override
    public ScalarFunctionImplementation specialize(Map<String, Type> types, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        Type elementType = types.get("T");
        MethodHandle equalsFunction = functionRegistry.getScalarFunctionImplementation(Signature.internalOperator(OperatorType.EQUAL, (Type)BooleanType.BOOLEAN, (List<? extends Type>)ImmutableList.of((Object)elementType, (Object)elementType))).getMethodHandle();
        MethodHandle method = METHOD_HANDLE.bindTo(equalsFunction).bindTo(elementType);
        return new ScalarFunctionImplementation(false, (List<Boolean>)ImmutableList.of((Object)false, (Object)false), method, this.isDeterministic());
    }

    public static boolean equals(MethodHandle equalsFunction, Type type, Block leftArray, Block rightArray) {
        if (leftArray.getPositionCount() != rightArray.getPositionCount()) {
            return false;
        }
        for (int i = 0; i < leftArray.getPositionCount(); ++i) {
            com.facebook.presto.type.TypeUtils.checkElementNotNull(leftArray.isNull(i), "ARRAY comparison not supported for arrays with null elements");
            com.facebook.presto.type.TypeUtils.checkElementNotNull(rightArray.isNull(i), "ARRAY comparison not supported for arrays with null elements");
            Object leftElement = TypeUtils.readNativeValue((Type)type, (Block)leftArray, (int)i);
            Object rightElement = TypeUtils.readNativeValue((Type)type, (Block)rightArray, (int)i);
            try {
                if (equalsFunction.invoke(leftElement, rightElement)) continue;
                return false;
            }
            catch (Throwable t) {
                Throwables.propagateIfInstanceOf((Throwable)t, Error.class);
                Throwables.propagateIfInstanceOf((Throwable)t, PrestoException.class);
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INTERNAL_ERROR, t);
            }
        }
        return true;
    }
}

