/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.HashGenerator;
import com.facebook.presto.operator.InterpretedHashGenerator;
import com.facebook.presto.operator.LookupSource;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.type.Type;
import it.unimi.dsi.fastutil.HashCommon;
import java.util.Arrays;
import java.util.List;

public class PartitionedLookupSource
implements LookupSource {
    private final LookupSource[] lookupSources;
    private final HashGenerator hashGenerator;
    private final int partitionMask;

    public PartitionedLookupSource(List<? extends LookupSource> lookupSources, List<Type> hashChannelTypes) {
        this.lookupSources = lookupSources.toArray(new LookupSource[lookupSources.size()]);
        int[] hashChannels = new int[hashChannelTypes.size()];
        for (int i = 0; i < hashChannels.length; ++i) {
            hashChannels[i] = i;
        }
        this.hashGenerator = new InterpretedHashGenerator(hashChannelTypes, hashChannels);
        this.partitionMask = lookupSources.size() - 1;
    }

    @Override
    public int getChannelCount() {
        return this.lookupSources[0].getChannelCount();
    }

    @Override
    public int getJoinPositionCount() {
        throw new UnsupportedOperationException("Parallel hash can not be used in a RIGHT or FULL outer join");
    }

    @Override
    public long getInMemorySizeInBytes() {
        return Arrays.stream(this.lookupSources).mapToLong(LookupSource::getInMemorySizeInBytes).sum();
    }

    @Override
    public long getJoinPosition(int position, Page page) {
        return this.getJoinPosition(position, page, this.hashGenerator.hashPosition(position, page));
    }

    @Override
    public long getJoinPosition(int position, Page page, int rawHash) {
        int partition = HashCommon.murmurHash3((int)rawHash) & this.partitionMask;
        LookupSource lookupSource = this.lookupSources[partition];
        long joinPosition = lookupSource.getJoinPosition(position, page, rawHash);
        if (joinPosition < 0L) {
            return joinPosition;
        }
        return this.encodePartitionedJoinPosition(partition, joinPosition);
    }

    @Override
    public long getNextJoinPosition(long partitionedJoinPosition) {
        int partition = (int)(partitionedJoinPosition & (long)this.partitionMask);
        LookupSource lookupSource = this.lookupSources[partition];
        long joinPosition = partitionedJoinPosition >>> this.lookupSources.length;
        long nextJoinPosition = lookupSource.getNextJoinPosition(joinPosition);
        if (nextJoinPosition < 0L) {
            return nextJoinPosition;
        }
        return this.encodePartitionedJoinPosition(partition, nextJoinPosition);
    }

    @Override
    public void appendTo(long partitionedJoinPosition, PageBuilder pageBuilder, int outputChannelOffset) {
        int partition = (int)(partitionedJoinPosition & (long)this.partitionMask);
        long joinPosition = partitionedJoinPosition >>> this.lookupSources.length;
        LookupSource lookupSource = this.lookupSources[partition];
        lookupSource.appendTo(joinPosition, pageBuilder, outputChannelOffset);
    }

    @Override
    public void close() {
        for (LookupSource lookupSource : this.lookupSources) {
            lookupSource.close();
        }
    }

    private long encodePartitionedJoinPosition(int partition, long joinPosition) {
        return joinPosition << this.lookupSources.length | (long)partition;
    }
}

