/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.metadata.TableLayoutHandle;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorTableLayout;
import com.facebook.presto.spi.DiscretePredicates;
import com.facebook.presto.spi.LocalProperty;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.sql.planner.PartitioningHandle;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class TableLayout {
    private final TableLayoutHandle handle;
    private final ConnectorTableLayout layout;

    public TableLayout(TableLayoutHandle handle, ConnectorTableLayout layout) {
        Objects.requireNonNull(handle, "handle is null");
        Objects.requireNonNull(layout, "layout is null");
        this.handle = handle;
        this.layout = layout;
    }

    public String getConnectorId() {
        return this.handle.getConnectorId();
    }

    public Optional<List<ColumnHandle>> getColumns() {
        return this.layout.getColumns();
    }

    public TupleDomain<ColumnHandle> getPredicate() {
        return this.layout.getPredicate();
    }

    public List<LocalProperty<ColumnHandle>> getLocalProperties() {
        return this.layout.getLocalProperties();
    }

    public TableLayoutHandle getHandle() {
        return this.handle;
    }

    public Optional<NodePartitioning> getNodePartitioning() {
        return this.layout.getNodePartitioning().map(nodePartitioning -> new NodePartitioning(new PartitioningHandle(Optional.of(this.handle.getConnectorId()), Optional.of(this.handle.getTransactionHandle()), nodePartitioning.getPartitioningHandle()), nodePartitioning.getPartitioningColumns()));
    }

    public Optional<Set<ColumnHandle>> getPartitioningColumns() {
        return this.layout.getStreamPartitioningColumns();
    }

    public Optional<DiscretePredicates> getDiscretePredicates() {
        return this.layout.getDiscretePredicates();
    }

    public static TableLayout fromConnectorLayout(String connectorId, ConnectorTransactionHandle transactionHandle, ConnectorTableLayout layout) {
        return new TableLayout(new TableLayoutHandle(connectorId, transactionHandle, layout.getHandle()), layout);
    }

    public static class NodePartitioning {
        private final PartitioningHandle partitioningHandle;
        private final List<ColumnHandle> partitioningColumns;

        public NodePartitioning(PartitioningHandle partitioningHandle, List<ColumnHandle> partitioningColumns) {
            this.partitioningHandle = Objects.requireNonNull(partitioningHandle, "partitioningHandle is null");
            this.partitioningColumns = ImmutableList.copyOf((Collection)Objects.requireNonNull(partitioningColumns, "partitioningColumns is null"));
        }

        public PartitioningHandle getPartitioningHandle() {
            return this.partitioningHandle;
        }

        public List<ColumnHandle> getPartitioningColumns() {
            return this.partitioningColumns;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NodePartitioning that = (NodePartitioning)o;
            return Objects.equals(this.partitioningHandle, that.partitioningHandle) && Objects.equals(this.partitioningColumns, that.partitioningColumns);
        }

        public int hashCode() {
            return Objects.hash(this.partitioningHandle, this.partitioningColumns);
        }
    }
}

