/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.memory;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.DefunctConfig;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.airlift.units.MinDuration;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.NotNull;

@DefunctConfig(value={"experimental.cluster-memory-manager-enabled"})
public class MemoryManagerConfig {
    public static final String QUERY_MAX_MEMORY_PER_NODE_CONFIG = "query.max-memory-per-node";
    private DataSize maxQueryMemory = new DataSize(20.0, DataSize.Unit.GIGABYTE);
    private DataSize maxQueryMemoryPerNode = new DataSize(1.0, DataSize.Unit.GIGABYTE);
    private boolean killOnOutOfMemory;
    private Duration killOnOutOfMemoryDelay = new Duration(5.0, TimeUnit.MINUTES);

    public boolean isKillOnOutOfMemory() {
        return this.killOnOutOfMemory;
    }

    @Config(value="query.low-memory-killer.enabled")
    @ConfigDescription(value="Enable low memory killer")
    public MemoryManagerConfig setKillOnOutOfMemory(boolean killOnOutOfMemory) {
        this.killOnOutOfMemory = killOnOutOfMemory;
        return this;
    }

    @NotNull
    @MinDuration(value="5s")
    public Duration getKillOnOutOfMemoryDelay() {
        return this.killOnOutOfMemoryDelay;
    }

    @Config(value="query.low-memory-killer.delay")
    @ConfigDescription(value="Delay between cluster running low on memory and invoking killer")
    public MemoryManagerConfig setKillOnOutOfMemoryDelay(Duration killOnOutOfMemoryDelay) {
        this.killOnOutOfMemoryDelay = killOnOutOfMemoryDelay;
        return this;
    }

    @NotNull
    public DataSize getMaxQueryMemory() {
        return this.maxQueryMemory;
    }

    @Config(value="query.max-memory")
    public MemoryManagerConfig setMaxQueryMemory(DataSize maxQueryMemory) {
        this.maxQueryMemory = maxQueryMemory;
        return this;
    }

    @NotNull
    public DataSize getMaxQueryMemoryPerNode() {
        return this.maxQueryMemoryPerNode;
    }

    @Config(value="query.max-memory-per-node")
    public MemoryManagerConfig setMaxQueryMemoryPerNode(DataSize maxQueryMemoryPerNode) {
        this.maxQueryMemoryPerNode = maxQueryMemoryPerNode;
        return this;
    }
}

