/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.util;

import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public final class Reflection {
    private Reflection() {
    }

    public static Field field(Class<?> clazz, String name) {
        try {
            return clazz.getField(name);
        }
        catch (NoSuchFieldException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INTERNAL_ERROR, (Throwable)e);
        }
    }

    public static Method method(Class<?> clazz, String name, Class<?> ... parameterTypes) {
        try {
            return clazz.getMethod(name, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INTERNAL_ERROR, (Throwable)e);
        }
    }

    public static MethodHandle methodHandle(Class<?> clazz, String name, Class<?> ... parameterTypes) {
        try {
            return MethodHandles.lookup().unreflect(clazz.getMethod(name, parameterTypes));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INTERNAL_ERROR, (Throwable)e);
        }
    }

    public static MethodHandle constructorMethodHandle(StandardErrorCode errorCode, Class<?> clazz, Class<?> ... parameterTypes) {
        try {
            return MethodHandles.lookup().unreflectConstructor(clazz.getConstructor(parameterTypes));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new PrestoException((ErrorCodeSupplier)errorCode, (Throwable)e);
        }
    }
}

