/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.HyperLogLogType;
import com.facebook.presto.spi.type.IntervalDayTimeType;
import com.facebook.presto.spi.type.IntervalYearMonthType;
import com.facebook.presto.spi.type.P4HyperLogLogType;
import com.facebook.presto.spi.type.TimeType;
import com.facebook.presto.spi.type.TimeWithTimeZoneType;
import com.facebook.presto.spi.type.TimestampType;
import com.facebook.presto.spi.type.TimestampWithTimeZoneType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeParameter;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.spi.type.TypeSignatureParameter;
import com.facebook.presto.spi.type.VarbinaryType;
import com.facebook.presto.type.ArrayParametricType;
import com.facebook.presto.type.ColorType;
import com.facebook.presto.type.FunctionParametricType;
import com.facebook.presto.type.JsonPathType;
import com.facebook.presto.type.JsonType;
import com.facebook.presto.type.LikePatternType;
import com.facebook.presto.type.MapParametricType;
import com.facebook.presto.type.ParametricType;
import com.facebook.presto.type.RegexpType;
import com.facebook.presto.type.RowParametricType;
import com.facebook.presto.type.UnknownType;
import com.facebook.presto.type.VarcharParametricType;
import com.facebook.presto.util.ImmutableCollectors;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;

@ThreadSafe
public final class TypeRegistry
implements TypeManager {
    private final ConcurrentMap<TypeSignature, Type> types = new ConcurrentHashMap<TypeSignature, Type>();
    private final ConcurrentMap<String, ParametricType> parametricTypes = new ConcurrentHashMap<String, ParametricType>();

    public TypeRegistry() {
        this((Set<Type>)ImmutableSet.of());
    }

    @Inject
    public TypeRegistry(Set<Type> types) {
        Objects.requireNonNull(types, "types is null");
        this.types.put(UnknownType.UNKNOWN.getTypeSignature(), (Type)UnknownType.UNKNOWN);
        this.addType((Type)BooleanType.BOOLEAN);
        this.addType((Type)BigintType.BIGINT);
        this.addType((Type)DoubleType.DOUBLE);
        this.addType((Type)VarbinaryType.VARBINARY);
        this.addType((Type)DateType.DATE);
        this.addType((Type)TimeType.TIME);
        this.addType((Type)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE);
        this.addType((Type)TimestampType.TIMESTAMP);
        this.addType((Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE);
        this.addType((Type)IntervalYearMonthType.INTERVAL_YEAR_MONTH);
        this.addType((Type)IntervalDayTimeType.INTERVAL_DAY_TIME);
        this.addType((Type)HyperLogLogType.HYPER_LOG_LOG);
        this.addType((Type)P4HyperLogLogType.P4_HYPER_LOG_LOG);
        this.addType((Type)RegexpType.REGEXP);
        this.addType((Type)LikePatternType.LIKE_PATTERN);
        this.addType((Type)JsonPathType.JSON_PATH);
        this.addType((Type)ColorType.COLOR);
        this.addType((Type)JsonType.JSON);
        this.addParametricType(VarcharParametricType.VARCHAR);
        this.addParametricType(RowParametricType.ROW);
        this.addParametricType(ArrayParametricType.ARRAY);
        this.addParametricType(MapParametricType.MAP);
        this.addParametricType(FunctionParametricType.FUNCTION);
        for (Type type : types) {
            this.addType(type);
        }
    }

    public Type getType(TypeSignature signature) {
        Type type = (Type)this.types.get(signature);
        if (type == null) {
            return this.instantiateParametricType(signature);
        }
        return type;
    }

    public Type getParameterizedType(String baseTypeName, List<TypeSignatureParameter> typeParameters) {
        return this.getType(new TypeSignature(baseTypeName, typeParameters));
    }

    @Deprecated
    public Type getParameterizedType(String baseTypeName, List<TypeSignature> typeParameters, List<String> literalParameters) {
        if (baseTypeName.equals("row")) {
            return this.getType(new TypeSignature(baseTypeName, typeParameters, literalParameters));
        }
        return this.getParameterizedType(baseTypeName, typeParameters.stream().map(TypeSignatureParameter::of).collect(Collectors.toList()));
    }

    private Type instantiateParametricType(TypeSignature signature) {
        ArrayList<TypeParameter> parameters = new ArrayList<TypeParameter>();
        for (TypeSignatureParameter parameter : signature.getParameters()) {
            TypeParameter typeParameter = TypeParameter.of((TypeSignatureParameter)parameter, (TypeManager)this);
            if (typeParameter == null) {
                return null;
            }
            parameters.add(typeParameter);
        }
        ParametricType parametricType = (ParametricType)this.parametricTypes.get(signature.getBase().toLowerCase(Locale.ENGLISH));
        if (parametricType == null) {
            return null;
        }
        Type instantiatedType = parametricType.createType(parameters);
        return instantiatedType;
    }

    public List<Type> getTypes() {
        return ImmutableList.copyOf(this.types.values());
    }

    public void addType(Type type) {
        TypeRegistry.verifyTypeClass(type);
        Type existingType = this.types.putIfAbsent(type.getTypeSignature(), type);
        Preconditions.checkState((existingType == null || existingType.equals(type) ? 1 : 0) != 0, (String)"Type %s is already registered", (Object[])new Object[]{type});
    }

    public void addParametricType(ParametricType parametricType) {
        String name = parametricType.getName().toLowerCase(Locale.ENGLISH);
        Preconditions.checkArgument((!this.parametricTypes.containsKey(name) ? 1 : 0) != 0, (String)"Parametric type already registered: %s", (Object[])new Object[]{name});
        this.parametricTypes.putIfAbsent(name, parametricType);
    }

    public static void verifyTypeClass(Type type) {
        Objects.requireNonNull(type, "type is null");
    }

    public static boolean canCoerce(List<? extends Type> actualTypes, List<Type> expectedTypes) {
        if (actualTypes.size() != expectedTypes.size()) {
            return false;
        }
        for (int i = 0; i < expectedTypes.size(); ++i) {
            Type expectedType = expectedTypes.get(i);
            Type actualType = actualTypes.get(i);
            if (TypeRegistry.canCoerce(actualType, expectedType)) continue;
            return false;
        }
        return true;
    }

    private static boolean canCastTypeBase(String fromTypeBase, String toTypeBase) {
        if ("unknown".equals(fromTypeBase)) {
            return true;
        }
        if (toTypeBase.equals(fromTypeBase)) {
            return true;
        }
        switch (fromTypeBase) {
            case "bigint": {
                return "double".equals(toTypeBase);
            }
            case "date": {
                return "timestamp".equals(toTypeBase) || "timestamp with time zone".equals(toTypeBase);
            }
            case "time": {
                return "time with time zone".equals(toTypeBase);
            }
            case "timestamp": {
                return "timestamp with time zone".equals(toTypeBase);
            }
            case "varchar": {
                return "RegExp".equals(toTypeBase) || "LikePattern".equals(toTypeBase) || "JsonPath".equals(toTypeBase);
            }
            case "P4HyperLogLog": {
                return "HyperLogLog".equals(toTypeBase);
            }
        }
        return false;
    }

    private static boolean isCovariantParameterPosition(String firstTypeBase, int position) {
        return firstTypeBase.equals("array") || firstTypeBase.equals("map");
    }

    public static boolean isTypeOnlyCoercion(TypeSignature actualType, TypeSignature expectedType) {
        if (!TypeRegistry.canCoerce(actualType, expectedType)) {
            return false;
        }
        if (actualType.equals((Object)expectedType)) {
            return true;
        }
        if (actualType.getBase().equals("varchar") && expectedType.getBase().equals("varchar")) {
            return true;
        }
        if (actualType.getBase().equals(expectedType.getBase()) && actualType.getParameters().size() == expectedType.getParameters().size()) {
            for (int i = 0; i < actualType.getParameters().size(); ++i) {
                TypeSignatureParameter expectedParameter;
                if (!TypeRegistry.isCovariantParameterPosition(actualType.getBase(), i)) {
                    return false;
                }
                TypeSignatureParameter actualParameter = (TypeSignatureParameter)actualType.getParameters().get(i);
                if (actualParameter.equals((Object)(expectedParameter = (TypeSignatureParameter)expectedType.getParameters().get(i)))) continue;
                Optional actualParameterSignature = actualParameter.getTypeSignatureOrNamedTypeSignature();
                Optional expectedParameterSignature = expectedParameter.getTypeSignatureOrNamedTypeSignature();
                if (!actualParameterSignature.isPresent() || !expectedParameterSignature.isPresent()) {
                    return false;
                }
                if (TypeRegistry.isTypeOnlyCoercion((TypeSignature)actualParameterSignature.get(), (TypeSignature)expectedParameterSignature.get())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean canCoerce(Type actualType, Type expectedType) {
        return TypeRegistry.canCoerce(actualType.getTypeSignature(), expectedType.getTypeSignature());
    }

    public static boolean canCoerce(TypeSignature actualType, TypeSignature expectedType) {
        Optional<TypeSignature> commonSuperTypeSignature = TypeRegistry.getCommonSuperTypeSignature(actualType, expectedType);
        return commonSuperTypeSignature.isPresent() && commonSuperTypeSignature.get().equals((Object)expectedType);
    }

    public Optional<Type> getCommonSuperType(List<? extends Type> types) {
        Preconditions.checkArgument((!types.isEmpty() ? 1 : 0) != 0, (Object)"types is empty");
        Optional<TypeSignature> commonSuperTypeSignature = TypeRegistry.getCommonSuperTypeSignature((List)types.stream().map(Type::getTypeSignature).collect(ImmutableCollectors.toImmutableList()));
        return commonSuperTypeSignature.map(this::getType);
    }

    public Optional<Type> getCommonSuperType(Type firstType, Type secondType) {
        return TypeRegistry.getCommonSuperTypeSignature(firstType.getTypeSignature(), secondType.getTypeSignature()).map(this::getType);
    }

    private static Optional<String> getCommonSuperTypeBase(String firstTypeBase, String secondTypeBase) {
        if (TypeRegistry.canCastTypeBase(firstTypeBase, secondTypeBase)) {
            return Optional.of(secondTypeBase);
        }
        if (TypeRegistry.canCastTypeBase(secondTypeBase, firstTypeBase)) {
            return Optional.of(firstTypeBase);
        }
        return Optional.empty();
    }

    public static Optional<TypeSignature> getCommonSuperTypeSignature(List<? extends TypeSignature> typeSignatures) {
        Preconditions.checkArgument((!typeSignatures.isEmpty() ? 1 : 0) != 0, (Object)"typeSignatures is empty");
        TypeSignature superTypeSignature = UnknownType.UNKNOWN.getTypeSignature();
        for (TypeSignature typeSignature : typeSignatures) {
            Optional<TypeSignature> commonSuperTypeSignature = TypeRegistry.getCommonSuperTypeSignature(superTypeSignature, typeSignature);
            if (!commonSuperTypeSignature.isPresent()) {
                return Optional.empty();
            }
            superTypeSignature = commonSuperTypeSignature.get();
        }
        return Optional.of(superTypeSignature);
    }

    public static Optional<TypeSignature> getCommonSuperTypeSignature(TypeSignature firstType, TypeSignature secondType) {
        if ("unknown".equals(firstType.getBase())) {
            return Optional.of(secondType);
        }
        if ("unknown".equals(secondType.getBase())) {
            return Optional.of(firstType);
        }
        for (String varcharSubType : new String[]{"RegExp", "LikePattern", "JsonPath"}) {
            if (firstType.getBase().equals("varchar") && secondType.getBase().equals(varcharSubType)) {
                return Optional.of(secondType);
            }
            if (!secondType.getBase().equals("varchar") || !firstType.getBase().equals(varcharSubType)) continue;
            return Optional.of(firstType);
        }
        Optional<String> commonSuperTypeBase = TypeRegistry.getCommonSuperTypeBase(firstType.getBase(), secondType.getBase());
        if (!commonSuperTypeBase.isPresent()) {
            return Optional.empty();
        }
        List firstTypeTypeParameters = firstType.getParameters();
        List secondTypeTypeParameters = secondType.getParameters();
        Preconditions.checkArgument((firstTypeTypeParameters.size() == secondTypeTypeParameters.size() ? 1 : 0) != 0, (String)"Can not compare types [%s, %s] with different number of parameters. All default parameters should be expanded", (Object[])new Object[]{firstType, secondType});
        ImmutableList.Builder typeParameters = ImmutableList.builder();
        for (int i = 0; i < firstTypeTypeParameters.size(); ++i) {
            TypeSignatureParameter firstParameter = (TypeSignatureParameter)firstTypeTypeParameters.get(i);
            TypeSignatureParameter secondParameter = (TypeSignatureParameter)secondTypeTypeParameters.get(i);
            if (firstParameter.isLongLiteral() && secondParameter.isLongLiteral()) {
                typeParameters.add((Object)TypeSignatureParameter.of((long)Math.max(firstParameter.getLongLiteral(), secondParameter.getLongLiteral())));
                continue;
            }
            if (TypeRegistry.isCovariantParameterPosition(commonSuperTypeBase.get(), i)) {
                Optional firstParameterSignature = firstParameter.getTypeSignatureOrNamedTypeSignature();
                Optional secondParameterSignature = secondParameter.getTypeSignatureOrNamedTypeSignature();
                if (!firstParameterSignature.isPresent() || !secondParameterSignature.isPresent()) {
                    return Optional.empty();
                }
                Optional<TypeSignature> commonSuperType = TypeRegistry.getCommonSuperTypeSignature((TypeSignature)firstParameterSignature.get(), (TypeSignature)secondParameterSignature.get());
                if (!commonSuperType.isPresent()) {
                    return Optional.empty();
                }
                typeParameters.add((Object)TypeSignatureParameter.of((TypeSignature)commonSuperType.get()));
                continue;
            }
            if (!firstParameter.equals((Object)secondParameter)) {
                return Optional.empty();
            }
            typeParameters.add((Object)firstParameter);
        }
        return Optional.of(new TypeSignature(commonSuperTypeBase.get(), (List)typeParameters.build()));
    }
}

